local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local thisObj, son, cameraOneShotObjectTempleVista
function OnScriptLoaded(level, obj)
  thisObj = obj
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
end
function OnUpdate(level, obj)
  if cameraOneShotObjectTempleVista ~= nil then
    cameraOneShotObjectTempleVista:Update()
  end
end
function PlaySonBoatLookBUPOI()
  if game.Level.GetVariable("CompletedCineNumber") < 242 then
    game.SubObject.Wake(thisObj)
    cameraOneShotObjectTempleVista = CCOS.OneShotCamera.New("PLYR_Boat_Vista_AlfTemple", 6, nil)
    cameraOneShotObjectTempleVista:Start()
    cameraOneShotObjectTempleVista:SetCallback(DestroyCamera)
    local sonPupp = game.Puppeteer.NewForce(thisObj, "POI_AlfSonBoatLookBU", son)
    sonPupp:StartMove("MOV_SonBoatLookBU")
    game.Audio.PlayBanter("TempleRingRedirect")
    LD.EnableBoatLore(20)
    game.Audio.StartMusic("SND_MX_ALF_alfheim_lake_reveal")
    sonPupp:OnComplete(function()
      sonPupp = nil
    end)
  end
end
function DestroyCamera()
  cameraOneShotObjectTempleVista = nil
  game.SubObject.Sleep(thisObj)
end
