local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local CCOS = require("camera.camera_oneshot")
local AlfheimRuneOFF = false
local player, playerPosition, drivenObjWheelCrankLeft, drivenObjWheelCrankRight, camZoneRuneSolveVista
local bCamRuneVistaDisabled = false
local resetRuneBowl = false
local bCamElevatorReveal010 = false
local bCamElevatorFirstTime = false
local bridge320Crystal
local bInRuneVistaZone = false
local runeBowl_trench, collisionLift, WalkToObj, WalkOnObj, thisLevel, pad
local darkoneEliteKilled = false
local boolSandBowlPillarsBtr = false
local Area_1_Encounter_0, Area_1_Encounter_1, camCineEnterTrenchOpen010, camCineEnterTrenchOpen020, leftCrankMonitor, rightCrankMonitor, camOneShot_RunebowlUp, camOneShot_RunebowlDown, HalfdoorLEmitter, HalfdoorREmitter
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
  thisLevel = level
  WalkToObj = level:FindGameObject("WalkToFront")
  WalkOnObj = level:FindGameObject("WalkOntoLift")
  drivenObjWheelCrankLeft = level:FindGameObject("TrenchRune_Left")
  drivenObjWheelCrankRight = level:FindGameObject("TrenchRune_Right")
  leftCrankMonitor = monitors.CreateAnimFrameMonitor(drivenObjWheelCrankLeft)
  rightCrankMonitor = monitors.CreateAnimFrameMonitor(drivenObjWheelCrankRight)
  camZoneRuneSolveVista = level:GetGameObject("GRP_RuneVistaReveal")
  collisionLift = level:GetGameObject("collision_lift")
  bridge320Crystal = level:FindGameObject("BifrostTemporal_IntactLarge")
  if not bridge320Crystal.LuaObjectScript then
    bridge320Crystal.Child.LuaObjectScript.SetTemporalObject(GameObjects.Bridge_MegaBridge_Intro)
  else
    bridge320Crystal.LuaObjectScript.SetTemporalObject(GameObjects.Bridge_MegaBridge_Intro)
  end
  runeBowl_trench = level:FindGameObject("Sunebowl_Trench").Child.LuaObjectScript
  InitializeSoundVariables()
  SetUpSoundMonitors()
  WheelCrank_Fight_0()
  WheelCrank_Fight_1()
  local rightcrank = level:FindGameObject("WheelCrankRune_R")
  if rightcrank ~= nil and rightcrank.LuaObjectScript ~= nil then
    rightcrank.LuaObjectScript.OverrideCameraInteractApproach("ENV_Crank_Approach_RightJustified")
  end
end
function OnFirstStart(level)
  GameObjects.AnimateTrenchOpen:Hide()
  GameObjects.EntZn_Area_0_Spawn:HideEntityVolume()
  GameObjects.Despawn320FightZone:HideEntityVolume()
  GameObjects.RuneBowlTrenchWall:HideCollision()
  GameObjects.SetCineWalk_Lift:HideEntityVolume()
  GameObjects.SetCineWalk_BoatExit_RuneComplete:HideEntityVolume()
  GameObjects.InputMask_Elevator:HideEntityVolume()
  GameObjects.Crawl_Entrance_Blocker:Hide()
  GameObjects.Crawl_Entrance_Blocker:HideCollision()
  GameObjects.IC_BoatExit_RuneComplete:HideCollision()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {
    levelstate = checkpoint.Save()
  }
  savedInfo.bCamRuneVistaDisabled = bCamRuneVistaDisabled
  savedInfo.bCamElevatorFirstTime = bCamElevatorFirstTime
  savedInfo.bCamElevatorReveal010 = bCamElevatorReveal010
  savedInfo.bInRuneVistaZone = bInRuneVistaZone
  savedInfo.boolSandBowlPillarsBtr = boolSandBowlPillarsBtr
  savedInfo.darkoneEliteKilled = darkoneEliteKilled
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  if savedInfo == nil then
    return
  end
  checkpoint.Restore(savedInfo.levelstate)
  bCamRuneVistaDisabled = savedInfo.bCamRuneVistaDisabled
  bCamElevatorFirstTime = savedInfo.bCamElevatorFirstTime
  bCamElevatorReveal010 = savedInfo.bCamElevatorReveal010
  bInRuneVistaZone = savedInfo.bInRuneVistaZone
  boolSandBowlPillarsBtr = savedInfo.boolSandBowlPillarsBtr
  darkoneEliteKilled = savedInfo.darkoneEliteKilled
  if game.Level.GetVariable("CompletedCineNumber") >= 247 then
    runeBowl_trench.ReInitSandBowl_Reuse()
  end
end
function OnStart(level, obj)
  GameObjects.ToggleLTW1:HideEntityVolume()
  GameObjects.ToggleLTW1_Reverse:HideEntityVolume()
  GameObjects.SpreadDoor_Alfheim_Lake.LuaObjectScript:GetBackInteractZone():SetHintXZRange(24)
  GameObjects.SpreadDoor_Alfheim_Lake.LuaObjectScript:GetFrontInteractZone():SetHintXZRange(24)
  leftCrankMonitor:OnFrameForward(83, function()
    SwitchCamera_LeftCrank("PLYR_Crank_RuneRevealLeft_020")
  end)
  leftCrankMonitor:OnFrameBackward(82, function()
    SwitchCamera_LeftCrank("PLYR_Crank_RuneRevealLeft_010")
  end)
  rightCrankMonitor:OnFrameForward(83, function()
    SwitchCamera_RightCrank("PLYR_Crank_RuneRevealRight_020")
  end)
  rightCrankMonitor:OnFrameBackward(82, function()
    SwitchCamera_RightCrank("PLYR_Crank_RuneRevealRight_010")
  end)
  Disable320Flyers()
  GameObjects.EZE_BlockBackHalf:HideEntityVolume()
  if bCamElevatorFirstTime == true then
    GameObjects.CamElevatorGroup:HideCameraVolume()
  end
  if bCamRuneVistaDisabled == true then
    GameObjects.CamZone_TurnOff_RuneVista:HideCameraVolume()
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    DisableCARuneReady()
    DisableCASonGetOut()
    GameObjects.TempleController1_1.LuaObjectScript.Disable()
    GameObjects.TempleController1_2.LuaObjectScript.Disable()
    GameObjects.TempleController2_1.LuaObjectScript.Disable()
    GameObjects.TempleController2_2.LuaObjectScript.Disable()
    GameObjects.TempleController3_1.LuaObjectScript.Disable()
    GameObjects.TempleController3_2.LuaObjectScript.Disable()
    GameObjects.TempleController3_3.LuaObjectScript.Disable()
    GameObjects.TraverseCrawl:HideTraversePath()
    GameObjects.Crawl_Entrance_Blocker:Show()
    GameObjects.Crawl_Entrance_Blocker:ShowCollision()
  end
  SoundOnStart()
  GameObjects.DarkOneHiveGround1:Hide()
  GameObjects.DarkOneHiveGround2:Hide()
  GameObjects.DarkOneHiveHover1:Hide()
  GameObjects.DarkOneHiveHover2:Hide()
  GameObjects.DarkOneHiveHover3:Hide()
  GameObjects.DarkOneHiveHover4:Hide()
  GameObjects.DarkOneHiveExit1:Hide()
  GameObjects.DarkOneHiveExit2:Hide()
  if game.Level.GetVariable("BridgeVanish") == false then
    GameObjects.CamZone_BigRing_BoatExit:ShowCameraVolume()
  end
  DisableLiftCollision()
  if LD.GetEntityVariable("ALF_TrenchOpen") == true then
    GameObjects.AnimateTrenchOpen:Show()
    GameObjects.AnimateTrenchOpen:JumpAnimToPercent(1)
    GameObjects.TrenchRune_Left:Hide()
    GameObjects.TrenchRune_Right:Hide()
    GameObjects.CA_GetDownThereHint.LuaObjectScript.Disable()
    GameObjects.CA_FoundRuneSymbol.LuaObjectScript.Disable()
  end
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    GameObjects.CamZone_RuneForwardRailCam:HideCameraVolume()
  end
end
function DestroyOneShot_RunebowlUp()
  camOneShot_RunebowlUp = nil
end
function StartCameraLookAt_RunebowlUp()
  camOneShot_RunebowlUp = CCOS.OneShotCamera.New("PLYR_NAR_Runebowl_Solved_AlfElevatorUp", 30)
  camOneShot_RunebowlUp:SetCallback(DestroyOneShot_RunebowlUp)
  camOneShot_RunebowlUp:Start()
end
function DestroyOneShot_RunebowlDown()
  camOneShot_RunebowlDown = nil
end
function StartCameraLookAt_RunebowlDown()
  camOneShot_RunebowlDown = CCOS.OneShotCamera.New("PLYR_NAR_Runebowl_Solved_AlfElevatorUp", 45)
  camOneShot_RunebowlDown:SetCallback(DestroyOneShot_RunebowlDown)
  camOneShot_RunebowlDown:Start()
end
function CamShakeElevatorUp()
  timer.StartLevelTimer(4.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_OBJECT_LIGHT",
      Duration = 27.7,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Weight = 1
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 27.7,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Priority = 2
    })
  end)
  timer.StartLevelTimer(32.5, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_OBJECT_LIGHT",
      Duration = 12,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Weight = 0.4
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 12.7,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Priority = 5,
      Weight = 0.4
    })
  end)
  timer.StartLevelTimer(45.5, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_LIGHT",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5},
      Weight = 0.2
    })
    game.Blender.Trigger({
      Name = "FFB_MEDIUM",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5},
      Priority = 4000,
      Weight = 0.6
    })
  end)
end
function CamShakeElevatorReUseDown()
  timer.StartLevelTimer(4.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_OBJECT_LIGHT",
      Duration = 12,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Weight = 0.4
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 12.7,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Priority = 5,
      Weight = 0.4
    })
  end)
  timer.StartLevelTimer(16.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_LIGHT",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5},
      Weight = 0.2
    })
  end)
  timer.StartLevelTimer(16.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_OBJECT_LIGHT",
      Duration = 27.7,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.5},
      Weight = 1
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 27,
      TweenIn = {Time = 2},
      TweenOut = {Time = 0.1},
      Priority = 2
    })
  end)
  timer.StartLevelTimer(44.5, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_LIGHT",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5},
      Weight = 0.2
    })
    game.Blender.Trigger({
      Name = "FFB_MEDIUM",
      Duration = 0.25,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.25},
      Priority = 4000,
      Weight = 0.5
    })
  end)
end
function OnUpdate(level)
  playerPosition = player.WorldPosition
  if resetRuneBowl == false and LD.GetEntityVariable("ALF_TrenchClosing") == true then
    resetRuneBowl = true
  end
  if AlfheimRuneOFF == false and LD.GetEntityVariable("ALF_LightAcquired") == true and LD.GetEntityVariable("ALF_TrenchOpen") == true and LD.GetEntityVariable("ALF_TrenchClosing") == true then
    AlfheimRuneOFF = true
  end
  if bCamRuneVistaDisabled == false and LD.GetEntityVariable("RuneCrankEnd_Left") == true and LD.GetEntityVariable("RuneCrankEnd_Right") == true then
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_TurnOn_RuneVista") then
      if player:HasMarker("Exit") then
        bInRuneVistaZone = true
        camZoneRuneSolveVista:ShowCameraVolume()
        LD.CallFunctionAfterDelay(SandBowlPillarsBanter, 3.5)
        GameObjects.IC_BoatExit_RuneComplete:ShowCollision()
        GameObjects.SetCineWalk_BoatExit_RuneComplete:ShowEntityVolume()
        GameObjects.InputMask_Elevator:ShowEntityVolume()
      end
    elseif bInRuneVistaZone == true then
      bInRuneVistaZone = false
    end
    if game.World.IsInsideCameraZone(playerPosition, "CamZone_TurnOff_RuneVista") == true then
      camZoneRuneSolveVista:HideCameraVolume()
      bCamRuneVistaDisabled = true
      timer.StartLevelTimer(2, function()
        GameObjects.IC_BoatExit_RuneComplete:HideCollision()
      end)
    end
  end
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_RuneForwardRailCam") then
    game.Camera.SubmitCameraByName("PLYR_Nar_RuneForward")
  end
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_BigRing_BoatExit") and player:HasMarker("Exit") then
    GameObjects.CamZone_BigRing_BoatExit:HideCameraVolume()
    GameObjects.CamZone_LookAtBigRing:ShowCameraVolume()
    GameObjects.CamZone_LookAtBridge:ShowCameraVolume()
    local recenterToLock = {
      TimeStart = 0,
      TimeDuration = 4.5,
      LockRecenter = 1,
      YawRange = 180,
      PitchRange = 90
    }
    game.Camera.Recenter(recenterToLock)
  end
  if bCamElevatorFirstTime == false then
    if camCineEnterTrenchOpen010 ~= nil then
      camCineEnterTrenchOpen010:Update()
    end
    if camCineEnterTrenchOpen020 ~= nil then
      camCineEnterTrenchOpen020:Update()
    end
  end
  if camOneShot_RunebowlUp ~= nil then
    camOneShot_RunebowlUp:Update()
  end
  if camOneShot_RunebowlDown ~= nil then
    camOneShot_RunebowlDown:Update()
  end
end
function HideTentaclePOIZones()
  GameObjects.CamZone_LookAtBigRing:HideCameraVolume()
  GameObjects.CamZone_LookAtBigRing:HideCameraVolume()
end
function CheckLTWZones()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 242 <= cineNum and cineNum <= 245 then
    GameObjects.ToggleLTW1:HideEntityVolume()
    GameObjects.LeadTheWay_1R.LuaObjectScript.Enable()
    GameObjects.ToggleLTW1_Reverse:ShowEntityVolume()
  elseif cineNum == 230 then
    GameObjects.LTW_BeforeBridge.LuaObjectScript.Disable()
    GameObjects.ToggleLTW1_Reverse:HideEntityVolume()
    GameObjects.ToggleLTW1:ShowEntityVolume()
    GameObjects.EntZn_RemoveIdleContext:ShowEntityVolume()
  end
end
function ExitBoat_IslandDock()
  if LD.GetEntityVariable("ALF_LakeRunesFound") and LD.GetEntityVariable("ALF_LightAcquired") == false then
    runeBowl_trench.Enable()
    ReadSandBowlRune()
    EnableCARuneReady()
  else
    EnableCASonGetOut()
  end
end
function EnterBoat_IslandDock()
  DisableCASonGetOut()
  DisableCARuneReady()
end
function BookmarkCheck_06_Alfheim_030_Lake()
  return LD.GetEntityVariable("ALF_LakeRunesFound") == true
end
function BookmarkCheck_06_Alfheim_080_TrenchDone()
  return LD.GetEntityVariable("ALF_LightAcquired") == true
end
function EnableSandbowlEntZone()
  runeBowl_trench.Enable()
end
function DisableSandbowlEntZone()
  runeBowl_trench.Disable()
end
function EnableInputMaskElevator()
  pad:DisableGameButton(tweaks.ePad.kPadTouch)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
end
function DisableInputMaskElevator()
  pad:EnableGameButton(tweaks.ePad.kPadTouch)
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
  pad:EnableGameButton(tweaks.ePad.kPadCross)
  pad:EnableGameButton(tweaks.ePad.kPadUp)
  pad:EnableGameButton(tweaks.ePad.kPadLeft)
  pad:EnableGameButton(tweaks.ePad.kPadDown)
  pad:EnableGameButton(tweaks.ePad.kPadRight)
  pad:EnableGameButton(tweaks.ePad.kPadL1)
  pad:EnableGameButton(tweaks.ePad.kPadL2)
  pad:EnableGameButton(tweaks.ePad.kPadL3)
  pad:EnableGameButton(tweaks.ePad.kPadR1)
  pad:EnableGameButton(tweaks.ePad.kPadR2)
end
function StartTrenchOpenCamera()
  camCineEnterTrenchOpen010 = CCOS.OneShotCamera.New("ENV_Vista_TrenchReveal_010", 8)
  camCineEnterTrenchOpen020 = CCOS.OneShotCamera.New("ENV_Vista_TrenchReveal_020", 35)
  camCineEnterTrenchOpen020:SetCallback(DestroyCamera)
  camCineEnterTrenchOpen010:Start()
  camCineEnterTrenchOpen010:ActivateSlowWalk(player, 30)
  camCineEnterTrenchOpen020:Start()
end
function DestroyCamera()
  print("CAMERA: Destroy trench open cameras ENV_Vista_TrenchReveal_010 and ENV_Vista_TrenchReveal_020")
  if camCineEnterTrenchOpen010 ~= nil then
    camCineEnterTrenchOpen010 = nil
  end
  if camCineEnterTrenchOpen020 ~= nil then
    camCineEnterTrenchOpen020 = nil
  end
  GameObjects.CamZone_RuneForwardRailCam:HideCameraVolume()
end
function TriggerBridgeDarkOnes()
  local DarkOneHiveGround1 = GameObjects.DarkOneHiveGround1.Child
  local DarkOneHiveGround2 = GameObjects.DarkOneHiveGround2.Child
  local DarkOneHiveHover1 = GameObjects.DarkOneHiveHover1.Child
  local DarkOneHiveHover2 = GameObjects.DarkOneHiveHover2.Child
  local DarkOneHiveHover3 = GameObjects.DarkOneHiveHover3.Child
  local DarkOneHiveHover4 = GameObjects.DarkOneHiveHover4.Child
  local DarkOneHiveExit1 = GameObjects.DarkOneHiveExit1.Child
  local DarkOneHiveExit2 = GameObjects.DarkOneHiveExit2.Child
  GameObjects.DarkOneHiveGround1:Show()
  GameObjects.DarkOneHiveGround2:Show()
  GameObjects.DarkOneHiveHover1:Show()
  GameObjects.DarkOneHiveHover2:Show()
  GameObjects.DarkOneHiveHover3:Show()
  GameObjects.DarkOneHiveHover4:Show()
  GameObjects.DarkOneHiveExit1:Show()
  GameObjects.DarkOneHiveExit2:Show()
  timer.StartLevelTimer(14, function()
    GameObjects.EntZn_Area_0_Spawn:ShowEntityVolume()
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.Despawn320FightZone:ShowEntityVolume()
  end)
  timer.StartLevelTimer(0, function()
    DarkOneHiveGround1:StartAnim("poiBridgeDarkOneGround")
  end)
  timer.StartLevelTimer(10, function()
    DarkOneHiveGround1:StartAnim("poiBridgeDarkOneGroundFly")
  end)
  timer.StartLevelTimer(0.5, function()
    DarkOneHiveGround2:StartAnim("poiBridgeDarkOneGround")
  end)
  timer.StartLevelTimer(10.2, function()
    DarkOneHiveGround2:StartAnim("poiBridgeDarkOneGroundFly")
  end)
  timer.StartLevelTimer(0, function()
    DarkOneHiveHover1:StartAnim("poiBridgeDarkOneHover")
  end)
  timer.StartLevelTimer(8, function()
    DarkOneHiveHover1:StartAnim("poiBridgeDarkOneHoverFly")
  end)
  timer.StartLevelTimer(0.1, function()
    DarkOneHiveHover2:StartAnim("poiBridgeDarkOneHover")
  end)
  timer.StartLevelTimer(8.1, function()
    DarkOneHiveHover2:StartAnim("poiBridgeDarkOneHoverFly")
  end)
  timer.StartLevelTimer(0.6, function()
    DarkOneHiveHover3:StartAnim("poiBridgeDarkOneHover")
  end)
  timer.StartLevelTimer(8.6, function()
    DarkOneHiveHover3:StartAnim("poiBridgeDarkOneHoverFly")
  end)
  timer.StartLevelTimer(1, function()
    DarkOneHiveHover4:StartAnim("poiBridgeDarkOneHover")
  end)
  timer.StartLevelTimer(9, function()
    DarkOneHiveHover4:StartAnim("poiBridgeDarkOneHoverFly")
  end)
  timer.StartLevelTimer(9.5, function()
    DarkOneHiveExit1:StartAnim("poiBridgeDarkOneExit")
  end)
  timer.StartLevelTimer(11.5, function()
    DarkOneHiveExit2:StartAnim("poiBridgeDarkOneExit")
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.DarkOneHiveGround1:Hide()
  end)
  timer.StartLevelTimer(15, function()
    GameObjects.DarkOneHiveGround2:Hide()
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.DarkOneHiveHover1:Hide()
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.DarkOneHiveHover2:Hide()
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.DarkOneHiveHover3:Hide()
  end)
  timer.StartLevelTimer(14, function()
    GameObjects.DarkOneHiveHover4:Hide()
  end)
  timer.StartLevelTimer(18, function()
    GameObjects.DarkOneHiveExit1:Hide()
  end)
  timer.StartLevelTimer(18, function()
    GameObjects.DarkOneHiveExit2:Hide()
  end)
end
function Enable320Flyers()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    timer.StartLevelTimer(1, function()
      GameObjects.FlyController1_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(5, function()
      GameObjects.FlyController2_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(10, function()
      GameObjects.FlyController3_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(15, function()
      GameObjects.FlyController4_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(20, function()
      GameObjects.FlyController5_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(25, function()
      GameObjects.FlyController6_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(30, function()
      GameObjects.FlyController7_1.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(32, function()
      GameObjects.FlyController8_1.LuaObjectScript.Enable()
    end)
  end
end
function Disable320Flyers()
  GameObjects.FlyController1_1.LuaObjectScript.Disable()
  GameObjects.FlyController2_1.LuaObjectScript.Disable()
  GameObjects.FlyController3_1.LuaObjectScript.Disable()
  GameObjects.FlyController4_1.LuaObjectScript.Disable()
  GameObjects.FlyController5_1.LuaObjectScript.Disable()
  GameObjects.FlyController6_1.LuaObjectScript.Disable()
  GameObjects.FlyController7_1.LuaObjectScript.Disable()
  GameObjects.FlyController8_1.LuaObjectScript.Disable()
end
function ActivateBridge()
  bridge320Crystal.LuaObjectScript.SetCrystalObjectStates(2)
  GameObjects.MainBridgeIC:HideCollision()
  local alf321 = game.FindLevel("Alf321_TrenchALightsPre")
  if alf321 ~= nil then
    alf321:CallScript("BridgeCrystalLightOn")
  end
  if game.FindLevel("Alf050_Sound") then
    game.FindLevel("Alf050_Sound"):CallScript("Show320BridgeZone")
  end
end
function BridgeOFF()
  for _, x in pairs(GameObjects.Bridge_MegaBridge_Intro.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.Disable()
    else
      x:Hide()
    end
  end
end
function BridgeON()
  for _, x in pairs(GameObjects.Bridge_MegaBridge_Intro.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.Enable()
    else
      x:Show()
    end
  end
end
function BridgeVanish()
  game.Level.SetVariable("BridgeVanish", true)
  if game.FindLevel("Alf050_Sound") then
    game.FindLevel("Alf050_Sound"):CallScript("Hide320BridgeZone")
  end
  local temporalBridge
  for _, x in pairs(GameObjects.Bridge_MegaBridge_Intro.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      temporalBridge = x
      break
    end
  end
  if temporalBridge then
    LD.CallFunctionAfterDelay(function()
      temporalBridge.LuaObjectScript.FlickerOff(BridgeVanishComplete)
    end, 0.26)
  else
    BridgeVanishComplete()
  end
end
function BridgeVanishComplete()
  GameObjects.Bridge_MegaBridge_Intro:Hide()
end
function PlayShakes_TrenchOpening()
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_TREMORS_LEVEL_0",
      Duration = 3,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 0.8}
    })
  end)
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 3,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 0.8}
    })
  end)
  timer.StartLevelTimer(6, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_TREMORS_LEVEL_2",
      Duration = 3,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.8}
    })
  end)
  timer.StartLevelTimer(6, function()
    game.Blender.Trigger({
      Name = "FFB_LOOP_LARGEST",
      Duration = 0.8,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.8}
    })
  end)
  timer.StartLevelTimer(6.3, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_EXTREME",
      Duration = 2.5,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 0.8}
    })
  end)
  timer.StartLevelTimer(6.5, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 10,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 1}
    })
  end)
  timer.StartLevelTimer(17, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 8,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 3.5}
    })
  end)
end
function ActivateTrenchRunes()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    PlayShakes_TrenchOpening()
    GameObjects.AnimateTrenchOpen:Show()
    GameObjects.AnimateTrenchOpen:PlayAnimToEnd()
    GameObjects.TrenchRune_Left:Hide()
    GameObjects.TrenchRune_Right:Hide()
  end
end
function DeactivateTrenchRunes()
  GameObjects.AnimateTrenchOpen:Hide()
  GameObjects.TrenchRune_Left:Hide()
  GameObjects.TrenchRune_Right:Hide()
end
function DetectIslandFirst()
  if game.Level.GetVariable("ALF_LakeRunesFound") == false then
    game.Level.SetVariable("RuneBowlPreCrank", true)
    GameObjects.DetectIslandFirstZone:HideEntityVolume()
  end
end
function DelayLoadZonesCine()
  local alf300 = game.FindLevel("Alf300_LakeDark")
  if alf300 ~= nil then
    alf300:CallScript("LightOnesReturnLoadZone")
  end
end
function DoorOpenSideA()
  local alf300 = game.FindLevel("Alf300_LakeDark")
  if alf300 ~= nil then
    alf300:CallScript("DoorOpenFrom300")
  end
end
function DoorOpenSideB()
  local alf300 = game.FindLevel("Alf300_LakeDark")
  if alf300 ~= nil then
    alf300:CallScript("DoorOpenFrom690")
  end
end
function SyncExitSideA()
  GameObjects.CA_syncexit_SpreadDoorBridge.LuaObjectScript.Disable()
  GameObjects.CA_syncexit_SpreadDoorTemple.LuaObjectScript.Enable()
end
function SyncExitSideB()
  if game.Level.GetVariable("CompletedCineNumber") >= 245 then
    GameObjects.CA_syncexit_SpreadDoorBridge.LuaObjectScript.Enable()
    GameObjects.CA_syncexit_SpreadDoorTemple.LuaObjectScript.Disable()
  end
end
function Bookmark690Puzzle()
  EnableMainGate()
end
function EnableMainGate()
  GameObjects.SpreadDoor_Alfheim_Lake.LuaObjectScript.Enable()
end
function UnlockMainGate()
  GameObjects.DOOR_CRACK:PlayAnimToEnd()
  timer.StartLevelTimer(1.5, function()
    GameObjects.SpreadDoor_Alfheim_Lake.Child:PlayAnimToEnd()
  end)
end
function BlockBlueDoor()
  GameObjects.SpreadDoor_Alfheim_Lake.LuaObjectScript.Disable()
  GameObjects.DOOR_CRACK:PlayAnimToFrame(0, -10)
  GameObjects.InteractZone_BlueDoor_return.Child.LuaObjectScript.Enable()
end
function UnBlockBlueDoor()
  GameObjects.SpreadDoor_Alfheim_Lake.LuaObjectScript.Enable()
  GameObjects.DOOR_CRACK:PlayAnimToEnd(4)
end
function SwitchCamera_LeftCrank(strName)
  GameObjects.WheelCrankRune_L.LuaObjectScript.AssignCamera(strName)
end
function SwitchCamera_RightCrank(strName)
  GameObjects.WheelCrankRune_R.LuaObjectScript.AssignCamera(strName)
end
function StopMonitor_LeftCrankCamera()
  if leftCrankMonitor ~= nil then
    leftCrankMonitor:Stop()
    leftCrankMonitor:Terminate()
    leftCrankMonitor = nil
  end
end
function StopMonitor_RightCrankCamera()
  if rightCrankMonitor ~= nil then
    rightCrankMonitor:Stop()
    rightCrankMonitor:Terminate()
    rightCrankMonitor = nil
  end
end
function RuneCrankStart_Left()
  game.Level.SetVariable("RuneCrank_Left", true)
end
function RuneCrankStart_Right()
  game.Level.SetVariable("RuneCrank_Right", true)
end
function DetachedLeftEvent()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_ObserveFar_LeftCrank.LuaObjectScript.Disable()
  end, 4)
end
function DetachedRightEvent()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_ObserveFar_RightCrank.LuaObjectScript.Disable()
  end, 4)
end
function PlayShakeEffect()
  local effect = {
    EffectName = "FSE_SHAKE_JAMMED",
    Duration = 0.8,
    TweenInTime = 0.08,
    TweenOutTime = 0.07
  }
  game.FX.SubmitEffect(effect)
end
function RuneCrankEnd_Left()
  game.Level.SetVariable("RuneCrankEnd_Left", true)
  timer.StartLevelTimer(5, function()
    GameObjects.LeftCrank:PlayAnimToEnd()
  end)
  PlayLeftCrankLowering()
  LD.CallFunctionAfterDelay(StartNearCrankEncounter, 4.5)
  GameObjects.Despawn320FightZone:ShowEntityVolume()
  StopMonitor_LeftCrankCamera()
  if game.Level.GetVariable("RuneCrankEnd_Right") == true then
    BothCranksSuccess()
  end
end
function RuneCrankEnd_Right()
  game.Level.SetVariable("RuneCrankEnd_Right", true)
  timer.StartLevelTimer(5, function()
    GameObjects.RightCrank:PlayAnimToEnd()
  end)
  PlayRightCrankLowering()
  LD.CallFunctionAfterDelay(StartNearCrankEncounter, 4.5)
  GameObjects.Despawn320FightZone:ShowEntityVolume()
  StopMonitor_RightCrankCamera()
  if game.Level.GetVariable("RuneCrankEnd_Left") == true then
    BothCranksSuccess()
  end
end
function BothCranksSuccess()
  LD.CompleteQuest("Quest_Alfheim_Objective210")
  game.Level.SetVariable("ALF_LakeRunesFound", true)
  GameObjects.CA_FoundRuneSymbol.LuaObjectScript.Enable()
  timer.StartLevelTimer(3, function()
    GameObjects.CA_ObserveRuneSymbol.LuaObjectScript.Disable()
  end)
  LD.CallFunctionAfterDelay(CheckPlayerLinger, 30)
end
function CheckPlayerLinger()
  if LD.GetEntityVariable("ALF_AtMainDock") == true then
    game.Audio.PlayBanter("Alf_CrankYankers_Linger")
  end
end
function EnableIslandDock()
  local alf001 = game.FindLevel("Alf000_SkyDark")
  if alf001 ~= nil then
    alf001:CallScript("EnableIslandDock")
  end
end
function DisableIslandDock()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local alf001 = game.FindLevel("Alf000_SkyDark")
    if alf001 ~= nil then
      alf001:CallScript("DisableIslandDock")
    end
  end
end
function ReadSandBowlRune()
  SetNeverCare()
  runeBowl_trench.SetRuneDiscovered()
end
function TurnOnCollisonFromRuneBowl()
  if runeBowl_trench.IsRuneDiscovered() == true then
    collisionLift:ShowCollision()
  end
end
function SandBowlEngaged()
  if runeBowl_trench.IsRuneDiscovered() == true then
    collisionLift:ShowCollision()
  else
    DisableIslandDock()
  end
end
function SandBowlQuestionStart()
  LD.CallFunctionAfterDelay(CheckPlayerLingerIsland, 30)
end
function CheckPlayerLingerIsland()
  if LD.GetEntityVariable("ALF_AtIslandDock") == true then
    game.Audio.PlayBanter("SandbowlHaveAnswer_Linger")
  end
end
function SetSonUnavailable()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SetSonAvailable()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function SandBowlQuestionComplete()
end
function SandBowl_Arrived()
end
function SandBowl_Observe()
end
function SandBowl_Question()
end
function SandBowlSolveStart()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    if player:InsideZone(GameObjects.Zone_TooFarBack) then
      LD.GoToLocation(player, WalkToObj, 1, "walkPoint")
    end
    GameObjects.EZE_BlockBackHalf:ShowEntityVolume()
    GameObjects.CamZone_RuneForwardRailCam:ShowCameraVolume()
    timer.StartLevelTimer(40, function()
      GameObjects.CamZone_RuneForwardRailCam:HideCameraVolume()
    end)
  end
end
function BlockBackHalf()
  GameObjects.PushKratosTowardsFrontOfElevator:JumpAnimToPercent(1)
end
function EnableBowl()
  if LD.GetEntityVariable("ALF_LightAcquired") then
    runeBowl_trench.Enable()
  end
end
function EnableCASonGetOut()
  GameObjects.sonGetOut.LuaObjectScript.Enable()
end
function DisableCASonGetOut()
  GameObjects.sonGetOut.LuaObjectScript.Disable()
end
function EnableCARuneReady()
  GameObjects.sonRuneReady.LuaObjectScript.Enable()
end
function DisableCARuneReady()
  GameObjects.sonRuneReady.LuaObjectScript.Disable()
end
function SetNeverCare()
  runeBowl_trench.SetSonAlf320Branch()
end
function DisableLiftCollision()
  collisionLift:HideCollision()
  GameObjects.CA_Elevator_FirstTime.LuaObjectScript.Disable()
  GameObjects.CA_ElevatorArgument.LuaObjectScript.Disable()
  GameObjects.CA_ElevatorMovingUp.LuaObjectScript.Disable()
  GameObjects.CA_ElevatorMovingDown.LuaObjectScript.Disable()
  local Alf340 = game.FindLevel("Alf340_TrenchBDark")
  if Alf340 ~= nil then
    Alf340:CallScript("ShowDeathIC")
  end
end
function RuneBowlTrenchON()
  if LD.GetEntityVariable("ALF_LightAcquired") == false and LD.GetEntityVariable("ALF_TrenchOpen") == false then
    GameObjects.SandBowl_Lift:PlayAnimToEnd(0.83)
    LD.SetEntityVariable("ALF_TrenchOpen", true)
    ActivateTrenchRunes()
    AnimTrenchRoof()
    timer.StartLevelTimer(3, StartTrenchOpenCamera)
    local alf001 = game.FindLevel("Alf000_SkyDark")
    if alf001 ~= nil then
      alf001:CallScript("DisableMainDock")
      alf001:CallScript("EnableIslandDock")
    end
    GameObjects.CamElevatorGroup:ShowCameraVolume()
    timer.StartLevelTimer(6, function()
      bCamElevatorReveal010 = true
    end)
    GameObjects.CA_Elevator_FirstTime.LuaObjectScript.Enable()
    ShowTrenchSoundZones()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 247 or darkoneEliteKilled == true then
    if GameObjects.SandBowl_Lift.AnimFrame == GameObjects.SandBowl_Lift.AnimLengthFrames then
      GameObjects.CA_ElevatorMovingUp.LuaObjectScript.Enable()
      timer.StartLevelTimer(6, function()
        GameObjects.SandBowl_Lift:PlayAnimToEnd(-0.83)
      end)
      timer.StartLevelTimer(27, DisableLiftCollision)
      StartCameraLookAt_RunebowlUp()
      CamShakeElevatorUp()
    elseif GameObjects.SandBowl_Lift.AnimFrame == 0 then
      timer.StartLevelTimer(6, function()
        GameObjects.SandBowl_Lift:PlayAnimToEnd(0.83)
        CamShakeElevatorReUseDown()
      end)
      GameObjects.CA_ElevatorMovingDown.LuaObjectScript.Enable()
      StartCameraLookAt_RunebowlDown()
    end
    collisionLift:ShowCollision()
    local alf003 = game.FindLevel("Alf000_SkyDark")
    if alf003 ~= nil then
      alf003:CallScript("DisableMainDock")
      alf003:CallScript("EnableIslandDock")
    end
  elseif game.Level.GetVariable("CompletedCineNumber") == 247 then
    timer.StartLevelTimer(6, function()
      GameObjects.SandBowl_Lift:PlayAnimToEnd(-0.83)
    end)
    collisionLift:ShowCollision()
    if not player:InsideZone(GameObjects.DetectLiftZone) then
      LD.GoToLocation(player, WalkOnObj, 1, "LiftPoint")
    end
    timer.StartLevelTimer(27, DisableLiftCollision)
    AnimTrenchRoof()
    local alf002 = game.FindLevel("Alf000_SkyDark")
    if alf002 ~= nil then
      alf002:CallScript("EnableMainDock")
      alf002:CallScript("EnableIslandDock")
    end
    darkoneEliteKilled = true
    StartCameraLookAt_RunebowlUp()
    CamShakeElevatorUp()
    UnBlockBlueDoor()
    GameObjects.ToggleLTW1_Reverse:HideEntityVolume()
    GameObjects.LeadTheWay_1R.LuaObjectScript.Disable()
    GameObjects.CA_ElevatorArgument.LuaObjectScript.Enable()
  end
  GameObjects.SandBowl_Lift:OnAnimDone(thisLevel, "LiftStop")
  EnableInputMaskElevator()
  GameObjects.SetCineWalk_Lift:ShowEntityVolume()
  GameObjects.SetCineWalk_BoatExit_RuneComplete:HideEntityVolume()
  PlayTrenchOpenSound()
  PlayRunebowlLiftSound()
  local alf340 = game.FindLevel("Alf340_TrenchBDark")
  if alf340 ~= nil then
    alf340:CallScript("DisableCA_Lift")
  end
end
function LiftStop()
  DisableLiftCollision()
  GameObjects.SetCineWalk_Lift:HideEntityVolume()
  GameObjects.InputMask_Elevator:HideEntityVolume()
  GameObjects.SetCineWalk_BoatExit_RuneComplete:HideEntityVolume()
  DisableInputMaskElevator()
  bCamElevatorFirstTime = true
  GameObjects.CamElevatorGroup:HideCameraVolume()
  GameObjects.PushKratosTowardsFrontOfElevator:HideCollision()
  timer.StartLevelTimer(0.1, function()
    game.World.StoreCheckpoint()
  end)
  if game.Level.GetVariable("CompletedCineNumber") < 247 then
    runeBowl_trench.ForcedDisable()
  else
    runeBowl_trench.Enable()
  end
end
function AnimTrenchRoof()
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    alf000:CallScript("ActivateTrenchRoof")
  end
  local alf340 = game.FindLevel("Alf340_TrenchBDark")
  if alf340 ~= nil then
    alf340:CallScript("ActivateTrenchRoof")
    alf340:CallScript("HideDeathIC")
  end
end
function RuneBowlStartInteract()
  GameObjects.RuneBowlTrenchWall:ShowCollision()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    timer.StartLevelTimer(39, function()
      GameObjects.RuneBowlTrenchWall:HideCollision()
    end)
  elseif LD.GetEntityVariable("ALF_LightAcquired") == true then
    timer.StartLevelTimer(39, function()
      GameObjects.RuneBowlTrenchWall:HideCollision()
    end)
  end
end
function UnlockSpinChest()
  GameObjects.BlockedDoor:PlayAnimToEnd()
  LD.PlaySoundAfterDelay(HalfdoorLEmitter, "SND_DOOR_Stone_Double_Pry_Apart_Push_Open_L", 1)
  LD.PlaySoundAfterDelay(HalfdoorREmitter, "SND_DOOR_Stone_Double_Pry_Apart_Push_Open_R", 1)
  GameObjects.Tendrils_Group:Hide()
  for _, x in pairs(GameObjects.HiveInsideTunnel.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
end
function BridgeVanishFightComplete()
  timer.StartLevelTimer(3, function()
    LD.SetEntityVariable("BridgeVanishFight", true)
  end)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Base")
end
function FirstFightComplete()
  timer.StartLevelTimer(3, function()
    GameObjects.CA_GetDownThereHint.LuaObjectScript.Enable()
    GameObjects.LTW_BeforeBridge.LuaObjectScript.Enable()
  end)
  game.Compass.SetDesignerForcedHide(false)
end
function RemoveGetDownThere()
  GameObjects.CA_GetDownThereHint.LuaObjectScript.Disable()
end
function ShowSkyWadTemple()
  local Alf000 = game.FindLevel("Alf000_SkyDark")
  if Alf000 ~= nil then
    Alf000:CallScript("ShowTemple")
    Alf000:CallScript("ShowRing")
  end
end
function HideSkyWadTemple()
  local Alf000 = game.FindLevel("Alf000_SkyDark")
  if Alf000 ~= nil then
    Alf000:CallScript("HideTemple")
    Alf000:CallScript("HideRing")
  end
end
function EnableCA_ShopAndCrawl()
  GameObjects.CA_CrawlEntrance.LuaObjectScript.Enable()
end
function DisableCA_ShopAndCrawl()
  GameObjects.CA_CrawlEntrance.LuaObjectScript.Disable()
end
function Enable_LTW1()
  GameObjects.LeadTheWay_1.LuaObjectScript.Enable()
end
function Disable_LTW1()
  GameObjects.LeadTheWay_1.LuaObjectScript.Disable()
end
function Enable_LTW1R()
  GameObjects.LeadTheWay_1R.LuaObjectScript.Enable()
end
function Disable_LTW1R()
  GameObjects.LeadTheWay_1R.LuaObjectScript.Disable()
end
function DisableSplineNav()
  GameObjects.LeadTheWay_SplineNav.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_1R.LuaObjectScript.Disable()
end
function EnableSplineNav()
  GameObjects.LeadTheWay_SplineNav.LuaObjectScript.Enable()
end
function ChestSealsBroken()
  if game.Level.GetVariable("CompletedCineNumber") ~= 245 then
    GameObjects.Reaction_BellPuzzleWin.LuaObjectScript.Trigger()
    GameObjects.EntZn_OnPuzzleBehavior:HideEntityVolume()
  end
end
function Clear_LeadTheWay()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
end
function Respawn320Encounters()
  if Area_1_Encounter_0 ~= nil and Area_1_Encounter_0:WasRunning() then
    Area_1_Encounter_0:Start()
  end
  if Area_1_Encounter_1 ~= nil and not Area_1_Encounter_1:IsRunning() and not Area_1_Encounter_1:IsComplete() and (game.Level.GetVariable("RuneCrankEnd_Right") == true or game.Level.GetVariable("RuneCrankEnd_Left") == true) then
    Area_1_Encounter_1:Start()
  end
end
function WheelCrank_Fight_0()
  Area_1_Encounter_0 = EC.NewEncounter(thisLevel, "[Area 1]EC:0 Bridge AlfDgn320 Spawn before Cranks", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone320",
    LodHigh = 0
  })
  Area_1_Encounter_0:AddWave({
    {
      spawners = "DarkOnes_U_SFBL",
      spawnLocators = "A1_Loc_1",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "DarkOnes_U_SFBR",
      spawnLocators = "A1_Loc_3",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.3
    },
    {
      spawners = "DarkOnes_U_SFBF",
      spawnLocators = "A1_Loc_2",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6.6
    }
  })
  Area_1_Encounter_0:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DarkOnes_SFA",
      spawnLocators = "A2_Loc_*",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DarkOnes_SFA",
      spawnLocators = "A2_Loc_*",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_1_Encounter_0:SetStartZone(thisLevel:GetGameObject("EntZn_Area_0_Spawn"))
  Area_1_Encounter_0:OnStart(TriggerSonReaction)
  Area_1_Encounter_0:OnComplete(FirstFightComplete)
  Area_1_Encounter_0:OnEnemyDeath(function()
    Area_1_Encounter_0:StartWave(2)
  end, {count = 1})
end
function TriggerSonReaction()
  LD.CallFunctionAfterDelay(function()
    GameObjects.ReactionStim.LuaObjectScript.Trigger()
  end, 4)
end
function WheelCrank_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Bridge AlfDgn320 Spawn near Cranks", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone320",
    LodHigh = 0
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DarkOnes_SFBL",
      spawnLocators = "A1_Loc_1",
      spawnWad = "Alf340_AI_TrenchPre",
      disableSpawnerPostSpawn = true,
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DarkOnes_SFBF",
      spawnLocators = "A1_Loc_2",
      spawnWad = "Alf340_AI_TrenchPre",
      disableSpawnerPostSpawn = true,
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "DarkOnes_SFA",
      spawnLocators = "A2_Loc_*",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 12
    }
  })
  Area_1_Encounter_1:OnComplete(BridgeVanishFightComplete)
end
function StartNearCrankEncounter()
  if Area_1_Encounter_1 ~= nil then
    Area_1_Encounter_1:Start()
  end
end
local PillarSoundEmitter, leftAnimFrameMonitor, rightAnimFrameMonitor
local soundPillarStart = "SND_EVNT_Trench_Crank_Start_Pillars_Raise_A"
local soundPillarBreachWater = "SND_EVNT_Trench_Crank_Start_Pillars_Raise_B"
local soundPillarEnd = "SND_EVNT_Trench_Crank_Start_Pillars_Raise_B_Locked"
local framePillarStart, framePillarBreach, framePillarEnd, SandBowlLiftEmitter, SandBowlRingEmitter, LeftCrankObject, LeftCrankEmitter, RightCrankObject, RightCrankEmitter
local PillarCrankSoundOverrides = {
  OnForward = "SND_EVNT_Trench_Crank_Gear_LP",
  OnBackward = "SND_EVNT_Trench_Crank_Gear_LP"
}
function InitializeSoundVariables()
  PillarSoundEmitter = GameObjects.PillarSoundGroup:FindSingleSoundEmitterByName("PillarSoundEmitter")
  SandBowlLiftEmitter = GameObjects.SandBowl_Lift:FindSingleSoundEmitterByName("SND_SandBowl_Lift")
  SandBowlRingEmitter = GameObjects.SandBowl_Lift:FindSingleSoundEmitterByName("SND_SandBowl_Ring")
  HalfdoorLEmitter = GameObjects.SNDGrpHalfDoorLeft:FindSingleSoundEmitterByName("SNDHalfDoorLeft")
  HalfdoorREmitter = GameObjects.SNDGrpHalfDoorRight:FindSingleSoundEmitterByName("SNDHalfDoorRight")
  framePillarStart = 1
  framePillarBreach = tonumber(drivenObjWheelCrankLeft.AnimLengthFrames) / 2 - 4
  framePillarEnd = tonumber(drivenObjWheelCrankLeft.AnimLengthFrames)
end
function SoundOnStart()
  GameObjects.WheelCrankRune_R.LuaObjectScript.CrankSoundSetup(PillarCrankSoundOverrides)
  GameObjects.WheelCrankRune_L.LuaObjectScript.CrankSoundSetup(PillarCrankSoundOverrides)
end
function SetUpSoundMonitors()
  leftAnimFrameMonitor = monitors.CreateAnimFrameMonitor(drivenObjWheelCrankLeft)
  rightAnimFrameMonitor = monitors.CreateAnimFrameMonitor(drivenObjWheelCrankRight)
  leftAnimFrameMonitor:OnFrame(framePillarStart, function()
    LD.PlaySound(PillarSoundEmitter, soundPillarStart)
  end)
  rightAnimFrameMonitor:OnFrame(framePillarStart, function()
    LD.PlaySound(PillarSoundEmitter, soundPillarStart)
  end)
  leftAnimFrameMonitor:OnFrameForward(tonumber(framePillarBreach), function()
    LD.PlaySound(PillarSoundEmitter, soundPillarBreachWater)
  end)
  rightAnimFrameMonitor:OnFrameForward(tonumber(framePillarBreach), function()
    LD.PlaySound(PillarSoundEmitter, soundPillarBreachWater)
  end)
  leftAnimFrameMonitor:OnFrame(tonumber(framePillarEnd), function()
    LD.PlaySound(PillarSoundEmitter, soundPillarEnd)
    leftAnimFrameMonitor:Stop()
    leftAnimFrameMonitor:Terminate()
    leftAnimFrameMonitor = nil
  end)
  rightAnimFrameMonitor:OnFrame(tonumber(framePillarEnd), function()
    LD.PlaySound(PillarSoundEmitter, soundPillarEnd)
    rightAnimFrameMonitor:Stop()
    rightAnimFrameMonitor:Terminate()
    rightAnimFrameMonitor = nil
  end)
end
function PlayTrenchOpenSound()
  LD.PlaySoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_CINE_Alf300_Trench_Platform_Spin_LP", 100, "forward")
  LD.PlaySoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_CINE_Alf300_Trench_Platform_Drop_LP", 360, "forward")
  LD.StopSoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_CINE_Alf300_Trench_Platform_Spin_LP", 360, "forward")
  LD.PlaySoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_CINE_Alf300_Trench_Platform_Creak", 990, "forward")
  LD.StopSoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_CINE_Alf300_Trench_Platform_Drop_LP", 1110, "forward")
end
function PlayRunebowlLiftSound()
  if GameObjects.SandBowl_Lift.AnimFrame == 0 then
    LD.PlaySoundOnFrame(SandBowlRingEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_Ring_Turn", 120, "forward")
    LD.PlaySoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_LP", 420, "forward")
    LD.StopSoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_LP", 1110, "forward")
  elseif GameObjects.SandBowl_Lift.AnimFrame == GameObjects.SandBowl_Lift.AnimLengthFrames then
    LD.PlaySoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_LP", 1109, "backward")
    LD.StopSoundOnFrame(SandBowlLiftEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_LP", 420, "backward")
    LD.PlaySoundOnFrame(GameObjects.SNDGrpTrenchExitOneShot.SoundEmitters[1], GameObjects.SandBowl_Lift, "SND_AMB_EMTI_Wildlife_One_Shot_Alf320", 421, "backward")
    LD.PlaySoundOnFrame(SandBowlRingEmitter, GameObjects.SandBowl_Lift, "SND_MECH_Lift_Trench_Elevator_Ring_Turn", 420, "backward")
  end
end
function ShowTrenchSoundZones()
  local alf050 = game.FindLevel("Alf050_Sound")
  if alf050 ~= nil then
    alf050:CallScript("ShowTrenchSoundZones")
  end
end
function HideTrenchSoundZones()
  if LD.GetEntityVariable("ALF_TrenchOpen") == false then
    local alf050 = game.FindLevel("Alf050_Sound")
    if alf050 ~= nil then
      alf050:CallScript("HideTrenchSoundZones")
    end
  end
end
function PlayRightCrankLowering()
  RightCrankObject = GameObjects.SNDCrankEndObject_Alf320
  RightCrankEmitter = RightCrankObject:FindSingleSoundEmitterByName("SND1CrankEndEmitter_Alf320")
  LD.PlaySoundAfterDelay(RightCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 5)
  LD.StopSoundAfterDelay(RightCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 5.8)
  LD.PlaySoundAfterDelay(RightCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_Stop", 6)
end
function PlayLeftCrankLowering()
  LeftCrankObject = GameObjects.SNDCrankEndObject_Alf320
  LeftCrankEmitter = LeftCrankObject:FindSingleSoundEmitterByName("SND2CrankEndEmitter_Alf320")
  LD.PlaySoundAfterDelay(LeftCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 5)
  LD.StopSoundAfterDelay(LeftCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 5.8)
  LD.PlaySoundAfterDelay(LeftCrankEmitter, "SND_MECH_Crank_Wheel_Metal_Lower_Stop", 6)
end
function OnEvaluateLoadGroup_Lighting()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function ShowLiftDebugInfo(x, y)
  local debugTable = {}
  debugTable.Title = "SandBowl_Lift Info"
  debugTable.X = x or 5
  debugTable.Y = y or 15
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  debugTable[#debugTable + 1] = {
    " ",
    GameObjects.SandBowl_Lift:GetName()
  }
  debugTable[#debugTable + 1] = {
    "AnimFrame: ",
    GameObjects.SandBowl_Lift.AnimFrame
  }
  debugTable[#debugTable + 1] = {
    "CurrentSpeed",
    GameObjects.SandBowl_Lift.CurrentSpeed
  }
  engine.DrawDebugTable(debugTable)
end
function SandBowlPillarsBanter()
  if boolSandBowlPillarsBtr == false then
    game.Audio.PlayBanter("SandBowlPillarsUp")
    boolSandBowlPillarsBtr = true
  end
end
