local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor
local LightOne1 = GameObjects.LightOne1.Child
local LightOne2 = GameObjects.LightOne2.Child
local LightOne3 = GameObjects.LightOne3.Child
local LightOne4 = GameObjects.LightOne4.Child
local LightOne5 = GameObjects.LightOne5.Child
local LightOne6 = GameObjects.LightOne6.Child
local LightOne7 = GameObjects.LightOne7.Child
local LightOne8 = GameObjects.LightOne8.Child
local LightOne9 = GameObjects.LightOne9.Child
local LightOne10 = GameObjects.LightOne10.Child
local LightOne11 = GameObjects.LightOne11.Child
local LightOne12 = GameObjects.LightOne12.Child
local LightOne13 = GameObjects.LightOne13.Child
local lightOnesReturnPlayed = false
local cineEnterLightOneReturn, cine_lights_250
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  cine_lights_250 = GameObjects.Cine_Start_250
  HideCineLights()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if LD.GetEntityVariable("ALF_LightAcquired") == true and cineNum < 245 then
    SetupSeq()
    ShowLightOnes()
  else
    HideLightOnes()
  end
end
function OnUpdate(level, obj)
  if cineEnterLightOneReturn ~= nil then
    cineEnterLightOneReturn:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    playedSceneBool = lightOnesReturnPlayed,
    LevelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  lightOnesReturnPlayed = savedInfo.playedSceneBool
end
function SetupSeq()
  kraActor = actor.Actor.New("LIGHT ONES RETURN: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("LIGHT ONES RETURN: Son Actor", game.AI.FindSon)
end
function SetupCineSequence()
  local doorObj
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 245 then
    local lightOnesReturnSeq = LD.CreateCineSequence(thisLevel, thisObj, "Lights Ones Return Sequence")
    local lightOnesReturn_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_LightOnesReturn"
      },
      {
        Obj = LightOne1,
        Anim = "narAlfLightOnesReturn00CineScene"
      },
      {
        Obj = LightOne2,
        Anim = "narAlfLightOnesReturn00CineScene1"
      },
      {
        Obj = LightOne3,
        Anim = "narAlfLightOnesReturn00CineScene2"
      },
      {
        Obj = LightOne4,
        Anim = "narAlfLightOnesReturn00CineScene3"
      },
      {
        Obj = LightOne5,
        Anim = "narAlfLightOnesReturn00CineScene4"
      },
      {
        Obj = LightOne6,
        Anim = "narAlfLightOnesReturn00CineScene5"
      },
      {
        Obj = LightOne7,
        Anim = "narAlfLightOnesReturn00CineScene6"
      },
      {
        Obj = LightOne8,
        Anim = "narAlfLightOnesReturn00CineScene7"
      },
      {
        Obj = LightOne9,
        Anim = "narAlfLightOnesReturn00CineScene8"
      },
      {
        Obj = LightOne10,
        Anim = "narAlfLightOnesReturn00CineScene9"
      },
      {
        Obj = LightOne11,
        Anim = "narAlfLightOnesReturn00CineScene10"
      },
      {
        Obj = LightOne12,
        Anim = "narAlfLightOnesReturn00CineScene11"
      },
      {
        Obj = LightOne13,
        Anim = "narAlfLightOnesReturn00CineScene12"
      }
    }
    doorObj = GameObjects.Alfheim_SpreadDoor:FindSingleGOByName("SpreadDoor_Alfheim_Lake")
    if doorObj.IsRefNode then
      doorObj = doorObj.Child
    end
    doorObj.LuaObjectScript.EnableCinematicTrigger()
    lightOnesReturnSeq:SetPostSkipMusic("SND_MX_ALF_start_master")
    lightOnesReturnSeq:MarkAbleToSkip()
    lightOnesReturnSeq:Do(CameraStartLightOneReturn)
    lightOnesReturnSeq:Do(PlayCineLights)
    lightOnesReturnSeq:Do(_G.CheckLTWZones)
    lightOnesReturnSeq:Do(_G.DisableSplineNav)
    lightOnesReturnSeq:RequestCineModeAndWait(kraActor, thisObj)
    lightOnesReturnSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_LightOnesReturn",
      ReferenceJoint = "LightOnesReturn_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.InteractStopDistance,
      should_strafe = true,
      weapon_state = "bare"
    })
    lightOnesReturnSeq:Do(function()
      doorObj:StartAnim("narAlfLightOnesReturn00CineScene")
    end)
    lightOnesReturnSeq:ActorSync(kraActor, {
      Slaves = lightOnesReturn_ActorTable,
      Branch = "BRA_LightOnesReturn",
      ReferenceJoint = "LightOnesReturn_SynchJoint"
    })
    lightOnesReturnSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    lightOnesReturnSeq:Do(Lock_Alf320_BlueDoor)
    lightOnesReturnSeq:WaitForActorMoveComplete(sonActor)
    lightOnesReturnSeq:StopPuppetingActor(kraActor)
    lightOnesReturnSeq:StopPuppetingActor(sonActor)
    lightOnesReturnSeq:Do(HideCineLights)
    lightOnesReturnSeq:SetCompletedCineNumber(245)
    lightOnesReturnSeq:Do(AwardTrophy)
    lightOnesReturnSeq:Do(BestiaryEntry)
    lightOnesReturnSeq:Do(HideLightOnes)
    lightOnesReturnSeq:Do(ShowTempleAndRing)
    lightOnesReturnSeq:Do(ShowAlf300LoadZonePost)
    lightOnesReturnSeq:Do(StartAlfQuest690)
    lightOnesReturnSeq:Do(SaveBookmarkAndCheckpoint)
    lightOnesReturnSeq:StartSequence()
  end
end
function PlayCineLights()
  cine_lights_250:Show()
  cine_lights_250:JumpAnimToFrame(0)
  cine_lights_250:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_250:Hide()
end
function ShowTempleAndRing()
  game.FindLevel("Alf000_SkyDark"):CallScript("ShowTemple")
  game.FindLevel("Alf000_SkyDark"):CallScript("ShowRing")
end
function AwardTrophy()
  print("Award Trophy: Feels Like Home")
  game.UnlockTrophy(3)
end
function BestiaryEntry()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_LightOne")
end
function SaveBookmarkAndCheckpoint()
  LD.CallFunctionAfterDelay(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_070_TempleExit"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end, 0.1)
end
function ShowAlf300LoadZonePost()
  local alf300 = game.FindLevel("Alf300_LakeDark")
  if alf300 ~= nil then
    alf300:CallScript("LightOnesReturnLoadZone")
  end
end
function Lock_Alf320_BlueDoor()
  game.FindLevel("Alf320_TrenchADark"):CallScript("BlockBlueDoor")
end
function ShowLightOnes()
  LightOne1:Show()
  LightOne1:SetCharacterConfig("config1")
  LightOne2:Show()
  LightOne2:SetCharacterConfig("config2")
  LightOne3:Show()
  LightOne3:SetCharacterConfig("config3")
  LightOne4:Show()
  LightOne4:SetCharacterConfig("config4")
  LightOne5:Show()
  LightOne5:SetCharacterConfig("config0")
  LightOne6:Show()
  LightOne6:SetCharacterConfig("config2")
  LightOne7:Show()
  LightOne7:SetCharacterConfig("config3")
  LightOne8:Show()
  LightOne8:SetCharacterConfig("config4")
  LightOne9:Show()
  LightOne9:SetCharacterConfig("config1")
  LightOne10:Show()
  LightOne10:SetCharacterConfig("config2")
  LightOne11:Show()
  LightOne11:SetCharacterConfig("config3")
  LightOne12:Show()
  LightOne12:SetCharacterConfig("config4")
  LightOne13:Show()
  LightOne13:SetCharacterConfig("config0")
end
function HideLightOnes()
  LightOne1:Hide()
  LightOne2:Hide()
  LightOne3:Hide()
  LightOne4:Hide()
  LightOne5:Hide()
  LightOne6:Hide()
  LightOne7:Hide()
  LightOne8:Hide()
  LightOne9:Hide()
  LightOne10:Hide()
  LightOne11:Hide()
  LightOne12:Hide()
  LightOne13:Hide()
end
function CameraStartLightOneReturn()
  game.SubObject.Wake(thisObj)
  cineEnterLightOneReturn = CCEC.CineEnterCamera.New("ENV_CineEnter_narAlfLightOnesReturn00CineScene", 5, nil)
  cineEnterLightOneReturn:SetCallback(CameraDestroyLightOneReturn)
  cineEnterLightOneReturn:Start()
end
function CameraDestroyLightOneReturn()
  game.SubObject.Sleep(thisObj)
  cineEnterLightOneReturn = nil
end
function StartAlfQuest690()
  game.QuestManager.ProposeQuestState("Quest_Alfheim_Objective600", "Complete")
end
