local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 245 or cineNum == 242 then
    SetupActors()
  else
    local BlueDoor = GameObjects.InteractZone_BlueDoor_return.Child.LuaObjectScript
    BlueDoor:Disable()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("BLUE DOOR POI: Kratos Actor", game.Player.FindPlayer)
end
function POI_BlueDoorReturn()
  local blueDoorsSeq = ND.CreateCineSequence(thisLevel, thisObj, "Blue Door Blocked Again")
  blueDoorsSeq:RequestCineModeAndWait(kraActor, thisObj)
  blueDoorsSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_BlueDoor",
    ReferenceJoint = "POI_BlueDoor_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  blueDoorsSeq:ActorSync(kraActor, {
    Branch = "BRA_BlueDoor",
    ReferenceJoint = "POI_BlueDoor_SynchJoint"
  })
  blueDoorsSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  blueDoorsSeq:StopPuppetingActor(kraActor)
  blueDoorsSeq:StartSequence()
end
