local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, darkOneEliteActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 242 <= cineNum and cineNum < 250 then
    CreateActors()
  end
end
function CreateActors()
  darkOneEliteActor = actor.Actor.New("Dark One Trench Exit: Dark One Elite")
  SpawnDarkOneElite()
end
function SpawnDarkOneElite()
  darkOneEliteActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "POI_DarkOneTempleExit_Group", "DarkOneTempleExit_StartJoint", "CRT_DarkOneElite00", "BRA_DOEliteTempleExit_Spawn", "darkOneElite", {PowerLevel = "3", Variant = "Boss"})
  end)
end
function BuildTempleExitPOI_EnterSeq()
  GameObjects.KillBox:HideCollision()
  player:SetMaxSpeedOverride(3)
  local poiTempleExitseq = LD.CreateCineSequence(thisLevel, thisObj, "Dark One Elite Temple Exit - POI")
  poiTempleExitseq:SpawnActorAndWait(darkOneEliteActor)
  poiTempleExitseq:ActorSync(darkOneEliteActor, {
    Branch = "BRA_DOEliteTempleExit_Enter",
    ReferenceJoint = "DarkOneTempleExit_SynchJoint"
  })
  poiTempleExitseq:Do(function()
    game.Audio.PlayBanter("EliteBeatsFeet")
  end)
  poiTempleExitseq:WaitSeconds(10)
  poiTempleExitseq:ActorSync(darkOneEliteActor, {
    Branch = "BRA_DOEliteTempleExit_Exit",
    ReferenceJoint = "DarkOneTempleExit_SynchJoint"
  })
  poiTempleExitseq:WaitForActorMoveComplete(darkOneEliteActor)
  poiTempleExitseq:DespawnActor(darkOneEliteActor)
  poiTempleExitseq:Do(function()
    GameObjects.KillBox:ShowCollision()
    player:ClearMaxSpeedOverride()
  end)
  poiTempleExitseq:StartSequence()
end
