local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, sonActor
local bZooCrank = false
local bPostZooFight = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  SetupActors()
end
function OnUpdate(level, obj)
  if game.Level.GetVariable("PrisonDraugrFight") == true and bPostZooFight == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("PostZooFight")
    end, 3)
    bPostZooFight = true
  end
end
function OnSaveCheckpoint(level, obj)
  return {bZooCrank = bZooCrank, bPostZooFight = bPostZooFight}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bZooCrank = savedInfo.bZooCrank
  bPostZooFight = savedInfo.bPostZooFight
end
function TrenchFightComplete()
  return game.Level.GetVariable("TrenchFightBanter") and game.Level.GetVariable("CompletedCineNumber") < 242
end
function WheelFightComplete()
  return game.Level.GetVariable("WheelCrankFight") and game.Level.GetVariable("CompletedCineNumber") < 242
end
function ZooCrankBanter()
  if bZooCrank == false then
    game.Audio.PlayBanter("ZooCrank")
    bZooCrank = true
  end
end
function CrankCompleteBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("CrankComplete")
  end, 2)
  GameObjects.Btr_CrankComplete:HideEntityVolume()
end
function SetupActors()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Nornir Chest Sequence")
  cineSeq:RequestCineModeAndWait(sonActor, thisObj)
  cineSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_NornirChest",
    ReferenceJoint = "poi_NornirChest_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius
  })
  cineSeq:ActorSync(sonActor, {
    Branch = "BRA_NornirChest",
    ReferenceJoint = "poi_NornirChest_SynchJoint"
  })
  cineSeq:WaitForAndCompleteCineMode(sonActor, thisObj)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StartSequence()
end
