local LD = require("design.LevelDesignLibrary")
local bHoldLightUp = false
local bCrystalBaseFound = false
local bCrystalFound = false
local bCrystalPickedUp = false
local bCrystalPuzzleSolved = false
function OnUpdate(level, obj)
  if game.Level.GetVariable("TrenchFight01Ret") == true and bHoldLightUp == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("HoldTheLightUp")
    end, 0.8)
    bHoldLightUp = true
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    bHoldLightUp = bHoldLightUp,
    bCrystalBaseFound = bCrystalBaseFound,
    bCrystalFound = bCrystalFound,
    bCrystalPuzzleSolved = bCrystalPuzzleSolved
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bHoldLightUp = savedInfo.bHoldLightUp
  bCrystalBaseFound = savedInfo.bCrystalBaseFound
  bCrystalFound = savedInfo.bCrystalFound
  bCrystalPuzzleSolved = savedInfo.bCrystalPuzzleSolved
end
function TrenchClosed()
  return game.Level.GetVariable("ALF_TrenchClosing")
end
function TrenchClosedFightOver()
  return game.Level.GetVariable("TrenchFight01Ret")
end
function CystalBaseFound()
  if bCrystalFound == false then
    bCrystalBaseFound = true
    LD.CallFunctionAfterDelay(CrystalBaseFoundHint, 20)
  end
end
function CrystalBaseFoundHint()
  if bCrystalFound == false and game.Level.GetVariable("CompletedCineNumber") < 250 then
    game.Audio.PlayBanter("TrenchReturnCrystalPuzzle_Hint")
  end
end
function CrystalPickUpBanter()
  if bCrystalPickedUp == false then
    bCrystalPickedUp = true
    if bCrystalBaseFound == false then
      if game.Level.GetVariable("CompletedCineNumber") < 250 then
        game.Audio.PlayBanter("TrenchReturnCrystalPuzzle_Crystal1")
      end
      GameObjects.Btr_TrenchReturn_Base:HideEntityVolume()
    else
      if game.Level.GetVariable("CompletedCineNumber") < 250 then
        game.Audio.PlayBanter("TrenchReturnCrystalPuzzle_Crystal2")
      end
      GameObjects.Btr_TrenchReturn_Base:HideEntityVolume()
    end
  end
end
function FoundCrystal()
  bCrystalFound = true
end
function CrystalBaseSolved()
  if bCrystalPuzzleSolved == false then
    if game.Level.GetVariable("CompletedCineNumber") < 250 then
      game.Audio.PlayBanter("TrenchReturnCrystalPuzzle_Solved")
    end
    bCrystalPuzzleSolved = true
  end
end
