local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, darkOneEliteActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  CreateActors()
  SpawnDarkOneElite()
end
function SpawnDarkOneElite()
  darkOneEliteActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "POI_TrenchRevealBattle_Group", "darkOneElite_StartJoint", "CRT_DarkOneElite00", "BRA_TrenchRevealBattle", "darkOneElite", {PowerLevel = "3", Variant = "Boss"})
  end)
end
function CreateActors()
  darkOneEliteActor = actor.Actor.New("POI Trench Reveal Battle: Dark One Elite")
end
function TrenchRevealBattle_Sequence()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "Trench Reveal Battle")
    local trenchRevealBattle_ActorTable = {}
    cineSeq:SpawnActorAndWait(darkOneEliteActor)
    cineSeq:RequestCineModeAndWait(darkOneEliteActor, thisObj)
    cineSeq:ActorSync(darkOneEliteActor, {
      Slaves = trenchRevealBattle_ActorTable,
      Branch = "BRA_TrenchRevealBattle",
      ReferenceJoint = "darkOneElite_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(darkOneEliteActor, thisObj)
    cineSeq:StopPuppetingActor(darkOneEliteActor)
    cineSeq:DespawnActor(darkOneEliteActor)
    cineSeq:StartSequence()
  end
end
