local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local CCOS = require("camera.camera_oneshot")
local thisLevel, doorObj, elevatorCrystal, elevator_SpeedZone, elevator_TopCollision, elevator_BottomCollision, elevator_Switch, elevator_Manager
local debug_activate = false
local camOneShot_LookAtExitDoor, bCamera_PlayedUpElevatorCamera, bCamera_PlayedDownElevatorCamera
function OnScriptLoaded(level)
  thisLevel = level
  elevatorCrystal = level:FindGameObject("BifrostTemporal_Crystal")
  elevator_SpeedZone = GameObjects.SetCineWalk_345Lift
  elevator_TopCollision = GameObjects.ElevatorTop_IC
  elevator_BottomCollision = GameObjects.ElevatorBottom_IC
  elevator_Switch = GameObjects.TemporalElevator_SwitchWall
  elevator_Manager = GameObjects.Alf345Temporal_ElevatorManager
  doorObj = GameObjects.SpreadDoor_Alfheim_StayOpen
  if doorObj.IsRefNode then
    doorObj = doorObj.Child
  end
  SoundInit()
  bCamera_PlayedUpElevatorCamera = false
  bCamera_PlayedDownElevatorCamera = false
end
function OnFirstStart(level)
  GameObjects.ElevatorTemporal_Sheet:HideCollision()
  for _, x in pairs(GameObjects._ElevatorFloor.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.Disable()
    else
      x:Hide()
    end
  end
  GameObjects._Elevator_top:Hide()
  GameObjects.SetCineWalk_345Lift:HideEntityVolume()
  GameObjects.LiftCollisionOn:HideCollision()
end
function OnStart(level)
  GameObjects.Enable_CA_ReadyForElevator:HideEntityVolume()
  CheckDoorStatus()
  SoundOnStart()
  Clear_GetoffElevator_CA()
  if bCamera_PlayedUpElevatorCamera == nil then
    bCamera_PlayedUpElevatorCamera = false
  end
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if bCamera_PlayedUpElevatorCamera ~= true and 230 < cineNumber then
    bCamera_PlayedUpElevatorCamera = true
  end
  if bCamera_PlayedDownElevatorCamera == nil then
    bCamera_PlayedDownElevatorCamera = false
  end
  if bCamera_PlayedDownElevatorCamera ~= true and 245 < cineNumber then
    bCamera_PlayedDownElevatorCamera = true
  end
  GameObjects.CamZone_345_ElevatorUpReveal:HideCameraVolume()
end
function ElevatorIsReady()
  GameObjects.Enable_CA_ReadyForElevator:ShowEntityVolume()
end
function OnUpdate(level)
  if camOneShot_LookAtExitDoor ~= nil then
    camOneShot_LookAtExitDoor:Update()
  end
end
function CheckDoorStatus()
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    doorObj:ShowNavObstacle()
    doorObj.LuaObjectScript.Disable()
    GameObjects.PrisDoor01.Child:JumpAnimToPercent(1)
    GameObjects.PrisDoor02.Child:JumpAnimToPercent(1)
  end
end
function Quest_Alfheim_Objective370_Complete()
  LD.CompleteQuest("Quest_Alfheim_Objective370")
end
function ActivateLift()
  GameObjects._ElevatorFloor:Show()
  GameObjects.ElevatorTemporal_Sheet:ShowCollision()
  for _, x in pairs(GameObjects._ElevatorFloor.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.TurnTemporalObjectOn()
    else
      x:Show()
    end
  end
  GameObjects._Elevator_top:Show()
  elevatorCrystal.LuaObjectScript.SetCrystalObjectStates(2)
  elevator_Manager.LuaObjectScript.EnableElevator()
  GameObjects.SonNavObstacle:HideNavObstacle()
  elevator_BottomCollision:Hide()
  GameObjects.Zone_ENABLE_Bottom_Elevator_Spline:Show()
  GameObjects.Zone_DISABLE_Bottom_Elevator_Spline:Show()
  PlayLiftIdle()
end
function HideWalkZone()
  elevator_SpeedZone:HideEntityVolume()
end
function OnInteractFinish_Do180()
  local elevatorstate = elevator_Manager.LuaObjectScript.GetState()
  if bCamera_PlayedUpElevatorCamera == false and elevatorstate == "MovingUp" then
    local dummyObj = thisLevel:FindSingleGameObject("dummymarker_elevator")
    local player = game.Player.FindPlayer()
    timer.StartLevelTimer(0, function()
      LD.PlayMove(player, dummyObj, "MOV_Alf_Elevator_180")
    end)
    bCamera_PlayedUpElevatorCamera = true
  end
end
function Do180()
  local dummyObj = thisLevel:FindSingleGameObject("dummymarker_elevator")
  local player = game.Player.FindPlayer()
  timer.StartLevelTimer(3, function()
    LD.PlayMove(player, dummyObj, "MOV_Alf_Elevator_180")
  end)
end
function SetInteractCamera()
  local elevatorstate = elevator_Manager.LuaObjectScript.GetState()
  if elevatorstate == "Top" then
    if elevator_Switch ~= nil then
      elevator_Switch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_WallSwitch_LS")
      elevator_Switch.LuaObjectScript.OverrideCameraSubmissionTime(4.2)
      if bCamera_PlayedDownElevatorCamera == false and LD.GetEntityVariable("ALF_LightAcquired") == true then
        timer.StartLevelTimer(3, CamLookAt_ExitDoor)
      end
    end
  elseif elevatorstate == "Bottom" then
    if elevator_Switch ~= nil then
      elevator_Switch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_WallSwitch_LS")
      elevator_Switch.LuaObjectScript.OverrideCameraSubmissionTime(4.2)
    end
    if bCamera_PlayedUpElevatorCamera == false then
      local delay = 1.5
      timer.StartLevelTimer(delay, function()
        GameObjects.CamZone_345_ElevatorUpReveal:ShowCameraVolume()
      end)
    end
  end
end
function PlayerActivateElevator()
  GameObjects.CA_GetOffElevator_top.LuaObjectScript.Disable()
  GameObjects.CA_ReadyForElevator.LuaObjectScript.Disable()
  GameObjects.LTW_ElevatorBottomFloor.LuaObjectScript.Disable()
  GameObjects.CA_Wait_OnElevatorTop.LuaObjectScript.Disable()
end
function CompassOn()
  game.Compass.SetDesignerForcedHide(false)
end
function CompassOff()
  game.Compass.SetDesignerForcedHide(true)
end
function TrenchLift_MoveUp()
  elevator_TopCollision:Hide()
  elevator_BottomCollision:Show()
  elevator_SpeedZone:ShowEntityVolume()
  PlayLiftSound()
end
function TrenchLift_MoveDown()
  elevator_TopCollision:Show()
  elevator_BottomCollision:Hide()
  PlayLiftSound()
end
function Clear_GetoffElevator_CA()
  GameObjects.CA_GetOffElevator_top.LuaObjectScript.Disable()
end
function LiftAtTop()
  GameObjects.CA_GetOffElevator_top.LuaObjectScript.Enable()
end
function LiftAtBottom()
end
function BottomFloorExit()
  GameObjects.LTW_ElevatorBottomFloor.LuaObjectScript.Enable()
end
function Enable_CA_DoorExit()
  timer.StartLevelTimer(1, function()
    GameObjects.CA_DoorExit.LuaObjectScript.Enable()
  end)
end
function Disable_CA_DoorExit()
  GameObjects.CA_DoorExit.LuaObjectScript.Disable()
end
function Disable_CA_DiscoverElevator()
  GameObjects.CA_DiscoverElevator.LuaObjectScript.Disable()
end
function Enable_CA_ReadyForElevator()
  GameObjects.CA_ReadyForElevator.LuaObjectScript.Enable()
  local alf340 = game.FindLevel("Alf340_TrenchBDark")
  if alf340 ~= nil then
    alf340:CallScript("CLeanUpCAExitInside")
  end
end
function Enable_CA_WaitAtTopForElevator()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if elevator_Manager.LuaObjectScript.GetState() == "Top" and 245 <= cineNumber then
    GameObjects.CA_Wait_OnElevatorTop.LuaObjectScript.Enable()
  end
end
function Disable_CA_WaitAtTopForElevator()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if elevator_Manager.LuaObjectScript.GetState() == "Top" and 245 <= cineNumber then
    GameObjects.CA_Wait_OnElevatorTop.LuaObjectScript.Disable()
  end
end
local soundLiftTemporal
local soundEvents = {
  isLooping = false,
  LiftIdle = "SND_MAG_Temporal_Light_Lift_Idle_LP",
  LiftLoop = "SND_MAG_Temporal_Light_Lift_LP"
}
local spreadDoorSoundEvents = {OnInteractClose_Left = "", OnInteractClose_Right = ""}
function SoundInit()
  soundLiftTemporal = GameObjects.Alf345_TemporalElevator:FindSingleSoundEmitterByName("SNDLiftUpEnd")
end
function SoundOnStart()
  doorObj.LuaObjectScript.SoundSetup(spreadDoorSoundEvents)
  if GameObjects.Alf345Temporal_ElevatorManager.LuaObjectScript.IsEnabled() then
    PlayLiftIdle()
  end
end
function PlayLiftIdle()
  LD.PlaySound(soundLiftTemporal, soundEvents.LiftIdle)
end
function PlayLiftSound()
  LD.PlaySound(soundLiftTemporal, soundEvents.LiftLoop)
end
function StopLiftSound()
  LD.StopSound(soundLiftTemporal, soundEvents.LiftLoop)
end
function DestroyOneShot_ExitDoor()
  camOneShot_LookAtExitDoor = nil
end
function CamLookAt_ExitDoor()
  camOneShot_LookAtExitDoor = CCOS.OneShotCamera.New("ENV_345_ElevatorDown", 15.15)
  camOneShot_LookAtExitDoor:SetCallback(DestroyOneShot_ExitDoor)
  camOneShot_LookAtExitDoor:ActivateSlowWalk()
  camOneShot_LookAtExitDoor:Start()
  bCamera_PlayedDownElevatorCamera = true
end
function OnEvaluateLoadGroup_Lighting()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingTrenchOpen"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingTrenchClosed"
  end
end
function OnSaveCheckpoint(level)
  local savedInfo = {}
  savedInfo.bCamera_PlayedUpElevatorCamera = bCamera_PlayedUpElevatorCamera
  savedInfo.bCamera_PlayedDownElevatorCamera = bCamera_PlayedDownElevatorCamera
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  bCamera_PlayedUpElevatorCamera = savedInfo.bCamera_PlayedUpElevatorCamera
  bCamera_PlayedDownElevatorCamera = savedInfo.bCamera_PlayedDownElevatorCamera
end
