local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
checkpoint = require("level.checkpoint")
uiCalls = require("ui.uicalls")
local thisLevel, player, son
local AlfheimReturnText = false
local alf355, ChiselElevator, ElevatorManager, pad
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnStart(level)
  SoundOnStart()
end
function OnEvaluateLoadGroup_Lighting7()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function ChiselTextZone()
  AlfheimReturnText = true
  uiCalls.UI_Event_DiscoverLocation("Alfheim Chisel Dungeon")
  ChiselLabor()
end
function AlfheimChiselTextZone()
  if AlfheimReturnText == true then
    AlfheimReturnText = false
    uiCalls.UI_Event_DiscoverLocation("Alfheim Chisel Dungeon")
  end
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_Alf")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_Alf")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function LoadCheck_Alf355()
  game.UI.LoadCheck("Alf355_ChiselDungeon")
end
function LoadCheck_AlfDgn210_Main()
  game.UI.LoadCheck("AlfDgn210_Main")
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function switchedLever01()
  if GameObjects.anim_elevator_01.AnimFrame == 0 then
    GameObjects.anim_elevator_01:PlayAnimToEnd()
  elseif GameObjects.anim_elevator_01.AnimFrame == GameObjects.anim_elevator_01.AnimLengthFrames then
    GameObjects.anim_elevator_01:PlayAnimToEnd(-1)
  end
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function Alf355_LTW_Enable()
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  if alf355 ~= nil then
    alf355:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Alf355_LTW_Disable()
  local alf355 = game.FindLevel("Alf355_ChiselDungeon")
  if alf355 ~= nil then
    alf355:CallScript("LTW_Lobby_Disable", "CA_Lobby_Disable")
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
