local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local ChiselEncounter1, ChiselEncounter2
player = game.Player.FindPlayer()
Player = nil
Son = nil
thisObj = nil
local thisLevel, Enc_Valkyrie_Fight
local encounterComplete = false
local sonWarpTriggered = false
function OnScriptLoaded(level)
  thisLevel = level
  Player = game.Player.FindPlayer()
  Son = game.AI.FindSon()
  Fnc_Valkyrie_Fight()
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Valkyrie_Alert:Hide()
end
function OnStart(level, obj)
  GameObjects.primarydoor_animated_inner.Child:JumpAnimationToFrame(60)
  GameObjects.primarydoor_animated_inner.Child:HideCollision()
  GameObjects.primarydoor_animated_outer.Child:JumpAnimationToFrame(60)
  GameObjects.primarydoor_animated_outer.Child:HideCollision()
  GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
  Player:ClearMaxSpeedOverride()
end
function FT_JumpElevator()
  local Alf350 = game.FindLevel("Alf350_ChiselSite")
  if Alf350 ~= nil then
    Alf350:CallScript("JumpElevator")
  end
end
function ChiselEncounter()
end
function ChiselEncounter1End(level, obj)
end
function LoadCheck_Alf350()
  game.UI.LoadCheck("Alf350_ChiselSite")
end
function LTW_Lobby_Enable()
  if encounterComplete == false then
    GameObjects.LTW_Lobby_In.LuaObjectScript.Enable()
  elseif encounterComplete == true then
    GameObjects.LTW_Lobby_Out.LuaObjectScript.Enable()
    GameObjects.LTW_Lobby_In.LuaObjectScript.Disable()
    GameObjects.LTW_Balcony_R_Down.LuaObjectScript.Enable()
    GameObjects.LTW_Balcony_L_Down.LuaObjectScript.Enable()
  end
end
function LTW_Lobby_Disable()
  if encounterComplete == true then
    GameObjects.LTW_Lobby_In.LuaObjectScript.Disable()
  end
  GameObjects.LTW_Balcony_R_Down.LuaObjectScript.Disable()
  GameObjects.LTW_Balcony_L_Down.LuaObjectScript.Disable()
  GameObjects.LTW_Lobby_Out.LuaObjectScript.Disable()
end
function CA_Lobby_Enable()
  if encounterComplete == false then
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Enable()
  elseif encounterComplete == true then
    GameObjects.CA_IdleBehavior_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Puzzled_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Lobby.LuaObjectScript.Enable()
  end
end
function CA_Lobby_Disable()
  GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Lobby.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_Lobby.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Lobby.LuaObjectScript.Disable()
end
function CA_Balcony_Enable()
  if encounterComplete == true then
    GameObjects.CA_Observe_Forward_Up_Balcony.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_Balcony.LuaObjectScript.Enable()
  end
end
function CA_Balcony_Disable()
  if encounterComplete == true then
    GameObjects.CA_Observe_Forward_Up_Balcony.LuaObjectScript.Disable()
    GameObjects.CA_IdleBehavior_Balcony.LuaObjectScript.Disable()
  end
end
function CA_SonHoldPosition_Enable()
  if encounterComplete == false then
    GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Interrupt()
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Disable()
  end
end
function CA_SonHoldPosition_Disable()
  GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Interrupt()
  GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Disable()
end
function CA_ArenaOnAlert_Enable()
  if encounterComplete == false then
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Enable()
  end
end
function CA_ArenaOnAlert_Disable()
  GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
end
function CA_Arena_Enable()
  if encounterComplete == true then
    Son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_PlayWithKnife_Arena.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_Arena.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_01.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_02.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_03.LuaObjectScript.Enable()
    GameObjects.CA_LookUnderObject_Forward_Arena.LuaObjectScript.Enable()
  end
end
function CA_Arena_Disable()
  Son:CallScript("ClearBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_PlayWithKnife_Arena.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Arena.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_01.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_02.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_03.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Forward_Arena.LuaObjectScript.Disable()
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    encounterComplete = encounterComplete,
    sonWarpTriggered = sonWarpTriggered
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  encounterComplete = savedInfo.encounterComplete
  sonWarpTriggered = savedInfo.sonWarpTriggered
end
function RiftEncounter()
end
function Chisel_Encounter_1()
  ChiselEncounter1 = EC.NewEncounter(thisLevel, "ChiselEncounter1")
  ChiselEncounter1:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldownType = "Sequential",
      initialSpawnAmount = 3,
      initialSpawnCooldown = {
        1,
        3,
        5
      },
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.1
    }
  })
  ChiselEncounter1:AddWave({
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 13,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 21
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldownType = "Sequential",
      initialSpawnCooldown = {
        1,
        3,
        5,
        8
      },
      initialSpawnAmount = 4,
      maxActive = 4,
      totalSpawns = 4,
      spawnCooldown = {5, 8}
    }
  })
  ChiselEncounter1:AddWave({
    timeBeforeNextWave = 30,
    {
      spawners = "Troll_I_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  ChiselEncounter1:AddWave({
    {
      spawners = "U_Draugr_PL_SFG",
      spawnLocators = "A1_O_Loc_*",
      markerID = "Support_AI",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 1,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 16
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 21
    }
  })
  ChiselEncounter1:OnComplete(ChiselEncounter1End)
end
function Chisel_Encounter_2()
  ChiselEncounter2 = EC.NewEncounter(thisLevel, "[Chisel] EC 1")
  ChiselEncounter2:AddWave({
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = {1, 3},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.1
    }
  })
  ChiselEncounter2:AddWave({
    requiredWaveCompletion = 75,
    {
      spawners = "DarkOne_N_SFA",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = {2, 5},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.1
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 10,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    }
  })
  ChiselEncounter2:AddWave({
    {
      spawners = "Witch_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "DarkOne_N_SFA",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 10,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.1
    }
  })
end
function Fnc_Valkyrie_Fight()
  Enc_Valkyrie_Fight = EC.NewEncounter(thisLevel, "[Alf355 - Chisel Arena]EC: Valkyrie00", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Alf355_Valk"
  })
  Enc_Valkyrie_Fight:AddWave({
    {
      spawners = "Valkyrie_Evader_SSD",
      markerID = "Valkyrie_Alf355",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Enc_Valkyrie_Fight:SetStartZone(GameObjects.EntZn_Valkyrie_Spawn)
  Enc_Valkyrie_Fight:SetAlertZone(GameObjects.EntZn_Valkyrie_Alert)
  Enc_Valkyrie_Fight:OnComplete(function()
    encounterComplete = true
    CA_Arena_Enable()
    LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end)
end
function UnlockArena()
  timers.StartLevelTimer(1.5, function()
    GameObjects.primarydoor_animated_inner.Child:PlayAnimToEnd()
    GameObjects.primarydoor_animated_inner.Child:OnAnimDone(thisLevel, "HideInnerDoorCollision")
    GameObjects.primarydoor_animated_outer.Child:PlayAnimToEnd()
    GameObjects.primarydoor_animated_outer.Child:OnAnimDone(thisLevel, "HideOuterDoorCollision")
  end)
end
function HideInnerDoorCollision()
  GameObjects.primarydoor_animated_inner.Child:HideCollision()
end
function HideOuterDoorCollision()
  GameObjects.primarydoor_animated_outer.Child:HideCollision()
end
function Alf355_CloseDoor_Callback()
  print("Alf355_CloseDoor_Callback")
  if sonWarpTriggered == false then
    sonWarpTriggered = true
    GameObjects.SonWarpSafe.LuaObjectScript.WarpSon()
  end
  GameObjects.primarydoor_animated_inner.Child:PlayAnimToEnd(-1)
  GameObjects.primarydoor_animated_inner.Child:ShowCollision()
  GameObjects.primarydoor_animated_outer.Child:PlayAnimToEnd(-1)
  GameObjects.primarydoor_animated_outer.Child:ShowCollision()
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
