local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local TUT = require("game.GlobalTutorials")
local CCOS = require("camera.camera_oneshot")
local uiCalls = require("ui.uicalls")
local thisLevel, player, kraPuppeteer, pad, Encounter01, Encounter02, Golem_HealthMonitor
local bCamLightRevealPart1 = false
local bCamLightRevealPart2 = false
local varBanterPlayed = false
local bPlayCamera_FirstHiveTnF, camera_FirstHiveTnF_010, camera_FirstHiveTnF_020, camera_FirstHiveTnF_025, camera_FirstHiveTnF_030, camera_FirstHiveTnF_040, camera_FirstHiveTnF_050, bridge370Crystal_0, bridge370Crystal_1, bridge370Crystal_2
local TendrilLargeDissipated = 0
local TendrilSmallDissipated = 0
local lookAtObj, lookAtAnim, postlightWalkObj, bShowTutorialBridge, golemHelpTextTimer, golemCreature
local golemHelpTextDelay = 50
local golemHealthCheckAmt = 100
local helpTextDisplayDuration = 10
local Area_1_Encounter_1, Area_2_Encounter_1, ZM_A1_E1_Attack, ZM_A2_E1_Attack
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
  pad = player.Pad
  Area_2_Fight_1()
  bridge370Crystal_0 = level:FindGameObject("BifrostTemporal_Intact00")
  bridge370Crystal_1 = level:FindGameObject("BifrostTemporal_IntactA")
  bridge370Crystal_2 = level:FindGameObject("BifrostTemporal_IntactB")
  postlightWalkObj = level:FindGameObject("PostLightWalk")
  game.Compass.SetGatewayMarkerIsOpen("ALF_370_Helper_5", false)
  lookAtAnim = level:FindGameObject("lookAtAnim")
  lookAtObj = lookAtAnim.Child
  bShowTutorialBridge = false
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.TeachTemporal:Hide()
  GameObjects.TeachTemporalBeams:Hide()
  GameObjects.Left370Bridge:Hide()
  GameObjects.Left370Bridge:HideCollision()
  GameObjects.TnF_03_Decay:Hide()
  GameObjects.KillBoxFight:HideCollision()
  if lookAtAnim ~= nil then
    lookAtAnim:PauseAnim()
  end
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    alf000:CallScript("TurnOnTemple")
  end
end
function OnStart(level)
  GameObjects.CA_Ready2Cross.LuaObjectScript.Disable()
  GameObjects.CA_Ready2Climb.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_LB_0.LuaObjectScript.Disable()
  if Area_2_Encounter_1:WasRunning() then
    Area_2_Encounter_1:Start()
  end
  GameObjects.TnF_03_Decay:Hide()
  if game.Level.GetVariable("BridgeVanish") == true then
    GameObjects.TnF_03_Decay:Show()
  end
  if game.Level.GetVariable("ALF_TrenchEndTnF") == false then
    GameObjects.TeachTemporal:Hide()
    GameObjects.TeachTemporalBeams:Hide()
    GameObjects.Left370Bridge:Hide()
    GameObjects.Left370Bridge:HideCollision()
  end
  SoundOnStart()
end
function OnUpdate(level)
  if bPlayCamera_FirstHiveTnF == true then
    UpdateFirstHiveCameras()
  end
end
function DisableClimbExit()
  local ClimbPath = thisLevel:FindTraversePath("TraverseClimb")
  ClimbPath:Disable("ClimbEntryPoint")
  GameObjects.CA_Ready2Climb.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_LB_0.LuaObjectScript.Disable()
end
function TendrilBreak370Large()
  GameObjects.TnF_03_Decay.Child.Child:PlayAnimToEnd()
  GameObjects.HiveTendonFreeze.LuaObjectScript.LuaHook_Exit180()
  soundHiveTendonMoment()
end
function TendrilDecayedLarge()
  TendrilLargeDissipated = TendrilLargeDissipated + 1
end
function TendrilBreak370Small()
  for _, x in pairs(GameObjects.SmallHiveGeo_Decay.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  game.Compass.SetGatewayMarkerIsOpen("ALF_370_Helper_6", false)
  game.Compass.SetGatewayMarkerIsOpen("ALF_370_Helper_5", true)
end
function ShowCrawlTutorialMsg()
  TUT.Crawl_Tutorial()
end
function HideTutorialMsg()
  TUT.HideTutorial()
end
function ShowDropTutorialMsg()
  TUT.DropDown_Tutorial()
end
function TurnOffDropHint()
  GameObjects.BuddyDrop_Hint:HideEntityVolume()
  TUT.HideTutorial()
end
function Encounter370Half()
  Encounter02:Start()
end
function Encounter370End()
  timer.StartLevelTimer(3, function()
    game.Level.SetVariable("Encounter370", true)
  end)
  GameObjects.HiveTendonFreeze.LuaObjectScript.EnableInteract()
  GameObjects.CA_ReadyToChop.LuaObjectScript.Enable()
  GameObjects.KillBoxFight:HideCollision()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Warrior")
  game.Compass.SetDesignerForcedHide(false)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_Stone")
  game.Audio.StartMusic("SND_MX_ALF_dark_tree_combat_out")
end
function TentacleWrapAnim()
  timer.StartLevelTimer(0.01, function()
    GameObjects.alfheimTentacleLarge.Child:StartAnim("poiAlfSonLightBridgeObscuredTendril")
  end)
  timer.StartLevelTimer(3.2, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 2,
      TweenIn = {Time = 1},
      TweenOut = {Time = 2}
    })
    game.Blender.Trigger({
      Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
      Duration = 2,
      TweenIn = {Time = 1},
      TweenOut = {Time = 2}
    })
  end)
  PlayTentacleWrapSound()
end
function SwapHiveTentacles()
  GameObjects.alfheimTentacleLarge:Hide()
  GameObjects.TnF_03_Decay:Show()
end
function TnF_StartFight()
  Area_2_Encounter_1:Start()
  GameObjects.KillBoxFight:ShowCollision()
  GameObjects.TraverseClimb:HideTraversePath()
end
function IdleKratos()
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
end
function UnIdleKratos()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  pad:ClearAllDisabledGameButtons()
end
function TnF_Started()
  if varBanterPlayed ~= true then
    LD.CallFunctionAfterDelay(function()
      varBanterPlayed = true
      game.Audio.PlayBanter("TendrilFreeze")
    end, 2)
  end
end
function TnF_Rip()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
  timer.StartLevelTimer(10, function()
    game.Level.SetVariable("ALF_TrenchEndTnF", true)
  end)
  game.Level.SetVariable("BridgeVanish", false)
  GameObjects.TraverseUp_5M:HideTraversePath()
  GameObjects.entityZone_CrackClimb_disable:HideEntityVolume()
  GameObjects.entityZone_CrackClimb_enable:HideEntityVolume()
  local alf371 = game.FindLevel("Alf371_MoatLightsPre")
  if alf371 ~= nil then
    alf371:CallScript("TurnOnMoatLights1")
  end
  IdleKratos()
  timer.StartLevelTimer(11, UnIdleKratos)
  lookAtAnim:JumpAnimToFrame(0)
  lookAtAnim:PlayAnimToEnd()
  TendrilBreak370Large()
  GameObjects.MainHiveCollision:HideCollision()
  GameObjects.NavObstacle_ArenaExit:HideNavObstacle()
  LD.CallFunctionAfterDelay(function()
    game.Audio.StartMusic("SND_MX_ALF_light_bridge_revealed")
  end, 0.5)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Beam370:JumpAnimToFrame(0)
  end, 4)
  timer.StartLevelTimer(4.5, TurnOn320)
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("BridgeForms")
  end, 5)
  timer.StartLevelTimer(7, SonWalkPostCine)
  timer.StartLevelTimer(8, KratosWalkPostCine)
  timer.StartLevelTimer(8.8, Show370Bridges)
  timer.StartLevelTimer(9, StartAlfQuestNext)
  timer.StartLevelTimer(10, TurnOn345)
  timer.StartLevelTimer(14, BOOKMARK_06_Alfheim_037_BridgeEnabled)
end
function RemoveNavBlockerOnBridge()
  GameObjects.NavObstacle_MainBridgeStart:HideNavObstacle()
end
function KratosWalkPostCine()
  local pointPos = postlightWalkObj:GetWorldJointPosition(postlightWalkObj:GetJointIndex("walkPoint"))
  kraPuppeteer = game.Puppeteer.NewForce(postlightWalkObj, "KratosWalkPostTnF", player)
  kraPuppeteer:Approach({
    pos = pointPos,
    speed = 1.5,
    stop = true
  })
  kraPuppeteer:OnArrival(KratosSettle, {pos = pointPos, radius = 1})
end
function KratosSettle()
  if kraPuppeteer ~= nil then
    kraPuppeteer:StartMove("MOV_CineIdle_AutoExit")
    timer.StartLevelTimer(0.1, function()
      if kraPuppeteer ~= nil then
        kraPuppeteer:Clear()
        kraPuppeteer = nil
      end
    end)
  end
end
function SonWalkPostCine()
  GameObjects.CA_ReadyToChop.LuaObjectScript.Disable()
  GameObjects.LeadTheWay.LuaObjectScript.Enable()
end
function StartAlfQuestNext()
  LD.CompleteQuest("Quest_Alfheim_Objective320")
end
function Disable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
end
function TurnOn345(level, obj)
  if lookAtObj ~= nil then
    lookAtObj.LuaObjectScript.DisableLookAt()
  end
  local alf345 = game.FindLevel("Alf345_TrenchBDarkTWR")
  if alf345 ~= nil then
    alf345:CallScript("ActivateLift")
  end
end
function TurnOn320(level, obj)
  local alf320 = game.FindLevel("Alf320_TrenchADark")
  if alf320 ~= nil then
    alf320:CallScript("ActivateBridge")
  end
end
function Show370Bridges()
  game.Compass.SetGatewayMarkerIsOpen("ALF_370_Helper_6", true)
  TurnBridgesOn()
  GameObjects.BridgeSheetVisOff:HideCollision()
  bridge370Crystal_1.LuaObjectScript.SetCrystalObjectStates(2)
  bridge370Crystal_2.LuaObjectScript.SetCrystalObjectStates(2)
  local alf371 = game.FindLevel("Alf371_MoatLightsPre")
  if alf371 ~= nil then
    alf371:CallScript("TurnOnMoatLights2")
  end
end
function TurnBridgesOn()
  for _, x in pairs(GameObjects.Left370Bridge.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.TurnTemporalObjectOn()
    else
      x:Show()
    end
  end
end
function ActivateSlowZone_TendrilTutorial()
  local goSpeedZone = thisLevel:GetGameObject("SpeedController_Alf370_TendrilTutorial")
  goSpeedZone:Show()
end
function DeactivateSlowZone_TendrilTutorial()
  local goSpeedZone = thisLevel:GetGameObject("SpeedController_Alf370_TendrilTutorial")
  goSpeedZone:Hide()
end
function alfheimBridgeTutorial()
  game.Level.SetVariable("TempBridge", true)
  timer.StartLevelTimer(4.75, teachingTemporal)
  timer.StartLevelTimer(2.5, teachingBeams)
  soundLightBridge1()
  timer.StartLevelTimer(2.5, alfheimTutorialLight)
  timer.StartLevelTimer(0.5, function()
    GameObjects.TendrilAxeTarget11:Hide()
  end)
  timer.StartLevelTimer(0.5, function()
    GameObjects.TendrilAxeTarget12:Hide()
  end)
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("SmallLightBlockerFreed")
  end, 1.3)
  local player = game.Player.FindPlayer()
  local recenterToLock = {
    TimeStart = 0,
    TimeDuration = 3,
    LockRecenter = 1,
    YawRange = -1,
    TriggerLeft = 0,
    TriggerRight = 0,
    ReturnLeft = 180,
    ReturnRight = -180,
    PitchRange = -1,
    ReturnDown = -90,
    ReturnUp = 90
  }
  game.Camera.Recenter(recenterToLock)
  bShowTutorialBridge = true
  local fnf = thisLevel:GetGameObject("FNF_LookAtLightBridge").Child
  ActivateSlowZone_TendrilTutorial()
  timer.StartLevelTimer(7.7, function()
    DeactivateSlowZone_TendrilTutorial()
  end)
end
function GetBool_bShowTutorialBridge()
  return bShowTutorialBridge
end
function alfheimTutorialLight()
  local alf371 = game.FindLevel("Alf371_MoatLightsPre")
  if alf371 ~= nil then
    alf371:CallScript("TemporalTutorialLights")
  end
end
function teachingTemporal()
  bridge370Crystal_0.LuaObjectScript.SetCrystalObjectStates(2)
  GameObjects.CA_Ready2Cross.LuaObjectScript.Interrupt()
  GameObjects.CA_Ready2Cross.LuaObjectScript.Disable()
  GameObjects.CA_Ready2Climb.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_LB_0.LuaObjectScript.Enable()
  GameObjects.SmallBridgeSheetOff:HideCollision()
end
function teachingBeams()
  GameObjects.TeachTemporalBeams:Show()
  GameObjects.TeachTemporalBeamsOFF:Hide()
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dark One Fight AlfDgn370", {CheckpointOnComplete = true})
  Area_2_Encounter_1:AddWave({
    {
      spawners = "DarkOne_H_SFA",
      spawnLocators = "A2_O_T_Loc_1",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "DarkOne_H_SFBF",
      spawnLocators = "A2_O_Loc_5",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DarkOne_UP_TURR",
      spawnLocators = "A2_P_Loc_1",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "Goilem00_DORMANT",
      spawnWad = "Alf370_AI_01",
      markerID = "Golem370",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "DarkOne_TURR",
      spawnLocators = "A2_O_T_Loc_2",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    prioritizeSpawnersInRange = {14, 40},
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DarkOne_H_SFBF",
      spawnLocators = "A2_O_Loc_*",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    },
    {
      spawners = "DarkOne_H_SFBF",
      spawnLocators = "A2_O_Loc_*",
      spawnWad = "Alf340_AI_TrenchPre",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_2_Encounter_1:OnEnemySpawn(Golem_Health_Encounter, {markerID = "Golem370"})
  Area_2_Encounter_1:OnComplete(Encounter370End)
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(2)
  end, {count = 3})
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:AlertEnemies()
  end, {count = 4})
  Area_2_Encounter_1:OnStart(function()
    game.World.StoreCheckpoint()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_2_Encounter_1:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_ALF_dark_tree_combat_in")
  end)
end
function Golem_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local GolemHealth = Enemy:GetHitPoints()
    Golem_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = GolemHealth * 0.5
    Golem_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_2_Encounter_1:StartWave(3)
    end)
  end
end
local CleanUpGolemHelpTextTimer = function(level)
  if golemHelpTextTimer ~= nil then
    golemHelpTextTimer:Stop()
    golemHelpTextTimer = nil
  end
end
local GolemHelpTextCheck = function()
  if golemCreature ~= nil then
    local currentHealth = golemCreature.HitPoints
    if 0 < currentHealth and currentHealth >= golemHealthCheckAmt then
      uiCalls.SendSidebarDesignerMessage({
        Text = 40934,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        DisplayTime = helpTextDisplayDuration
      })
    elseif currentHealth <= 0 then
      CleanUpGolemHelpTextTimer()
    end
    CleanUpGolemHelpTextTimer()
  else
    CleanUpGolemHelpTextTimer()
  end
end
function LuaHook_StartGolemHelpTimer(level, creature)
  golemCreature = creature
  golemHelpTextTimer = StartLevelTimer(golemHelpTextDelay, GolemHelpTextCheck)
  golemHealthCheckAmt = golemCreature.HitPoints
  golemHelpTextTimer:Restart()
end
function LuaHook_StopGolemHelpTimer(level, creature)
  CleanUpGolemHelpTextTimer()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function StopDesignerCamera()
  bPlayCamera_FirstHiveTnF = false
end
function StartFirstHiveTnFCam_010()
  camera_FirstHiveTnF_010 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_010", 4)
  camera_FirstHiveTnF_010:Start()
end
function StartFirstHiveTnFCam_020()
  camera_FirstHiveTnF_020 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_020", 4)
  camera_FirstHiveTnF_020:Start()
end
function StartFirstHiveTnFCam_025()
  camera_FirstHiveTnF_025 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_025", 5)
  camera_FirstHiveTnF_025:Start()
end
function StartFirstHiveTnFCam_030()
  camera_FirstHiveTnF_030 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_030", 6)
  camera_FirstHiveTnF_030:Start()
end
function StartFirstHiveTnFCam_040()
  camera_FirstHiveTnF_040 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_040", 2.5)
  camera_FirstHiveTnF_040:Start()
end
function StartFirstHiveTnFCam_050()
  camera_FirstHiveTnF_050 = CCOS.OneShotCamera.New("PLYR_Nar_FirstHiveTnF_050", 1.5)
  camera_FirstHiveTnF_050:SetCallback(StopDesignerCamera)
  camera_FirstHiveTnF_050:Start()
end
function StartRevealCameras()
  bPlayCamera_FirstHiveTnF = true
  timer.StartLevelTimer(0, StartFirstHiveTnFCam_010)
  timer.StartLevelTimer(0.7, StartFirstHiveTnFCam_020)
  timer.StartLevelTimer(2, StartFirstHiveTnFCam_025)
  timer.StartLevelTimer(6, StartFirstHiveTnFCam_030)
  timer.StartLevelTimer(11, StartFirstHiveTnFCam_040)
  timer.StartLevelTimer(13, StartFirstHiveTnFCam_050)
end
function UpdateFirstHiveCameras()
  if camera_FirstHiveTnF_010 ~= nil then
    camera_FirstHiveTnF_010:Update()
  end
  if camera_FirstHiveTnF_020 ~= nil then
    camera_FirstHiveTnF_020:Update()
  end
  if camera_FirstHiveTnF_025 ~= nil then
    camera_FirstHiveTnF_025:Update()
  end
  if camera_FirstHiveTnF_030 ~= nil then
    camera_FirstHiveTnF_030:Update()
  end
  if camera_FirstHiveTnF_040 ~= nil then
    camera_FirstHiveTnF_040:Update()
  end
  if camera_FirstHiveTnF_050 ~= nil then
    camera_FirstHiveTnF_050:Update()
  end
end
function OnEvaluateLoadGroup_Lighting()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function BOOKMARK_06_Alfheim_037_BridgeEnabled()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_037_BridgeEnabled"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
local SNDLightBridgeHide, SNDLightBridgeShow1, SNDLightOn
function SoundInit()
  SNDLightBridgeHide = GameObjects.SNDGrpLightBridgeHide:FindSingleSoundEmitterByName("SNDLightBridgeHide")
  SNDLightBridgeShow1 = GameObjects.SNDGrpLightBridgeShow1:FindSingleSoundEmitterByName("SNDLightBridgeShow1")
  SNDLightOn = GameObjects.SNDGrpLightOn:FindSingleSoundEmitterByName("SNDLightOn")
end
function SoundOnStart()
  if game.Level.GetVariable("BridgeVanish") == false then
    LD.PlayRestartableSoundLoop(SNDLightOn, "SND_MAG_Temporal_Light_Crystal_Active_LP")
  end
end
function PlayTentacleWrapSound()
  LD.PlaySound(SNDLightBridgeHide, "SND_EVNT_Alf300_Bridge_Intro_Obscured")
end
function soundLightBridge1()
  LD.PlaySound(SNDLightBridgeShow1, "SND_MAG_Temporal_Light_Crystal_Active_LP")
end
function soundHiveTendonMoment()
  LD.PlayRestartableSoundLoop(SNDLightOn, "SND_MAG_Temporal_Light_Crystal_Active_LP")
  LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), "SND_TNF_Alf000_Hive_Tendon_Moment")
end
