local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local TUT = require("game.GlobalTutorials")
local CCOS = require("camera.camera_oneshot")
local thisLevel, Encounter01, oneShotSummonerIntroCam, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2, Area_2_Encounter_3, Area_2_Encounter_4, ZM_A1_E1_Attack, ZM_A2_E1_Attack
function OnScriptLoaded(level)
  thisLevel = level
  Area_1_Fight_1()
  Area_2_Fight_1()
end
function OnFirstStart()
  GameObjects.FlyerSpawnZone:HideEntityVolume()
end
function OnUpdate(level)
  if game.Player.FindPlayer():InsideZone(GameObjects.EntZn_Area_2_Attack) and LD.GetEntityVariable("HallwayFight02Started") == false then
    LD.SetEntityVariable("HallwayFight02Started", true)
  end
  if oneShotSummonerIntroCam ~= nil then
    oneShotSummonerIntroCam:Update()
  end
end
function HideTutorialMsg()
  TUT.HideTutorial()
end
function ShowDropTutorialMsg()
  TUT.DropDown_Tutorial()
end
function EnableCA_CrawlExit()
  GameObjects.CA_CrawlExit.LuaObjectScript.Enable()
end
function DisableCA_CrawlExit()
  GameObjects.CA_CrawlExit.LuaObjectScript.Disable()
end
function Enable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Enable()
end
function Disable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
end
function FirePulse()
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Summoner intro AlfDgn390", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone390"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DarkOne_SUM",
      spawnLocators = "A1_Loc_1_1",
      markerID = "DarkSummoner",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Attack)
  Area_1_Encounter_1:OnCombatStart(function()
    Area1MusicFun()
  end)
  Area_1_Encounter_1:OnStart(function()
    timer.StartLevelTimer(4, function()
      GameObjects.BridgeSlowDownZone:HideEntityVolume()
    end)
  end)
  Area_1_Encounter_1:OnStart(function()
    timer.StartLevelTimer(2.5, CameraStartSummonerOneShot)
  end)
  Area_1_Encounter_1:OnComplete(Hallway01FightComplete)
end
function CameraStartSummonerOneShot()
  oneShotSummonerIntroCam = CCOS.OneShotCamera.New("PLYR_Nar_DarkOneSummoner", 2.5)
  oneShotSummonerIntroCam:Start()
  oneShotSummonerIntroCam:SetCallback(CameraDestroySummonerOneShot)
  game.Camera.Recenter({
    RotationSpace = 1,
    TimeStart = 0,
    TimeDuration = 3.5,
    LockRecenter = 0.32,
    PitchRange = -1,
    TriggerUp = 2,
    ReturnUp = 2,
    ReturnDown = 2,
    TriggerDown = 2,
    YawRange = -1,
    TriggerLeft = 167,
    ReturnLeft = 167,
    ReturnRight = 167,
    TriggerRight = 167
  })
end
function CameraDestroySummonerOneShot()
  oneShotSummonerIntroCam = nil
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Flyer & Darkones Fight AlfDgn390", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone390"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Flyer_SUI_PATROL_1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SUI_PATROL_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SUI_PATROL_3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SUI_IDLE_1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SUI_IDLE_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Flyer_SAG",
      spawnLocators = "A2_U_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SAG",
      spawnLocators = "A2_U_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_DarkOne_SFA",
      spawnLocators = "A2_U_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_DarkOne_SFL8",
      spawnLocators = "A2_O_LocL_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Flyer_SAG",
      spawnLocators = "A2_U_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    },
    {
      spawners = "Flyer_SAG",
      spawnLocators = "A2_U_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 12
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_Attack)
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(2)
  end, {count = 3})
  Area_2_Encounter_1:OnCombatStart(function()
    Area2MusicFun()
  end)
  Area_2_Encounter_1:OnComplete(Hallway02FightComplete)
end
function Loot_Drop_390()
  for _, x in pairs(GameObjects.HiveTendrils.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  GameObjects.HiveCoffin_tier1_alf390_1.LuaObjectScript.Enable()
  GameObjects.TendrilWall:HideCollision()
end
function Hallway01FightComplete()
  CheckMusicArea1()
  LD.SetEntityVariable("HallwayFight01", true)
  if Area_1_Encounter_1:IsComplete() and Area_2_Encounter_1:IsComplete() then
    game.World.StoreCheckpoint()
  end
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Summoner")
end
function Hallway02FightComplete()
  CheckMusicArea2()
  LD.SetEntityVariable("HallwayFight02", true)
  if Area_1_Encounter_1:IsComplete() and Area_2_Encounter_1:IsComplete() then
    game.World.StoreCheckpoint()
  end
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Suicide")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Warrior")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
local musicisactive
function Area1MusicFun()
  if not musicisactive then
    game.Audio.StartMusic("SND_MX_ALF_temple_hallway_combat1_in")
    musicisactive = true
  end
end
function Area2MusicFun()
  if not Area_1_Encounter_1:IsRunning() then
    game.Audio.StartMusic("SND_MX_ALF_temple_hallway_combat1_in")
  end
end
function CheckMusicArea1()
  if not Area_2_Encounter_1:IsRunning() then
    game.Audio.StartMusic("SND_MX_ALF_temple_hallway_combat1_out")
  end
end
function CheckMusicArea2()
  if not Area_1_Encounter_1:IsRunning() then
    game.Audio.StartMusic("SND_MX_ALF_temple_hallway_combat1_out")
  end
end
