local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local tendrilCountNum = 0
local tendrilBtrTimer
local playedBtr = {
  played01 = false,
  played02 = false,
  played03 = false
}
function OnSaveCheckpoint(level, obj)
  return {playedTab = playedBtr}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedBtr = savedInfo.playedTab
end
function PlayTendrilCutBtr()
  if not playedBtr.played03 and tendrilBtrTimer == nil then
    if not playedBtr.played01 then
      playedBtr.played01 = true
      tendrilBtrTimer = timers.StartLevelTimer(2, PlayFirstAttempt)
    elseif not playedBtr.played02 then
      playedBtr.played02 = true
      tendrilBtrTimer = timers.StartLevelTimer(2, PlaySecondAttempt)
    end
  end
end
function PlayFirstAttempt()
  if not playedBtr.played03 then
    game.Audio.PlayBanter("Alf_TripleThreat_Son1")
  end
  tendrilBtrTimer = nil
end
function PlaySecondAttempt()
  if not playedBtr.played03 then
    game.Audio.PlayBanter("Alf_TripleThreat_Son2")
  end
  tendrilBtrTimer = nil
end
function PlayTendrilWinBtr()
  playedBtr.played03 = true
  game.Audio.PlayBanter("Alf_TripleThreat_Son3")
end
function Fight1End()
  return game.Level.GetVariable("HallwayFight01") == true and (game.Level.GetVariable("HallwayFight02Started") == false or game.Level.GetVariable("HallwayFight02") == true)
end
function CheckFightDone()
  return game.Level.GetVariable("HallwayFight02")
end
