local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local timer = require("level.timer")
local thisObj, thisLevel, darkOneEliteActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  CreateActors()
  SpawnDarkOneElite()
end
function SpawnDarkOneElite()
  darkOneEliteActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Btr_TheDarkOnesReturns", "DarkOneReturns_ZeroJoint", "CRT_DarkOneElite00", "BRA_TempleEntryCry", "darkOneElite")
  end)
end
function PlayTheDarkOneReturnsBanter1()
  timer.StartLevelTimer(1.5, function()
    game.Audio.PlayBanter("TheDarkOneReturns")
  end)
  LD.CallFunctionAfterDelay(DarkOneReturns_Sequence, 3)
  GameObjects.Btr_TheDarkOnesReturns:HideEntityVolume()
end
function CreateActors()
  darkOneEliteActor = actor.Actor.New("POI Dark One Returns: Dark One Elite")
end
function PlayTheDarkOneReturnsBanter2()
  timer.StartLevelTimer(3.2, function()
    game.Audio.PlayBanter("TheDarkOneReturns2")
  end)
end
function DarkOneReturns_Sequence()
  local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "Dark One Returns POI")
  local darkOneReturns_ActorTable = {}
  cineSeq:SpawnActorAndWait(darkOneEliteActor)
  cineSeq:RequestCineModeAndWait(darkOneEliteActor, thisObj)
  cineSeq:Do(PlayTheDarkOneReturnsBanter2)
  cineSeq:ActorSync(darkOneEliteActor, {
    Slaves = darkOneReturns_ActorTable,
    Branch = "BRA_TempleEntryCry",
    ReferenceJoint = "DarkOneReturns_SynchJoint"
  })
  cineSeq:WaitForAndCompleteCineMode(darkOneEliteActor, thisObj)
  cineSeq:StopPuppetingActor(darkOneEliteActor)
  cineSeq:DespawnActor(darkOneEliteActor)
  cineSeq:Do(function()
    GameObjects.Btr_TheDarkOnesReturns:Hide()
  end)
  cineSeq:StartSequence()
end
