local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local CWU = require("camera.camera_wakeup")
local thisLevel, Encounter01, Encounter02, TnFCrystal01, TnFCrystal02
local FightIC = false
local LightStruggle = false
local player, pad, cineDarkOne_01, cineDarkOne_02, cineDarkOne_03, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
  thisLevel = level
  Alf450_Area_1_Fight_1()
  Alf450_Area_2_Fight_1()
  Alf450_Area_2_Fight_2()
  TnFCrystal01 = level:FindGameObject("Crystal032")
  TnFCrystal02 = level:FindGameObject("Crystal03")
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.TemporalBridge_01:Hide()
  GameObjects.WALKWAY_IC_450_A:HideCollision()
  GameObjects.TemporalBridge_01:HideLights()
  GameObjects.TemporalBridge_02:Hide()
  GameObjects.WALKWAY_IC_450_B:HideCollision()
  GameObjects.TemporalBridge_02:HideLights()
  GameObjects.LightStruggleLight:HideLights()
end
function OnStart(level)
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:OnStart(function()
      Area_1_Encounter_1:SetSpawnCooldown({
        wave = 2,
        element = 1,
        cooldown = 1
      })
      Area_1_Encounter_1:SetSpawnCooldown({
        wave = 2,
        element = 2,
        cooldown = 2
      })
      Area_1_Encounter_1:SetSpawnCooldown({
        wave = 3,
        element = 1,
        cooldown = 2.5
      })
      Area_1_Encounter_1:StartWave(2)
      Area_1_Encounter_1:StartWave(3)
    end)
    Area_1_Encounter_1:Start()
  end
end
function OnUpdate(level)
  if player:InsideZone(GameObjects.First_Fight_IC) and FightIC == false then
    FightIC = true
    GameObjects.RingClimb:HideTraversePath()
  end
  if player:InsideZone(GameObjects.LightStruggleZone) and LightStruggle == false then
    LightStruggle = true
    GameObjects.LightStruggleZone:HideEntityVolume()
    GameObjects.LightStruggleLight:PlayAnimToEnd()
    GameObjects.LightStruggleLight:ShowLights()
    timer.StartLevelTimer(0.1, function()
      GameObjects.LightBridgeTakedown.LuaObjectScript.TurnTemporalObjectOn()
    end)
    timer.StartLevelTimer(28, function()
      GameObjects.LightStruggleLight:HideLights()
    end)
    timer.StartLevelTimer(12.26, function()
      GameObjects.LightBridgeTakedown.LuaObjectScript.FlickerOff()
    end)
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CrackClimb_Alf450_RingClimb*") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_Vista_LS_AlfheimRing")
  end
end
function HideCLB()
  GameObjects.LightBridgeTakedown.LuaObjectScript.TurnTemporalObjectOff()
  GameObjects.LightBridgeTakedown:Hide()
end
function FirePulse()
end
function DisableClimbExit()
  local ClimbPath = thisLevel:FindTraversePath("RingClimb")
  ClimbPath:Disable("ClimbEntryPoint")
end
function Start_Quest_Alfheim_Objective390()
  LD.CompleteQuest("Quest_Alfheim_Objective390")
  game.Compass.SetGatewayMarkerIsOpen("ALF_690_Helper_03", true)
end
function Start_Quest_Alfheim_Objective450()
  LD.CompleteQuest("Quest_Alfheim_Objective450")
end
function Start_Quest_Alfheim_Objective460()
  LD.CompleteQuest("Quest_Alfheim_Objective460")
end
function SoftSave()
  game.SubObject.SoftSave()
end
function MainEntryCut()
  local links = GameObjects.WeakPointMain:FindSingleGOByName("Links")
  local weak = GameObjects.WeakPointMain:FindSingleGOByName("WeakPoint")
  timer.StartLevelTimer(1.2, weak:Hide())
  timer.StartLevelTimer(0.8, links:PlayAnimToEnd())
end
function alfheimHiveTnF_01()
  DisableCameraControl()
  GameObjects.HiveTendonFreeze01.LuaObjectScript.LuaHook_Exit180()
  EnableTLW_0()
  timer.StartLevelTimer(2.5, function()
    soundActivateBridge1()
    TnFCrystal01.LuaObjectScript.SetCrystalObjectStates(2)
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.Window01Sheet:HideCollision()
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.WALKWAY_IC_450_A:ShowCollision()
  end)
  timer.StartLevelTimer(2.5, function()
    game.Level.SetVariable("ALF_NAR_HiveClear01", true)
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.TemporalBridge_01:ShowLights()
  end)
  timer.StartLevelTimer(3.5, function()
    soundLightBridge1()
  end)
  timer.StartLevelTimer(4, EnableCameraControl)
end
function alfheimHiveTnF_02()
  DisableCameraControl()
  GameObjects.HiveTendonFreeze02.LuaObjectScript.LuaHook_Exit180()
  timer.StartLevelTimer(2.35, EnableTLW)
  timer.StartLevelTimer(2.5, function()
    soundActivateBridge2()
    TnFCrystal02.LuaObjectScript.SetCrystalObjectStates(2)
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.Window02Sheet:HideCollision()
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.WALKWAY_IC_450_B:ShowCollision()
  end)
  timer.StartLevelTimer(2.5, function()
    game.Level.SetVariable("ALF_NAR_HiveClear02", true)
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.TemporalBridge_02:ShowLights()
  end)
  timer.StartLevelTimer(3.5, function()
    soundLightBridge2()
  end)
  timer.StartLevelTimer(4, EnableCameraControl)
end
function DisableCameraControl()
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
end
function EnableCameraControl()
  pad:EnableGameButton(tweaks.ePad.kPadRightStickX)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickY)
end
function EnableTLW_0()
  GameObjects.CA_Point_Forward.LuaObjectScript.Enable()
end
function EnableTLW()
  GameObjects.LeadTheWay.LuaObjectScript.Enable()
end
function DisableTLW()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
end
function GotoCAIdle()
  Start_Quest_Alfheim_Objective450()
  GameObjects.CA_PuzzleIdle.LuaObjectScript.Enable()
  GameObjects.ca_puzzled.LuaObjectScript.Enable()
  GameObjects.CA_PuzzleIdle.LuaObjectScript.Enable()
  GameObjects.CA_TakeOutJournal.LuaObjectScript.Enable()
  GameObjects.CA_PuzzleStart.LuaObjectScript.Disable()
  DisableTLW()
end
function TriggerTemporalObject(tObj)
  for _, x in pairs(tObj.Descendants) do
    if x.LuaObjectScript and x.LuaObjectScript.IsTemporalObject then
      x.LuaObjectScript.TurnTemporalObjectOn()
    else
      x:Show()
    end
  end
end
function Hive1EncounterComplete()
  game.Compass.SetDesignerForcedHide(false)
  GameObjects.Btr_TempleOverHere.LuaObjectScript.PlayTWNBtr()
  GameObjects.HiveTendonFreeze01.LuaObjectScript.EnableInteract()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Summoner")
  BOOKMARK_06_Alfheim_045_AfterCrackClimb()
end
function Hive2_1_EncounterComplete()
  LD.SetEntityVariable("HiveFight02_1", true)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Suicide")
end
function Hive2_2_EncounterComplete()
  game.Compass.SetDesignerForcedHide(false)
  LD.SetEntityVariable("HiveFight02_2", true)
  GameObjects.HiveTendonFreeze02.LuaObjectScript.EnableInteract()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Summoner")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Suicide")
end
function HiveOpenComplete_1()
  GameObjects.CA_PuzzleIdle.LuaObjectScript.Disable()
  GameObjects.CA_PuzzleSolved.LuaObjectScript.Enable()
  GameObjects.CA_PuzzleHint.LuaObjectScript.Disable()
  GameObjects.CA_PuzzleIdle.LuaObjectScript.Disable()
  GameObjects.ca_puzzled.LuaObjectScript.Disable()
  GameObjects.CA_TakeOutJournal.LuaObjectScript.Disable()
  GameObjects.EntZn_ContextWaitAndExplore:HideEntityVolume()
  game.Level.SetVariable("Tendril1Destroyed", true)
  GameObjects.HiveBlocker_Ground_8m_01.Child.LuaObjectScript.StartDecay()
  GameObjects.HiveBlocker_Ground_8m_01B.LuaObjectScript.StartDecay()
  GameObjects.HiveBlocker_EpicPuzzle_C.LuaObjectScript.StartDecay()
  timer.StartLevelTimer(1, function()
    GameObjects.OPENHIVE_GEO_1:HideCollision()
    GameObjects.Tendrils_OPENHIVE_1:Hide()
  end)
end
function HiveOpenComplete_2()
  game.Level.SetVariable("Tendril2Destroyed", true)
  GameObjects.HiveBlocker_Ground_8m_02.Child.LuaObjectScript.StartDecay()
  GameObjects.HiveBlocker_EpicPuzzle_A.LuaObjectScript.StartDecay()
  timer.StartLevelTimer(1, function()
    GameObjects.OPENHIVE_GEO_2:HideCollision()
    GameObjects.Tendrils_OPENHIVE_2:Hide()
  end)
end
function HiveOpenComplete_3()
  game.Level.SetVariable("Tendril3Destroyed", true)
  GameObjects.Btr_LooksHard.LuaObjectScript.PauseTooHard()
  GameObjects.CA_PuzzleHint.LuaObjectScript.Interrupt()
  GameObjects.CA_PuzzleHint.LuaObjectScript.Disable()
  GameObjects.CA_PuzzleIdle.LuaObjectScript.Enable()
  GameObjects.HiveBlocker_Ground_8m_03.Child.LuaObjectScript.StartDecay()
  GameObjects.HiveBlocker_EpicPuzzle_B.LuaObjectScript.StartDecay()
  timer.StartLevelTimer(1, function()
    GameObjects.OPENHIVE_GEO_3:HideCollision()
    GameObjects.Tendrils_OPENHIVE_3:Hide()
  end)
end
function EnterPuzzleArea()
  LD.CallFunctionAfterDelay(CheckPuzzleHint, 150)
  local alf050 = game.FindLevel("Alf050_Sound")
  if alf050 then
    alf050:CallScript("Show490Zones")
  end
end
function CheckPuzzleHint()
  if LD.GetEntityVariable("Tendril3Destroyed") ~= true then
    GameObjects.CA_PuzzleHint.LuaObjectScript.Enable()
    GameObjects.CA_PuzzleIdle.LuaObjectScript.Disable()
    GameObjects.Btr_LooksHard.LuaObjectScript.PauseTooHard()
  end
end
function GetCineEncounter()
  return Area_1_Encounter_1
end
function Alf450_Area_1_Fight_1_StartWave03()
  Area_1_Encounter_1:StartWave(3)
  game.Compass.SetDesignerForcedHide(true)
end
function Alf450_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 First Fight AlfDgn450", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone450",
    StartMusic = "SND_MX_ALF_hive_exterior_combat1_in",
    StopMusic = "SND_MX_ALF_hive_exterior_combat1_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DarkOne_CINE_LOTakedown_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    {
      spawners = "DarkOne_CINE_LOTakedown_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DarkOne_CINE_LOTakedown_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    {
      spawners = "DarkOne_SUM3_SFL8",
      spawnLocators = "A1_S_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "DarkOne_H_SFBF",
      spawnLocators = "A1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {15, 18}
    }
  })
  Area_1_Encounter_1:OnCombatStart(function()
    Area_1_Encounter_1:AlertEnemies(1)
  end, 0.5)
  Area_1_Encounter_1:OnComplete(Hive1EncounterComplete)
end
function Alf450_Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1_2 Smaller Middle AlfDgn450", {CheckpointOnComplete = false})
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Flyer_SBUP",
      spawnLocators = "A1_2_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyer_SBUP",
      spawnLocators = "A1_2_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Flyer_SBUP",
      spawnLocators = "A1_2_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Flyer_SBUP",
      spawnLocators = "A1_2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Flyer_SBUP",
      spawnLocators = "A1_2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_1_Spawn)
  Area_2_Encounter_1:OnComplete(Hive2_1_EncounterComplete)
end
function Alf450_Area_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:2 Second AlfDgn450", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_ALF_hive_exterior_combat1_in",
    StopMusic = "SND_MX_ALF_hive_exterior_combat1_out"
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Flyer_SBFWD",
      spawnLocators = "A2_F_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SBFWD",
      spawnLocators = "A2_F_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Flyer_SBFWD",
      spawnLocators = "A2_F_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {14.3, 16.8}
    },
    {
      spawners = "DarkOne_SUM3_SFL8",
      spawnLocators = "A2_S_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "DarkOne_H_SFBF",
      spawnLocators = "A2_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {16.3, 20.8}
    },
    {
      spawners = "Flyer_SBFWD",
      spawnLocators = "A2_F_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {23.3, 28.8}
    }
  })
  Area_2_Encounter_2:SetStartZone(GameObjects.EntZn_Area_2_2_Spawn)
  Area_2_Encounter_2:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_2_Encounter_2:OnComplete(Hive2_2_EncounterComplete)
end
function WakeRingClimbJumpFWD()
  CWU.WakeUpTheRecenterZones("Recenters_Wake_RingClimbFWD", thisLevel)
end
function ShutOffTightCam()
  GameObjects.CamZone_CrackClimb_Alf450_RingClimb_030_TightFWD:HideCameraVolume()
end
function TurnOnTightCam()
  GameObjects.CamZone_CrackClimb_Alf450_RingClimb_030_TightFWD:ShowCameraVolume()
end
local soundEmitter1, soundEmitter2, soundEmitter3, soundEmitter4, soundEmitter5, soundEmitter6, soundEmitter7
function SoundInit()
  soundEmitter1 = GameObjects.SNDGrpTemporalBridge_01:FindSingleSoundEmitterByName("SNDTemporalBridge_01")
  soundEmitter2 = GameObjects.SNDGrpTemporalBridge_02:FindSingleSoundEmitterByName("SNDTemporalBridge_02")
  soundEmitter3 = GameObjects.SNDGrpBridgeActivate1:FindSingleSoundEmitterByName("SNDBridgeActivate1")
  soundEmitter4 = GameObjects.SNDGrpBridgeActivate2:FindSingleSoundEmitterByName("SNDBridgeActivate2")
  soundEmitter5 = GameObjects.SNDGrpLightPillar1:FindSingleSoundEmitterByName("SNDLightPillar1")
  soundEmitter6 = GameObjects.SNDGrpLightPillar2:FindSingleSoundEmitterByName("SNDLightPillar2")
  soundEmitter7 = GameObjects.SNDGrpLightPillar3:FindSingleSoundEmitterByName("SNDLightPillar3")
end
function soundLightBridge1()
  LD.PlaySound(soundEmitter1, "SND_MAG_Temporal_Light_Bridge_LP")
  LD.PlaySound(soundEmitter5, "SND_MAG_Temporal_Light_Bridge_LP")
end
function soundLightBridge2()
  LD.PlaySound(soundEmitter2, "SND_MAG_Temporal_Light_Bridge_LP")
  LD.PlaySound(soundEmitter6, "SND_MAG_Temporal_Light_Bridge_LP")
  LD.PlaySound(soundEmitter7, "SND_MAG_Temporal_Light_Bridge_LP")
end
function soundActivateBridge1()
  LD.PlaySound(soundEmitter3, "SND_MAG_Temporal_Light_Crystal_Active_LP_Start")
end
function soundActivateBridge2()
  LD.PlaySound(soundEmitter4, "SND_MAG_Temporal_Light_Crystal_Active_LP_Start")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function BOOKMARK_06_Alfheim_045_AfterCrackClimb()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_045_AfterCrackClimb"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
