local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local playedLooksHardSolvedBool = false
local playedMissedBtrBool = {
  played00 = false,
  played01 = false,
  played02 = false,
  played03 = false
}
local looksHardTimer
local varFailedCounter = 0
local bHintInProgress = false
function OnScriptLoaded(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {btrSolved = playedLooksHardSolvedBool, btrMissed = playedMissedBtrBool}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedLooksHardSolvedBool = savedInfo.btrSolved
  playedMissedBtrBool = savedInfo.btrMissed
end
function FailedOne()
  if bHintInProgress == false then
    varFailedCounter = varFailedCounter + 1
    if varFailedCounter == 4 then
      varFailedCounter = 0
      PlayTendrilCutBtr()
    end
  end
end
function PlayTendrilCutBtr()
  if playedLooksHardSolvedBool == false and looksHardTimer == nil then
    if playedMissedBtrBool.played00 == false then
      playedMissedBtrBool.played00 = true
      looksHardTimer = timers.StartLevelTimer(1, PlayTooHard)
    elseif playedMissedBtrBool.played01 == false then
      playedMissedBtrBool.played01 = true
      looksHardTimer = timers.StartLevelTimer(2, PlayFirstAttempt)
    elseif playedMissedBtrBool.played02 == false then
      playedMissedBtrBool.played02 = true
      looksHardTimer = timers.StartLevelTimer(4, PlaySecondAttempt)
    elseif playedMissedBtrBool.played03 == false then
      playedMissedBtrBool.played03 = true
      looksHardTimer = timers.StartLevelTimer(1, PlayThirdAttempt)
    end
  end
end
function PlayTooHard()
  if playedLooksHardSolvedBool == false then
    game.Audio.PlayBanter("LooksTooHard")
  end
  looksHardTimer = nil
end
function PlayFirstAttempt()
  if playedLooksHardSolvedBool == false then
    game.Audio.PlayBanter("Alf_LooksTooHard_Son1")
  end
  looksHardTimer = nil
end
function PlaySecondAttempt()
  if playedLooksHardSolvedBool == false then
    game.Audio.PlayBanter("Alf_LooksTooHard_Son2")
  end
  looksHardTimer = nil
end
function PlayThirdAttempt()
  if playedLooksHardSolvedBool == false then
    game.Audio.PlayBanter("Alf_LooksTooHard_Son3")
  end
  looksHardTimer = nil
end
function PlayTendrilWinBtr()
  timers.StartLevelTimer(2, function()
    game.Audio.PlayBanter("LooksTooHard_Solved")
  end)
end
function PauseTooHard()
  bHintInProgress = true
end
function ResumeTooHard()
  varFailedCounter = 0
  bHintInProgress = false
end
