local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel, player, son, hintTimer
local playedTOHHintBool = false
local playedTOHBool = false
local playedTDIBool = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  son = game.AI.FindSon()
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    playedHintBtr = playedTOHHintBool,
    playedTOHBtr = playedTOHBool,
    playedTDIBtr = playedTDIBool
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedTOHHintBool = savedInfo.playedHintBtr
  playedTOHBool = savedInfo.playedTOHBtr
  playedTDIBool = savedInfo.playedTDIBtr
end
function PlayTWNBtr()
  if playedTOHHintBool == false then
    playedTOHHintBool = true
    game.Audio.PlayBanter("TempleWhatNow")
    hintTimer = timers.StartLevelTimer(60, GotoHintPos)
  end
end
function GotoHintPos()
  LD.GoToLocation(son, thisObj, 3, "Son_HintJoint")
  hintTimer = timers.StartLevelTimer(5, PlayHintBtr)
end
function PlayHintBtr()
  game.Audio.PlayBanter("TempleOverHere_Hint")
end
function PlayTOHBtr()
  if playedTOHBool == false then
    playedTOHBool = true
    if hintTimer ~= nil then
      hintTimer:Stop()
    end
    timers.StartLevelTimer(4, function()
      game.Audio.PlayBanter("TempleOverHere")
    end)
  end
end
function PlayTDIBtr()
  if playedTDIBool == false then
    playedTDIBool = true
    timers.StartLevelTimer(3.5, function()
      game.Audio.PlayBanter("ThatDidIt")
    end)
  end
end
