local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, sonActor, kratosActor, darkOneProp, cine_lights_235
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  InitializeVariables()
  game.SubObject.Sleep(thisObj)
  SoundOnInit()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitializeVariables()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  darkOneProp = GameObjects.DarkOneCine_HiveClimb.Child
  darkOneProp:StartAnim("narAlfHiveClimbKillLoop")
  HideCineLights()
end
function BuildHiveClimbKillSeq()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "HiveClimbKill")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AlfHiveClimbKill"
    },
    {
      Obj = darkOneProp,
      Anim = "narAlfHiveClimbKill000Cine"
    }
  }
  cineSeq:BeginMultipleWait()
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Crack_Climb_Up_Start_Forward") or player:IsPlayingMove("MOV_Crack_Climb_Up_Forward")
  end)
  cineSeq:WaitForActorInZone(kratosActor, "CineZone_ClimbKillPlay1")
  cineSeq:EndMultipleWait()
  cineSeq:SetPostSkipMusic("SND_MX_ALF_start_master")
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(PlayBreakable)
  cineSeq:Do(PlayDarkOneEfforts)
  cineSeq:ActorSync(kratosActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_AlfHiveClimbKill",
    ReferenceJoint = "HiveClimbKill_SynchJoint"
  })
  cineSeq:WaitForActorFinishMove(kratosActor, "MOV_AlfHiveClimbKill")
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:WaitForActorPuppeteerComplete(kratosActor)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(HiveClimbKillAftermath)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:SetCompletedCineNumber(235)
  cineSeq:StartSequence()
end
function PlayCineLights()
  cine_lights_235:Show()
  cine_lights_235:JumpAnimToFrame(0)
  cine_lights_235:PlayAnimToEnd()
end
function PlayBreakable()
  GameObjects.crack_climb_breach_break.Child:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_235 = GameObjects.Cine_Start_235
  cine_lights_235:Hide()
end
function HiveClimbKillAftermath()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("HiveClimbKillAftermath")
  end, 1)
  game.AI.FindSon():CallScript("EnterBehaviorContext", "ALERT_BEHAVIOR_CONTEXT_CONFIG")
end
local soundEmitter
local soundEvent = "SND_vo_glb_cbt_exrt_cine_knifeintheface_edrk"
function SoundOnInit()
  soundEmitter = darkOneProp:FindSingleSoundEmitterByName("SNDMouth")
end
function PlayDarkOneEfforts()
  LD.PlaySoundAfterDelay(soundEmitter, soundEvent, 1.3)
end
