local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor, sonActor, doActor1, doActor3, doActor4, doActor5, darkOne0, darkOne1, darkOne2, darkOne3, lowerHiveTendrilObj, upperHiveTendrilObj, cine_lights_237
function OnScriptLoaded(level, go)
  thisObj = go
  thisLevel = level
end
function OnStart(level, obj)
  CreateActors()
  SpawnDarkOnes()
  HideDarkOnes()
  cine_lights_237 = GameObjects.Cine_Start_237
  HideCineLights()
  lowerHiveTendrilObj = GameObjects.lowerHiveTendrilProp.Child
  upperHiveTendrilObj = GameObjects.upperHiveTendrilProp.Child
  HideProps()
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function HideDarkOnes()
  local alf510 = game.FindLevel("Alf510_HiveIntCine")
  if alf510 ~= nil then
    local cineObj = alf510:FindSingleGameObject("Cine_OutOfTheLight")
    cineObj:CallScript("HideDeadDarkOnes")
  end
end
function SpawnDarkOnes()
  SpawnDarkOne1()
  SpawnDarkOne3()
  SpawnDarkOne4()
  SpawnDarkOne5()
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  doActor1 = actor.Actor.New("darkone1")
  doActor3 = actor.Actor.New("darkone3")
  doActor4 = actor.Actor.New("darkone4")
  doActor5 = actor.Actor.New("darkone5")
end
function SpawnDarkOne1()
  doActor1:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AlfheimLight_Group", "darkone_Spawn_1", "CRT_DarkOne00", "BRA_AlfTendrilCut021", "TendrilCut02_darkone1", {
      PowerLevel = "1",
      Variant = "HiveFighterWeak"
    })
  end)
end
function SpawnDarkOne3()
  doActor3:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AlfheimLight_Group", "darkone_Spawn_3", "CRT_DarkOne00", "BRA_AlfTendrilCut023", "TendrilCut02_darkone3", {
      PowerLevel = "1",
      Variant = "HiveFighterWeak"
    })
  end)
end
function SpawnDarkOne4()
  doActor4:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AlfheimLight_Group", "darkone_Spawn_4", "CRT_DarkOne00", "BRA_AlfTendrilCut024", "TendrilCut02_darkone4", {
      PowerLevel = "1",
      Variant = "HiveFighterWeak"
    })
  end)
end
function SpawnDarkOne5()
  doActor5:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AlfheimLight_Group", "darkone_Spawn_5", "CRT_DarkOne00", "BRA_AlfTendrilCut025", "darkone5", {
      PowerLevel = "1",
      Variant = "HiveFighterWeak"
    })
  end)
end
function TendrilCut02Cine()
  local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "TendrilCut02")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AlfTendrilCut02"
    },
    {
      Actor = doActor1,
      Branch = "BRA_AlfTendrilCut021"
    },
    {
      Actor = doActor3,
      Branch = "BRA_AlfTendrilCut023"
    },
    {
      Actor = doActor4,
      Branch = "BRA_AlfTendrilCut024"
    },
    {
      Actor = doActor5,
      Branch = "BRA_AlfTendrilCut025"
    },
    {
      Obj = lowerHiveTendrilObj,
      Anim = "envAlfTendrilCut02"
    },
    {
      Obj = upperHiveTendrilObj,
      Anim = "envAlfTendrilCut02"
    }
  }
  cineSeq:SpawnActorAndWait(doActor1)
  cineSeq:SpawnActorAndWait(doActor3)
  cineSeq:SpawnActorAndWait(doActor4)
  cineSeq:SpawnActorAndWait(doActor5)
  cineSeq:Do(ShowProps)
  cineSeq:ActorSync(kraActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_AlfTendrilCut02",
    ReferenceJoint = "Tendril2_SynchJoint"
  })
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(PlayWorldAnims)
  cineSeq:SetPostSkipMusic("SND_MX_ALF_start_master", nil, nil, nil, "SND_MX_ALF_hive_combat_in")
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor)
  cineSeq:WaitForActorMoveComplete(kraActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(doActor1)
  cineSeq:StopPuppetingActor(doActor3)
  cineSeq:StopPuppetingActor(doActor4)
  cineSeq:StopPuppetingActor(doActor5)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(HideProps)
  cineSeq:SetCompletedCineNumber(240)
  cineSeq:StartSequence()
end
function PlayWorldAnims()
  game.Level.SetVariable("BreakTendril02", true)
  GameObjects.HIVE_INTERIOR:PlayAnimToEnd()
  GameObjects.HiveTilt:PlayAnimToEnd()
  GameObjects.Tendril02IC:HideCollision()
  GameObjects.HiveTiltParent:PlayAnimToEnd()
  GameObjects.HivePathsTilt:PlayAnimToEnd()
end
function HideProps()
  lowerHiveTendrilObj:Hide()
  upperHiveTendrilObj:Hide()
end
function ShowProps()
  lowerHiveTendrilObj:Show()
  upperHiveTendrilObj:Show()
end
function PlayCineLights()
  cine_lights_237:Show()
  cine_lights_237:JumpAnimToFrame(0)
  cine_lights_237:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_237:Hide()
end
function Tendril02Cut()
end
