local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, pad, kraActor, sonActor
local DarkOne = GameObjects.DarkOneCine.Child
local DarkOne1 = GameObjects.DarkOneCine1.Child
local cineSeq, cameraCineEnter_CrashThroughFloor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
end
function OnStart(level, obj)
  HideDarkOnes()
end
function OnUpdate(level, obj)
  if cameraCineEnter_CrashThroughFloor ~= nil then
    cameraCineEnter_CrashThroughFloor:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function CrashThruFloorCine()
  if cineSeq == nil then
    CreateActors()
    cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "Crash Thru Floor")
    local cineSeq_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_AlfCrashThroughFloor"
      },
      {
        Obj = DarkOne,
        Anim = "narAlfCrashThroughFloorCine"
      },
      {
        Obj = DarkOne1,
        Anim = "narAlfCrashThroughFloorCine1"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_ALF_start_master")
    cineSeq:Do(AddApproachMarker)
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(StartCineEnter_CrashThroughFloor)
    cineSeq:WaitForActorPlayingMove(kraActor, "MOV_Crouch_Exit")
    cineSeq:Do(function()
      cineSeq:MarkAbleToSkip()
    end)
    cineSeq:Do(FloorBreak490)
    cineSeq:Do(ShowDarkOnes)
    cineSeq:Do(AreaAnnounce)
    cineSeq:Do(UpdateInputMask)
    cineSeq:ActorSync(kraActor, {
      Slaves = cineSeq_ActorTable,
      Branch = "BRA_AlfCrashThroughFloor",
      ReferenceJoint = "CrashThruFloor_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:Do(RemoveApproachMarker)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(HideDarkOnes)
    cineSeq:SetCompletedCineNumber(236)
    cineSeq:Do(Quest_Alfheim_Objective475_Complete)
    cineSeq:Do(function()
      GameObjects.Cine_CrashThruFloor:HideEntityVolume()
    end)
    cineSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    cineSeq:StartSequence()
  end
end
function AddApproachMarker()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveApproachMarker()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function AreaAnnounce()
  game.Compass.SetDesignerForcedHide(true)
  timer.StartLevelTimer(22, function()
    uiCalls.UI_Event_DiscoverLocation("Alfheim Light")
  end)
end
function UpdateInputMask()
  LD.SetEntityVariable("ALF_InputMaskStage", 500)
  pad:ClearAllDisabledGameButtons()
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
end
function ShowDarkOnes()
  DarkOne:Show()
  DarkOne1:Show()
  DarkOne:AddMarker("crashThruFloor_DarkOne")
end
function HideDarkOnes()
  DarkOne:Hide()
  DarkOne1:Hide()
end
function FloorBreak490()
  local alf490 = game.FindLevel("Alf490_HiveIntLH")
  if alf490 ~= nil then
    alf490:CallScript("TriggerFloorBreak")
  end
  timer.StartLevelTimer(20, function()
    GameObjects.RampSheet:ShowCollision()
  end)
end
function StartCineEnter_CrashThroughFloor()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_CrashThroughFloor = CCEC.CineEnterCamera.New("PLYR_CineEnter_CrashThroughFloor", 8)
  cameraCineEnter_CrashThroughFloor:SetCallback(DestroyCineEnter_CrashThroughFloor)
  cameraCineEnter_CrashThroughFloor:Start()
end
function DestroyCineEnter_CrashThroughFloor()
  cameraCineEnter_CrashThroughFloor = nil
  game.SubObject.Sleep(thisObj)
end
function Quest_Alfheim_Objective475_Complete()
  game.QuestManager.ProposeQuestState("Quest_Alfheim_Objective475", "Complete")
end
