local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local monitors = require("level.MonitorLibrary")
local hideDreamWorldZone = false
local thisLevel, player, son, L2buttonMonitor
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  thisLevel = level
end
function OnFirstStart(level)
  GameObjects.Alf550FX:Hide()
  GameObjects.Alf551FX:Hide()
  GameObjects.Alf552FX:Hide()
  GameObjects.Alf553FX:Hide()
  GameObjects.Alf554FX:Hide()
  GameObjects.Alf555FX:Hide()
end
function OnStart(level)
  GameObjects.FXAlf550_TRANSITION:HideTriggerVolume()
  GameObjects.FXAlf550_TRANSITION:Hide()
  GameObjects.Cine_Start_551:Hide()
  GameObjects.Cine_Start_552:Hide()
  GameObjects.Cine_Start_554:Hide()
  GameObjects.Cine_Start_556:Hide()
  GameObjects.Cine_Start_555:Hide()
  L2buttonMonitor = monitors.CreateL2ButtonMonitor()
  L2buttonMonitor:OnButtonDown(L2Down)
  L2buttonMonitor:OnButtonUp(L2Up)
  L2buttonMonitor:Stop()
  if LD.GetEntityVariable("CompletedCineNumber") <= 235 then
    GameObjects.WALLS_Break:Hide()
    GameObjects.WALLS_Break:HideCollision()
    GameObjects.ROOT_BASE:Hide()
  end
  if LD.GetEntityVariable("CompletedCineNumber") == 236 then
    GameObjects.WALLS_Break:Show()
    GameObjects.WALLS_Break:ShowCollision()
    GameObjects.ROOT_BASE:Show()
  end
  if LD.GetEntityVariable("CompletedCineNumber") == 242 then
    GameObjects.ROOT_BASE:Hide()
  end
  LD.CallFunctionAfterDelay(function()
    if LD.GetEntityVariable("ALF_InputMaskStage") == 600 then
      game.Audio.PlayBanter("BifrostArrowTutorial", StartTutorial)
    end
  end, 1)
end
function StartTutorial()
  if LD.GetEntityVariable("ALF_InputMaskStage") == 600 then
    L2buttonMonitor:Start()
    uiCalls.SendSidebarDesignerMessage({
      Text = 18150,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
  end
end
function L2Down()
  uiCalls.SendSidebarDesignerMessage({
    Text = 40952,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
function L2Up()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18150,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
function OnUpdate(level)
  if player:IsInsideEntityZone("LoadDreamWorld") == true and hideDreamWorldZone == false then
    hideDreamWorldZone = true
    GameObjects.LoadDreamWorld:HideEntityVolume()
    StopAllAlfheimAmbience()
    PlayInsideTheLightAmbience()
  end
end
function OnUseWorld(level)
end
function WarpTo551()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("InsideTheLight3")
  end, 1)
end
function ShowHiveWalls()
  GameObjects.WALLS_Break:Show()
  GameObjects.WALLS_Break:ShowCollision()
  GameObjects.ROOT_BASE:Show()
  local alf500 = game.FindLevel("Alf500_HiveInt")
  if alf500 ~= nil then
    alf500:CallScript("ShowPieceOfGeo")
  end
end
function DisableTutorialPostUp()
  GameObjects.CA_Post_Up_Arrow_Upgrade_Tutorial.LuaObjectScript.Disable()
  L2buttonMonitor:Stop()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function AnimateLightsGeo()
  GameObjects.Phase1_Hive_Crumble.Child:PlayAnimToEnd()
  GameObjects.Phase1_Foreground_Crumble.Child:PlayAnimToEnd()
  GameObjects.WALLS_Break:PlayAnimToEnd()
  GameObjects.Exposure_240:JumpAnimToFrame(0)
  GameObjects.Exposure_240:PlayAnimToFrame(370)
  timer.StartLevelTimer(35, function()
    GameObjects.WALLS_Break:Hide()
  end)
  timer.StartLevelTimer(35, function()
    GameObjects.WALLS_Break:HideCollision()
  end)
  timer.StartLevelTimer(3, function()
    GameObjects.ROOT_BASE:Hide()
  end)
  timer.StartLevelTimer(3, function()
    GameObjects.Fully_Vis_Walls:Hide()
  end)
  timer.StartLevelTimer(3.5, function()
    GameObjects.BLEND_SKIRTBASE:Hide()
  end)
end
function LightExplosion550()
end
function LightExposure510()
  GameObjects.FXAlf550_TRANSITION:ShowTriggerVolume()
  GameObjects.FXAlf550_TRANSITION:Show()
  GameObjects.Exposure_TRANSITION:JumpAnimToFrame(0)
  GameObjects.Exposure_TRANSITION:PlayAnimToEnd()
end
function SonBowOut()
  son:CallScript("LuaHook_SetBowOutStatus", true)
end
function SonBowBack()
  son:CallScript("LuaHook_SetBowOutStatus", false)
end
function DisablePeaksClimb()
  GameObjects.InsideLightClimb:HideTraversePath()
end
function Animate551Lights()
end
function PlayExposure551()
  GameObjects.Cine_Start_551:Show()
  GameObjects.Cine_Start_551:JumpAnimToFrame(0)
  GameObjects.Cine_Start_551:PlayAnimToEnd()
  timer.StartLevelTimer(4, function()
    GameObjects.Cine_Start_551:Hide()
  end)
  timer.StartLevelTimer(12, function()
    GameObjects.Cine_Start_552:Show()
  end)
  timer.StartLevelTimer(12, function()
    GameObjects.Cine_Start_552:JumpAnimToFrame(0)
  end)
  timer.StartLevelTimer(12, function()
    GameObjects.Cine_Start_552:PlayAnimToEnd()
  end)
  timer.StartLevelTimer(15, function()
    GameObjects.Cine_Start_552:Hide()
  end)
  game.Audio.StartCheckpointedMusic("SND_MX_ALF_follow_light_2")
end
function PlayExposure552()
end
function PlayExposure553()
  GameObjects.Cine_Start_553:Show()
  GameObjects.Cine_Start_553:JumpAnimToFrame(0)
  GameObjects.Cine_Start_553:PlayAnimToEnd()
  timer.StartLevelTimer(3, function()
    GameObjects.Cine_Start_553:Hide()
  end)
end
function PlayExposure554()
  GameObjects.Cine_Start_554:Show()
  GameObjects.Cine_Start_554:JumpAnimToFrame(0)
  GameObjects.Cine_Start_554:PlayAnimToEnd()
  timer.StartLevelTimer(3, function()
    GameObjects.Cine_Start_554:Hide()
  end)
end
function PlayExposure556()
  GameObjects.Cine_Start_556:Show()
  GameObjects.Cine_Start_556:JumpAnimToFrame(0)
  GameObjects.Cine_Start_556:PlayAnimToEnd()
  timer.StartLevelTimer(8, function()
    GameObjects.Cine_Start_556:Hide()
  end)
end
function PlayExposure555()
  GameObjects.Cine_Start_555:Show()
  GameObjects.Cine_Start_555:JumpAnimToFrame(0)
  GameObjects.Cine_Start_555:PlayAnimToEnd()
  timer.StartLevelTimer(12, function()
    GameObjects.Cine_Start_555:Hide()
  end)
end
function LoadCheck_552()
  game.UI.LoadCheck("Alf552_ILSecond", "Alf553_ILThird")
end
function LoadCheck_554()
  game.UI.LoadCheck("Alf554_ILFourth", "Alf555_ILFifth")
end
function Alf600_Bookmark_TempleIntSetup()
end
function PlayInsideTheLightAmbience()
  player:CallScript("PlaySoundOnKratos", "SND_CINE_InsideTheLight_Scene_01")
end
function StopAllAlfheimAmbience(level)
  local alf050 = game.FindLevel("Alf050_Sound")
  if alf050 ~= nil then
    alf050:CallScript("StopAllPulseSound", thisLevel)
    alf050:CallScript("ShowLightZone")
    alf050:CallScript("HideTempleZones")
  end
  local alf600 = game.FindLevel("Alf600_TempleInt")
  if alf600 ~= nil then
    alf600:CallScript("StopRumbleSound")
  end
end
