local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local color = require("core.color")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, kraActor, sonActor, cine_lights_240, cine_lights_240B, ashesPouchObj, lowerHiveTendrilObj, upperHiveTendrilObj, baldurRockObj, axeObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  CreateActors()
  HideCineLights()
  HideCineLightsB()
  HideAxeIfInsideLight()
end
function CreateActors()
  kraActor = actor.Actor.New("INTO THE LIGHT: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("INTO THE LIGHT: Son Actor", game.AI.FindSon)
  ashesPouchObj = GameObjects.ashesPouch00Prop.Child
  lowerHiveTendrilObj = GameObjects.lowerHiveTendril00Prop.Child
  upperHiveTendrilObj = GameObjects.upperHiveTendril00Prop.Child
  baldurRockObj = GameObjects.baldurRock00Prop.Child
  HideProps()
  HideTendrils()
end
function HideAxeIfInsideLight()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 240 then
    local seq = LD.CreateCineSequence(thisLevel, thisObj, "dropAxe")
    seq:WaitForFunctionTrue(FindAxe)
    seq:Do(function()
      axeObj = FindAxe()
      player:DropThrowable("ATT_Axe", true)
      axeObj:SetWorldPosition(engine.Vector.New(482, -23, 589))
    end)
    seq:StartSequence()
  end
end
function FindAxe()
  return player.Axe
end
function IntoTheLightSequence()
  game.UI.LoadCheck("Alf600_TempleInt", "Alf690_LakeLightLH")
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "IntoTheLight")
  local intoTheLight_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AlfIntoTheLight"
    },
    {
      Obj = lowerHiveTendrilObj,
      Anim = "scnAlfheimLight000CineEnter"
    },
    {
      Obj = upperHiveTendrilObj,
      Anim = "scnAlfheimLight000CineEnter"
    },
    {
      Obj = baldurRockObj,
      Anim = "scnAlfheimLight000CineEnter"
    }
  }
  local intoTheLight_ActorTable2 = {
    {
      Obj = ashesPouchObj,
      Anim = "scnAlfheimLight060CineScene"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_ALF_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:Do(EnableManualCineMode)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(ShowProps)
  cineSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = intoTheLight_ActorTable,
    Branch = "BRA_AlfIntoTheLight",
    ReferenceJoint = "IntoTheLight_SynchJoint"
  })
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(5)
  end)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 355)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(nil)
  end)
  cineSeq:Do(HideTendrils)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 1200)
  cineSeq:Do(TurnOnTemporalObjects)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 3030)
  cineSeq:Do(DisableSon)
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_AlfheimLightIdle")
  end)
  cineSeq:WaitForFunctionTrue(function()
    if cineSeq.skipping then
      return game.UI.LoadCheck("Alf550_InsideLight", "Alf551_ILFirst") == 0
    else
      return true
    end
  end)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_AlfheimLightWin")
  end)
  cineSeq:Do(ExposureBlast)
  cineSeq:Do(function()
    game.UI.LoadCheck("Alf550_InsideLight", "Alf551_ILFirst")
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = intoTheLight_ActorTable2,
    Branch = "BRA_AlfIntoTheLightWin",
    ReferenceJoint = "IntoTheLight_SynchJoint"
  })
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(2)
  end)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(PlayCineLightsB)
  cineSeq:Do(ShowJimFX)
  cineSeq:Do(ShowPouch)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.35)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(nil)
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:WaitForActorMoveComplete(kraActor)
  cineSeq:Do(DisableManualCineMode)
  cineSeq:Do(HideCineLightsB)
  cineSeq:Do(HideProps)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:Do(function()
    GameObjects.ashesPouch00Prop:Hide()
  end)
  cineSeq:SetCompletedCineNumber(240)
  cineSeq:Do(BOOKMARK_06_Alfheim_055_InsideLight)
  cineSeq:StartSequence()
end
function BOOKMARK_06_Alfheim_055_InsideLight()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_055_InsideLight"]
  tableEntry.OverrideObject = GameObjects.CO_06_Alfheim_055_InsideLight
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function TurnOnTemporalObjects()
  game.Level.SetVariable("LightCineDone", true)
  local alf690 = game.FindLevel("Alf690_LakeLightLH")
  if alf690 ~= nil then
    alf690:CallScript("TurnOn690Door")
  end
  local alf600 = game.FindLevel("Alf600_TempleInt")
  if alf600 ~= nil then
    alf600:CallScript("TriggerTemporal_600")
  end
end
function HideJimFX()
  GameObjects.Alf550FX:Hide()
  GameObjects.Alf551FX:Hide()
  GameObjects.Alf552FX:Hide()
  GameObjects.Alf553FX:Hide()
  GameObjects.Alf554FX:Hide()
  GameObjects.Alf555FX:Hide()
end
function ShowJimFX()
  GameObjects.Alf550FX:Show()
  GameObjects.Alf551FX:Show()
  GameObjects.Alf552FX:Show()
  GameObjects.Alf553FX:Show()
  GameObjects.Alf554FX:Show()
  GameObjects.Alf555FX:Show()
end
function PlayCineLights()
  cine_lights_240:Show()
  cine_lights_240:JumpAnimToFrame(0)
  cine_lights_240:PlayAnimToEnd()
end
function PlayCineLightsB()
  cine_lights_240B:Show()
  cine_lights_240B:JumpAnimToFrame(0)
  cine_lights_240B:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_240 = GameObjects.Cine_Start_240
  cine_lights_240:Hide()
end
function HideCineLightsB()
  cine_lights_240B = GameObjects.Cine_Start_240_B
  timer.StartLevelTimer(5, function()
    cine_lights_240B:Hide()
  end)
end
function ExposureBlast()
  GameObjects.Exposure_240:JumpAnimToFrame(370)
  GameObjects.Exposure_240:PlayAnimToFrame(567)
end
function HideTendrils()
  lowerHiveTendrilObj:Hide()
  upperHiveTendrilObj:Hide()
end
function HideProps()
  baldurRockObj:Hide()
  ashesPouchObj:Hide()
end
function ShowPouch()
  ashesPouchObj:Show()
end
function ShowProps()
  lowerHiveTendrilObj:Show()
  upperHiveTendrilObj:Show()
  baldurRockObj:Show()
end
function DisableSon()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function EnableManualCineMode()
  game.Cinematics.EnableCinematicMode()
  local pad = game.Player.FindPlayer().Pad
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  game.Player.FindPlayer():CallScript("LuaHook_ForceCineRageModeExit")
end
function DisableManualCineMode()
  local pad = game.Player.FindPlayer().Pad
  pad:EnableGameButton(tweaks.ePad.kPadUp)
end
