local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local player, pad
local varAshesToLightPlayed = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
end
function OnStart(level)
  game.Compass.SetDesignerForcedHide(true)
  uiCalls.UI_Event_Force_Combat_HUD_Off()
  GameObjects.For400_Cheap:Hide()
  local seq = LD.CreateCineSequence(level, level, "InsideTheLight1 banter")
  seq:WaitSeconds(4.5)
  seq:WaitForFunctionTrue(function()
    return not player:IsPlayingMove("MOV_AlfheimLightWin")
  end)
  seq:WaitSeconds(3)
  seq:Do(function()
    game.Audio.PlayBanter("InsideTheLight1")
  end)
  seq:StartSequence()
end
function OnFirstStart(level)
  GameObjects.ForestRefnodes:Hide()
  GameObjects.HandLight:Hide()
  GameObjects.SwitchTo551:HideEntityVolume()
  GameObjects.AnimLight00_REV:HideEntityVolume()
  GameObjects.AnimLight01_REV:HideEntityVolume()
  GameObjects.AnimLight02_REV:HideEntityVolume()
  GameObjects.AnimLight03_REV:HideEntityVolume()
  GameObjects.AnimLight04_REV:HideEntityVolume()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function AshesToLight()
  if varAshesToLightPlayed == false then
    varAshesToLightPlayed = true
    GameObjects.ForestRefnodes:Show()
    GameObjects.MainPlatform:Hide()
    GameObjects.HandLight:PlayAnimToFrame(470, 1.2)
    PlaySoundHandLightLoop()
    startInputMask()
    timer.StartLevelTimer(14, function()
      GameObjects.HandLight:PlayAnimToFrame(600, 0.5)
      PlayInsideTheLightAmbience_TransitionToForest()
    end)
    timer.StartLevelTimer(2, function()
      GameObjects.Alf550_Point_01:HideLights()
      GameObjects.Alf550_Spot_01:HideLights()
      timer.StartLevelTimer(2, function()
        GameObjects.HandLight:Show()
      end)
    end)
  end
end
function startInputMask()
  LD.SetEntityVariable("ALF_InputMaskStage", 550)
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
end
function TriggerExposure()
  local alf510 = game.FindLevel("Alf510_HiveIntCine")
  if alf510 ~= nil then
    alf510:CallScript("LightExposure510")
  end
end
function StartExposure551()
  local alf510 = game.FindLevel("Alf510_HiveIntCine")
  if alf510 ~= nil then
    alf510:CallScript("PlayExposure551")
  end
end
function Switch551()
  timer.StartLevelTimer(0.2, function()
    GameObjects.SwitchTo551:ShowEntityVolume()
  end)
  GameObjects.SlowWalkZone:HideEntityVolume()
  StopSoundHandLightLoop()
end
function Light000REV()
  GameObjects.HandLight:PlayAnimToFrame(600, -0.3)
  GameObjects.AnimLight00_REV:HideEntityVolume()
  GameObjects.AnimLight00_FWD:ShowEntityVolume()
  PlaySoundHandLightLoop()
end
function Light000FWD()
  GameObjects.HandLight:PlayAnimToFrame(650, 0.3)
  GameObjects.AnimLight00_REV:ShowEntityVolume()
  GameObjects.AnimLight00_FWD:HideEntityVolume()
end
function Light650REV()
  GameObjects.HandLight:PlayAnimToFrame(650, -0.3)
  GameObjects.AnimLight01_REV:HideEntityVolume()
  GameObjects.AnimLight01_FWD:ShowEntityVolume()
end
function Light650FWD()
  GameObjects.HandLight:PlayAnimToFrame(700, 0.3)
  GameObjects.AnimLight01_REV:ShowEntityVolume()
  GameObjects.AnimLight01_FWD:HideEntityVolume()
end
function Light700REV()
  GameObjects.HandLight:PlayAnimToFrame(700, -0.3)
  GameObjects.AnimLight02_REV:HideEntityVolume()
  GameObjects.AnimLight02_FWD:ShowEntityVolume()
end
function Light700FWD()
  GameObjects.HandLight:PlayAnimToFrame(750, 0.3)
  GameObjects.AnimLight02_REV:ShowEntityVolume()
  GameObjects.AnimLight02_FWD:HideEntityVolume()
end
function Light800REV()
  GameObjects.HandLight:PlayAnimToFrame(750, -0.3)
  GameObjects.AnimLight03_REV:HideEntityVolume()
  GameObjects.AnimLight03_FWD:ShowEntityVolume()
end
function Light800FWD()
  GameObjects.HandLight:PlayAnimToFrame(800, 0.3)
  GameObjects.AnimLight03_REV:ShowEntityVolume()
  GameObjects.AnimLight03_FWD:HideEntityVolume()
end
function Light900REV()
  GameObjects.HandLight:PlayAnimToFrame(800, -0.3)
  GameObjects.AnimLight04_REV:HideEntityVolume()
  GameObjects.AnimLight04_FWD:ShowEntityVolume()
end
function Light900FWD()
  GameObjects.HandLight:PlayAnimToFrame(850, 0.3)
  GameObjects.AnimLight04_REV:ShowEntityVolume()
  GameObjects.AnimLight04_FWD:HideEntityVolume()
end
function OnKratosHouseDoorInteract()
  PlayInsideTheLightAmbience_TransitionToHelship()
end
function OnSaveCheckpoint(level)
  return {varAshesToLightPlayed = varAshesToLightPlayed}
end
function OnRestoreCheckpoint(level, savedInfo)
  varAshesToLightPlayed = savedInfo.varAshesToLightPlayed
  if varAshesToLightPlayed then
    GameObjects.HandLight:JumpAnimToFrame(470)
    GameObjects.HandLight:PauseAnim()
    GameObjects.HandLight:PlayAnimToFrame(600, 0.5)
    PlayInsideTheLightAmbience_TransitionToForest()
    startInputMask()
  end
end
local HandLightSound = {
  Emitter = nil,
  PhaseEmitter = nil,
  Loop = "SND_CINE_InsideTheLight_MAG_LightOrb_LP",
  Phase = "SND_CINE_InsideTheLight_MAG_LightOrb_PassThru"
}
local HandLightPhaseAnimMonitor
function SoundInit()
  HandLightSound.Emitter = GameObjects.HandLight.SoundEmitters[1]
  HandLightSound.PhaseEmitter = GameObjects.WallPhaseSoundGO.SoundEmitters[1]
  HandLightPhaseAnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.HandLight)
  HandLightPhaseAnimMonitor:OnFrameForward(822, PlaySoundHandLightPhase)
  HandLightPhaseAnimMonitor:OnFrameForward(825, function()
    StopSoundHandLightLoop()
    HandLightPhaseAnimMonitor:Stop()
    HandLightPhaseAnimMonitor:Terminate()
    HandLightPhaseAnimMonitor = nil
  end)
end
function PlaySoundHandLightPhase()
  LD.PlaySound(HandLightSound.PhaseEmitter, HandLightSound.Phase)
end
function PlaySoundHandLightLoop()
  LD.PlaySound(HandLightSound.Emitter, HandLightSound.Loop)
end
function StopSoundHandLightLoop()
  LD.StopSound(HandLightSound.Emitter, HandLightSound.Loop)
end
function PlayInsideTheLightAmbience_TransitionToForest()
  player:CallScript("PlaySoundOnKratos", "SND_CINE_InsideTheLight_Scene_02")
end
function PlayInsideTheLightAmbience_TransitionToHelship()
  player:CallScript("PlaySoundOnKratos", "SND_CINE_InsideTheLight_Scene_03")
end
