local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local thisLevel, player, son
function OnScriptLoaded(level)
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.Light_HandLight:HideLights()
  GameObjects.Light_HandLight:Hide()
  PlaySoundMotherLightLoop()
  BOOKMARK_06_Alfheim_057_BaseOfCrackClimb()
end
function OnStart(level)
  MotherLightAnimFwd1()
  FishSlowAnimPlay()
  game.Compass.SetDesignerForcedHide(true)
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
  game.Audio.PlaySound("SND_CINE_InsideTheLight_Scene_04")
end
function FishSlowAnimPlay()
  local speed = 0.2
  LD.CallFunctionAfterDelay(function()
    GameObjects.dream_fish3.Child:PlayAnimOscillate(speed)
    GameObjects.dream_fish7.Child:PlayAnimOscillate(speed)
  end, 0.5)
  LD.CallFunctionAfterDelay(function()
    GameObjects.dream_fish1.Child:PlayAnimOscillate(speed)
    GameObjects.dream_fish9.Child:PlayAnimOscillate(speed)
  end, 1)
  LD.CallFunctionAfterDelay(function()
    GameObjects.dream_fish2.Child:PlayAnimOscillate(speed)
    GameObjects.dream_fish8.Child:PlayAnimOscillate(speed)
  end, 1.5)
  LD.CallFunctionAfterDelay(function()
    GameObjects.dream_fish4.Child:PlayAnimOscillate(speed)
    GameObjects.dream_fish6.Child:PlayAnimOscillate(speed)
  end, 2)
  LD.CallFunctionAfterDelay(function()
    GameObjects.dream_fish10.Child:PlayAnimOscillate(speed)
  end, 2.5)
  GameObjects.dream_fish5.Child:PlayAnimOscillate(speed)
end
function OnLevelShutdown(level)
  StopSoundMotherLightLoop()
end
function MotherLightAnimFwd1()
  GameObjects.MotherLight:PlayAnimToFrame(400, 1)
  timer.StartLevelTimer(12, function()
    GameObjects.Light_HandLight:ShowLights()
  end)
  timer.StartLevelTimer(12, function()
    GameObjects.Light_HandLight:Show()
  end)
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("InsideTheLight4")
  end, 2.68)
end
function MotherLightAnimRev1()
  GameObjects.MotherLight:PlayAnimToFrame(0, -0.7)
end
function MotherLightAnimFwd2()
  GameObjects.MotherLight:PlayAnimToFrame(400, 0.7)
end
function MotherLightAnimRev2()
  GameObjects.MotherLight:PlayAnimToFrame(300, -0.7)
end
function BOOKMARK_06_Alfheim_057_BaseOfCrackClimb()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_057_BaseOfCrackClimb"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
local MotherLightSound = {
  Emitter = nil,
  Loop = "SND_CINE_InsideTheLight_MAG_LightOrb_LP"
}
function SoundInit()
  MotherLightSound.Emitter = GameObjects.MotherLight.SoundEmitters[1]
end
function PlaySoundMotherLightLoop()
  LD.PlaySound(MotherLightSound.Emitter, MotherLightSound.Loop)
end
function StopSoundMotherLightLoop()
  LD.StopSound(MotherLightSound.Emitter, MotherLightSound.Loop)
end
