local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisLevel, player, son
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  SoundInit()
end
function OnStart()
  GameObjects.DiningTable_GRP:Hide()
  GameObjects.KratosHouseDoor_Dream.LuaObjectScript.SetAllowSyncWithSonNotAvailable(true)
end
function MotherLightAnim()
  GameObjects.MotherLight:PlayAnimToEnd()
end
function OutsideLightAnim()
  GameObjects.OutsideLight:PlayAnimOscillate()
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function StartExposure556()
  local alf510 = game.FindLevel("Alf510_HiveIntCine")
  if alf510 ~= nil then
    alf510:CallScript("PlayExposure556")
  end
end
function OnKratosHouseDoorInteract()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  GameObjects.HouseSlowDownZone:PlayAnimToEnd(3)
  PlayInsideTheLightAmbience_TransitionToJotunheim()
end
local MotherLightSound = {
  Emitter = nil,
  PhaseEmitter = nil,
  Loop = "SND_CINE_InsideTheLight_MAG_LightOrb_LP",
  Phase = "SND_CINE_InsideTheLight_MAG_LightOrb_PassThru"
}
local MotherLightPhaseAnimMonitor
function SoundInit()
  MotherLightSound.Emitter = GameObjects.MotherLight.SoundEmitters[1]
  MotherLightSound.PhaseEmitter = GameObjects.WallPhaseSoundGO.SoundEmitters[1]
  PlaySoundMotherLightLoop()
  MotherLightPhaseAnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.MotherLight)
  MotherLightPhaseAnimMonitor:OnFrameForward(245, PlaySoundMotherLightPhase)
  MotherLightPhaseAnimMonitor:OnFrameForward(248, function()
    StopSoundMotherLightLoop()
    MotherLightPhaseAnimMonitor:Stop()
    MotherLightPhaseAnimMonitor:Terminate()
    MotherLightPhaseAnimMonitor = nil
  end)
end
function PlaySoundMotherLightPhase()
  LD.PlaySound(MotherLightSound.PhaseEmitter, MotherLightSound.Phase)
end
function PlaySoundMotherLightLoop()
  LD.PlaySound(MotherLightSound.Emitter, MotherLightSound.Loop)
end
function StopSoundMotherLightLoop()
  LD.StopSound(MotherLightSound.Emitter, MotherLightSound.Loop)
end
function PlayInsideTheLightAmbience_TransitionToJotunheim()
  player:CallScript("PlaySoundOnKratos", "SND_CINE_InsideTheLight_Scene_07")
end
