local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, sonActor, mothersBody, mothersCandles, mothersCandles1, mothersTable
local poiInsideTheLightBool = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  SpawnProps()
end
function OnStart()
  CreateActors()
  POI_InsideTheLight_Sequence()
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function CreateActors()
  local availabilityState = {
    AvailableForSync = true,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  sonActor = actor.Actor.New("POI - INSIDE THE LIGHT", game.AI.FindSon)
end
function SpawnProps()
  mothersBody = GameObjects.motherBody00Top.Child
  mothersCandles = GameObjects.mothersCandles00Top.Child
  mothersCandles1 = GameObjects.mothersCandles01Top.Child
  mothersTable = GameObjects.mothersTable00Top.Child
end
function POI_InsideTheLight_Sequence()
  local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "POI Inside the Light")
  local poiInsideTheLight_ActorTable = {
    {
      Obj = mothersBody,
      Anim = "poiAlfinsideTheLight"
    },
    {
      Obj = mothersCandles,
      Anim = "poiAlfinsideTheLight"
    },
    {
      Obj = mothersCandles1,
      Anim = "poiAlfinsideTheLight1"
    },
    {
      Obj = mothersTable,
      Anim = "poiAlfinsideTheLight"
    }
  }
  cineSeq:ActorSync(sonActor, {
    Slaves = poiInsideTheLight_ActorTable,
    Branch = "BRA_AlfinsideTheLight",
    ReferenceJoint = "poi_InsideTheLight_SynchJoint"
  })
  cineSeq:Do(function()
    local availabilityState = {
      AvailableForSync = false,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end)
  cineSeq:Do(function()
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("InsideTheLight6")
    end, 1)
  end)
  cineSeq:StartSequence()
end
