local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local CCOS = require("camera.camera_oneshot")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local TnFCrystal01, TnFCrystal02, TnFCrystal03
local hideDreamWorldZone = false
local varKratosDidit = false
local thisLevel, son, pad
local Player = game.Player.FindPlayer()
local reminderDone = false
local varFinalBridgeOn
local bTendril01 = false
local bTendril02 = false
local varCoveredCount = 0
local varCrystalSocketed = false
local carryObject, bridge05Timer, bridge02Timer, Area_0_Encounter_1, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2, Area_3_Encounter_1
function OnScriptLoaded(level)
  thisLevel = level
  pad = Player.Pad
  Area_0_Fight_1()
  Area_1_Fight_1()
  Area_2_Fight_1()
  Area_3_Fight_1()
  SoundInit()
end
function OnFirstStart(level)
  HideDeadOnes()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  HideRingAndTemple()
  DisableTendrilSolve()
  GameObjects.WALKWAY_09_sheet:HideCollision()
  GameObjects.WALKWAY_010_sheet:HideCollision()
  GameObjects.LightPillarCollision:HideCollision()
  GameObjects.CamZone_VistaPeakReveal:HideCameraVolume()
  GameObjects.EntZn_Area_2_2_Spawn:HideEntityVolume()
  GameObjects.EntZn_Area_2_1_Spawn:HideEntityVolume()
  game.Level.SetVariable("ALF_LightAcquired", true)
  GameObjects.TraverseClimbHive:HideTraversePath()
  GameObjects.Stop_CA_ClimbHint:HideEntityVolume()
  varFinalBridgeOn = false
end
function OnStart(level)
  GameObjects.TraverseVault:ShowTraverseLink()
  LD.EnableContextBehaviorBanter()
  TnFCrystal01 = level:FindGameObject("Crystal01")
  TnFCrystal02 = level:FindGameObject("Crystal02")
  TnFCrystal03 = level:FindGameObject("Crystal03")
  carryObject = level:FindSingleGameObject("CarryBifrostLight_Top").LuaObjectScript
  if game.Level.GetVariable("CompletedCineNumber") == 241 then
    ShowDeadOnes()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 263 then
    GameObjects.DeadDarkOnePropCollision:HideCollision()
  end
  CheckTendrilStatus()
  if bTendril02 == true then
    local cameraFnFTendrilZoom = thisLevel:GetGameObject("FireAndForgetV3_Tendril2_Zoom").Child
    if cameraFnFTendrilZoom ~= nil then
      game.SubObject.Sleep(cameraFnFTendrilZoom)
    end
  end
  PlayRumbleSound()
  if game.Level.GetVariable("CompletedCineNumber") == 242 and LD.GetEntityVariable("FOR_BaldurBossDone") == true then
    GetSonReadyForBridge()
  end
  if Area_0_Encounter_1:WasRunning() and game.Level.GetVariable("CompletedCineNumber") == 242 then
    Area_0_Encounter_1:Start()
  end
  if Area_2_Encounter_1:WasRunning() and game.Level.GetVariable("CompletedCineNumber") == 242 then
    Area_2_Encounter_1:Start()
  end
  if Area_3_Encounter_1:WasRunning() and game.Level.GetVariable("CompletedCineNumber") == 242 then
    Area_3_Encounter_1:Start()
  end
  GameObjects.EZE_KratosNearCrystalBase:HideEntityVolume()
  if GameObjects.TendrilController4.LuaObjectScript.GetAllTendrilsDestroyed() == true then
    GameObjects.Tendril_Crystal2:Hide()
  end
end
function OnUpdate(level)
  if LD.GetEntityVariable("AlfTurnOnCrystals") == true then
    LD.SetEntityVariable("AlfTurnOnCrystals", false)
    TnFCrystal01.LuaObjectScript.SetCrystalObjectStates(2)
    TnFCrystal02.LuaObjectScript.SetCrystalObjectStates(2)
    TnFCrystal03.LuaObjectScript.SetCrystalObjectStates(2)
  end
  if son == nil then
    son = game.AI.FindSon()
    print("spam check")
  end
  if game.World.IsInsideCameraZone(Player.WorldPosition, "CamZone_BifrostArrowTutorial") then
    if Player:HasMarker("Aiming") then
      game.Camera.SubmitCameraByName("AIM_Spline_LightArrowTutorial")
    else
      game.Camera.SubmitCameraByName("PLYR_Spline_LightArrowTutorial")
    end
  end
end
function DisableSplineCamera()
  local camzone = thisLevel:GetGameObject("CamZone_BifrostArrowTutorial")
  camzone:HideCameraVolume()
end
function EnableSplineCamera()
  local camzone = thisLevel:GetGameObject("CamZone_BifrostArrowTutorial")
  camzone:ShowCameraVolume()
end
function SetVar_KratosDidIt()
  varKratosDidit = true
end
function ClearVar_KratosDidIt()
  varKratosDidit = false
end
function TurnOffVault()
  if LD.GetEntityVariable("ALF_SonBusy") == true then
    GameObjects.TraverseVault:HideTraverseLink()
  end
end
function TurnOnVault()
  GameObjects.TraverseVault:ShowTraverseLink()
end
function HideRingAndTemple()
  local Alf000 = game.FindLevel("Alf000_SkyDark")
  if Alf000 ~= nil then
    Alf000:CallScript("HideRing")
    Alf000:CallScript("HideTemple")
  else
    timer.StartLevelTimer(1, HideRingAndTemple)
  end
end
function removeInputMask()
  LD.SetEntityVariable("ALF_InputMaskStage", 555)
  pad:ClearAllDisabledGameButtons()
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
end
function ShowDeadOnes()
  GameObjects.DEAD_ONES:Show()
  GameObjects.DEAD_ONES_EXTRA:Show()
  GameObjects.DeadCollision:ShowCollision()
end
function HideDeadOnes()
  GameObjects.DEAD_ONES:Hide()
  GameObjects.DEAD_ONES_EXTRA:Hide()
  GameObjects.DeadCollision:HideCollision()
end
function GetSonReadyForBridge()
end
function GetSonReadyForDrop()
end
function FirstCarryCrystal()
  GameObjects.ContextAction_Step3.LuaObjectScript.Disable()
end
function LB02_Created()
  if varKratosDidit == true then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    GameObjects.EZE_KratosNearCrystalBase:ShowEntityVolume()
    if Player:InsideZone(GameObjects.EZE_KratosNearCrystalBase) then
      GameObjects.CA_SonAvoidBridge.LuaObjectScript.Enable()
    end
    GameObjects.CA_SonAvoidBridge_far.LuaObjectScript.Disable()
    if bridge02Timer == nil then
      bridge02Timer = timer.StartLevelTimer(1, function()
        GameObjects.BridgeCollision02:HideCollision()
      end)
    else
      bridge02Timer:Start()
    end
    GameObjects.CA_ObserveBridge3.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_1.LuaObjectScript.Disable()
    GameObjects.CA_IdleBehavior_2.LuaObjectScript.Disable()
    GameObjects.CA_IdleBehavior_3.LuaObjectScript.Disable()
    GameObjects.CA_SpitOverLedge.LuaObjectScript.Disable()
    Enable_LTW()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function LB02_Destroyed()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "FRUSTRATED_CONTEXT_CONFIG")
  Disable_LTW()
  if bridge02Timer ~= nil then
    bridge02Timer:Reset()
  end
  GameObjects.BridgeCollision02:ShowCollision()
  varCrystalSocketed = false
  GameObjects.CA_SonAvoidBridge_far.LuaObjectScript.Enable()
end
function SonOnLightBridge()
  if varCrystalSocketed and carryObject ~= nil then
    carryObject.SetCarryDisallowedTags()
  end
end
function SonOffLightBridge()
  if varCrystalSocketed and carryObject ~= nil then
    carryObject.ClearCarryDisallowedTags()
  end
end
function Enable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Enable()
end
function Disable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
end
function NextTo_CrystalBase()
  GameObjects.CA_SonAvoidBridge.LuaObjectScript.Enable()
end
function AwayFrom_CrystalBase()
  GameObjects.CA_SonAvoidBridge.LuaObjectScript.Disable()
end
function BeamCollision()
  GameObjects.LightPillarCollision:ShowCollision()
end
function TurnOnColumns()
end
function TriggerTemporal_600()
  TriggerTemporalObject(GameObjects.columntemporal9)
  timer.StartLevelTimer(0.4, function()
    TriggerTemporalObject(GameObjects.columntemporal8)
  end)
  timer.StartLevelTimer(1.4, function()
    TriggerTemporalObject(GameObjects.decorative_statue)
  end)
  timer.StartLevelTimer(1.9, function()
    TriggerTemporalObject(GameObjects.decorative_statue1)
  end)
  timer.StartLevelTimer(0.8, function()
    TriggerTemporalObject(GameObjects.columntemporal7)
  end)
  timer.StartLevelTimer(1.2, function()
    TriggerTemporalObject(GameObjects.columntemporal6)
  end)
  timer.StartLevelTimer(1.5, function()
    TriggerTemporalObject(GameObjects.columntemporal0)
    TriggerTemporalObject(GameObjects.columntemporal1)
    TriggerTemporalObject(GameObjects.columntemporal2)
    TriggerTemporalObject(GameObjects.columntemporal3)
    TriggerTemporalObject(GameObjects.columntemporal4)
    TriggerTemporalObject(GameObjects.columntemporal5)
  end)
end
function TriggerTemporalObject(tObj)
  tObj.Child.LuaObjectScript.TurnTemporalObjectOff()
  timer.StartLevelTimer(0.5, function()
    tObj.Child.LuaObjectScript.TurnTemporalObjectOn()
  end)
end
function ReminderText()
  if reminderDone == false then
    TUT.Alf600_LightArrow_Reminder()
    reminderDone = true
  end
  varCrystalSocketed = true
end
function UnidleKratos()
  LD.SetEntityVariable("ALF_InputMaskStage", 0)
  pad:ClearAllDisabledGameButtons()
end
function PlayBanter_CoveredCrystal()
  varCoveredCount = varCoveredCount + 1
  if varCoveredCount == 1 then
    game.Audio.PlayBanter("CoveredCrystal1")
  elseif varCoveredCount == 2 then
    game.Audio.PlayBanter("CoveredCrystal2")
  elseif varCoveredCount == 3 then
    game.Audio.PlayBanter("CoveredCrystal3")
  else
    varCoveredCount = 4
  end
end
function alfheimLightBridgeOn_02()
  if game.Level.GetVariable("ALF_LightArrowLearnt") == false then
    LD.CallFunctionAfterDelay(function()
      game.AI.FindSon():CallScript("EnterBehaviorContext", "FRUSTRATED_CONTEXT_CONFIG")
    end, 10)
    DisableSplineCamera()
    local alf510 = game.FindLevel("Alf510_HiveIntCine")
    if alf510 ~= nil then
      alf510:CallScript("DisableTutorialPostUp")
    end
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("BifrostArrowTutorial_Fired")
      uiCalls.UI_Event_TurnOffDesignerMessage()
      UnidleKratos()
    end, 1)
    LD.CallFunctionAfterDelay(function()
      GameObjects.BridgeCollision01:HideCollision()
      son:RemoveMarker("PostUpNoCollision")
    end, 2)
  end
end
function EnableBridge1Spline()
  GameObjects.LTW_FirstBridge.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_1.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_2.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_3.LuaObjectScript.Enable()
  GameObjects.CA_SpitOverLedge.LuaObjectScript.Enable()
end
function alfheimLightBridgeOn_04()
  if game.Level.GetVariable("ALF_LightArrowLearnt") == false then
    LD.SetEntityVariable("ALF_LightArrowLearnt", true)
    varFinalBridgeOn = true
    LD.CallFunctionAfterDelay(function()
      GameObjects.BridgeCollision06:HideCollision()
    end, 2)
    GameObjects.CA_HintAtFinalBridge.LuaObjectScript.Interrupt()
    GameObjects.CA_HintAtFinalBridge.LuaObjectScript.Disable()
    if Player:IsInsideEntityZone("MainPlatformZone") == true then
      EnableLTWExitTo690()
    end
  end
end
function alfheimLightBridgeOn_05()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  if bridge05Timer == nil then
    bridge05Timer = timer.StartLevelTimer(2, function()
      GameObjects.BridgeCollision05:HideCollision()
    end)
  else
    bridge05Timer:Start()
  end
end
function alfheimLightBridgeReset_05()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  GameObjects.BridgeCollision05:ShowCollision()
  if bridge05Timer ~= nil then
    bridge05Timer:Reset()
  end
  varCrystalSocketed = false
end
function alfheimLightBridgeOn_09()
  GameObjects.WALKWAY_09_sheet:ShowCollision()
  LD.CallFunctionAfterDelay(function()
    GameObjects.BridgeCollision09:HideCollision()
  end, 2)
end
function alfheimLightBridgeOn_10()
  GameObjects.WALKWAY_010_sheet:ShowCollision()
  LD.CallFunctionAfterDelay(function()
    GameObjects.BridgeCollision10:HideCollision()
  end, 2)
end
function CheckTendrilStatus()
  local tendrilcrystal02 = thisLevel:GetGameObject("TendrilController4")
  if tendrilcrystal02 ~= nil then
    bTendril02 = tendrilcrystal02.LuaObjectScript.GetAllTendrilsDestroyed()
  end
end
function CrystalTendrilBreak1()
end
function CrystalTendrilBreak2()
end
function TemporalDoorCombatZone()
end
function EnableTendrilSolve()
  GameObjects.TendrilAxeTarget_CC.Child.LuaObjectScript.Enable()
end
function DisableTendrilSolve()
  GameObjects.TendrilAxeTarget_CC.Child.LuaObjectScript.Disable()
end
function CrystalTendrilBreak_02()
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
  GameObjects.LowerLTW_Follow.LuaObjectScript.Enable()
  GameObjects.CA_BoredBridge3.LuaObjectScript.Disable()
  GameObjects.BifrostTemporal_Bridge04.LuaObjectScript.Enable()
  GameObjects.HiveBlocker_GiantPuzzle.Child.LuaObjectScript.StartDecay()
  GameObjects.HiveCollision01:HideCollision()
  GameObjects.NavObstacle00:HideNavObstacle()
  bTendril02 = true
  GameObjects.EntZn_Area_2_2_Spawn:ShowEntityVolume()
  GameObjects.EntZn_Area_2_1_Spawn:ShowEntityVolume()
  GameObjects.CA_shortcut.LuaObjectScript.Enable()
  GameObjects.CA_turretSon.LuaObjectScript.Disable()
  GameObjects.Stop_CA_ClimbHint:ShowEntityVolume()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("CoveredCrystal_Clear")
    GameObjects.Tendril_Crystal2:Hide()
    game.World.StoreCheckpoint()
  end, 1)
  LD.CallFunctionAfterDelay(function()
    pad:EnableGameButton(tweaks.ePad.kPadSquare)
  end, 4)
end
function RemoveExtraDeadBodies()
  GameObjects.DEAD_ONES_EXTRA:Hide()
  GameObjects.NavObstacles600:HideNavObstacle()
  GameObjects.DeadCollision:HideCollision()
end
function Disable_CA_ClimbHint()
  GameObjects.CA_shortcut.LuaObjectScript.Disable()
end
function RevealShortcut()
  GameObjects.TraverseClimbHive:ShowTraversePath()
  for _, x in pairs(GameObjects.ClimbTendrilGeo.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
end
function CheckFinalBridgeStatus()
  LD.CallFunctionAfterDelay(function()
    TUT.LightArrowUnlocks_Tutorial()
  end, 5)
  if varFinalBridgeOn == true then
    EnableLTWExitTo690()
  else
    GameObjects.CA_HintAtFinalBridge.LuaObjectScript.Enable()
  end
end
function FinalBridgeLead()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
end
function EnableLTWExitTo690()
  GameObjects.LTW_ExitTo690.LuaObjectScript.Enable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
end
function DisableLTWExitTo690()
  GameObjects.LTW_ExitTo690.LuaObjectScript.Disable()
end
function RevealLootContainer()
  GameObjects.chest_common_tier1_alf600_1.LuaObjectScript.Enable()
  for _, x in pairs(GameObjects.AnimatedHiveCover.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
end
function GetBool_CrystalTendril1()
  return bTendril01
end
function GetBool_CrystalTendril2()
  if bTendril02 == true then
    local fnf = thisLevel:GetGameObject("FireAndForgetV3_Tendril2_Zoom").Child
    fnf.LuaObjectScript.UseCineLock()
    return true
  end
  return false
end
function ClimbTendrilBreak()
  GameObjects.TraverseClimbHive:ShowTraversePath()
  GameObjects.ClimbTendrilGeo:PlayAnimToEnd()
  GameObjects.TraverseClimbFirst:HideTraversePath()
  GameObjects.CamZone_VistaPeakReveal:ShowCameraVolume()
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Fliers AlfDgn600", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone600Low"
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_L_10",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_L_12",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_L_13",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_0_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_0_Spawn"), {cineRequirement = 242})
  Area_0_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Suicide")
    game.AI.FindSon():CallScript("EnterBehaviorContext", "BORED_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_ObserveBridge3.LuaObjectScript.Enable()
  end)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Leftover Dark Ones AlfDgn600", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone600Low"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DarkOne_SFBL",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DarkOne_TURR",
      spawnLocators = "A1_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"), {cineRequirement = 242})
  Area_1_Encounter_1:OnStart(function()
    GameObjects.CA_turretSon.LuaObjectScript.Enable()
  end)
  Area_1_Encounter_1:OnComplete(function()
    GameObjects.CA_BoredBridge3.LuaObjectScript.Enable()
    GameObjects.CA_ObserveBridge3.LuaObjectScript.Disable()
    GameObjects.CA_turretSon.LuaObjectScript.Disable()
  end)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dark Ones Near Light Beam AlfDgn600", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone600Mid"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "DarkOne_SFBF",
      spawnLocators = "A1_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.3
    },
    {
      spawners = "DarkOne_SFBF",
      spawnLocators = "A1_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "DarkOne_SFBR",
      spawnLocators = "A1_Loc_L_11",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_1_Spawn"), {cineRequirement = 242})
  Area_2_Encounter_1:OnStart(function()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
  end)
  Area_2_Encounter_1:OnComplete(CheckFinalBridgeStatus)
end
function Area_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Flyers on return to crack climb AlfDgn600", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone600Low"
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyer_SABU",
      spawnLocators = "A1_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    }
  })
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dark Ones Jump Out Before Temporal Door", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone600Upper"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "DarkOne_SFR8",
      spawnLocators = "A1_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    },
    {
      spawners = "DarkOne_SFBF",
      spawnLocators = "A1_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.1
    }
  })
  Area_3_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_3_Spawn"), {cineRequirement = 242})
  Area_3_Encounter_1:OnStart(function()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
  end)
end
function OnSaveCheckpoint(level)
  return {
    reminderDone = reminderDone,
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  reminderDone = savedInfo.reminderDone
  checkpoint.Restore(savedInfo.levelstate)
end
function Quest_CompleteObj500()
  LD.CompleteQuest("Quest_Alfheim_Objective500")
  game.Compass.SetDesignerForcedHide(false)
end
function Quest_CompleteObj500_Failsafe()
  if game.Level.GetVariable("CompletedCineNumber") >= 242 then
    LD.CompleteQuest("Quest_Alfheim_Objective500")
    game.Compass.SetDesignerForcedHide(false)
  end
end
local soundEmitter, SNDPulseOff, Alf050
function SoundInit()
  soundEmitter = GameObjects.LightRumbleSoundGroup:FindSingleSoundEmitterByName("SNDLightRumble")
end
function PlayRumbleSound(level)
  LD.PlaySound(soundEmitter, "SND_AMB_EMIT_Alfheim_Light_Swam_Rumble_LP")
end
function StopRumbleSound()
  LD.StopSound(soundEmitter, "SND_AMB_EMIT_Alfheim_Light_Swam_Rumble_LP")
end
function StopAllAlfheimAmbience(level)
  if Alf050 == nil then
    Alf050 = game.FindLevel("Alf050_Sound")
  end
  if Alf050 ~= nil then
    Alf050:CallScript("StopAllPulseSound", thisLevel)
  end
  StopRumbleSound()
end
function Alf600_Bookmark_TempleIntSetup()
end
