local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local CCOS = require("camera.camera_oneshot")
local uiCalls = require("ui.uicalls")
local player, pad, son, CarryBlock
local CarryBlockDisabled = false
local sandLocated = false
local varLightBridge01 = false
local sandbowlSolved = false
local mainDoorCrystal, boostWarpMarker
local interactStarted = false
local doorEmitterLeft, doorEmitterRight, temporalDoorChainEmitter
local sonBoosted = false
local sandBowl, carryCryastal
local doorCrystalBroken = false
local varBeconMsgOn = false
local bBridgeActive = false
local camOneShot_LookAtRuneBowl, camOneShot_LookAtBlueDoor, tendrilsCut
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
  son = game.AI.FindSon()
  boostWarpMarker = GameObjects.SonWarpPoint1
  sandBowl = GameObjects.Runebowl690.LuaObjectScript
  MainGateEmittersInit()
end
function OnFirstStart(level)
  GameObjects.TemporalBridge_01:Hide()
  GameObjects.TemporalBridge_01:HideCollision()
  GameObjects.TemporalBridge_02:Hide()
  GameObjects.TemporalBridge_02:HideCollision()
  GameObjects.Anim_SwayIdle:PlayAnimCycle()
  StopLTW()
  GameObjects.s_hook_breakable.Child:SetEmissiveScale(5)
end
function OnStartGameFromThisLevel(level)
  game.Level.SetVariable("ALF_LightAcquired", true)
end
function OnStart(level)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  SoundOnStart()
  GameObjects.ca_boostdropdown_5m.LuaObjectScript.Disable()
  if cineNum < 245 then
    carryCryastal = GameObjects.CarryBifrostMainDoor.LuaObjectScript
  else
    if 250 <= cineNum then
      GameObjects.BanterZone_LegendarySass.LuaObjectScript.Disable()
    end
    GameObjects.ScrollGroup:JumpAnimToPercent(1)
  end
  OnStartFixup_TemporalCrystal()
end
function OnStartFixup_TemporalCrystal()
  if LD.GetEntityVariable("ALF_TempleDone") == true and GameObjects.Btr_CrystalRune.LuaObjectScript.CrystalHasBeenPickedUp() == false then
    GameObjects.CarryBifrostMainDoor.LuaObjectScript.EnableInteract()
    StartLTW()
  end
end
function OnUpdate(level)
  if player:IsInsideEntityZone("DetectSonEnterRoom") == true and sandLocated == false then
    sandLocated = true
    game.Level.SetVariable("ALF_NAR_SandLocated", true)
  end
  if camOneShot_LookAtRuneBowl ~= nil then
    camOneShot_LookAtRuneBowl:Update()
  end
  if camOneShot_LookAtBlueDoor ~= nil then
    camOneShot_LookAtBlueDoor:Update()
  end
end
function DisableTendrilSolve()
  GameObjects.TendrilAxeTarget03.Child.LuaObjectScript.Disable()
end
function EnableTendrilSolve()
  GameObjects.TendrilAxeTarget03.Child.LuaObjectScript.Enable()
end
function TemporalGateVanish()
  LD.SetEntityVariable("ALF_TempleDone", true)
  GameObjects.Anim_BreakAndFall:PlayAnimToEnd()
  GameObjects.Anim_SwayIdle:PlayAnimToEnd(2)
  LD.CallFunctionAfterDelay(function()
    GameObjects.CarryBifrostMainDoor.LuaObjectScript.EnableInteract()
  end, 2)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_CrystalDrop.LuaObjectScript.Trigger()
  end, 0.75)
  GameObjects.CA_WaitAtStairs.LuaObjectScript.Enable()
  PlayDoorVanishSound()
  local temporalDoor
  temporalDoor = GameObjects.DOOR_690.Child
  if temporalDoor then
    temporalDoor.LuaObjectScript.FlickerOff(DoorVanishComplete)
  else
    DoorVanishComplete()
  end
  local alf600 = game.FindLevel("Alf600_TempleInt")
  if alf600 ~= nil then
    alf600:CallScript("TemporalDoorCombatZone")
  end
  timer.StartLevelTimer(2, StartLTW)
end
function StartLTW()
  GameObjects.CA_ShieldEyes.LuaObjectScript.Disable()
  GameObjects.NavObstacle_LightDoor:HideNavObstacle()
  Enable_LTW()
end
function StopLTW()
end
function Enable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Enable()
end
function Disable_LTW()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
end
function DoorVanishComplete()
  GameObjects.DOOR_690:Hide()
  timer.StartLevelTimer(2, function()
    BOOKMARK_06_Alfheim_065_AfterTempleIntPuzzle()
  end)
end
function TurnOn690Door()
  timer.StartLevelTimer(2.7, TurnOnDoor)
end
function TurnOnDoor()
  GameObjects.DOOR_690.LuaObjectScript.TurnTemporalObjectOff()
  timer.StartLevelTimer(0.5, function()
    GameObjects.DOOR_690.Child.LuaObjectScript.TurnTemporalObjectOn()
  end)
end
function WaitingForBridge()
  GameObjects.CA_WaitForLight.LuaObjectScript.Disable()
  engine.SendHook("OnStandGround", son, true)
end
function AtBowl()
  carryCryastal.Enable()
end
function EnableSandBowl()
  if not sandbowlSolved then
    sandBowl.Enable()
    carryCryastal.Disable()
  end
end
function DisableSandBowl()
  sandBowl.Disable()
end
function ReadRune()
  if interactStarted == false then
    if sonBoosted == false or varLightBridge01 == false then
      sandBowl.SetRuneDiscovered(true)
    else
      sandBowl.SetRuneDiscovered()
      game.Audio.StartMusic("SND_MX_ALF_temple_interior_puzzle_out")
    end
  end
  interactStarted = true
end
function PostReadRune(test, test2)
  if sonBoosted and varLightBridge01 then
    LookAt_KidAndRunebowl()
    sandBowl.EnableFromAlf690()
  end
end
function SonBoosted()
  sonBoosted = true
  game.Level.SetVariable("ALF_SonBusy", true)
  GameObjects.CA_WaitForBoost.LuaObjectScript.Disable()
  GameObjects.CA_Idle_PuzzleArea1.LuaObjectScript.Disable()
  GameObjects.CA_Idle_PuzzleArea2.LuaObjectScript.Disable()
  GameObjects.CA_Idle_Kick.LuaObjectScript.Disable()
  GameObjects.CA_SitOnGround.LuaObjectScript.Disable()
  GameObjects.IdleBored.LuaObjectScript.Disable()
  GameObjects.EntZn_EnableSit:HideEntityVolume()
  GameObjects.EntZn_DisableSit:HideEntityVolume()
  son:Warp(boostWarpMarker:GetWorldPosition(), boostWarpMarker:GetWorldForward())
  if varLightBridge01 then
    EnableSandBowl()
    GameObjects.CarryBifrostLightTop.LuaObjectScript.Lock()
  else
    GameObjects.CA_WaitForLight.LuaObjectScript.Enable()
  end
end
function OnSonDrop()
  GameObjects.CarryBifrostLightTop.LuaObjectScript.Unlock()
end
function Alf690_LB_ON_01()
  varLightBridge01 = true
  GameObjects.TemporalBridge_01:Show()
  GameObjects.TemporalBridge_01:ShowCollision()
  if sonBoosted and not sandbowlSolved then
    EnableSandBowl()
    GameObjects.CarryBifrostLightTop.LuaObjectScript.Lock()
    engine.SendHook("OnStandGround", son, false)
    GameObjects.CA_WaitForLight.LuaObjectScript.Disable()
  end
  if bBridgeActive == false and game.Level.GetVariable("CompletedCineNumber") < 245 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("BlueDoorBowl_LightBridgeActive")
    end, 1)
    bBridgeActive = true
  end
end
function Alf690_LB_OFF_01()
  varLightBridge01 = false
  GameObjects.TemporalBridge_01:Hide()
  GameObjects.TemporalBridge_01:HideCollision()
end
function CheckBridgeState()
  return varLightBridge01
end
function alfheimGateRunesON_02()
  GameObjects.TemporalBridge_02:Show()
  GameObjects.TemporalBridge_02:ShowCollision()
end
function alfheimGateRunesOFF_02()
  GameObjects.TemporalBridge_02:Hide()
  GameObjects.TemporalBridge_02:HideCollision()
end
function alfheimRuneReadExit()
  game.Level.SetVariable("ALF_LightAcquired", true)
  game.Level.SetVariable("ALF_SonBusy", false)
  PlayMainGateOpeningSound()
  GameObjects.AlfheimMainGate:PlayAnimToEnd()
  LookAt_BlueDoor()
  GameObjects.ca_boostdropdown_5m.LuaObjectScript.Enable()
  game.Audio.PlayBanter("BlueDoorBowl_DoorAfterAll")
  sandbowlSolved = true
  local alf320 = game.FindLevel("Alf320_TrenchADark")
  if alf320 ~= nil then
    alf320:CallScript("EnableMainGate")
    alf320:CallScript("UnlockMainGate")
  end
end
function Bookmark690Puzzle()
  alfheimRuneReadExit()
end
function EnableSitOnGround()
  GameObjects.CA_SitOnGround.LuaObjectScript.Enable()
end
function DisableSitOnGround()
  GameObjects.CA_SitOnGround.LuaObjectScript.Disable()
  if tendrilsCut then
    GameObjects.CA_WaitForBoost.LuaObjectScript.Enable()
  end
end
function RemoveHive690()
  tendrilsCut = true
  for _, x in pairs(GameObjects.HiveBlocker690.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  timer.StartLevelTimer(1, function()
    GameObjects.Tendrils690:Hide()
  end)
  GameObjects.CA_Idle_Kick.LuaObjectScript.Disable()
  GameObjects.Scripted_HiveWall:HideCollision()
  GameObjects.SonBoost.LuaObjectScript.Enable()
  GameObjects.EntZn_EnableSit:HideEntityVolume()
end
function RemoveHiveSecret()
  for _, x in pairs(GameObjects.HiveBlockerSecret.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  timer.StartLevelTimer(1, function()
    GameObjects.TendrilsSecret:Hide()
  end)
end
function TurnOff_690RingAndBeam()
  GameObjects.Ring690:Hide()
  GameObjects.Beam690:Hide()
end
function TurnOn_690RingAndBeam()
  GameObjects.Ring690:Show()
  GameObjects.Beam690:Show()
end
function ShowBeconText()
  if LD.GetEntityVariable("ALF_SonBusy") == true and varBeconMsgOn == false then
    uiCalls.SendBottomDesignerMessage({
      Text = 43051,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
    varBeconMsgOn = true
  end
end
function ShowBeconText_CanRepeat()
  if LD.GetEntityVariable("ALF_SonBusy") == true then
    uiCalls.SendBottomDesignerMessage({
      Text = 43051,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
  end
end
function HideBeckonText()
  if varBeconMsgOn == true then
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end
end
function DisableSonArrow()
  if LD.GetEntityVariable("ALF_SonBusy") == true then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
  end
end
function EnableSonArrow()
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
end
function OnSaveCheckpoint(level)
  return {sandbowlSolved = sandbowlSolved, tendrilsCut = tendrilsCut}
end
function OnRestoreCheckpoint(level, savedInfo)
  sandbowlSolved = savedInfo.sandbowlSolved or false
  tendrilsCut = savedInfo.tendrilsCut
end
function SoundOnStart()
  GameObjects.InvisibleInkTotem:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
  if GameObjects.Anim_BreakAndFall.AnimFrame < 1 then
    LD.PlayRestartableSoundLoop(temporalDoorChainEmitter, "SND_AMB_EMIT_Bifrost_Crystal_Hanging_Chain_LP")
  end
end
function MainGateEmittersInit()
  doorEmitterRight = GameObjects.AlfheimMainGate:FindSingleSoundEmitterByName("SNDTempleDoorLeft")
  doorEmitterLeft = GameObjects.AlfheimMainGate:FindSingleSoundEmitterByName("SNDTempleDoorRight")
  temporalDoorChainEmitter = GameObjects.DoorOn1SndGrp:FindSingleSoundEmitterByName("SNDCrystalChain")
end
function PlayMainGateOpeningSound()
  LD.PlaySound(GameObjects.SNDGrpRunes:FindSingleSoundEmitterByName("SNDRunes"), "SND_DOOR_Alfheim_Temple_Round_Puzzle_Magic_Open")
end
function PlayDoorVanishSound()
  LD.PlaySound(GameObjects.DoorOn1SndGrp:FindSingleSoundEmitterByName("SNDDoorOn1"), "SND_MAG_Temporal_Light_Door_PowerDown")
  LD.StopRestartableSoundLoop(temporalDoorChainEmitter, "SND_AMB_EMIT_Bifrost_Crystal_Hanging_Chain_LP")
  LD.PlaySoundOnFrame(GameObjects.CarryBifrostMainDoor.Child.SoundEmitters[1], GameObjects.Anim_BreakAndFall, "SND_AMB_EMIT_Bifrost_Crystal_Hanging_Fall_Impact", 26, "forward")
end
function StopDoorLoops()
  LD.StopSound(doorEmitterRight, "SND_DOOR_Stone_Alfheim_Temple_Open_LP_R")
  LD.StopSound(doorEmitterLeft, "SND_DOOR_Stone_Alfheim_Temple_Open_LP_L")
end
function OnEvaluateLoadGroup_Lighting1()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting2()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function BOOKMARK_06_Alfheim_065_AfterTempleIntPuzzle()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_065_AfterTempleIntPuzzle"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function DestroyOneShot_LookAtRuneBowl()
  camOneShot_LookAtRuneBowl = nil
end
function DestroyOneShot_LookAtBlueDoor()
  camOneShot_LookAtBlueDoor = nil
end
function LookAt_KidAndRunebowl()
  camOneShot_LookAtRuneBowl = CCOS.OneShotCamera.New("PLYR_NAR_Alf690_Solved_RuneBowl", 15)
  camOneShot_LookAtRuneBowl:SetCallback(DestroyOneShot_LookAtRuneBowl)
  camOneShot_LookAtRuneBowl:ActivateCineLock(22)
  camOneShot_LookAtRuneBowl:Start()
end
function LookAt_BlueDoor()
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 5,
    TweenIn = {Time = 1},
    TweenOut = {Time = 2}
  })
  camOneShot_LookAtBlueDoor = CCOS.OneShotCamera.New("PLYR_NAR_Alf690_Solved_BlueDoor", 7.5)
  camOneShot_LookAtBlueDoor:SetCallback(DestroyOneShot_LookAtBlueDoor)
  camOneShot_LookAtBlueDoor:Start()
end
