local timers = require("level.timer")
local playedBtr01 = false
local playedBtr02 = false
function OnScriptLoaded(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {played01 = playedBtr01, played02 = playedBtr02}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedBtr01 = savedInfo.played01
  playedBtr02 = savedInfo.played02
end
function PlayCrystalRune01Btr()
  if not playedBtr01 then
    playedBtr01 = true
    if game.Level.GetVariable("CompletedCineNumber") < 250 then
      timers.StartLevelTimer(1, function()
        game.Audio.PlayBanter("ALf_CrystalRune_Son1")
      end)
    end
  end
end
function CrystalHasBeenPickedUp()
  return playedBtr01
end
function PlayCrystalRune02Btr()
  if not playedBtr02 then
    playedBtr02 = true
    if game.Level.GetVariable("CompletedCineNumber") < 250 then
      game.Audio.PlayBanter("Alf_CrystalRune_Kra")
    end
  end
end
