local LD, calderaDebug, realmInfo, thisLevel
function OnScriptLoaded(level)
  thisLevel = level
  calderaDebug = engine.VFSBool.New("Show Caldera Debug")
  if game.build.GOLD_VERSION == 1 then
    OnUpdate = nil
  end
end
function OnUpdate(level)
  if game.build.GOLD_VERSION ~= 1 and engine.IsDebug() == true and calderaDebug.value == true then
    if LD == nil then
      LD = require("design.LevelDesignLibrary")
      realmInfo = require("design.RealmInfoLibrary")
      realmInfo.debugObjLoc = {}
      for _, realm in ipairs(realmInfo.names) do
        realmInfo.debugObjLoc[realm] = GameObjects[realm .. "_LocatorDebug"].WorldPosition
      end
    end
    local t = {}
    t.Title = "Global Entity Variables"
    t.X = 200
    t.Y = 1
    table.insert(t, {
      "CompletedCineNumber: ",
      tostring(game.Level.GetVariable("CompletedCineNumber"))
    })
    table.insert(t, {
      "CurrentRealm: ",
      LD.GetCurrentRealm() .. ": " .. tostring(game.Level.GetVariable("_GBL_CurrentRealm"))
    })
    table.insert(t, {
      "SelectedRealm: ",
      LD.GetSelectedRealm() .. ": " .. tostring(game.Level.GetVariable("_GBL_SelectedRealm"))
    })
    table.insert(t, {
      "BridgePosition: ",
      LD.GetBridgePosition() .. ": " .. tostring(game.Level.GetVariable("_GBL_BridgePosition"))
    })
    table.insert(t, {
      "BridgeAnimationTargetFrame: ",
      tostring(LD.GetBridgeAnimationFrame())
    })
    table.insert(t, {
      "BridgeAnimationRate: ",
      tostring(LD.GetBridgeAnimationRate())
    })
    table.insert(t, {
      "WaterDrop01Triggered: ",
      game.Level.GetVariable("_GBL_WaterDrop01Triggered")
    })
    table.insert(t, {
      "WaterDrop02Triggered: ",
      game.Level.GetVariable("_GBL_WaterDrop02Triggered")
    })
    table.insert(t, {
      "DragonArrivalTriggered: ",
      game.Level.GetVariable("_GBL_DragonArrivalTriggered")
    })
    engine.DrawDebugTable(t)
    t = {}
    t[#t + 1] = {
      "Frame Locations:"
    }
    for _, realm in ipairs(realmInfo.names) do
      t[#t + 1] = {
        "\t" .. tostring(realmInfo.frames[realm]) .. " (" .. realm .. ")"
      }
      local textPos = realmInfo.debugObjLoc[realm]
      if textPos ~= nil then
        engine.DrawTextInWorld(textPos, realm, 16711680)
      end
    end
    for i, child in ipairs(GameObjects.Debug_POIs.Children) do
      engine.DrawTextInWorld(child.WorldPosition, child:GetName(), 255, i % 2)
    end
  end
end
function WorldSnakeIntroComplete()
  UpdateBoatDocks()
  EnableDropletSpawner()
end
function UpdateBoatDocks()
  local activeDocks = game.World.FindGameObjectsByMarker("BoatDock")
  for _, dock in pairs(activeDocks) do
    if dock.LuaObjectScript ~= nil then
      dock.LuaObjectScript.UpdateDockState()
    else
      dock:CallScript("UpdateDockState")
    end
  end
end
function EnableDropletSpawner()
  local player = game.Player.FindPlayer()
  local fx = game.FX.Spawn("calderawaterdrop_decay_fx", thisLevel, {
    Scale = 1,
    Follow = true,
    EffectCreator = player,
    GameObject = player,
    Joint = "JONeck1",
    AutoDelete = false,
    DeleteWithCreature = false
  })
  local timers = require("level.timer")
  timers.StartLevelTimer(150, function()
    fx:Remove()
  end)
end
