local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local TUT = require("game.GlobalTutorials")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local thisObj, thisLevel, kraActor, sonActor, brkActor, fishProp0, fishProp1, fishProp2, beastProp, camCineEnterShopPre, camCineEnterShopIntro
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 183 then
    SetupActors()
  else
    thisObj:FindSingleGOByName("NoGoZone"):Hide()
  end
  SetupProps()
end
function SetupProps()
  fishProp0 = GameObjects.fishProp.Child
  fishProp1 = GameObjects.fishProp1.Child
  fishProp2 = GameObjects.fishProp2.Child
  beastProp = GameObjects.huldraCreatureProp.Child
  HideProps()
end
function HideProps()
  fishProp0:Hide()
  fishProp1:Hide()
  fishProp2:Hide()
  beastProp:Hide()
end
function ShowProps()
  fishProp0:Show()
  fishProp1:Show()
  fishProp2:Show()
  beastProp:Show()
end
function SetupActors()
  kraActor = actor.Actor.New("CAL SHOP INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("CAL SHOP INTRO: Son Actor", game.AI.FindSon)
  brkActor = actor.Actor.New("CAL SHOP INTRO: Brok Actor", ND.FindBrok)
end
function SetupCineSeqLeft()
  game.SubObject.Wake(thisObj)
  camCineEnterShopPre = CCEC.CineEnterCamera.New("ENV_CineEnter_narCalCalderaShopLeft", 12, nil)
  camCineEnterShopPre:Start()
  SetupCineSeq(thisObj:GetJointIndex("TopOfStairsLeft_Joint"), thisObj:GetJointIndex("FaceMountainLeft_Joint"))
end
function SetupCineSeqRight()
  game.SubObject.Wake(thisObj)
  camCineEnterShopPre = CCEC.CineEnterCamera.New("ENV_CineEnter_narCalCalderaShopRight", 12, nil)
  camCineEnterShopPre:Start()
  SetupCineSeq(thisObj:GetJointIndex("TopOfStairsRight_Joint"), thisObj:GetJointIndex("FaceMountainRight_Joint"))
end
local stuckFishFrame
function SetupCineSeq(firstApproachJoint, secondApproachJoint)
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "CalShopIntro")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = brkActor},
    {Obj = beastProp},
    {Obj = fishProp0},
    {
      Obj = fishProp1,
      Anim = "narCalCalderaShopIntro000CineScene1"
    },
    {
      Obj = fishProp2,
      Anim = "narCalCalderaShopIntro000CineScene2"
    }
  }
  local joint01Pos = thisObj:GetWorldJointPosition(firstApproachJoint)
  local joint01Dir = thisObj:GetWorldJointForward(firstApproachJoint)
  local joint02Pos = thisObj:GetWorldJointPosition(secondApproachJoint)
  local joint02Dir = thisObj:GetWorldJointForward(secondApproachJoint)
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  seq:MarkAbleToSkip()
  seq:Do(function()
    LD.CallFunctionAfterDelay(CameraStartCineEnter, 6)
  end)
  seq:Do(function()
    game.Player.FindPlayer():SetAccelerationOverride(1.2)
  end)
  seq:Do(function()
    game.Player.FindPlayer():SetDecelerationOverride(1.2)
  end)
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(function()
    thisObj:FindSingleGOByName("NoGoZone"):Hide()
  end)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_CalShopIntro",
    ReferenceJoint = "CalShopIntro_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    strafe_distance = 0.5,
    radius = ND.ArrivalRadius,
    foot = game.Creature.Foot.kLeft,
    weapon_state = "bare_on_back",
    ignore_navmesh = false
  })
  seq:WaitForLoadCheck("Cal120_Airlock")
  seq:Do(function()
    table.insert(slaveTab, {
      Obj = game.FindLevel("Cal120_Airlock"):GetGameObject("SpreadDoor_Caldera_AirLock").Child
    })
  end)
  seq:WaitForFunctionTrue(FindBrokOrSpawn)
  seq:Do(ShowProps)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_CalShopIntro",
    ReferenceJoint = "CalShopIntro_SynchJoint"
  })
  seq:Do(RemoveFastTravelWalletItem_PatchFixGuarantee)
  seq:WaitSeconds(1)
  seq:Do(function()
    stuckFishFrame = fishProp2.AnimFrame
  end)
  seq:WaitForFunctionTrue(FishAnimUpdating)
  seq:Do(ResetFishFrame)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(brkActor)
  seq:Do(HideProps)
  seq:Do(function()
    game.Player.FindPlayer():ClearAccelerationOverride()
  end)
  seq:Do(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end)
  seq:SetCompletedCineNumber(183)
  seq:WaitForLoadCheck("Cal120_Airlock")
  seq:Do(UnloadCalShopIntro)
  seq:Do(function()
    LD.UnlockPreMimirBoatLore()
    LD.EnableBoatLore()
  end)
  seq:Do(RiverPass_940)
  seq:StartSequence()
end
function RemoveFastTravelWalletItem_PatchFixGuarantee()
  local resourceCount = game.Wallets.GetResourceValue("HERO", "FastTravelUnlock01")
  if 0 < resourceCount then
    game.Wallets.RemoveResource("HERO", "FastTravelUnlock01", resourceCount)
  end
end
function FishAnimUpdating()
  return stuckFishFrame ~= fishProp2.AnimFrame
end
function ResetFishFrame()
  fishProp0:JumpAnimationToFrame(beastProp.AnimFrame)
  fishProp1:JumpAnimationToFrame(beastProp.AnimFrame)
  fishProp2:JumpAnimationToFrame(beastProp.AnimFrame)
end
function FindBrokOrSpawn()
  if ND.FindBrok() then
    return true
  end
  game.FindLevel("Cal120_Airlock"):CallScript("ShopIntroStart")
  return false
end
function LuaHook_EnableVendorInteract()
  print("GOT ENABLE ON VENDOR INTERACT")
  game.FindLevel("Cal120_Airlock"):CallScript("EnableLargeShopVendorInteract")
end
function UnloadCalShopIntro()
  local cal100 = game.FindLevel("Cal100_Hub")
  cal100:CallScript("TurnOffShopIntroLoadCheck")
  game.FindLevel("Cal120_Airlock"):CallScript("ShopIntroDone")
end
function CameraStartCineEnter()
  camCineEnterShopIntro = CCEC.CineEnterCamera.New("ENV_CineEnter_narCalCalderaShopIntro", 10, nil)
  camCineEnterShopIntro:Start()
  camCineEnterShopIntro:SetCallback(CameraDestroyCineEnter)
end
function CameraDestroyCineEnter()
  camCineEnterShopIntro = nil
  camCineEnterShopPre = nil
  game.SubObject.Sleep(thisObj)
end
function RiverPass_940()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective940", "Complete")
end
function OnUpdate(level, obj)
  if camCineEnterShopPre ~= nil then
    camCineEnterShopPre:Update()
  end
  if camCineEnterShopIntro ~= nil then
    camCineEnterShopIntro:Update()
  end
end
