local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local delayTimers = require("level.timer")
local thisLevel, player, son
local jotumheimTowerICShouldHide = false
local bridge, dragonChkpt, peaksChkpt, fake120doors, freyaBridgeCollision, serpentPushCollision, jotTowerDocks, templeWaterDrips, PreStreamNode, hornElevatorManager, hornElevator, horn, hornElevatorSwitch, snakeHornLoad, midgardBridgeZone, dragonRideBridgeZone, foothillsLoadZone, bridgePushZones, shopIntroLoad, foothillsActivate, xplBridgeZones, cameraCineEnterBridgePush
local bDoor1Opened = false
local bDoor2Opened = false
local bTempleFlipKeyUsed = false
local TempleFlipState = "Outside"
local RuneVaultState = "Outside"
local insideRuneVault = false
local RuneVaultEnterTimers
local Rift_Challenge_Duration = 10
local Challenge_Started = false
local ecTimer, ec_TimeRequirement, hudTimeRemaining
local delayDestruction = false
local delayDestruction_T = {}
local Cal100_combatScript
local timers_LoadLibrary = function()
  if timers == nil then
    timers = require("level.timer")
  end
end
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  bridge = GameObjects.calderaBridge
  dragonChkpt = GameObjects.DragonRideChkpt
  peaksChkpt = GameObjects.PeaksReturnChkpt
  fake120doors = GameObjects.FakeAirlockDoor
  freyaBridgeCollision = GameObjects.PitEdgeCollision
  serpentPushCollision = GameObjects.SerpentPushCollision
  templeWaterDrips = GameObjects.FX_Temple_drips01
  hornElevatorManager = GameObjects.Cal100Horn_ElevatorManager
  hornElevatorManager = GameObjects.Cal100Horn_ElevatorManager
  hornElevator = GameObjects.HornElevator
  horn = GameObjects.HornInteractZone
  hornElevatorSwitch = GameObjects.Cal100Horn_ElevatorSwitch
  midgardBridgeZone = GameObjects.LoadInteriorMidgard
  snakeHornLoad = GameObjects.LoadSnake
  dragonRideBridgeZone = GameObjects.LoadInteriorDragonRide
  foothillsLoadZone = GameObjects.LoadFoothills
  bridgePushZones = level:FindGameObjects("LoadBridgePush*")
  shopIntroLoad = GameObjects.LoadInteriorShopIntro
  foothillsActivate = GameObjects.FoothillsActivate
  xplBridgeZones = level:FindGameObjects("LoadBridgeXpl*")
  jotTowerDocks = level:FindGameObjects("BoatDockJotunheim*")
  PreStreamNode = GameObjects.PreStreamGroup
  SoundInit()
  Cal100_combatScript = GameObjects.Cbt_Cal100.LuaObjectScript
end
function OnFirstStart(level)
  HideJotTower()
  GameObjects.bridgeCrankHandle.Child:StartAnim("envCal100BridgeWheelRepairTNF1_Enter")
  GameObjects.bridgeCrankHandle.Child:JumpAnimToPercent(0)
  GameObjects.bridgeCrankHandle.Child:PauseAnim()
  bridge:StartAnim("rotate360")
  bridge:JumpAnimToFrame(0)
  bridge:PauseAnim()
  dragonRideBridgeZone:HideEntityVolume()
  midgardBridgeZone:ShowEntityVolume()
  foothillsLoadZone:ShowEntityVolume()
  shopIntroLoad:HideEntityVolume()
  foothillsActivate:HideEntityVolume()
  HideTableElements(xplBridgeZones)
  ShowTableElements(bridgePushZones)
  GameObjects.LoadElevator_Runevault:HideEntityVolume()
  GameObjects.Snap120toBridge:HideEntityVolume()
  dragonChkpt:HideEntityVolume()
  peaksChkpt:HideEntityVolume()
  GameObjects.FakeNavmeshObjects:Hide()
  serpentPushCollision:Hide()
  GameObjects.SonSickBlockersBridge:Hide()
  GameObjects.DragonRideLoadCheck:Hide()
  templeWaterDrips:Hide()
  GameObjects.traveler_lowRes1:Hide()
  GameObjects.traveler_lowRes2:Hide()
  GameObjects.traveler_lowRes3:Hide()
  GameObjects.coli_right:Hide()
  GameObjects.coli_left:Hide()
  GameObjects.EntZn_Nidavellir_Tower_Start:HideEntityVolume()
  GameObjects.Alert_DeadFreight_Zone:HideEntityVolume()
  GameObjects.Cal100Horn_ElevatorInvisSheet:Hide()
  hornElevator:HideNavObstacle()
  GameObjects.PlaytestTextUI_Jot_RbR:Hide()
  GameObjects.navGeo:Hide()
  GameObjects.ElevatorGuardRail:Hide()
  GameObjects.TVBridgeHideCol:Hide()
  GameObjects.TVRuneVaultHideCol:Hide()
  RuneVaultState = "Outside"
  TempleFlipState = "Outside"
  game.EvaluateLoadZones()
  PreStreamNode:Hide()
  GameObjects.SnakeCol:Hide()
  GameObjects.UpperBridgeBoatDockL.LuaObjectScript.HasDiscoveredDock()
  GameObjects.LowerBridgeBoatDockL.LuaObjectScript.HasDiscoveredDock()
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.HasDiscoveredDock()
  GameObjects.UpperBridgeBoatDockR.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockHelheimL1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockHelheimL2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockHelheimR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAsgardR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAsgardR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockMuspelheimR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockMuspelheimR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockVanaheimL1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockVanaheimL2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockVanaheimR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockSvartalfheimR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockSvartalfheimR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAlfheimL1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAlfheimL2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAlfheimR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockAlfheimR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockNidavellirR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockNidavellirR2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockJotunheimL1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockJotunheimL2.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockJotunheimR1.LuaObjectScript.HasDiscoveredDock()
  GameObjects.BoatDockJotunheimR2.LuaObjectScript.HasDiscoveredDock()
  local helBeach = GameObjects.Beach_HelheimR2:FindSingleGOByName("dockpoint_beach")
  local yOffset = engine.Vector.New(0, 0.3, 0)
  helBeach.LuaObjectScript.OverrideDefaultSpawnLocation(helBeach:GetWorldPosition() + yOffset)
  helBeach.LuaObjectScript.HasDiscoveredDock()
end
function OnStart(level)
  GameObjects.TVBridgeHideCol:Hide()
  SetBridgeAlignmentImmediate()
  if game.Level.GetVariable("CompletedCineNumber") > 339 and GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.IsOpen() == false then
    GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.Enable()
    LD.CallFunctionAfterDelay(function()
      GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.InteractDisable()
    end, 0.5)
  end
  LD.RegisterForVariableUpdate(level, "SAVED_BOOKMARK_15_Caldera_010_ChiselReturn", {
    immediateFn = function()
      GameObjects.BOOKMARK_15_Caldera_010_ChiselReturn:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end,
    fn = function()
      GameObjects.BOOKMARK_15_Caldera_010_ChiselReturn:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end
  })
  LD.RegisterForVariableUpdate(level, "SAVED_BOOKMARK_35_Caldera_010_JotunheimReady", {
    immediateFn = function()
      GameObjects.BOOKMARK_35_Caldera_010_JotunheimReady:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end,
    fn = function()
      GameObjects.BOOKMARK_35_Caldera_010_JotunheimReady:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end
  })
  LD.RegisterForVariableUpdate(level, "DragonArrivalTriggered", {
    immediateFn = SetDragonArrival,
    fn = SetDragonArrival
  })
  LD.RegisterForVariableUpdate(level, "BridgePosition", {
    immediateFn = SetBridgeAlignmentImmediate,
    fn = SetBridgeAlignment
  })
  LD.RegisterForCineUpdate(level, {
    {
      at = 180,
      immediateFn = function()
        ShopIntroOn()
        SetElevators_WaterLv1(true)
      end,
      fn = function()
        ShopIntroOn()
        SetElevators_WaterLv1()
      end
    },
    {
      at = 183,
      immediateFn = function()
        ShopIntroOff()
      end,
      fn = function()
        ShopIntroOff()
      end
    },
    {
      at = 190,
      immediateFn = function()
        GameObjects.CalderaBridge_water02:Hide()
      end,
      fn = function()
        GameObjects.CalderaBridge_water02:Hide()
      end
    },
    {
      at = 195,
      immediateFn = function()
        GameObjects.bridgeCrankHandle.Child:StartAnim("envCal100BridgeHandleRetract")
        GameObjects.bridgeCrankHandle.Child:JumpAnimToPercent(100)
        GameObjects.bridgeCrankHandle.Child:PauseAnim()
        GameObjects.bridgeCrankHandle.LuaObjectScript.Disable()
        FreyaCreateBridge()
        SwitchSmallBridgeOn()
      end,
      fn = function()
        FreyaCreateBridge()
        SwitchSmallBridgeOn()
      end
    },
    {
      at = 250,
      immediateFn = function()
        HideTableElements(bridgePushZones)
        ShowTableElements(xplBridgeZones)
      end,
      fn = function()
        HideTableElements(bridgePushZones)
        ShowTableElements(xplBridgeZones)
      end
    },
    {
      at = 340,
      immediateFn = function()
        templeWaterDrips:Show()
        GameObjects.WaterBlocks:Hide()
        GameObjects.corpse_common_tier2_cal100_1.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_1:Hide()
        GameObjects.corpse_common_tier2_cal100_2.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_2:Hide()
        GameObjects.corpse_common_tier2_cal100_3.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_3:Hide()
        GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.Enable()
        LD.CallFunctionAfterDelay(function()
          GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.InteractDisable()
        end, 0.5)
      end,
      fn = function()
        templeWaterDrips:Show()
        GameObjects.WaterBlocks:Hide()
        GameObjects.corpse_common_tier2_cal100_1.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_1:Hide()
        GameObjects.corpse_common_tier2_cal100_2.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_2:Hide()
        GameObjects.corpse_common_tier2_cal100_3.LuaObjectScript.Disable()
        GameObjects.corpse_common_tier2_cal100_3:Hide()
        GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.Enable()
        LD.CallFunctionAfterDelay(function()
          GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.InteractDisable()
        end, 0.5)
      end
    },
    {
      at = 360,
      immediateFn = function()
        templeWaterDrips:Hide()
        GameObjects.Btr_Caldera_Bridge.LuaObjectScript.Cleanup_BanterModules()
      end,
      fn = function()
        templeWaterDrips:Hide()
        GameObjects.Btr_Caldera_Bridge.LuaObjectScript.Cleanup_BanterModules()
      end
    },
    {
      at = 365,
      immediateFn = function()
        EnableSonSickBlockers()
        SonSickDisableDocks()
      end,
      fn = function()
        EnableSonSickBlockers()
        SonSickDisableDocks()
      end
    },
    {
      at = 366,
      immediateFn = function()
        SonSickEnableDocks()
      end,
      fn = function()
        SonSickEnableDocks()
      end
    },
    {
      at = 368,
      immediateFn = function()
        GameObjects.entityZoneSonSick:Show()
      end,
      fn = function()
        GameObjects.entityZoneSonSick:Show()
      end
    },
    {
      at = 370,
      immediateFn = function()
        ResetChiselDoorsAfterSynch()
      end,
      fn = function()
        ResetChiselDoorsAfterSynch()
      end
    },
    {
      at = 390,
      immediateFn = function()
        GameObjects.entityZoneSonSick:Hide()
        DisableSonSickBlockers()
        LD.CallFunctionAfterDelay(SonSickEnableDocks, 1)
      end,
      fn = function()
        GameObjects.entityZoneSonSick:Hide()
        DisableSonSickBlockers()
        SonSickEnableDocks()
      end
    },
    {
      at = 440,
      immediateFn = function()
        GameObjects.Btr_Zone_Bridge_Arrival_Water02:HideEntityVolume()
        RuneVaultState = "Outside"
        game.EvaluateLoadZones()
      end,
      fn = function()
        GameObjects.Btr_Zone_Bridge_Arrival_Water02:HideEntityVolume()
        RuneVaultState = "Outside"
        game.EvaluateLoadZones()
      end
    },
    {
      at = 470,
      immediateFn = function()
        SetDragonArrival()
      end,
      fn = function()
        SetDragonArrival()
      end
    },
    {
      at = 490,
      immediateFn = function()
        DragonComplete()
      end,
      fn = function()
        DragonComplete()
      end
    },
    {
      at = 500,
      immediateFn = function()
        GameObjects.BtrZone_Cal11_EnterMidgard.LuaObjectScript.Enable()
      end,
      fn = function()
        GameObjects.BtrZone_Cal11_EnterMidgard.LuaObjectScript.Enable()
      end
    },
    {
      at = 510,
      immediateFn = function()
        ShowSnakeCineVolume()
        TempleFlipState = "Outside"
        game.EvaluateLoadZones()
      end,
      fn = function()
        ShowSnakeCineVolume()
        TempleFlipState = "Outside"
        game.EvaluateLoadZones()
      end
    },
    {
      at = 512,
      immediateFn = function()
        LeaveTempleFlipThroughTemple()
      end,
      fn = function()
        LeaveTempleFlipThroughTemple()
      end
    },
    {
      at = 515,
      immediateFn = function()
        ShowJotTower()
        HideJotunheimTowerIC()
      end,
      fn = function()
        ShowJotTower()
      end
    },
    {
      at = 520,
      immediateFn = function()
        GameObjects.SnakeCol:Show()
      end,
      fn = function()
        GameObjects.SnakeCol:Show()
      end
    },
    {
      at = 540,
      immediateFn = function()
        GameObjects.EntZone_DisableBoatLore_InWad:Hide()
        GameObjects.SnakeCol:Hide()
      end,
      fn = function()
        GameObjects.EntZone_DisableBoatLore_InWad:Hide()
        GameObjects.SnakeCol:Hide()
      end
    }
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      SetElevators_WaterLv2(true)
      HideDockFlags_WaterLv2()
      GameObjects.LTW_Level02.LuaObjectScript.Enable()
      GameObjects.traveler_lowRes1:Show()
      GameObjects.traveler_lowRes2:Show()
      GameObjects.traveler_lowRes3:Show()
    end,
    fn = function()
      SetElevators_WaterLv2()
      HideDockFlags_WaterLv2()
      GameObjects.LTW_Level02.LuaObjectScript.Enable()
      GameObjects.traveler_lowRes1:Show()
      GameObjects.traveler_lowRes2:Show()
      GameObjects.traveler_lowRes3:Show()
    end
  })
  GameObjects.UpperBridgeBoatDockL.LuaObjectScript.SetTransformSaving(false)
  GameObjects.LowerBridgeBoatDockL.LuaObjectScript.SetTransformSaving(false)
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.SetTransformSaving(false)
  GameObjects.UpperBridgeBoatDockR.LuaObjectScript.SetTransformSaving(false)
  GameObjects.bridgeCrankHandle.LuaObjectScript.RegisterOnPlayerEnterCompleteCallbacks(CrankInteract_WheelRepairComplete)
  LD.CallFunctionAfterDelay(function()
    if player:IsInsideEntityZone(GameObjects.BridgeElevatorDetectionZone) == false then
      hornElevatorManager.LuaObjectScript.JumpToBottomFloor()
      if hornElevatorSwitch.LuaObjectScript.SwitchIsBeingTurnedOn() == true then
        hornElevatorSwitch.LuaObjectScript.ToggleState()
      end
    end
  end, 0.25)
  hornElevatorSwitch.LuaObjectScript.RemoveInteract(3)
  hornElevatorSwitch.LuaObjectScript.RemoveInteract(2)
  local interactZone = hornElevatorSwitch.LuaObjectScript.GetInteractZoneTable()
  interactZone[1]:SetInteractFrontAngleWeight(0.8)
  interactZone[1]:SetCameraFrontAngle(0, 120)
  interactZone[1]:SetCameraFrontAngleWeight(1)
  hornElevatorSwitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_Elevator_Snake")
  hornElevatorSwitch.LuaObjectScript.OverrideDefaultCameraYaw(true, GetHornElevatorSwitchYaw())
  hornElevatorManager.LuaObjectScript.AddWaitingCallback(WaitingAtElevatorCallback)
  hornElevatorManager.LuaObjectScript.AddOnWaitCompleteCallback(OnWaitCompleteElevatorCallback)
  hornElevatorManager.LuaObjectScript.SetUseCollisionCheckForWarp(true)
  local cal120 = game.FindLevel("Cal120_Airlock")
  if cal120 ~= nil then
    FakeDoorsOff()
  else
    FakeDoorsOn()
  end
  GameObjects.ElevatorGuardRail:Hide()
  SoundOnStart()
  UpdateWindPositions()
  GameObjects.RealmTowerDoor_Mus:FindSingleGOByName("SpreadDoor_Caldera").LuaObjectScript.RegisterOnInteractStartCallback(EnableMuspelheimTower_RightElevator)
end
function HideDockFlags_WaterLv2()
  GameObjects.Caldera_Docking_Flag_loop3:Hide()
  GameObjects.Caldera_Docking_Flag_loop1:Hide()
end
function OnUpdate(level)
  if cameraCineEnterBridgePush ~= nil then
    cameraCineEnterBridgePush:Update()
  end
  UpdateCreatureDestruction()
  if Challenge_Started then
    Encounter_Timer()
  end
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Cal120_Airlock" then
    FakeDoorsOff()
  end
  if newLevel.Name == "WAD_Cal590_RuneVaultElevator" then
    newLevel:CallScript("SnapElevatorToAtrium")
    if bDoor1Opened then
      SetupRoom1()
    end
    if bDoor2Opened then
      SetupRoom2()
    end
  end
end
function OnWadUnloaded(level, newLevel)
  if newLevel.Name == "WAD_Cal120_Airlock" then
    FakeDoorsOn()
  end
end
function ResetChiselDoorsAfterSynch()
  GameObjects.ChiselDoor_Hero1.LuaObjectScript.ImmediatelyDestroyDoor()
  GameObjects.ChiselDoor_Hero2.LuaObjectScript.ImmediatelyDestroyDoor()
  GameObjects.ChiselDoor_Hero1.LuaObjectScript.EnableDoor()
  GameObjects.ChiselDoor_Hero2.LuaObjectScript.EnableDoor()
end
function LockChiselDoors()
  GameObjects.ChiselDoor_Hero1.LuaObjectScript.DisableDoor()
  GameObjects.ChiselDoor_Hero2.LuaObjectScript.DisableDoor()
end
function UnlockChiselDoors()
  GameObjects.ChiselDoor_Hero1.LuaObjectScript.EnableDoor()
  GameObjects.ChiselDoor_Hero2.LuaObjectScript.EnableDoor()
end
function FakeDoorsOff()
  fake120doors:Hide()
  print("cal100 hiding fake doors")
end
function FakeDoorsOn()
  fake120doors:Show()
  print("cal100 showing fake doors")
end
function HideTableElements(objectTable)
  for _, obj in ipairs(objectTable) do
    obj:Hide()
  end
end
function ShowTableElements(objectTable)
  for _, obj in ipairs(objectTable) do
    obj:Show()
  end
end
function SetBridgeAnimation_Push()
  bridge:StartAnim("envBridgePushMidgardToJotunheim")
  bridge:JumpAnimToFrame(0)
  bridge:PauseAnim()
end
function CrankInteract_WheelRepairComplete()
  bridge:StartAnim("envBridgePushMidgardToJotunheim")
  bridge:PauseAnim()
  game.GameObject.AnimSync(GameObjects.BridgeCrankWheelMesh, bridge, 1)
  game.GameObject.AnimSync(GameObjects.BridgeCrankAxelMesh, bridge, 1)
  GameObjects.bridgeCrankHandle.LuaObjectScript.SetDrivenObject(bridge)
  SoundSetup_BridgePushDrivenObject()
end
function CrankInteract_BridgePushComplete()
  Complete_FootHills_Obj500()
  game.Audio.PlayBanter("TempleTrack_Complete", Complete_FootHills_Obj501)
  bridge:StartAnim("rotate360")
  bridge:PauseAnim()
  LD.SetSelectedRealm("Jotunheim")
  LD.SetBridgePosition("Jotunheim")
  GameObjects.bridgeCrankHandle.LuaObjectScript.ClearDrivenObject()
  GameObjects.bridgeCrankHandle.LuaObjectScript.Disable()
  game.Level.SetVariable("CompletedCineNumber", 195)
  LD.SetEntityVariable("CAL_SeenFreya", 3)
  GameObjects.Btr_MagicBowstring.LuaObjectScript.CrankFinished()
end
function CompassOff()
  game.Compass.SetDesignerForcedHide(true)
end
function SetSerpentPush()
  serpentPushCollision:Show()
  hornElevatorSwitch.LuaObjectScript.OverrideDefaultCameraYaw(true, GetHornElevatorSwitchYaw())
end
function SetDragonArrival()
  PreStreamNode:Show()
  dragonChkpt:ShowEntityVolume()
  midgardBridgeZone:HideEntityVolume()
  foothillsLoadZone:HideEntityVolume()
  HideTableElements(bridgePushZones)
  HideTableElements(xplBridgeZones)
  shopIntroLoad:HideEntityVolume()
  dragonRideBridgeZone:ShowEntityVolume()
  GameObjects.Snap120toBridge:ShowEntityVolume()
  GameObjects.DragonRideLoadCheck:Show()
  GameObjects.Cal100Horn_ElevatorSwitch:Hide()
  GameObjects.Cal100Horn_ElevatorSwitch.LuaObjectScript.Disable()
  GameObjects.LoadActivateInterior:HideEntityVolume()
  snakeHornLoad:HideEntityVolume()
end
function DragonRideLoadCheck()
  game.UI.LoadCheck("HelR090_AI_HengeDisrupt")
end
function DragonComplete()
  PreStreamNode:Hide()
  midgardBridgeZone:ShowEntityVolume()
  foothillsLoadZone:ShowEntityVolume()
  GameObjects.LoadActivateInterior:ShowEntityVolume()
  snakeHornLoad:ShowEntityVolume()
  ShowTableElements(xplBridgeZones)
  GameObjects.Cal100Horn_ElevatorSwitch:Show()
  GameObjects.DragonRideLoadCheck:Hide()
  dragonRideBridgeZone:HideEntityVolume()
end
function BaldurSnap120()
  if game.Level.GetVariable("CompletedCineNumber") == 470 then
    LD.SetBridgePosition("Midgard", 0)
  end
end
function HideLoadBridgeXpl()
  GameObjects.LoadBridgeXplR:HideEntityVolume()
end
function ShowLoadBridgeXpl()
  GameObjects.LoadBridgeXplR:ShowEntityVolume()
end
function ShowFoothillsLH()
  foothillsActivate:ShowEntityVolume()
  local foothillsMus = false
  if game.Level.GetVariable("CompletedCineNumber") >= 182 and game.Level.GetVariable("CompletedCineNumber") < 185 and foothillsMus == false then
    game.Audio.StartMusic("SND_MX_CAL250_foothills_LH_explore_in")
    foothillsMus = true
  end
  timers_LoadLibrary()
  timers.StartLevelTimer(4, function()
    foothillsActivate:HideEntityVolume()
  end)
end
function HideWaterBlocks()
  GameObjects.WaterBlocks:Hide()
end
function OpenVanaDoorA()
  if game.Level.GetVariable("CompletedCineNumber") < 210 and game.Level.GetVariable("CompletedCineNumber") >= 190 then
    local doorObj = GameObjects.RealmTowerDoor_Mid
    doorObj = doorObj:FindSingleGOByName("SpreadDoor_Caldera").Child
    doorObj.LuaObjectScript.Lock()
    doorObj.LuaObjectScript.EnableCinematicTrigger(true)
    player:RequestInteract(doorObj)
    LD.PlayApproach_GroupSync(doorObj, {
      {
        player,
        "BRA_DoorSpreadFreyaOpen"
      },
      {
        son,
        "BRA_DoorSpreadFreyaOpen"
      },
      {
        LD:FindFreya(),
        "BRA_DoorSpreadFreyaOpen_LaterExit",
        {keepEvaluatingPath = true}
      }
    }, "DoorSpreadFreyaOpen", true, "synchJointFront", {completion_percentage = 0.7})
    local freyaChar = LD.FindFreya()
    if freyaChar ~= nil then
      freyaChar:CallScript("ForceForwardSplineNavState")
    end
    local ltwStage = game.Level.GetVariable("FreyaLTWStage")
    if ltwStage < 40 and 0 < ltwStage then
      local FreyaLTW = game.FindLevel("FreyaLTW")
      if FreyaLTW ~= nil then
        FreyaLTW:CallScript("LTW_ToBridgePush_Start")
        GameObjects.UpperBridgeBoatDockR.LuaObjectScript.DisableAndClear()
        GameObjects.UpperBridgeBoatDockL.LuaObjectScript.DisableAndClear()
        GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.DisableElevators()
        hornElevatorManager.LuaObjectScript.DisableElevator()
      end
    end
    local Cal250lvl = game.FindLevel("Cal250_FootHillsLH")
    if Cal250lvl ~= nil then
      Cal250lvl:CallScript("CleanUpAfterFreyaEvent")
    end
    local FrontDoor_Level = game.FindLevel("Foot095_FrontDoor")
    if FrontDoor_Level ~= nil then
      FrontDoor_Level:CallScript("UnlockDoor")
    end
  end
end
function OpenVanaDoorB()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber == 440 then
    game.Audio.PlayBanter("020_KeepOurSecret", nil, nil, false)
  end
end
function FreyaLTWBridgeDone()
  GameObjects.UpperBridgeBoatDockR.LuaObjectScript.EnableAndRespawn()
  GameObjects.UpperBridgeBoatDockL.LuaObjectScript.EnableAndRespawn()
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.EnableElevators()
  hornElevatorManager.LuaObjectScript.EnableElevator()
  local doorObj = GameObjects.RealmTowerDoor_Mid:FindSingleGOByName("SpreadDoor_Caldera").Child
  doorObj.LuaObjectScript.Unlock()
end
function LoadCheck_Cal250()
  game.UI.LoadCheck("Cal250_FootHillsLH")
end
function BookmarkElevatorDown()
  GameObjects.Caldera_ArtSheet_RealmTower_Van:FindSingleGOByName("CalderaRealmTowerElevatorR").LuaObjectScript.JumpElevatorToBottom()
end
function FreyaCreateBridge()
  freyaBridgeCollision:Hide()
end
function SoundSmallBridgeCrystalFreyaHit()
  GameObjects.BifrostCrystalBridge.Child.LuaObjectScript.PlaySoundActivateCrystal()
end
function SwitchSmallBridgeOn()
  GameObjects.BifrostCrystalBridge.Child.LuaObjectScript.SetCrystalObjectStates(2)
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 183 <= cineNumber and cineNumber < 185 then
    return "AI_Visit_01"
  elseif 190 <= cineNumber and cineNumber < 200 then
    return "AI_Visit_02"
  elseif 250 <= cineNumber and cineNumber < 270 then
    return "AI_Visit_03"
  elseif game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") == true and game.Level.GetVariable("CAL_NAR_EyesOnThePrize") == false then
    return "EyesOnThePrize"
  else
    return nil
  end
end
local BridgePositionLoadGroupConfigs = {
  Midgard = "VanPos",
  Helheim = "HelPos",
  Jotunheim = "JotPos"
}
function OnEvaluateLoadGroup_LoadGroup_BridgeRight()
  return BridgePositionLoadGroupConfigs[LD.GetBridgePosition()]
end
function OnEvaluateLoadGroup_LoadGroup_BridgeLeft()
  return BridgePositionLoadGroupConfigs[LD.GetBridgePosition()]
end
function OnEvaluateLoadGroup_LoadGroup_Xpl()
  return BridgePositionLoadGroupConfigs[LD.GetBridgePosition()]
end
function ShopIntroLoadCheck()
  game.UI.LoadCheck("Cal100_AI_ShopIntro")
  game.UI.LoadCheck("Cal120_Airlock")
end
function TurnOffShopIntroLoadCheck()
  GameObjects.ShopIntroLoadCheck:Hide()
end
function BridgeTopLoadCheck()
  game.UI.LoadCheck("Cal110_BridgeTop")
end
function Cal120LoadCheck()
  game.UI.LoadCheck("Cal120_Airlock")
end
function ShopIntroOn()
  shopIntroLoad:ShowEntityVolume()
  midgardBridgeZone:HideEntityVolume()
  GameObjects.LoadActivateInterior:HideEntityVolume()
end
function ShopIntroOff()
  shopIntroLoad:HideEntityVolume()
  midgardBridgeZone:ShowEntityVolume()
  GameObjects.LoadActivateInterior:ShowEntityVolume()
end
function ShowSnakeCineVolume()
  snakeHornLoad:ShowEntityVolume()
end
function QuestTyrsVault()
  LD.CompleteQuest("Quest_StoneMason_Objective800")
end
function OpenChiselDoor1()
  LD.CompleteQuest("Quest_Caldera_Objective300")
  GameObjects.ChiselDoor_Hero2.LuaObjectScript.ImmediatelyDestroyDoor()
  GameObjects.Btr_Zone_Bridge_TyrSecrets:Hide()
end
function OpenChiselDoor2()
  LD.CompleteQuest("Quest_Caldera_Objective300")
  GameObjects.ChiselDoor_Hero1.LuaObjectScript.ImmediatelyDestroyDoor()
  GameObjects.Btr_Zone_Bridge_TyrSecrets:Hide()
end
function ChiselDoorOpen()
  if game.UI.LoadCheck("Cal590_RuneVaultElevator") ~= 0 then
    engine.Print("Cal590_Loaded")
  end
end
function ApproachingSnakesBelly()
  if player:IsInVehicle() then
    son:CallScript("EnterBehaviorContext", "BOAT_CONTEXT_CONFIG_LEFT")
  end
end
function LeavingSnakesBelly()
  son:CallScript("ClearBehaviorContext")
end
function HideOutside()
  GameObjects.TVBackwall:Hide()
  GameObjects.overlappingTempleRailing:HideCollision()
  GameObjects.TVTemple:Hide()
  GameObjects.TVSide01:Hide()
  GameObjects.TVSide02:Hide()
  GameObjects.TVRuneVaultHideCol:Show()
  GameObjects.TVBridgeHideCol:Show()
  insideRuneVault = true
end
function ShowOutside()
  GameObjects.TVBackwall:Show()
  GameObjects.TVTemple:Show()
  GameObjects.TVSide01:Show()
  GameObjects.TVSide02:Show()
  GameObjects.overlappingTempleRailing:ShowCollision()
  GameObjects.TVRuneVaultHideCol:Hide()
  GameObjects.TVBridgeHideCol:Hide()
  insideRuneVault = false
  GameObjects.LTW_Level01.LuaObjectScript.Enable()
  GameObjects.LTW_Level02.LuaObjectScript.Enable()
  DisableRVDoorSplines()
end
function Outside()
  if game.Level.GetVariable("CompletedCineNumber") ~= 430 then
    RuneVaultState = "Outside"
    TempleFlipState = "Outside"
    game.EvaluateLoadZones()
  end
end
function OnEvaluateLoadGroup_LoadGroup_RunevaultLight()
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    if RuneVaultState == "Inside" then
      return "RuneVaultInside"
    elseif RuneVaultState == "Outside" then
      return "RuneVaultOutside"
    else
      return "RuneVaultEntrance"
    end
  else
    return "Nothing"
  end
end
function OnEvaluateLoadGroup_LoadGroup_RuneVaultAvailable()
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    return "RuneVaultAvailable"
  else
    return "Nothing"
  end
end
function OnEvaluateLoadGroup_LoadGroup_RuneVaultAvailable_Hidden()
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    return "RuneVaultAvailable_Hidden"
  else
    return "Nothing"
  end
end
function SetupEnter1()
  GameObjects.LTW_Level01.LuaObjectScript.Disable()
  GameObjects.LTW_Level02.LuaObjectScript.Disable()
  RuneVaultState = "Entering1"
  game.EvaluateLoadZones()
  if game.UI.LoadCheck("Cal590_RuneVaultElevator") ~= 0 then
    bDoor1Opened = true
  else
    SetupRoom1()
  end
end
function SetupRoom1()
  bDoor1Opened = false
  EnableRVDoorSplines()
  GameObjects.RunevaultDoor1CA.LuaObjectScript.Enable()
  timers_LoadLibrary()
  if RuneVaultEnterTimers == nil then
    RuneVaultEnterTimers = {}
  end
  RuneVaultEnterTimers[#RuneVaultEnterTimers + 1] = timers.StartLevelTimer(1, HideOutside)
  RuneVaultEnterTimers[#RuneVaultEnterTimers + 1] = timers.StartLevelTimer(4, Door1SlamsBehind_Enter)
end
function SetupEnter2()
  GameObjects.LTW_Level01.LuaObjectScript.Disable()
  GameObjects.LTW_Level02.LuaObjectScript.Disable()
  RuneVaultState = "Entering2"
  game.EvaluateLoadZones()
  if game.UI.LoadCheck("Cal590_RuneVaultElevator") ~= 0 then
    bDoor2Opened = true
  else
    SetupRoom2()
  end
end
function SetupRoom2()
  bDoor2Opened = false
  EnableRVDoorSplines()
  GameObjects.RunevaultDoor2CA.LuaObjectScript.Enable()
  timers_LoadLibrary()
  if RuneVaultEnterTimers == nil then
    RuneVaultEnterTimers = {}
  end
  RuneVaultEnterTimers[#RuneVaultEnterTimers + 1] = timers.StartLevelTimer(1, HideOutside)
  RuneVaultEnterTimers[#RuneVaultEnterTimers + 1] = timers.StartLevelTimer(4, Door2SlamsBehind_Enter)
end
function EnableRVDoorSplines()
  GameObjects.RVLeadTheWay1.LuaObjectScript.Enable()
  GameObjects.RVLeadTheWay2.LuaObjectScript.Enable()
end
function DisableRVDoorSplines()
  GameObjects.RVLeadTheWay1.LuaObjectScript.Disable()
  GameObjects.RVLeadTheWay2.LuaObjectScript.Disable()
end
function Door1SlamsBehind_Enter()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 ~= nil then
    cal590:CallScript("SetupEnter1")
  end
  RuneVaultState = "Inside"
  game.EvaluateLoadZones()
  HideOutside()
end
function Door2SlamsBehind_Enter()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 ~= nil then
    cal590:CallScript("SetupEnter2")
  end
  RuneVaultState = "Inside"
  game.EvaluateLoadZones()
  HideOutside()
end
function RunevaultDoorFinished()
  if RuneVaultState == "Exiting" then
    RuneVaultState = "Outside"
    game.EvaluateLoadZones()
  end
end
function ExitElevatorRoom()
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("HideRuneVaultZones")
  end
  if RuneVaultEnterTimers ~= nil then
    for i, v in ipairs(RuneVaultEnterTimers) do
      v:Stop()
      RuneVaultEnterTimers[i] = nil
    end
    RuneVaultEnterTimers = nil
  end
  RuneVaultState = "Exiting"
  game.EvaluateLoadZones()
  game.UI.LoadCheck("Cal590_RuneVaultElevator")
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 ~= nil then
    cal590:CallScript("ExitElevatorRoom")
  end
  ShowOutside()
end
function OpenModiDoor()
  ShowOutside()
  GameObjects.TVBackwall:Hide()
  local door = GameObjects.ChiselDoor_Hero1:FindSingleGOByName("SpreadDoor")
  if door.IsRefNode then
    door = door.Child
  end
  door:StartAnim("DoorSpreadStayOpen")
  door.LuaObjectScript.Disable()
  RuneVaultState = "Exiting"
  game.EvaluateLoadZones()
end
function CloseModiDoor()
  local door = GameObjects.ChiselDoor_Hero1:FindSingleGOByName("SpreadDoor")
  GameObjects.TVBackwall:Show()
  if door.IsRefNode then
    door = door.Child
  end
  door.LuaObjectScript.ForceDoorClose()
  door:ShowCollision()
end
function KidInBoat()
  RuneVaultState = "Outside"
  game.EvaluateLoadZones()
end
function DisableBridgeSplines()
  GameObjects.LTW_Level01.LuaObjectScript.Disable()
end
function EnableBridgeSplines()
  GameObjects.LTW_Level01.LuaObjectScript.Enable()
end
function OpenMedallion()
  GameObjects.LoadInteriorMidgard:HideEntityVolume()
  GameObjects.LoadElevator_Runevault:ShowEntityVolume()
  GameObjects.MovingBridgeTop:FindSingleGOByName("Slices"):PlayAnimToEnd()
  GameObjects.ElevatorGuardRail:Show()
end
function CloseMedallion()
  GameObjects.MovingBridgeTop:Show()
  GameObjects.MovingBridgeTop:FindSingleGOByName("Slices"):PlayAnimationToEnd({Rate = -1})
  GameObjects.MovingBridgeTop:FindSingleGOByName("Slices"):OnAnimationDone(thisLevel, "HideElevator")
end
function ArrivedAtTop()
  RuneVaultState = "Outside"
  ShowOutside()
end
function HideElevator()
  GameObjects.ElevatorGuardRail:Hide()
  GameObjects.LoadElevator_Runevault:HideEntityVolume()
  GameObjects.LoadInteriorMidgard:ShowEntityVolume()
  midgardBridgeZone:ShowEntityVolume()
  timers_LoadLibrary()
  timers.StartLevelTimer(0.1, function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "23_RuneVault_080_RuneVaultExit"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
end
function HideHelTower(level)
  GameObjects.Caldera_ArtSheet_RealmTower_Hel:Hide()
end
function EnableSonSickBlockers()
  GameObjects.SonSickBlockersBridge:Show()
end
function DisableSonSickBlockers()
  GameObjects.SonSickBlockersBridge:Hide()
end
function SonSickEnableDocks()
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.EnableAndRespawn()
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.EnableDocking()
end
function SonSickDisableDocks()
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.DisableAndClear()
  GameObjects.LowerBridgeBoatDockR.LuaObjectScript.DisableDocking()
end
function TurnOffRightPitEdgeCollision()
  LD.CallFunctionAfterDelay(function()
    GameObjects.RightPitEdgeCollision:Hide()
  end, 2)
end
function OnEvaluateLoadGroup_LoadGroup_TempleFlipLight()
  if TempleFlipState == "Inside" then
    return "TempleFlipInside"
  elseif TempleFlipState == "Outside" then
    return "TempleFlipOutside"
  else
    return "TempleFlipEntrance"
  end
end
function ApproachTempleFlip()
  TempleFlipState = "Entering"
  game.EvaluateLoadZones()
end
function LeaveTempleFlip()
  TempleFlipState = "Outside"
  game.EvaluateLoadZones()
end
function EnterTempleFlip()
  LD.CompleteQuest("Quest_Caldera_Objective700")
  Cal140LoadCheck()
  if not bTempleFlipKeyUsed then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("010_FlipEntrance")
    end, 2)
    game.Compass.OnWarp()
    bTempleFlipKeyUsed = true
  end
  timers_LoadLibrary()
  timers.StartLevelTimer(4, TempleDoorClosed)
  timers.StartLevelTimer(0.2, function()
    local cal140 = game.FindLevel("Cal140_TempleExt")
    cal140:CallScript("EnterRedDoorOpen")
  end)
  GameObjects.PullSonIntoDoor.LuaObjectScript.Enable()
  GameObjects.PullSonOutDoor.LuaObjectScript.Disable()
end
function ExitTempleFlip()
  Cal140LoadCheck()
  TempleFlipState = "Exiting"
  game.EvaluateLoadZones()
  GameObjects.PullSonOutDoor.LuaObjectScript.Enable()
  local cal140 = game.FindLevel("Cal140_TempleExt")
  cal140:CallScript("ExitRedDoor")
  LD.CallFunctionAfterDelay(function()
    TempleDoorClosed()
  end, 4)
end
function TempleDoorClosed()
  if TempleFlipState == "Entering" then
    TempleFlipState = "Inside"
    game.EvaluateLoadZones()
    local cal140 = game.FindLevel("Cal140_TempleExt")
    cal140:CallScript("EnterRedDoorCloseBehind")
  elseif TempleFlipState == "Exiting" then
    TempleFlipState = "Entering"
    game.EvaluateLoadZones()
  end
end
function LeaveTempleFlipThroughTemple()
  TempleFlipState = "Outside"
  game.EvaluateLoadZones()
end
function Complete_FootHills_Obj500()
  LD.CompleteQuest("Quest_Foothills_Objective500")
  game.Compass.OnWarp()
end
function Complete_FootHills_Obj501()
  LD.CompleteQuest("Quest_Foothills_Objective501")
  game.Compass.SetDesignerForcedHide(false)
end
function Quest_Foothills_Objective050()
  LD.CompleteQuest("Quest_Foothills_Objective050")
end
function Quest_Started_Foothills_Objective025()
  LD.CallFunctionAfterDelay(function()
    LD.CompleteQuest("Quest_Foothills_Objective025")
  end, 4)
end
function Quest_Foothills_Objective025()
  LD.CompleteQuest("Quest_Foothills_Objective025")
end
function Quest_RiverPass_Objective955()
  LD.CompleteQuest("Quest_RiverPass_Objective955")
end
function Quest_Caldera_Objective605()
  LD.CompleteQuest("Quest_Caldera_Objective605")
end
function SoftSave()
  game.SubObject.SoftSave()
end
function RiverPass_Obj936()
  LD.CompleteQuest("Quest_RiverPass_Objective936")
  LD.SetRegionDiscovered("CalderaShores")
  LD.SetRegionDiscovered("CalderaShoresA")
  LD.SetRegionDiscovered("CalderaShoresB")
  LD.SetRegionDiscovered("CalderaShoresC")
  LD.SetRegionDiscovered("CalderaShoresD")
  LD.SetRegionDiscovered("CalderaShoresE")
  LD.SetRegionDiscovered("CalderaShoresF")
  LD.SetRegionDiscovered("CalderaShoresG")
  LD.SetRegionDiscovered("CalderaShoresH")
end
function EnableLeftBoostDrop()
  if son:IsInsideEntityZone(GameObjects.SonZoneLeft) then
    GameObjects.CA_SonBoostDrop_L01.LuaObjectScript.Enable()
    GameObjects.CA_SonBoostDrop_L02.LuaObjectScript.Enable()
  end
end
function EnableRightBoostDrop()
  if son:IsInsideEntityZone(GameObjects.SonZoneRight) then
    GameObjects.CA_SonBoostDrop_R01.LuaObjectScript.Enable()
    GameObjects.CA_SonBoostDrop_R02.LuaObjectScript.Enable()
  end
end
function UpdateTempleFlipDoor(selBridgePosition)
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 370 then
    return
  end
  if selBridgePosition == "Midgard" then
    UnlockChiselDoors()
  else
    LockChiselDoors()
  end
end
function BridgeAnimDone(selBridgePosition)
  if game.Level.GetVariable("CompletedCineNumber") >= 515 then
    jotumheimTowerICShouldHide = true
  end
  HideJotunheimTowerIC()
  PlayBridgeStopSound()
  UpdateWindPositions()
  UpdateTempleFlipDoor(selBridgePosition)
end
function SetBridgeAlignment()
  local selBridgePosition = LD.GetBridgePosition()
  local frame = LD.GetRealmFrame(selBridgePosition)
  local rate = LD.GetCorrectedBridgeAnimRate(bridge, selBridgePosition)
  if frame == 0 and bridge.AnimFrame > bridge.AnimLengthFrames / 2 then
    frame = bridge.AnimLengthFrames
  end
  if rate == 0 then
    SetBridgeAlignmentImmediate()
    BridgeAnimDone()
  else
    UpdateEncounterZoneLogic(selBridgePosition)
    bridge:PlayAnimToFrame(frame, rate)
    PlayBridgeStartSound()
    bridge:OnAnimationDone(thisLevel, "BridgeAnimDone", selBridgePosition)
  end
end
function SetBridgeAlignmentImmediate()
  local selBridgePosition = LD.GetBridgePosition()
  local frame = LD.GetRealmFrame(selBridgePosition)
  UpdateEncounterZoneLogic(selBridgePosition)
  bridge:StartAnim("rotate360")
  bridge:JumpAnimToFrame(frame)
  bridge:PauseAnim()
  UpdateTempleFlipDoor(selBridgePosition)
end
function UpdateEncounterZoneLogic(bridgePosition)
  GameObjects.EntZn_Vanaheim_Encounter_1_Start:ShowEntityVolume()
end
function Disable_All_Encounter_Zones()
  GameObjects.EntZn_Vanaheim_Encounter_1_Start:HideEntityVolume()
  GameObjects.EntZn_Vanaheim_Encounter_2_Start:HideEntityVolume()
  GameObjects.EntZn_Vanaheim_Encounter_3_Start:HideEntityVolume()
  GameObjects.EntZn_Vanaheim_Encounter_4_Start:HideEntityVolume()
  GameObjects.EntZn_Alfheim_Encounter_Start:HideEntityVolume()
  GameObjects.EntZn_Stonemason_Encounter_Start:HideEntityVolume()
  GameObjects.EntZn_Muspellheim_Encounter_Start:HideEntityVolume()
  GameObjects.EntZn_Svartalfheim_Encounter_Start:HideEntityVolume()
  GameObjects.EntZn_Asgard_Encounter_Start:HideEntityVolume()
  GameObjects.EntZn_Jotunnheim_Encounter_Start:HideEntityVolume()
end
function LowerWater_Level01()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.DisableLeftElevator()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg:FindSingleGOByName("CalderaRealmTowerElevatorL"):FindSingleGOByName("SwitchWallL1").LuaObjectScript.Disable()
end
function LowerWater_Level02()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.EnableLeftElevator()
  SoundSetup_AsgardElevatorsWaterLevel02()
  SoundSetup_SvartalfheimRightElevatorWaterLevel02()
  SoundSetup_MuspelheimRightElevatorWaterLevel02()
end
function OnHornElevator_MoveUp()
  hornElevator:HideNavObstacle()
end
function OnHornElevator_MoveDown()
  hornElevator:HideNavObstacle()
  GameObjects.CalderaHornInteractScript.LuaObjectScript.HornElevator_MoveDown()
end
function OnHornElevator_ReachTop()
  hornElevator:ShowNavObstacle()
  hornElevatorSwitch.LuaObjectScript.OverrideDefaultCameraYaw(true, GetHornElevatorSwitchYaw())
end
function OnHornElevator_ReachBottom()
  hornElevatorSwitch.LuaObjectScript.OverrideDefaultCameraYaw(true, GetHornElevatorSwitchYaw())
end
function EnableHornElevatorCA()
  GameObjects.Cal100Horn_ElevatorManager:FindSingleGOByName("MoveToPoint_Son").LuaObjectScript.Enable()
end
function WaitingAtElevatorCallback(elevatorState)
end
function OnWaitCompleteElevatorCallback(elevatorState)
end
function GetHornElevatorSwitchYaw()
  local hornSwitchYawTable = {
    Midgard = {Top = -89, Bottom = -128},
    Helheim = {Top = 89, Bottom = 1},
    Jotunheim = {Top = -55, Bottom = -80}
  }
  local bridgePostition = LD.GetBridgePosition()
  local elevatorState = hornElevatorManager.LuaObjectScript.GetState()
  if hornSwitchYawTable[bridgePostition] then
    return hornSwitchYawTable[bridgePostition][elevatorState]
  else
    return hornSwitchYawTable.Midgard[elevatorState]
  end
end
function OnSaveCheckpoint(level)
  local tab = {
    levelstate = checkpoint.Save(),
    jotumheimTowerICShouldHide = jotumheimTowerICShouldHide,
    bTempleFlipKeyUsed = bTempleFlipKeyUsed,
    RuneVaultState = RuneVaultState,
    TempleFlipState = TempleFlipState,
    insideRuneVault = insideRuneVault
  }
  return tab
end
function OnRestoreCheckpoint(level, tab)
  checkpoint.Restore(tab.levelstate)
  jotumheimTowerICShouldHide = tab.jotumheimTowerICShouldHide
  bTempleFlipKeyUsed = tab.bTempleFlipKeyUsed
  RuneVaultState = tab.RuneVaultState
  TempleFlipState = tab.TempleFlipState
  insideRuneVault = tab.insideRuneVault
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function ShowJotTower()
  GameObjects.JotunheimTowerCollision:Show()
  GameObjects.TVJotunheim_on:Show()
  GameObjects.TVJotunheim_off:Hide()
  local JotunRealmTower = GameObjects.Jotun:FindSingleGOByName("Caldera_ArtSheet_RealmTower_Jot")
  JotunRealmTower.LuaObjectScript.ShowElevators(true)
  JotunRealmTower.LuaObjectScript.UpdateWaterLv2Flags()
  SoundSetup_JotunheimElevatorsWaterLevel02(JotunRealmTower)
  GameObjects.RealmTowerRuneRead2Jotunheim.LuaObjectScript.SetRequiresCriticalBanterComplete()
  GameObjects.CO_BOOKMARK_32_Underworld_020_CalderaReturn:Hide()
  for _, obj in ipairs(jotTowerDocks) do
    obj.LuaObjectScript.EnableAndRespawn()
    obj.LuaObjectScript.EnableDocking()
  end
end
function HideJotTower()
  GameObjects.JotunheimTowerCollision:Hide()
  GameObjects.TVJotunheim_on:Hide()
  GameObjects.TVJotunheim_off:Show()
  GameObjects.Jotun:FindSingleGOByName("Caldera_ArtSheet_RealmTower_Jot").LuaObjectScript.ShowElevators(false)
  for _, obj in ipairs(jotTowerDocks) do
    obj.LuaObjectScript.DisableAndClear()
    obj.LuaObjectScript.DisableDocking()
  end
end
function HideJotunheimTowerIC()
  if jotumheimTowerICShouldHide then
    GameObjects.BridgeEndCollision:Hide()
  end
end
function ReturnFromRBR()
  if game.Level.GetVariable("_GBL_JotTowerRevealed") == false then
    LD.SetBridgePosition("Jotunheim", 0.5)
    timers_LoadLibrary()
    timers.StartLevelTimer(27, function()
      GameObjects.PlaytestTextUI_Jot_RbR:Show()
    end)
    local cal110 = game.FindLevel("Cal110_BridgeTop")
    if cal110 then
      cal110:CallScript("PlayBridgeAlignFx")
    end
    game.Level.SetVariable("CompletedCineNumber", 515)
    game.Level.SetVariable("_GBL_JotTowerRevealed", true)
    LD.SetMarkerState("CAL_200_DockPoint_Lower3", 1)
    ShowJotTower()
    local cal200 = game.FindLevel("Cal200_Shore")
    cal200:CallScript("ShowJotCliff")
    ExitFinale()
  end
end
function EndTowerObjective()
  if LD.GetBridgePosition() and bridge.AnimFrame == 0 then
    LD.CompleteQuest("Quest_Caldera_Objective745")
  end
end
function Cal140LoadCheck()
  game.UI.LoadCheck("Cal140_TempleExt", "Cal200_Shore", "Cal075_Lighting")
end
function StartPreCineCameraBridgeRepair()
  local CCEC = require("camera.camera_cineentercamera")
  cameraCineEnterBridgePush = CCEC.CineEnterCamera.New("ENV_CineEnter_BridgeRepair", 3, nil)
  cameraCineEnterBridgePush:Start()
end
function HideSnakePushCameraZone()
  GameObjects.CamZone_SnakePush:HideCameraVolume()
end
function ShowSnakePushCameraZone()
  GameObjects.CamZone_SnakePush:ShowCameraVolume()
end
function HideHengeDisruptionSprintCamera()
  GameObjects.CamZone_Peak800_SprintSequence:HideCameraVolume()
  print("Hide Camera Volume - Henge Run")
end
function ShowHengeDisruptionSprintCamera()
  GameObjects.CamZone_Peak800_SprintSequence:ShowCameraVolume()
  print("Show Camera Volume - Henge Run")
end
function Enable_ZipliftPocketRift()
  if game.Level.GetVariable("CompletedCineNumber") > 339 and GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.IsOpen() == false then
    GameObjects.misc_legendary_tier3_cal100_2.LuaObjectScript.InteractEnable()
  end
end
function Hide410Door()
  local Cal410 = game.FindLevel("Cal410_FinaleTowerFight")
  if Cal410 ~= nil then
    Cal410:CallScript("Hide410Door")
  end
end
local SNDWaterLevel, SNDBridgeWaterLevel
local waterLevelYOffset = 41
local bridgeEmitter, cal200
local asgardElevatorSoundOverride = {
  OnForward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnForward = 10,
  OnBackward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameTopFloor = 10
}
local realmTowerElevatorLV2SoundOverride = {
  OnForward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnForward = 10,
  OnBackward = "SND_MECH_Lift_Caldera_Hub_Bridge_LP",
  AnimFrameOnBackward = 150,
  AnimFrameTopFloor = 10,
  AnimFrameBottomFloor = 150
}
local bridgePushDrivenObjectSoundOverride = {
  UseExplicitSoundMotion = true,
  SoundEmitter = nil,
  OnForward = "SND_MECH_Caldera_Bridge_Rotate_LP",
  OnForwardFrame = -1
}
function SoundInit()
  SNDWaterLevel = GameObjects.SNDWaterLevel
  SNDBridgeWaterLevel = bridge:FindSingleGOByName("SNDWaterLevel_Bridge")
  bridgeEmitter = GameObjects.Sound:FindSingleSoundEmitterByName("SNDSerpentHorn")
  if cal200 == nil then
    cal200 = game.FindLevel("Cal200_Shore")
  end
  if cal200 ~= nil then
    cal200:CallScript("SetWaterLevelSoundPosition")
    print("called")
  end
end
function SoundOnStart()
  if LD.GetCurrentWaterLevel() >= 2 then
    SoundSetup_AsgardElevatorsWaterLevel02()
    SoundSetup_SvartalfheimRightElevatorWaterLevel02()
    SoundSetup_MuspelheimRightElevatorWaterLevel02()
    SoundSetup_JotunheimElevatorsWaterLevel02(GameObjects.Jotun:FindSingleGOByName("Caldera_ArtSheet_RealmTower_Jot"))
  end
end
function SoundSetup_AsgardElevatorsWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg:FindSingleGOByName("CalderaRealmTowerElevatorL"):FindSingleGOByName("BasicElevator_Manager").LuaObjectScript.SoundSetup(asgardElevatorSoundOverride)
  GameObjects.Caldera_ArtSheet_RealmTower_Asg:FindSingleGOByName("CalderaRealmTowerElevatorR"):FindSingleGOByName("BasicElevator_Manager").LuaObjectScript.SoundSetup(realmTowerElevatorLV2SoundOverride)
end
function SoundSetup_SvartalfheimRightElevatorWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Sva:FindSingleGOByName("CalderaRealmTowerElevatorR"):FindSingleGOByName("BasicElevator_Manager").LuaObjectScript.SoundSetup(realmTowerElevatorLV2SoundOverride)
end
function SoundSetup_MuspelheimRightElevatorWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Mus:FindSingleGOByName("CalderaRealmTowerElevatorR"):FindSingleGOByName("BasicElevator_Manager").LuaObjectScript.SoundSetup(realmTowerElevatorLV2SoundOverride)
end
function SoundSetup_JotunheimElevatorsWaterLevel02(jotTowerGO)
  jotTowerGO:FindSingleGOByName("CalderaRealmTowerElevatorL"):FindSingleGOByName("BasicElevator_Manager").LuaObjectScript.SoundSetup(realmTowerElevatorLV2SoundOverride)
end
function SoundSetup_BridgePushDrivenObject()
  bridgePushDrivenObjectSoundOverride.SoundEmitter = player:FindSingleSoundEmitterByName("SNDKratos")
  GameObjects.bridgeCrankHandle.LuaObjectScript.DrivenObjectSoundSetup(bridgePushDrivenObjectSoundOverride)
end
function SetWaterLevelSoundPositions(level, position)
  local origPos = SNDWaterLevel:GetWorldPosition()
  local origPosBridge = SNDBridgeWaterLevel:GetWorldPosition()
  local newYPos = position.y + waterLevelYOffset
  SNDWaterLevel:SetWorldPosition(engine.Vector.New(origPos.x, newYPos, origPos.z))
  SNDBridgeWaterLevel:SetWorldPosition(engine.Vector.New(origPosBridge.x, newYPos, origPosBridge.z))
end
function PlayBridgeStartSound()
  LD.PlaySound(bridgeEmitter, "SND_MECH_Caldera_Bridge_Rotate_LP")
end
function PlayBridgeStopSound()
  LD.StopSound(bridgeEmitter, "SND_MECH_Caldera_Bridge_Rotate_LP")
end
function ExitFinale()
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("HideFinaleZones")
  end
end
function Cal100_Bookmark_Ch5_PreBridgePush()
  FreyaCreateBridge()
  SwitchSmallBridgeOn()
end
function Cal100_Bookmark_Ch5_AfterBridgePush()
  GameObjects.BifrostCrystalBridge.Child.LuaObjectScript.SetCrystalObjectStates(2)
end
function Cal100_Bookmark_Ch11_AfterMumirHead()
  BookmarkElevatorDown()
end
function SerpentPushComplete()
  hornElevatorManager.LuaObjectScript.EnableElevator()
  serpentPushCollision:Hide()
end
function Horn_DisableElevator()
  hornElevatorManager.LuaObjectScript.DisableElevator()
end
function Horn_Disable()
  horn.LuaObjectScript.Disable()
end
function Horn_Enable()
  horn.LuaObjectScript.Enable()
end
function Complete_Quest_PeaksPass_Objective747()
  LD.CompleteQuest("Quest_PeaksPass_Objective747")
end
function Quest_Started_PeaksPassObjective_741()
  LD.CallFunctionAfterDelay(function()
    LD.CompleteQuest("Quest_PeaksPass_Objective741")
  end, 4)
end
function Complete_Quest_PeaksPass_Objective741()
  LD.CompleteQuest("Quest_PeaksPass_Objective741")
end
function SetElevators_WaterLv1()
  GameObjects.Caldera_ArtSheet_RealmTower_Alf.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Alf.LuaObjectScript.UpdateWaterLv1Flags()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.StartAtTopFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.DisableElevators()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.UpdateWaterLv1Flags(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Hel.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Hel.LuaObjectScript.UpdateWaterLv1Flags()
  GameObjects.Caldera_ArtSheet_RealmTower_Mus.LuaObjectScript.UpdateWaterLv1Flags(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Nid.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Nid.LuaObjectScript.UpdateWaterLv1Flags(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.StartAtTopFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.StartLocked()
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.UpdateWaterLv1Flags(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.StartLocked()
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.UpdateWaterLv1Flags()
end
function EnableMuspelheimTower_RightElevator()
  GameObjects.Caldera_ArtSheet_RealmTower_Mus.LuaObjectScript.EnableRightElevator()
  GameObjects.Caldera_ArtSheet_RealmTower_Mus.LuaObjectScript.UnlockElevators()
end
function SetElevators_WaterLv2()
  GameObjects.Caldera_ArtSheet_RealmTower_Alf.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Alf.LuaObjectScript.UpdateWaterLv2Flags()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.EnableElevators()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.MoveLeftToBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.StartLocked_Right()
  GameObjects.Caldera_ArtSheet_RealmTower_Asg.LuaObjectScript.UpdateWaterLv2Flags(true)
  SoundSetup_AsgardElevatorsWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Hel.LuaObjectScript.EnableRightElevator()
  GameObjects.Caldera_ArtSheet_RealmTower_Hel.LuaObjectScript.StartAtTopFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Hel.LuaObjectScript.UpdateWaterLv2Flags()
  GameObjects.Caldera_ArtSheet_RealmTower_Mus.LuaObjectScript.StartAtTopFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Mus.LuaObjectScript.UpdateWaterLv2Flags(true)
  SoundSetup_MuspelheimRightElevatorWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Nid.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Nid.LuaObjectScript.UpdateWaterLv2Flags(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.EnableRightElevator()
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.StartLocked_Right()
  GameObjects.Caldera_ArtSheet_RealmTower_Sva.LuaObjectScript.UpdateWaterLv2Flags(true)
  SoundSetup_SvartalfheimRightElevatorWaterLevel02()
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.UnlockElevators()
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.StartAtBottomFloor(true)
  GameObjects.Caldera_ArtSheet_RealmTower_Van.LuaObjectScript.UpdateWaterLv2Flags()
end
function SonSickEntityZone_Enter()
  local boat = game.Boat.GetPlayerBoat()
  if boat ~= nil then
    local data = {}
    data.Boat = boat
    data.MaxDistance = 25
    thisLevel:EnableBoatForceTurnAroundControlMode(data)
  end
end
function SonSickEntityZone_Exit()
  local boat = game.Boat.GetPlayerBoat()
  if boat ~= nil then
    local data = {}
    data.Boat = boat
    thisLevel:DisableBoatForceTurnAroundControlMode(data)
  end
end
function ShowDebugText(distance)
  if engine.IsDebug() then
    local debugText = "inside Runevault " .. ", " .. tostring(insideRuneVault)
    local position = player:GetWorldPosition()
    engine.DrawTextInWorld(position, debugText)
  end
end
function UpdateWindPositions()
  game.FX.UpdateEveryStaticWindPosition()
end
function Set_Encounter_Timer(timeRequirement, encounter)
  timers_LoadLibrary()
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, function()
    EventFailed_TimeElapsed(encounter)
  end)
  ecTimer:Stop()
end
function Start_Timer()
  local startDelay = 1
  Challenge_Started = true
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = ec_TimeRequirement % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function Encounter_Timer()
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = hudTimeRemaining % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37906, {minutes, seconds})
end
function EventFailed_TimeElapsed(encounter)
  local seconds = Rift_Challenge_Duration % 60
  local minutes = Rift_Challenge_Duration / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.DisableMechanicText()
  Cal100_combatScript.Despawn_Enemy_VFX(encounter)
  encounter:Reset()
  encounter:Stop()
  Cal100_combatScript.ResetRift_Callback(encounter)
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Event_Complete()
  uiCalls.DisableMechanicText()
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Despawn_Enemy_VFX(encounter)
  local minTime = 0.01
  local maxTime = 0.3
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies = encounter:GetActiveEnemies()
  for _, enemy in pairs(enemies) do
    if enemy ~= nil and enemy:IsDoingSyncMove() == false then
      timers.StartLevelTimer(randomFn(), function()
        if enemy ~= nil then
          SpawnFXAtCreatureLocation(enemy)
          enemy:Destroy()
        end
      end)
      CreatureInSyncMove_DelayDestruction(enemy)
    end
  end
  encounter:ResetLivingEnemiesCount()
  encounter:ReportWaveDespawned(nil)
end
function SpawnFXAtCreatureLocation(creature)
  local fx = game.FX.Spawn("Body_Fire_Explode", nil, {
    AutoDelete = true,
    EffectCreator = creature,
    Scale = 1.5
  })
  local lastEnemyPos = creature:GetWorldJointPosition(creature:GetJointIndex("JOPelvis1"))
  fx:SetWorldPosition(lastEnemyPos)
end
function CreatureInSyncMove_DelayDestruction(creature)
  delayDestruction = true
  delayDestruction_T[creature] = true
end
function UpdateCreatureDestruction()
  if delayDestruction == true then
    local remaining = 0
    for creature, _ in pairs(delayDestruction_T) do
      if creature ~= nil and delayDestruction_T[creature] == true then
        if creature:IsDoingSyncMove() == false then
          SpawnFXAtCreatureLocation(creature)
          creature:Destroy()
          delayDestruction_T[creature] = nil
        else
          remaining = remaining + 1
        end
      end
    end
    if remaining == 0 then
      delayDestruction = false
      delayDestruction_T = {}
    end
  end
end
