local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local cp = {}
local keyLockTempleDoor
function OnScriptLoaded(level, obj)
  keyLockTempleDoor = GameObjects.KeyLockTempleDoor
  cp.IsTempleDoorLocked = true
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  GameObjects.ZoneEvents_Cal10:Hide()
  GameObjects.BanterZone_JotunOffCrit.LuaObjectScript.Disable()
  GameObjects.BanterZone_120_IntoTheBelly_01.LuaObjectScript.Disable()
  GameObjects.EntZone_DisableBoatLore_InWad:Hide()
  GameObjects.BtrZone_Cal11_EnterMidgard.LuaObjectScript.Disable()
end
function OnSaveCheckpoint(level, obj)
  return cp
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  cp = savedInfo
end
function OnEnterBoat_Cal_Bridge_L()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  PlayBanter_HeadEnchantReminder(completedCineNum)
  if completedCineNum == 183 then
    game.Audio.PlayBanter("055_HelpingBrok", nil, nil, false)
  elseif CanPlayStonemasonDirections_01_02(completedCineNum) then
    PlayStonemasonDirections_01(completedCineNum)
  elseif Can020_TempleFlipOffCriticalPlay() then
    PlayTempleFlipOffCritical()
  end
end
function OnEnterBoat_Cal_Bridge_R()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  PlayBanter_HeadEnchantReminder(completedCineNum)
  if completedCineNum == 183 then
    game.Audio.PlayBanter("055_HelpingBrok", nil, nil, false)
  elseif CanPlayStonemasonDirections_01_02(completedCineNum) then
    PlayStonemasonDirections_02(completedCineNum)
  elseif Can020_TempleFlipOffCriticalPlay() then
    PlayTempleFlipOffCritical()
  end
end
function PlayAreYouSure()
  if game.Level.GetVariable("CompletedCineNumber") == 520 then
    game.Audio.PlayBanter("110_AreYouSure", nil, nil, false)
  end
end
function OnEnterBoat_RealmTower_Water1()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if completedCineNum == 183 then
    game.Audio.PlayBanter("055_HelpingBrok", nil, nil, false)
  end
end
function OnEnterBoat_RealmTower_Water2()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if Can020_TempleFlipOffCriticalPlay() then
    PlayTempleFlipOffCritical()
  end
end
function CanPlayStonemasonDirections_01_02(completedCineNum)
  return not cp.StoneMasonDirections and 340 <= completedCineNum and completedCineNum < 350
end
function PlayStonemasonDirections_01(completedCineNum)
  game.Audio.PlayBanter("060_StoneMasonDirections02")
  cp.StoneMasonDirections = true
end
function PlayStonemasonDirections_02(completedCineNum)
  game.Audio.PlayBanter("060_StoneMasonDirections01")
  cp.StoneMasonDirections = true
end
function OnEnterBoat_HelheimRealmTower_Right()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if CanPlayStonemasonDirections_01_02(completedCineNum) then
    PlayStonemasonDirections_02(completedCineNum)
  end
end
function PlayBanter_HeadEnchantReminder(completedCineNum)
  if not cp.HeadEnchantReminder and 320 <= completedCineNum and completedCineNum < 330 then
    game.Audio.PlayBanter("010_HeadEnchantReminder")
    cp.HeadEnchantReminder = true
  end
end
function Trigger_StairsToVault()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if 360 <= completedCineNum and completedCineNum <= 364 then
    GameObjects.Btr_Zone_030_VaultOffCritical1:Hide()
    GameObjects.Btr_Zone_030_VaultOffCritical2:Hide()
  end
end
function Trigger_VaultOffCritical()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if 360 <= completedCineNum and completedCineNum <= 364 then
    game.Audio.PlayBanter("030_VaultOffCritical")
    GameObjects.Btr_Zone_030_VaultOffCritical1:Hide()
    GameObjects.Btr_Zone_030_VaultOffCritical2:Hide()
    GameObjects.BanterZone_TyrVault.LuaObjectScript.Reset()
    GameObjects.Btr_Zone_040_StairsToVault:Hide()
    GameObjects.Btr_Zone_020_VaultChiselGoal_03:Hide()
  end
end
function Trigger_VaultChisel_01()
  GameObjects.Btr_Zone_020_VaultChiselGoal_03:Hide()
end
function Trigger_VaultChisel_03()
  GameObjects.Btr_Zone_020_VaultChiselGoal_01:Hide()
end
function BridgeElevatorSwitch_InteractStart()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 515 and game.Level.GetVariable("CAL_NAR_EyesOnThePrize") then
    MimirWarmup_Banter()
  end
end
function MimirWarmup_Banter()
  if not cp.MimirWarmup_Played then
    game.Audio.PlayBanter("080_MimirWarmup")
    cp.MimirWarmup_Played = true
  end
end
function EnableJotunheimOrBust()
  GameObjects.ZoneEvents_Cal10:Show()
end
function PlayJotunheimOrBust()
  timers.StartLevelTimer(7, function()
    game.Audio.PlayBanter("010_JotunheimOrBust")
  end)
  GameObjects.ZoneEvents_Cal10:Hide()
  GameObjects.ZoneEvents_JotunheimOrBust.LuaObjectScript.Disable()
end
function Can020_TempleFlipOffCriticalPlay()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 510 and game.QuestManager.GetQuestState("Quest_Caldera_Objective700") ~= "Complete"
end
function ApproachLockedFlipTempleDoor()
  local completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cp.IsTempleDoorLocked then
    keyLockTempleDoor.LuaObjectScript.EnableCinematicTrigger()
    if completedCineNumber == 510 then
      cp.IsTempleDoorLocked = false
      GameObjects.POI_TempleFlip_Unlock.LuaObjectScript.AttemptSeq()
    elseif not cp.firstAttemptAtTempleDoor then
      cp.firstAttemptAtTempleDoor = true
      if 499 < completedCineNumber and completedCineNumber < 510 then
        keyLockTempleDoor.LuaObjectScript.Disable()
        game.Audio.PlayBanter("055_TempleFlipDoor_2", function()
          keyLockTempleDoor.LuaObjectScript.Enable()
        end)
      elseif completedCineNumber < 500 then
        keyLockTempleDoor.LuaObjectScript.Disable()
        game.Audio.PlayBanter("055_TempleFlipDoor_1", function()
          keyLockTempleDoor.LuaObjectScript.Enable()
        end)
      end
    else
      keyLockTempleDoor.LuaObjectScript.Disable()
      game.Audio.PlayBanter("055_TempleFlipDoor_3", function()
        keyLockTempleDoor.LuaObjectScript.Enable()
      end)
    end
  end
end
function PlayTempleFlipOffCritical()
  game.Audio.PlayBanter("020_TempleFlipOffCritical", nil, nil, false)
  GameObjects.Zone_TempleOffCritical:Hide()
  GameObjects.ZoneEvents_TempleOffCrit_Btr.LuaObjectScript.Disable()
end
function Play010_EnteringMidgard11()
  local CanPlay010_EnteringMidgard11_02 = function()
    return game.Level.GetVariable("CompletedCineNumber") == 510 and cp.firstAttemptAtTempleDoor
  end
  local CanPlay010_EnteringMidgard11_03 = function()
    return game.Level.GetVariable("CompletedCineNumber") == 510 and not cp.firstAttemptAtTempleDoor
  end
  if not cp.PlayEnterMidgard11_2or3 then
    if CanPlay010_EnteringMidgard11_02() then
      game.Audio.PlayBanter("010_EnteringMidgard11_02", nil, nil, true, function()
        cp.PlayEnterMidgard11_2or3 = true
      end)
    elseif CanPlay010_EnteringMidgard11_03() then
      game.Audio.PlayBanter("010_EnteringMidgard11_03", nil, nil, true, function()
        cp.PlayEnterMidgard11_2or3 = true
      end)
    end
  end
end
function CanPlay_JotunheimOffCrit1()
  return game.Level.GetVariable("CompletedCineNumber") == 515 and game.Level.GetVariable("_GBL_JotTowerRevealed") == true and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") == false
end
function Enable_Btr_JotunOffCrit()
  GameObjects.BanterZone_JotunOffCrit.LuaObjectScript.Enable()
end
function Enable_Btr_SnakeOffCrit()
  GameObjects.BanterZone_120_IntoTheBelly_01.LuaObjectScript.Enable()
  GameObjects.EntZone_DisableBoatLore_InWad:Show()
end
function PlayerBoatsTowardsSnakeBelly()
  game.Audio.SetBanterFact("disableBoatLoreInWAD", true)
  game.Audio.SetBanterFact("selected_lore", -1)
end
function PlayerBoatsAwayFrom_IntoSnakesBelly()
  game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
end
function Cleanup_BanterModules()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if 340 < completedCineNum then
    GameObjects.BanterLookAt_SnakeWall2.LuaObjectScript.Disable()
    GameObjects.BanterLookAt_SnakeWall3.LuaObjectScript.Disable()
  end
end
local towardsVanaheimTower1 = false
local towardsVanaheimTower2 = false
function EnterTowardsVanTower2()
  if towardsVanaheimTower1 == true then
    towardsVanaheimTower2 = true
  else
    towardsVanaheimTower2 = false
  end
end
function EnterTowardsVanTower1()
  towardsVanaheimTower1 = true
end
function ExitTowardsVanTower1()
  towardsVanaheimTower1 = false
end
function CanPlayVanaheimConfusion01()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  local canPlayBanter = towardsVanaheimTower1 and towardsVanaheimTower2 and 340 <= cineNum and cineNum <= 360 and LD.GetBridgePosition() == "Midgard"
  if canPlayBanter == true then
    GameObjects.TowardsVanaheimTowerZone1:Hide()
    GameObjects.TowardsVanaheimTowerZone2:Hide()
  end
  return canPlayBanter
end
