local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, kraActor, freActor, arrowProp
local boolLingerHidden = false
local SEQ_STAGES = {
  NONE = 0,
  START = 1,
  BRIDGEPUSH = 2,
  DONE = 3
}
local seqState = SEQ_STAGES.NONE
local cameraCineEnter, cameraCineEnter2
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  SleepSelf()
end
local MakeCameras = function()
  local CCEC = require("camera.camera_cineentercamera")
  cameraCineEnter = CCEC.CineEnterCamera.New("PLYR_Nar_FreyaShootsArrow_010", 5.2, nil)
  cameraCineEnter2 = CCEC.CineEnterCamera.New("PLYR_Nar_FreyaShootsArrow_020", 2.4, nil)
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
  if cameraCineEnter2 ~= nil then
    cameraCineEnter2:Update()
  end
end
function OnStart(level, obj)
  SetupProps()
  local ltwStage = game.Level.GetVariable("FreyaLTWStage")
  if 30 <= ltwStage and ltwStage < 50 and seqState < SEQ_STAGES.DONE then
    CreateActors()
    BuildMagicBowstringSequence()
  end
end
function CreateActors()
  local actor = require("narrative.actor")
  kraActor = actor.Actor.New("MAGIC BOW STRING: KRATOS ACTOR", game.Player.FindPlayer)
  freActor = actor.Actor.New("MAGIC BOW STRING: FREYA ACTOR", LD.FindFreya)
end
function SetupProps()
  arrowProp = GameObjects.arrowProp.Child
  HideProps()
end
function HideProps()
  arrowProp:Hide()
end
function ShowProps()
  arrowProp:Show()
end
function BuildMagicBowstringSequence()
  local ND = require("design.NarrativeDesignLibrary")
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "Btr_MagicBowstring")
  local shootingActorTable = {
    {
      Obj = arrowProp,
      Anim = "poiCalMagicBowstring020CineScene"
    }
  }
  seq:Do(HideTempleTrackApproachZone)
  seq:WaitForFunctionTrue(FindFreya)
  if seqState == SEQ_STAGES.NONE then
    seq:WaitForActorInZone(freActor, thisObj)
    seq:Do(SetStartSeqState)
  else
    seq:Do(function()
      local freObj = ND.FindFreya()
      if freObj ~= nil then
        local objName = "Btr_MagicBowstring"
        local jointName = "MagicBowstring_SynchJoint"
        local spawnPosVector = LD.GetWorldJointPosition(objName, jointName)
        local spawnDirVector = LD.GetWorldJointForward(objName, jointName)
        freObj:Warp(spawnPosVector, spawnDirVector)
      end
    end)
  end
  seq:Do(DisableYouShallNotPass)
  seq:Do(DisableFreyaLTW)
  if seqState < SEQ_STAGES.BRIDGEPUSH then
    seq:ActorForceApproachAndWait(freActor, {
      Branch = "BRA_MagicBowstringEnter",
      ReferenceJoint = "MagicBowstring_SynchJoint",
      speed = ND.SonRunSpeed,
      radius = ND.RunArrivalRadius,
      stop = false,
      prevent_path_eval = true
    })
    seq:ActorSync(freActor, {
      Branch = "BRA_MagicBowstringEnter",
      ReferenceJoint = "MagicBowstring_SynchJoint"
    })
    seq:WaitForActorInZone(kraActor, "POIZone_MagicBowstring_Cine")
    seq:Do(function()
      GameObjects.Btr_MagicBowstringLinger:Hide()
      GameObjects.POIZone_MagicBowstring_Cine:Hide()
      boolLingerHidden = true
    end)
    seq:Do(StartEnterCamera)
    seq:StartPOIMoment(1.5)
    seq:Do(function()
      game.Audio.PlayBanter("MagicBowstring_FreyaFire")
    end)
    seq:WaitSeconds(2)
    seq:Do(ShowProps)
    seq:ActorSync(freActor, {
      Slaves = shootingActorTable,
      Branch = "BRA_MagicBowstringCine",
      ReferenceJoint = "MagicBowstring_SynchJoint"
    })
    seq:WaitSeconds(0.2)
    seq:WaitUntilActorAnimPastFrame(freActor, 90)
    seq:WaitUntilActorAnimPastFrame(freActor, 100)
    seq:Do(_G.SoundSmallBridgeCrystalFreyaHit)
    seq:WaitUntilActorAnimPastFrame(freActor, 115)
    seq:Do(_G.SwitchSmallBridgeOn)
    seq:WaitUntilActorAnimPastFrame(freActor, 120)
    seq:Do(function()
      cameraCineEnter2:Start()
    end)
    seq:WaitUntilActorAnimPastFrame(freActor, 150)
    seq:Do(LTW_ToBridgePush)
    seq:Do(_G.FreyaCreateBridge)
    seq:EndPOIMoment()
    seq:Do(function()
      game.Audio.PlayBanter("MagicBowstring_Solid", ShowTempleTrackApproachZone)
    end)
    seq:WaitForFunctionTrue(function()
      return freActor:GetCreature():IsPlayingMove("MOV_MagicBowstringPostIdle")
    end)
    seq:Do(HideProps)
    seq:Do(function()
      game.Player.FindPlayer():ClearMaxSpeedOverride()
    end)
    seq:Do(function()
      seqState = SEQ_STAGES.BRIDGEPUSH
    end)
  else
    seq:ActorSync(freActor, {
      Branch = "BRA_MagicBowstringBridgePushIdle",
      ReferenceJoint = "MagicBowstring_SynchJoint"
    })
  end
  seq:StopPuppetingActor(freActor)
  seq:WaitForActorFinishMove(freActor, "MOV_MagicBowstringExit")
  seq:Do(LTW_PushComplete)
  seq:Do(SleepSelf)
  seq:WaitForActorPlayingMove(freActor, "MOV_CartButtonIdle")
  seq:WaitSeconds(0.2)
  seq:Do(ResetFreyaCloth)
  seq:StartSequence()
end
function FindFreya()
  return LD.FindFreya()
end
function SetStartSeqState()
  if seqState == SEQ_STAGES.NONE then
    seqState = SEQ_STAGES.START
  end
end
function PlayBowstringBanter()
  game.Audio.PlayBanter("MagicBowstring")
end
function HideTempleTrackApproachZone()
  GameObjects.BtrComp_TempleTrack_Approach.LuaObjectScript.Disable()
end
function ShowTempleTrackApproachZone()
  GameObjects.BtrComp_TempleTrack_Approach.LuaObjectScript.Enable()
end
function StartEnterCamera()
  MakeCameras()
  cameraCineEnter:Start()
  game.SubObject.Wake(thisObj)
end
function CrankFinished()
  freActor:GetCreature():TriggerMoveEvent("LE_BridgePushFinished")
end
function SleepSelf()
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {seqState = seqState}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  seqState = savedInfo.seqState
end
function LingerBanter()
  if not boolLingerHidden then
    game.Audio.PlayBanter("MagicBowstring_Linger")
  end
end
function WarpFreyaAndLTW()
end
function DisableFreyaLTW()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("TurnOffFreyaLTW")
  end
end
function DisableSonLTW()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("TurnOffSonLTW")
  end
end
function DisableYouShallNotPass()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("TurnOffYSNP")
  end
end
function LTW_ToBridgePush()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("LTW_ToBridgePush")
  end
end
function LTW_PushComplete()
  seqState = SEQ_STAGES.DONE
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("BridgePushComplete")
  end
end
function ResetFreyaCloth()
  freActor:GetCreature():ResetCloth()
end
function StartMaxSpeedOverride()
  game.Player.FindPlayer():SetMaxSpeedOverride(1.5)
end
