local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, son, sonActor, bridgeCrank
local trackinteractbanter = false
local trackreleasebanter = false
local tracklingerbanter = false
local lingerTimer
local playingStorytime = false
local lingerSeq
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  bridgeCrank = GameObjects.bridgeCrankHandle.Child
  if 190 <= cineNum and cineNum < 195 then
    CreateActors()
  end
end
function CreateActors()
  sonActor = actor.Actor.New("BRIDGEPUSHBANTER SON IDLE: SON ACTOR", game.AI.FindSon)
end
function SetupSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "BridgePushBanter")
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_Enter01")
  end)
  seq:WaitSeconds(0.3)
  seq:Do(function()
    game.Audio.PlayBanter("TempleTrack_Attach")
  end)
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_TNF_01_Win")
  end)
  seq:Do(function()
    game.Audio.PlayBanter("TempleTrack_Retrack")
  end)
  seq:Do(SetupSonIdleSeq)
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_TNF_02_Win")
  end)
  seq:WaitSeconds(2)
  seq:Do(function()
    game.Audio.PlayBanter("TempleTrack_Realign")
  end)
  seq:WaitForFunctionTrue(function()
    return CrankPercentageGreaterThan(0.01)
  end)
  seq:Do(function()
    game.Audio.PlayBanter("TempleTrack_Interact", TempleTrackLingerSeq)
  end)
  seq:WaitForFunctionTrue(function()
    return CrankPercentageGreaterThan(0.42)
  end)
  seq:Do(PlayStoryBanter)
  seq:WaitForFunctionTrue(function()
    return CrankPercentageGreaterThan(0.75)
  end)
  seq:Do(function()
    if not playingStorytime then
      game.Audio.PlayBanter("TempleTrack_Encourage2")
    end
  end)
  seq:WaitForFunctionTrue(function()
    return CrankPercentageGreaterThan(0.9)
  end)
  seq:Do(function()
    if not playingStorytime then
      game.Audio.PlayBanter("TempleTrack_Encourage3")
    end
  end)
  seq:StartSequence()
end
function SetupSonIdleSeq()
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.TempleTrack_SonBridgeSit, "BridgePushBanter_SonSit")
  seq:Do(function()
    son:Warp(GameObjects.TempleTrack_SonBridgeSit:GetWorldPosition(), GameObjects.TempleTrack_SonBridgeSit:GetWorldForward())
  end)
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_TNF_02_Win")
  end)
  seq:ActorSync(sonActor, {
    Branch = "BRA_BridgeSitEnter",
    ReferenceJoint = "SonBridgeSit_SynchJoint"
  })
  seq:WaitForFunctionTrue(function()
    return CrankPercentageGreaterThan(0)
  end)
  seq:WaitForFunctionTrue(CrankFinished)
  seq:Do(function()
    son:GetCreature():TriggerMoveEvent("LE_BridgeSitExit")
  end)
  seq:WaitForFunctionTrue(function()
    return son:IsPlayingMove("MOV_BridgeSitExit")
  end)
  seq:WaitForFunctionTrue(function()
    return not son:IsPlayingMove("MOV_BridgeSitExit")
  end)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function CrankPercentageGreaterThan(checkPercent)
  local drivenAnimPercentage = bridgeCrank.LuaObjectScript:GetDrivenObjectAnimPercentage()
  return drivenAnimPercentage ~= nil and checkPercent <= drivenAnimPercentage
end
function CrankFinished()
  local drivenAnimPercentage = bridgeCrank.LuaObjectScript:GetDrivenObjectAnimPercentage()
  return drivenAnimPercentage == nil or 1 <= drivenAnimPercentage
end
function TempleTrackInteract()
  if trackinteractbanter == false then
    game.Audio.PlayBanter("TempleTrack_Interact")
    trackinteractbanter = true
  end
end
function TempleTrackRelease()
  if not CrankFinished() and not playingStorytime then
    if trackreleasebanter == false then
      game.Audio.PlayBanter("TempleTrack_Release")
      trackreleasebanter = true
      lingerTimer = timers.StartLevelTimer(15, TempleTrackLinger)
    else
      lingerTimer = timers.StartLevelTimer(10, TempleTrackLinger)
    end
  end
end
function TempleTrackLinger()
  if not tracklingerbanter and not playingStorytime then
    game.Audio.PlayBanter("TempleTrack_Linger")
    tracklingerbanter = true
    lingerTimer = nil
  end
end
function RestartTempleTrackLingerSeq()
  playingStorytime = false
  TempleTrackLingerSeq()
end
function TempleTrackLingerSeq()
  lingerSeq = LD.CreateCineSequence(thisLevel, thisObj, "BridgePushBanter_Linger")
  lingerSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_Idle01") or CrankFinished()
  end)
  lingerSeq:Do(TempleTrackRelease)
  lingerSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Cal100BridgePush_Forward01") or CrankFinished()
  end)
  lingerSeq:Do(EndLingerSeq)
  lingerSeq:StartSequence()
end
function PlayStoryBanter()
  game.Audio.PlayBanter("TempleTrack_Encourage1", RestartTempleTrackLingerSeq)
  playingStorytime = true
  if lingerSeq ~= nil then
    lingerSeq:Complete()
  end
  EndLingerSeq()
end
function EndLingerSeq()
  if lingerTimer ~= nil then
    lingerTimer:Stop()
    lingerTimer = nil
  end
  if not tracklingerbanter and not CrankFinished() then
    TempleTrackLingerSeq()
  end
end
