local LD = require("design.LevelDesignLibrary")
local hornInteract
function OnScriptLoaded(level, obj)
  hornInteract = GameObjects.HornInteractZone
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function DisableHornInteract()
  hornInteract.LuaObjectScript.Disable()
end
function EnableHornInteract()
  hornInteract.LuaObjectScript.Enable()
end
function PlayerInteractWithHorn()
  local cal215 = game.FindLevel("Cal215_SnakeHornCine1")
  local currentRealm = LD.GetCurrentRealm()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  local hornElevatorManager = GameObjects.Cal100Horn_ElevatorManager
  if LD.GetCurrentRealm() == "Midgard" and hornElevatorManager.LuaObjectScript.GetState() == "Top" then
    if cal215 ~= nil and 330 <= completedCineNum and completedCineNum < 340 then
      cal215:GetGameObject("Cine_SerpentTranslate"):CallScript("SetupCineSequence")
    elseif cal215 ~= nil and 515 <= completedCineNum and completedCineNum < 520 and game.Level.GetVariable("CAL_NAR_EyesOnThePrize") then
      cal215:GetGameObject("Cine_SnakeStatue"):CallScript("SetupCineSequence")
    elseif game.Audio.CanBanterConversationPlay("060_SerpentHorn") and 183 <= completedCineNum and completedCineNum < 340 then
      DisableHornInteract()
      game.Audio.PlayBanter("060_SerpentHorn", EnableHornInteract)
    elseif game.Audio.GetTimeSinceBanterPlayed() > 0 then
      if 183 <= completedCineNum and completedCineNum < 340 then
        DisableHornInteract()
        game.Audio.PlayBanter("999_SerpentHorn1", EnableHornInteract)
      elseif 340 <= completedCineNum and completedCineNum < 520 then
        DisableHornInteract()
        game.Audio.PlayBanter("999_SerpentHorn2", EnableHornInteract)
      elseif 520 <= completedCineNum and completedCineNum < 570 then
        DisableHornInteract()
        game.Audio.PlayBanter("999_SerpentHorn3", EnableHornInteract)
      elseif 570 <= completedCineNum then
        DisableHornInteract()
        game.Audio.PlayBanter("999_SerpentHorn4")
      end
    end
  end
  print("Fire son fail interact POI")
end
function HornElevator_MoveDown()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if completedCineNum == 520 then
    game.Audio.PlayBanter("090_BiggerBoat", nil, nil, false)
  end
end
