local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local delayTimers = require("level.timer")
local thisObj, thisLevel, Area_0_Encounter_1, Area_0_Encounter_2, Area_1_Encounter_1, Area_1_Encounter_3, Area_1_Encounter_4, Area_1_Encounter_5, Area_4_Encounter_1, Area_4_Encounter_2, Area_9_Encounter_1, Tower_2_Encounter_1, Tower_3_Encounter_1, Tower_5_Encounter_1, Tower_6_Encounter_1, Tower_6_Encounter_2, Tower_7_Encounter_1, Tower_7_Encounter_2
local dfQuest = false
local trackingEnemy, trackingMove, trackingEncounter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") < 184 then
    Area_1_Fight_1()
    Area_0_Fight_1()
    Area_0_Fight_2()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 184 then
    Area_1_Fight_3()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 290 then
    if game.GetNewGamePlus() then
      New_Game_Plus_Area_1_Fight_5()
    else
      Area_1_Fight_5()
    end
    Area_4_Fight_1()
    Area_4_Fight_2()
    Tower_5_Fight_1()
    Tower_6_Fight_1()
    Tower_7_Fight_1()
    Tower_7_Fight_2()
  end
  if game.GetNewGamePlus() then
    New_Game_Plus_Tower_2_Fight_1()
  else
    Tower_2_Fight_1()
  end
  if game.GetNewGamePlus() then
    New_Game_Plus_Tower_6_Fight_2()
  else
    Tower_6_Fight_2()
  end
  game.QuestManager.RegisterListener(obj, "Quest_UnfinishedBusiness04_Objective_01")
  Tower_3_Fight_1()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if game.GetNewGamePlus() then
    New_Game_Plus_Rift_Proj_Fight()
  else
    Rift_Proj_Fight()
  end
  if 330 <= cineNumber then
    GameObjects.LoadTowerStn:HideEntityVolume()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
local StartTravelerUpdate = function(enemy, move, encounter)
  trackingEnemy = enemy
  trackingMove = move
  trackingEncounter = encounter
  game.SubObject.Wake(thisObj)
end
local EndTravelerUpdate = function()
  game.SubObject.Sleep(thisObj)
  trackingEnemy = nil
  trackingMove = nil
  trackingEncounter = nil
end
function OnUpdate(level, obj)
  if trackingEnemy == nil then
    EndTravelerUpdate()
    return
  end
  if trackingEnemy:IsPlayingMove(trackingMove) then
    trackingEncounter:Start()
    EndTravelerUpdate()
  end
end
function CrawlerAttack()
  local completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 182 <= completedCineNumber and completedCineNumber < 184 then
    Area_0_Encounter_1:Start()
    Area_0_Encounter_2:Start()
    local Cal250_Level = game.FindLevel("Cal250_FootHillsLH")
    if Cal250_Level ~= nil then
      Cal250_Level:CallScript("Disable_Checkpoints")
      Cal250_Level:CallScript("PoisonTotem_DeathHint_DisableZone")
    end
  end
end
function Cal250_EnableCheckpoints()
  local Cal250_Level = game.FindLevel("Cal250_FootHillsLH")
  if Cal250_Level ~= nil then
    Cal250_Level:CallScript("Enable_Checkpoints")
    Cal250_Level:CallScript("PoisonTotem_DeathHint_EnableZone")
  end
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Bandits Attack Crawler", {
    CheckpointOnComplete = false,
    spawnWad = "Cal100_AI_01",
    LoadCheck = true,
    LeashZone = "LeashCal250"
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Bandit_Reaction_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.7
    },
    {
      spawners = "Bandit_Reaction_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.4
    }
  })
  Area_0_Encounter_1:OnComplete(Cal250_EnableCheckpoints)
  Area_0_Encounter_1:OnStart(function()
    game.Audio.SetBanterFact("Generic Death Cooldown", "True", 100)
  end)
  Area_0_Encounter_1:OnStart(function()
    game.Audio.PlayBanter("CrawlerReaction")
  end)
end
function Area_0_Fight_2()
  Area_0_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC: Crawler Intro Attack", {
    CheckpointOnComplete = false,
    spawnWad = "Cal100_AI_01",
    LoadCheck = true,
    LeashZone = "LeashCal250"
  })
  Area_0_Encounter_2:AddWave({
    {
      spawners = "Crawler_GrabBandit",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Crawler_RunAway",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_0_Encounter_2:AddWave({
    {
      spawners = "Bandit_Reaction_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_0_Encounter_2:OnStart(function()
    timers.StartLevelTimer(8, function()
      Area_0_Encounter_2:DespawnEnemies()
    end)
  end)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Vanaheim Cal100", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneCalBridgeVan",
    spawnWad = "Cal100_AI_01",
    LoadCheck = true
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Bandit00_Ambush_04",
      spawnCooldown = 0
    },
    {
      spawners = "Bandit00_Ambush_01",
      spawnLocators = "A1_B_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    },
    {
      spawners = "Bandit00_Ambush_03",
      spawnLocators = "A1_B_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.3
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit00_ClimbUp_02",
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Vanaheim_Encounter_1_Start, {
    cineRequirement = {182, 185}
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Vanaheim_Encounter_1_Alert)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Bandit")
    local cineNumber = game.Level.GetVariable("CompletedCineNumber")
    if 182 <= cineNumber and cineNumber <= 189 then
      LD.CallFunctionAfterDelay(function()
        game.Audio.PlayBanter("065_VanaheimTowerIntro", nil, nil, false)
      end, 1)
    end
  end)
  Area_1_Encounter_1:OnStart(SonAdvancedCombatTutorial)
end
function SonAdvancedCombatTutorial()
  if game.Level.GetVariable("TUT_ShowSonAggression") == true then
    LD.CallFunctionAfterDelay(function()
      local TUT = require("game.GlobalTutorials")
      TUT.SonTrip_Tutorial()
    end, 4)
    game.AI.FindSon():CallScript("LuaHook_EnableAutonomousSon")
    game.Level.SetVariable("TUT_ShowSonAggression", false)
  end
end
function Area_1_Fight_3()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Draugr Leg Intro Return from Alf", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneCalBridgeVan",
    spawnWad = "Cal100_AI_03",
    LoadCheck = false,
    StartMusic = "SND_",
    StopMusic = "SND_"
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Draugr_L3_L_EDGE",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "Draugr_L3_L_PATROL",
      spawnLocators = "A1_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_L3_SH_EDGE",
      spawnLocators = "A1_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_L2_L_SFG",
      spawnLocators = "A1_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_1_Encounter_3:OnEnemyDeath(function()
    Area_1_Encounter_3:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_Vanaheim_Encounter_4_Start, {
    cineRequirement = {262, 267}
  })
  Area_1_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Legs")
  end)
end
function Area_1_Fight_4()
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Alfheim Cal100", {CheckpointOnComplete = false, LoadCheck = false})
  Area_1_Encounter_4:AddWave({
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A1_O_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_2",
      spawnCooldown = 2
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_2",
      spawnCooldown = 3
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_4:SetStartZone(GameObjects.EntZn_Vanaheim_Encounter_2_Start)
end
function TurnOnMuspRiftMarker()
  LD.SetMarkerState("CAL_100_MuspTowerFight", 1)
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Muspellheim Cal100", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneMuspTower",
    StartMusic = "SND_MX_XPL970_tower_msp_fight_in",
    StopMusic = "SND_MX_XPL970_tower_msp_fight_out"
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Traveler_5_Basic",
      spawnLocators = "A4_T_Loc_1",
      useSpawnLocatorsOnly = true,
      markerID = "Traveler_Musp",
      spawnWad = "Cal100_AI_Tow_Mus",
      spawnCooldown = 0
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_Muspellheim_Start)
  Area_4_Encounter_1:SetAlertZone(GameObjects.EntZn_Muspellheim_Alert)
  Area_4_Encounter_1:OnEnemySpawn(function(enemy)
    StartTravelerUpdate(enemy, "MOV_RuneChargeUpSuccess", Area_4_Encounter_2)
  end)
  Area_4_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_MuspTowerFight", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Traveler")
    game.Level.SetVariable("CAL_TravelerMusp", true)
    EndTravelerUpdate()
  end)
end
function Area_4_Fight_2()
  Area_4_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Muspellheim Support Cal100", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneMuspTower"
  })
  Area_4_Encounter_2:AddWave({
    {
      spawners = "Flyer00_L4_RiftFire",
      spawnLocators = "A4_T_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Mus",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Flyer00_L4_RiftFire",
      spawnLocators = "A4_T_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Mus",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.6
    },
    {
      spawners = "Flyer00_L4_RiftFire",
      spawnLocators = "A4_T_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Mus",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
end
function TurnOffSvaTraveler()
  if LD.GetEntityVariable("CAL_TravelerSva") == false then
    GameObjects.traveler_lowRes3:Hide()
  end
end
function TurnOnSvaTraveler()
  if LD.GetEntityVariable("CAL_TravelerSva") == false then
    GameObjects.traveler_lowRes3:Show()
  end
end
function TurnOffAsgTraveler()
  if LD.GetEntityVariable("CAL_TravelerAsg") == false then
    GameObjects.traveler_lowRes2:Hide()
  end
end
function TurnOnAsgTraveler()
  if LD.GetEntityVariable("CAL_TravelerAsg") == false then
    GameObjects.traveler_lowRes2:Show()
  end
end
function TurnOffMuspTraveler()
  GameObjects.traveler_lowRes1:Hide()
end
function TurnOnMuspTraveler()
  if LD.GetEntityVariable("CAL_TravelerMusp") == false then
    GameObjects.traveler_lowRes1:Show()
  end
end
function StartFightRiftAlfTower()
  timers.StartLevelTimer(2, function()
    Tower_2_Encounter_1:Start()
  end)
  timers.StartLevelTimer(9, function()
    GameObjects.LootPocketRiftAlf.LuaObjectScript.SpawningDone()
  end)
end
function StopFightRiftAlfTower()
  GameObjects.LootPocketRiftAlf.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnRiftAlfTower()
  GameObjects.LootPocketRiftAlf.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOnAlfRiftMarker()
  LD.SetMarkerState("CAL_100_AlfTowerFight", 1)
end
function Tower_2_Fight_1()
  Tower_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Alfheim Tower Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL_tower_alf_fight_in",
    StopMusic = "SND_MX_XPL_tower_alf_fight_out"
  })
  Tower_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_L4_L_SFG",
      spawnLocators = "A2_T_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L4_L_SFG",
      spawnLocators = "A2_T_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 1
    },
    {
      spawners = "H_Draugr_L4_SFG",
      spawnLocators = "A2_T_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 2
    }
  })
  Tower_2_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnRiftAlfTower)
  Tower_2_Encounter_1:OnComplete(function()
    StopFightRiftAlfTower()
    LD.SetMarkerState("CAL_100_AlfTowerFight", 0)
  end)
end
function New_Game_Plus_Tower_2_Fight_1()
  Tower_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 NPlus Alfheim Tower Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL_tower_alf_fight_in",
    StopMusic = "SND_MX_XPL_tower_alf_fight_out"
  })
  Tower_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_L4_L_SFG",
      spawnLocators = "A2_T_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L4_L_SFG",
      spawnLocators = "A2_T_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 1
    },
    {
      spawners = "H_Draugr_L4_SFG",
      spawnLocators = "A2_T_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Alf",
      spawnCooldown = 2
    }
  })
  Tower_2_Encounter_1:OnStart(function()
    _G.Set_Encounter_Timer(60, Tower_2_Encounter_1)
    _G.Start_Timer()
  end)
  Tower_2_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnRiftAlfTower)
  Tower_2_Encounter_1:OnComplete(function()
    _G.Event_Complete()
  end)
  Tower_2_Encounter_1:OnComplete(function()
    StopFightRiftAlfTower()
    LD.SetMarkerState("CAL_100_AlfTowerFight", 0)
  end)
end
function Tower_3_Fight_1()
  Tower_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Stonemason Tower Helwalker Fanatic", {CheckpointOnComplete = true, LoadCheck = false})
  Tower_3_Encounter_1:AddWave({
    {
      spawners = "Bandit00_3_RISING01",
      spawnLocators = "A3_T_Loc_1",
      useSpawnLocatorsOnly = true,
      markerID = "RisingRitual1",
      spawnWad = "Cal100_AI_Tow_Stn",
      spawnCooldown = 0
    },
    {
      spawners = "Bandit00_3_RISING02",
      spawnLocators = "A3_T_Loc_4",
      useSpawnLocatorsOnly = true,
      markerID = "RisingRitual2",
      spawnWad = "Cal100_AI_Tow_Stn",
      spawnCooldown = 0.3
    },
    {
      spawners = "Fanatic00_PRAY",
      spawnLocators = "A3_T_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Stn",
      spawnCooldown = 0.1
    },
    {
      spawners = "Fanatic00_PRAY",
      spawnLocators = "A3_T_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal100_AI_Tow_Stn",
      spawnCooldown = 1
    }
  })
  Tower_3_Encounter_1:SetStartZone(GameObjects.EntZn_Stonemason_Tower_Start)
  Tower_3_Encounter_1:OnEnemySpawn(function()
    timers.StartLevelTimer(1, function()
      Tower_3_Encounter_1:AlertEnemies()
    end)
  end, {
    markerID = "RisingRitual1"
  })
  Tower_3_Encounter_1:OnEnemySpawn(function()
    timers.StartLevelTimer(2, function()
      Tower_3_Encounter_1:AlertEnemies()
    end)
  end, {
    markerID = "RisingRitual2"
  })
  Tower_3_Encounter_1:SetAlertZone(GameObjects.EntZn_Stonemason_Tower_Alert_1)
end
function Tower_5_Fight_1()
  Tower_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Svartalheim Tower", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneSvaTower",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL_tower_sva_fight_in",
    StopMusic = "SND_MX_XPL_tower_sva_fight_out"
  })
  Tower_5_Encounter_1:AddWave({
    {
      spawners = "Traveler_4_Turtle",
      spawnLocators = "A5_T_Loc_1",
      useSpawnLocatorsOnly = true,
      markerID = "Traveler_Svartalheim",
      spawnWad = "Cal100_AI_Tow_Sva",
      spawnCooldown = 0
    }
  })
  Tower_5_Encounter_1:SetStartZone(GameObjects.EntZn_Svartalheim_Tower_Start)
  Tower_5_Encounter_1:SetAlertZone(GameObjects.EntZn_Svartalheim_Tower_Alert)
  Tower_5_Encounter_1:OnStart(function()
    LD.SetMarkerState("CAL_100_SvartaTowerFight", 1)
  end)
  Tower_5_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_SvartaTowerFight", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Traveler_Champion")
    game.Level.SetVariable("CAL_TravelerSva", true)
  end)
end
function Handle_Quest_Active(level, obj, questName, parentQuestName)
  if questName ~= "" then
    timers.StartLevelTimer(0.5, function()
      game.Level.SetVariable("CAL_DeadFreightEncounters", true)
    end)
    timers.StartLevelTimer(1, function()
      game.World.StoreCheckpoint()
    end)
    game.QuestManager.UnregisterListener(obj, questName)
  end
end
function NidTower_DF_TurnOnZones()
  if LD.GetEntityVariable("CAL_DeadFreightEncounters") == true and dfQuest == false then
    dfQuest = true
    GameObjects.EntZn_Nidavellir_Tower_Start:ShowEntityVolume()
    GameObjects.Alert_DeadFreight_Zone:ShowEntityVolume()
  end
end
function Tower_6_Fight_1_Complete()
  game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness04_Objective_01", 1)
  LD.CompleteQuest("Quest_UnfinishedBusiness04_Objective_01_SpotA")
  _G.StartLevelTimer(2, QuestBanter)
end
function QuestBanter()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness04_Objective_01")
  if progress == 1 then
    game.Audio.PlayBanter("UB4_DF_FirstBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 2 then
    game.Audio.PlayBanter("UB4_DF_SecondBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 3 then
    game.Audio.PlayBanter("UB4_DF_ThirdBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Return")
  end
end
function Tower_6_Fight_1()
  Tower_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Nidavellir Tower Bandit Dogpile", {CheckpointOnComplete = true, LoadCheck = false})
  Tower_6_Encounter_1:AddWave({
    {
      spawners = "Helwalker_Inspect",
      spawnWad = "Cal100_AI_Tow_Nid",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_Cautious",
      spawnWad = "Cal100_AI_Tow_Nid",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_Kneel",
      spawnWad = "Cal100_AI_Tow_Nid",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Tower_6_Encounter_1:SetStartZone(GameObjects.EntZn_Nidavellir_Tower_Start)
  Tower_6_Encounter_1:OnComplete(Tower_6_Fight_1_Complete)
end
function StartFightRiftNidTower()
  timers.StartLevelTimer(2, function()
    Tower_6_Encounter_2:Start()
  end)
  timers.StartLevelTimer(9, function()
    GameObjects.LootPocketRiftNid.LuaObjectScript.SpawningDone()
  end)
end
function StopFightRiftNidTower()
  GameObjects.LootPocketRiftNid.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnRiftNidTower()
  GameObjects.LootPocketRiftNid.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOnNidRiftMarker()
  LD.SetMarkerState("CAL_100_NidTowerFight", 1)
end
function Tower_6_Fight_2()
  Tower_6_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Nidavellir Tower Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL_tower_nif_fight_in",
    StopMusic = "SND_MX_XPL_tower_nif_fight_out"
  })
  Tower_6_Encounter_2:AddWave({
    {
      spawners = "Draugr_6_Heavy_Rift",
      spawnWad = "Cal100_AI_Tow_Nid",
      spawnLocators = "A6_T_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_6_Heavy_Rift",
      spawnWad = "Cal100_AI_Tow_Nid",
      spawnLocators = "A6_T_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Tower_6_Encounter_2:OnEnemySpawn(PlaySoundEnemySpawnRiftNidTower)
  Tower_6_Encounter_2:OnComplete(StopFightRiftNidTower)
  Tower_6_Encounter_2:OnComplete(function()
    LD.SetMarkerState("CAL_100_NidTowerFight", 0)
  end)
end
function New_Game_Plus_Tower_6_Fight_2()
  Tower_6_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 NPlus Nidavellir Tower Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL_tower_nif_fight_in",
    StopMusic = "SND_MX_XPL_tower_nif_fight_out"
  })
  Tower_6_Encounter_2:AddWave({
    {
      spawners = "Draugr_6_Heavy_Rift",
      spawnWad = "Cal100_AI_Tow_Nid",
      spawnLocators = "A6_T_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_6_Heavy_Rift",
      spawnWad = "Cal100_AI_Tow_Nid",
      spawnLocators = "A6_T_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Tower_6_Encounter_2:OnStart(function()
    _G.Set_Encounter_Timer(60, Tower_6_Encounter_2)
    _G.Start_Timer()
  end)
  Tower_6_Encounter_2:OnEnemySpawn(PlaySoundEnemySpawnRiftNidTower)
  Tower_6_Encounter_2:OnComplete(StopFightRiftNidTower)
  Tower_6_Encounter_2:OnComplete(function()
    _G.Event_Complete()
  end)
  Tower_6_Encounter_2:OnComplete(function()
    LD.SetMarkerState("CAL_100_NidTowerFight", 0)
  end)
end
function StartFightRiftAsgard()
  timers.StartLevelTimer(2, function()
    Tower_7_Encounter_1:Start()
  end)
  timers.StartLevelTimer(6, function()
    GameObjects.LootPocketRiftAsg.LuaObjectScript.SpawningDone()
  end)
end
function StopFightRiftAsgard()
  GameObjects.LootPocketRiftAsg.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnRiftAsgard()
  GameObjects.LootPocketRiftAsg.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function Tower_7_Fight_1()
  Tower_7_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Asgard Tower", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneAsgTower",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL910_tower_fight_in",
    StopMusic = "SND_MX_XPL910_tower_fight_out"
  })
  Tower_7_Encounter_1:AddWave({
    {
      spawners = "Traveler_7_Hel",
      spawnLocators = "A7_T_Loc_1",
      useSpawnLocatorsOnly = true,
      markerID = "Traveler_Asgard",
      spawnWad = "Cal100_AI_Tow_Asg",
      spawnCooldown = 0
    }
  })
  Tower_7_Encounter_1:SetStartZone(GameObjects.EntZn_Asgard_Tower_Start)
  Tower_7_Encounter_1:SetAlertZone(GameObjects.EntZn_Asgard_Tower_Alert)
  Tower_7_Encounter_1:OnStart(function()
    LD.SetMarkerState("CAL_100_AsgardTowerFight", 1)
  end)
  Tower_7_Encounter_1:OnEnemySpawn(function(enemy)
    StartTravelerUpdate(enemy, "MOV_RuneChargeUpSuccess3", Tower_7_Encounter_2)
  end)
  Tower_7_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_AsgardTowerFight", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Traveler")
    game.Level.SetVariable("CAL_TravelerAsg", true)
    EndTravelerUpdate()
  end)
end
function Tower_7_Fight_2()
  Tower_7_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:4 Asgard Tower Support", {CheckpointOnComplete = false})
  Tower_7_Encounter_2:AddWave({
    {
      spawners = "ProjectionsRise",
      spawnLocators = "A7_T_Loc_2",
      spawnWad = "Cal100_AI_Tow_Asg",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "ProjectionsRise",
      spawnLocators = "A7_T_Loc_3",
      spawnWad = "Cal100_AI_Tow_Asg",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "ProjectionsRise",
      spawnLocators = "A7_T_Loc_4",
      spawnWad = "Cal100_AI_Tow_Asg",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    }
  })
end
function StartFightRift940()
  timers.StartLevelTimer(2, function()
    Area_9_Encounter_1:Start()
  end)
  timers.StartLevelTimer(11, function()
    GameObjects.LootPocketRift940.LuaObjectScript.SpawningDone()
  end)
end
function StopFightRift940()
  GameObjects.LootPocketRift940.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnRift940()
  GameObjects.LootPocketRift940.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOnCaveRiftMarker()
  LD.SetMarkerState("CAL_100_BeachCaveFight", 1)
end
function Rift_Proj_Fight()
  Area_9_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Rift Challenge Wulver Xpl940", {
    CheckpointOnComplete = true,
    spawnWad = "Cal100_AI_Tow_Sva",
    StartMusic = "SND_MX_XPL_tower_sva_rift_fight_in",
    StopMusic = "SND_MX_XPL_tower_sva_rift_fight_out"
  })
  Area_9_Encounter_1:AddWave({
    {
      spawners = "WulverRiftSpawn_Power",
      spawnLocators = "A1_F_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "WulverRiftSpawn_Speed",
      spawnLocators = "A1_F_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_9_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnRift940)
  Area_9_Encounter_1:OnComplete(function()
    StopFightRift940()
    LD.SetMarkerState("CAL_100_BeachCaveFight", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
  end)
end
function New_Game_Plus_Rift_Proj_Fight()
  Area_9_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 NPlus Rift Challenge Wulver Xpl940", {
    CheckpointOnComplete = true,
    spawnWad = "Cal100_AI_Tow_Sva",
    StartMusic = "SND_MX_XPL_tower_sva_rift_fight_in",
    StopMusic = "SND_MX_XPL_tower_sva_rift_fight_out"
  })
  Area_9_Encounter_1:AddWave({
    {
      spawners = "WulverRiftSpawn_Power",
      spawnLocators = "A1_F_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "WulverRiftSpawn_Speed",
      spawnLocators = "A1_F_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_9_Encounter_1:OnStart(function()
    _G.Set_Encounter_Timer(60, Area_9_Encounter_1)
    _G.Start_Timer()
  end)
  Area_9_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnRift940)
  Area_9_Encounter_1:OnComplete(function()
    _G.Event_Complete()
  end)
  Area_9_Encounter_1:OnComplete(function()
    StopFightRift940()
    LD.SetMarkerState("CAL_100_BeachCaveFight", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
  end)
end
function TurnOnDragonRiftMarker()
  LD.SetMarkerState("CAL_100_MasonCaveFight", 1)
end
function Area_1_Fight_5()
  Area_1_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Mason Cave Pocket Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL650_rift_fight_in",
    StopMusic = "SND_MX_XPL650_rift_fight_out"
  })
  Area_1_Encounter_5:AddWave({
    {
      spawners = "BRA_6_RAISE",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 0
    },
    {
      spawners = "Hel_6_SPRINT",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 2
    },
    {
      spawners = "Hel_6_SHIELD",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 2.5
    }
  })
  Area_1_Encounter_5:OnEnemySpawn(PlaySoundEnemySpawnRiftMasonCave)
  Area_1_Encounter_5:OnComplete(function()
    StopFightRiftMasonCave()
    LD.SetMarkerState("CAL_100_MasonCaveFight", 0)
  end)
end
function New_Game_Plus_Area_1_Fight_5()
  Area_1_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 NPlus Mason Cave Pocket Rift", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL650_rift_fight_in",
    StopMusic = "SND_MX_XPL650_rift_fight_out"
  })
  Area_1_Encounter_5:AddWave({
    {
      spawners = "BRA_6_RAISE",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 0
    },
    {
      spawners = "Hel_6_SPRINT",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 2
    },
    {
      spawners = "Hel_6_SHIELD",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 2.2
    },
    {
      spawners = "Hel_6_SHIELD",
      spawnWad = "Xpl650_AI_02",
      spawnCooldown = 3.8
    }
  })
  Area_1_Encounter_5:OnStart(function()
    _G.Set_Encounter_Timer(60, Area_1_Encounter_5)
    _G.Start_Timer()
  end)
  Area_1_Encounter_5:OnEnemySpawn(PlaySoundEnemySpawnRiftMasonCave)
  Area_1_Encounter_5:OnComplete(function()
    StopFightRiftMasonCave()
    _G.Event_Complete()
    LD.SetMarkerState("CAL_100_MasonCaveFight", 0)
  end)
end
function StartFightRiftMasonCave()
  timers.StartLevelTimer(1, function()
    Area_1_Encounter_5:Start()
  end)
  timers.StartLevelTimer(3, function()
    GameObjects.LootPocketRiftDragon.LuaObjectScript.SpawningDone()
    GameObjects.RiftCollision650:HideCollision()
  end)
end
function StopFightRiftMasonCave()
  GameObjects.LootPocketRiftDragon.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnRiftMasonCave()
  GameObjects.LootPocketRiftDragon.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function ResetRift_Callback(encounter)
  if encounter == nil then
    return
  end
  if Area_1_Encounter_5 ~= nil and encounter.Name == Area_1_Encounter_5.Name then
    GameObjects.LootPocketRiftDragon.LuaObjectScript.ResetCombatState()
  elseif Tower_6_Encounter_2 ~= nil and encounter.Name == Tower_6_Encounter_2.Name then
    GameObjects.LootPocketRiftNid.LuaObjectScript.ResetCombatState()
  elseif Tower_2_Encounter_1 ~= nil and encounter.Name == Tower_2_Encounter_1.Name then
    GameObjects.LootPocketRiftAlf.LuaObjectScript.ResetCombatState()
  elseif Area_9_Encounter_1 ~= nil and encounter.Name == Area_9_Encounter_1.Name then
    GameObjects.LootPocketRift940.LuaObjectScript.ResetCombatState()
  end
end
