local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local CCOS = require("camera.camera_oneshot")
local thisObj, TowerFXObj, cameraOneShotBoatHack, cameraOneShotObjectTempleVista
local isFirstFlickerInBoat = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  TowerFXObj = obj:FindSingleGOByName("RT_fx").Child
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  TowerFXObj:JumpAnimToFrame(313)
  ShowTowerFX()
end
function OnUpdate(level, obj)
  if cameraOneShotBoatHack ~= nil then
    cameraOneShotBoatHack:Update()
  end
  if cameraOneShotObjectTempleVista ~= nil then
    cameraOneShotObjectTempleVista:Update()
  end
end
function PlayFlicker()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if 360 <= completedCineNum then
    PlaySecondFlicker()
  else
    PlayTowerVanishSound()
    PlayAnim()
  end
end
function PlayAnim()
  TowerFXObj:JumpAnimToFrame(0)
  TowerFXObj:PlayAnimationToEnd()
end
function PlayCamera()
  game.SubObject.Wake(thisObj)
  cameraOneShotBoatHack = CCOS.OneShotCamera.New("PLYR_Boat_Forward_Open_Override", 8, nil)
  cameraOneShotBoatHack:Start()
  cameraOneShotBoatHack:SetCallback(DestroyCamera)
  timers.StartLevelTimer(1, function()
    cameraOneShotObjectTempleVista = CCOS.OneShotCamera.New("PLYR_Boat_Vista_JotTower", 5, nil)
    cameraOneShotObjectTempleVista:Start()
  end)
end
function PlaySonPointing()
  local son = game.AI.FindSon()
  local sonPupp = game.Puppeteer.NewForce(thisObj, "POI_SonBoatLookJotTower", son)
  sonPupp:StartMove("MOV_SonBoatLookJotTower")
  sonPupp:OnComplete(function()
    sonPupp = nil
  end)
end
function PlaySecondFlicker()
  PlayTowerVanishSound()
  PlayAnim()
  if game.Boat.GetPlayerBoat() and not isFirstFlickerInBoat then
    timers.StartLevelTimer(1, PlaySonPointing)
    timers.StartLevelTimer(2.25, PlayCamera)
    isFirstFlickerInBoat = true
  end
  timers.StartLevelTimer(0.3, PlayAnim)
end
function HideTowerFX()
  TowerFXObj:Hide()
end
function ShowTowerFX()
  TowerFXObj:Show()
end
function IsBoatFacingTower()
  local boatFOV = 90
  local boat = game.Boat.GetPlayerBoat()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if boat and 360 <= completedCineNum and completedCineNum < 512 then
    local vectorToBoat = (thisObj:FindSingleGOByName("BanterLookAt_JotunheimRT"):GetWorldPosition() - boat:GetWorldPosition()):Normalized()
    local boatDirection = boat:GetWorldForward():Normalized()
    local angle = math.deg(math.acos(vectorToBoat:Dot(boatDirection)))
    print("boatDirection: ", boatDirection, " vectorToBoat: ", vectorToBoat, " angle: ", angle, " boatFOV: ", boatFOV, " isInRange: ", angle <= boatFOV / 2)
    return angle <= boatFOV / 2
  else
    return false
  end
end
function OnSaveCheckpoint(level, obj)
  return {isFirstFlickerInBoat = isFirstFlickerInBoat}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  isFirstFlickerInBoat = savedInfo.isFirstFlickerInBoat or false
end
local towerEmitter
function SoundInit()
  towerEmitter = thisObj:FindSingleSoundEmitterByName("SNDJotunTower")
end
function PlayTowerVanishSound()
  LD.PlaySound(towerEmitter, "SND_AMB_EMIT_Jotunheim_Tower_Vanishes")
end
function DestroyCamera()
  game.SubObject.Sleep(thisObj)
  cameraOneShotObjectTempleVista = nil
  cameraOneShotBoatHack = nil
end
