local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local kraActor, sonActor, thisLevel, thisObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function SetupActors()
  kraActor = actor.Actor.New("RealmTravelRestored: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("RealmTravelRestored: Son Actor", game.AI.FindSon)
end
function SetupCineSequence()
  SetupActors()
  local doorObj = GameObjects.RealmTowerDoor_Jot.Child.Child
  local cineSeq = LD.CreateCineSequence(thisLevel, doorObj, "RealmTravelRestored Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {
      Obj = doorObj,
      Anim = "poiRealmTravelRestored"
    }
  }
  doorObj.LuaObjectScript.EnableCinematicTrigger()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_RealmTravelRestored",
    ReferenceJoint = "synchJointFront",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.RunArrivalRadius,
    foot = game.Creature.Foot.kLeft,
    weapon_state = "bare"
  })
  cineSeq:Do(function()
    thisLevel:CallScript("ReturnFromRBR")
    GameObjects.Jotun:FindSingleGOByName("RealmTowerDoor_Jot").Child.LuaObjectScript.PlaySoundOnInteract_Forward()
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_RealmTravelRestored",
    ReferenceJoint = "synchJointFront"
  })
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer().AnimPercent >= 0.12
  end)
  cineSeq:Do(function()
    game.Audio.PlayBanter("010_SeenItAll", CheckBrazierQuest)
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:Do(CompleteRealmBetweenRealmsParent)
  cineSeq:Do(function()
    GameObjects.Btr_Caldera_Bridge.LuaObjectScript.Enable_Btr_JotunOffCrit()
    BOOKMARK_32_Underworld_020_CalderaReturn()
    GameObjects.Jotun:FindSingleGOByName("RealmTowerDoor_Jot").Child.LuaObjectScript.Lock()
  end)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StartSequence()
end
function CompleteRealmBetweenRealmsParent()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective742", "Complete")
  LD.ActivateQuest("Quest_JotunheimInReach_Parent")
end
function BOOKMARK_32_Underworld_020_CalderaReturn()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "32_Underworld_020_CalderaReturn"]
  tableEntry.OverrideObject = GameObjects.CO_BOOKMARK_32_Underworld_020_CalderaReturn
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function CheckBrazierQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_LightBrazier_Parent")
  if questState == "Active" then
    game.Audio.PlayBanter("010_SeenItAll_Contd")
  end
end
