local LD = require("design.LevelDesignLibrary")
local thisObj, player, thisLevel, kraActor, sonActor, cal140, DoorObj, keyProp
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.templeFlipKey_prop:Hide()
end
function OnStart()
  cal140 = game.FindLevel("Cal140_TempleExt")
  SoundOnStart()
end
function AttemptSeq()
  if game.Level.GetVariable("CompletedCineNumber") == 510 then
    local actor = require("narrative.actor")
    kraActor = actor.Actor.New("POI TempleFlip Unlock: Kratos Actor", game.Player.FindPlayer)
    sonActor = actor.Actor.New("BLUE DOOR POI: Son Actor", game.AI.FindSon)
    if cal140 == nil then
      cal140 = game.FindLevel("Cal140_TempleExt")
    end
    SetupSequence()
  end
end
function SetupSequence()
  local poiSeq = LD.CreateCineSequence(thisLevel, thisObj, "Unlocking TempleFlip Entrance Door Sequence")
  DoorObj = GameObjects.KeyLockTempleDoor.Child
  local switchObject = DoorObj:FindSingleGOByName("TempleflipLock").Child
  local switchPushOutGroup = switchObject:FindSingleGOByName("LockPushOutGroup")
  local switchHandlesGroup = switchObject:FindSingleGOByName("LockHandlesGroup")
  local switchRotateGroup = switchObject:FindSingleGOByName("LockRotateGroup")
  keyProp = GameObjects.templeFlipKey_prop.Child
  local keyEnterSlaveTab = {
    {
      Obj = keyProp,
      Anim = "envTempleFlipKeyEnter"
    }
  }
  local switchSlaveTab = {
    {
      Obj = switchObject,
      Anim = "envVertLever2HandsOff"
    }
  }
  local doorSlaveTab = {
    {
      Actor = sonActor,
      Branch = "BRA_DoorSpreadOpen"
    },
    {
      Obj = DoorObj,
      Anim = "DoorSpreadOpen"
    }
  }
  local ND = require("design.NarrativeDesignLibrary")
  poiSeq:Do(function()
    EnableGamePad(false)
  end)
  poiSeq:RequestCineModeAndWait(kraActor, thisObj)
  poiSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_POI_TempleFlipKeyEnter",
    ReferenceJoint = "synchJoint_KeyEnter",
    speed = ND.KraWalkSpeed,
    radius = ND.StopTurnRadius,
    weapon_state = "bare",
    completion_percentage = 0.7,
    stop = false
  })
  poiSeq:Do(function()
    local kraPup = kraActor:GetActivePuppeteer()
    kraPup:WeaponEquip({weaponMode = "Bare"})
  end)
  poiSeq:Do(function()
    DoorObj.LuaObjectScript.Disable()
    game.Audio.PlayBanter("055_TempleFlipDoor_4")
  end)
  poiSeq:ActorSync(kraActor, {
    Slaves = keyEnterSlaveTab,
    Branch = "BRA_POI_TempleFlipKeyEnter",
    ReferenceJoint = "synchJoint_KeyEnter"
  })
  poiSeq:WaitForActorMoveComplete(kraActor)
  poiSeq:Do(function()
    local kraPup = kraActor:GetActivePuppeteer()
    kraPup:WeaponEquip({weaponMode = "Bare"})
    switchPushOutGroup:JumpAnimToPercent(1)
    switchPushOutGroup:PlayAnimToFrame(20, -0.75)
    PlaySoundLockSwitchExtend()
    LD.CallFunctionAfterDelay(function()
      switchRotateGroup:JumpAnimToFrame(20)
      switchRotateGroup:PlayAnimToFrame(0, -0.75)
      switchHandlesGroup:PlayAnimToFrame(0, -0.9)
    end, 1)
  end)
  poiSeq:WaitForFunctionTrue(function()
    return switchHandlesGroup.AnimFrame == 0 and switchPushOutGroup.AnimFrame == 20
  end)
  poiSeq:ActorSync(kraActor, {
    Slaves = switchSlaveTab,
    Branch = "BRA_POI_TempleFlipTurnLock",
    ReferenceJoint = "synchJoint_SwitchTurn"
  })
  poiSeq:WaitForFunctionTrue(function()
    return WaitToPlaySoundTurnLock()
  end)
  poiSeq:WaitForActorMoveComplete(kraActor)
  poiSeq:Do(function()
    switchPushOutGroup:PlayAnimToEnd()
    PlaySoundLockSwitchRetract()
    switchHandlesGroup:PlayAnimToEnd(1.6)
  end)
  poiSeq:WaitForFunctionTrue(function()
    return switchHandlesGroup.AnimFrame == switchHandlesGroup.AnimLengthFrames and switchPushOutGroup.AnimFrame == switchPushOutGroup.AnimLengthFrames
  end)
  poiSeq:Do(function()
    local kraPup = kraActor:GetActivePuppeteer()
    kraPup:WeaponEquip({weaponMode = "Bare"})
  end)
  poiSeq:ActorSync(kraActor, {
    Slaves = doorSlaveTab,
    Branch = "BRA_DoorSpreadOpen",
    ReferenceJoint = "synchJoint_DoorEnter"
  })
  poiSeq:Do(function()
    _G.EnterTempleFlip()
    DoorObj.LuaObjectScript.PlaySoundOnInteract_Forward()
  end)
  poiSeq:StopPuppetingActor(sonActor)
  poiSeq:WaitForActorMoveComplete(kraActor)
  poiSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  poiSeq:Do(function()
    EnableGamePad(true)
    DoorObj.LuaObjectScript.Enable()
  end)
  poiSeq:StopPuppetingActor(kraActor)
  poiSeq:StartSequence()
end
function CanSeqFire()
  return game.Level.GetVariable("CompletedCineNumber") == 510
end
function LuaHook_ShowKeyProp()
  keyProp:Show()
end
function EnableGamePad(value)
  local buttons = {
    "kPadL3",
    "kPadR3",
    "kPadTouch",
    "kPadUp",
    "kPadRight",
    "kPadDown",
    "kPadLeft",
    "kPadLeftStickX",
    "kPadLeftStickY",
    "kPadRightStickX",
    "kPadRightStickY",
    "kPadR1",
    "kPadR2",
    "kPadL1",
    "kPadL2",
    "kPadTriangle",
    "kPadCircle",
    "kPadCross",
    "kPadSquare"
  }
  for i = 1, #buttons do
    if value then
      player.Pad:EnableGameButton(tweaks.ePad[buttons[i]])
    else
      player.Pad:DisableGameButton(tweaks.ePad[buttons[i]])
    end
  end
end
local doorLeftEmitter, doorRightEmitter
local doorSoundOverrides = {
  OnInteractForward_Left = "SND_DOOR_TempleFlip_Double_Door_Open_L",
  OnInteractForward_Right = "SND_DOOR_TempleFlip_Double_Door_Open_R",
  OnInteractBackward_Left = "SND_DOOR_TempleFlip_Double_Door_Open_L",
  OnInteractBackward_Right = "SND_DOOR_TempleFlip_Double_Door_Open_R",
  OnInteractClose_Left = "SND_DOOR_TempleFlip_Double_Door_Close_L",
  OnInteractClose_Right = "SND_DOOR_TempleFlip_Double_Door_Close_R"
}
function SoundOnStart()
  local doorObj = GameObjects.KeyLockTempleDoor.Child
  doorLeftEmitter = doorObj:FindSingleSoundEmitterByName("SNDDoorLeft")
  doorRightEmitter = doorObj:FindSingleSoundEmitterByName("SNDDoorRight")
  doorObj.LuaObjectScript.SoundSetup(doorSoundOverrides)
end
function LuaHook_Sound_KeyEnter_Pt1()
  LD.PlaySound(doorLeftEmitter, "SND_DOOR_TempleFlip_KeyEnter_55_L")
  LD.PlaySound(doorRightEmitter, "SND_DOOR_TempleFlip_KeyEnter_55_R")
end
function LuaHook_Sound_KeyEnter_Pt2()
  LD.PlaySound(doorLeftEmitter, "SND_DOOR_TempleFlip_KeyEnter_61_L")
  LD.PlaySound(doorRightEmitter, "SND_DOOR_TempleFlip_KeyEnter_61_R")
end
function PlaySoundLockSwitchExtend()
  LD.PlaySound(doorLeftEmitter, "SND_DOOR_TempleFlip_Opening_Lock_Extend_L")
  LD.PlaySound(doorRightEmitter, "SND_DOOR_TempleFlip_Opening_Lock_Extend_R")
end
function WaitToPlaySoundTurnLock()
  if player:IsPlayingMove("MOV_POI_TempleFlipTurnLock") and player:GetActiveMovePercent() >= 0.27 then
    LD.PlaySound(doorLeftEmitter, "SND_DOOR_TempleFlip_TurnLock_27_L")
    LD.PlaySound(doorRightEmitter, "SND_DOOR_TempleFlip_TurnLock_27_R")
    return true
  else
    return false
  end
end
function PlaySoundLockSwitchRetract()
  LD.PlaySound(doorLeftEmitter, "SND_DOOR_TempleFlip_Opening_Lock_Retract_L")
  LD.PlaySound(doorRightEmitter, "SND_DOOR_TempleFlip_Opening_Lock_Retract_R")
end
