local LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level)
  if GameObjects.bridgeTop.Parent ~= nil then
    GameObjects.bridgeTop:Unparent()
  end
  local LM = require("level.loadmonitor")
  LM.CreateLoadMonitor():AddCallback({
    Wads = {"Cal100_Hub"},
    Functions = {
      function()
        local cal100 = game.FindLevel("Cal100_Hub")
        local bridge = cal100:FindSingleGameObject("calderaBridge")
        bridge:AddChild(GameObjects.bridgeTop, bridge:GetJointIndex("JOBridge1"), 1)
      end
    }
  })
end
function OnStart(level)
  LD.RegisterForCineUpdate(level, {
    {
      at = 190,
      immediateFn = function()
        GameObjects.CalderaBridge_water01:Hide()
      end,
      fn = function()
        GameObjects.CalderaBridge_water01:Hide()
      end
    }
  })
  UpdateWindPositions()
end
function PlayBridgeAlignFx()
  local timers = require("level.timer")
  timers.StartLevelTimer(24, function()
    LD.ShowFX(GameObjects.bridge_dust_hit)
  end)
end
function UpdateWindPositions()
  game.FX.UpdateEveryStaticWindPosition()
end
