local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local room, hengeDisruption, cal100, hel100, fake130doors, surveyZoneAlfheim, surveyZonePeaksPass, surveyZoneJotunheim
local brokIsSpawned = false
local sindriIsSpawned = false
local largeShop, brokSpawnObject, sindriSpawnObject
local cineActive = false
local cineDespawn = false
local midgardLoad, alfheimLoad, jotunheimLoad, helheimLoad, niflheimLoad, muspelheimLoad, dragonLoad, brokCatLoad, brokShopLoad, brokCaresLoad, huldraReunionLoad, eyesOnThePrizeLoad, midgardActivationLoad, freyaLeadTheWayLoad, freyaLeadTheWayMid, freyaActivationLoad, midMidgardLoad, spreadDoorRealmHelper, AirlockMidgardGrunge
function OnScriptLoaded(level)
  room = GameObjects.calderaAirlock
  hengeDisruption = GameObjects.hengeDisruption
  fake130doors = GameObjects.Fake130Doors
  surveyZoneAlfheim = GameObjects.Zone_PlaytestCompleteAlfheim
  surveyZonePeaksPass = GameObjects.Zone_PlaytestCompletePeaks
  surveyZoneJotunheim = GameObjects.Zone_PlaytestCompleteJotunheim
  midgardLoad = GameObjects.LoadOutsideMidgard
  alfheimLoad = GameObjects.LoadOutsideAlfheim
  jotunheimLoad = GameObjects.LoadOutsideJotunheim
  helheimLoad = GameObjects.LoadOutsideHelheim
  niflheimLoad = GameObjects.LoadOutsideNidavellir
  muspelheimLoad = GameObjects.LoadOutsideMuspelheim
  dragonLoad = GameObjects.LoadOutsideDragonRide
  brokCatLoad = GameObjects.LoadOutsideBrokCat
  brokShopLoad = GameObjects.LoadOutsideBrokShop
  brokCaresLoad = GameObjects.LoadOutsideBrokCares
  huldraReunionLoad = GameObjects.LoadOutsideHuldraReunion
  eyesOnThePrizeLoad = GameObjects.LoadOutsideEyesOnThePrize
  midgardActivationLoad = GameObjects.ActivatedOutsideMidgard
  freyaLeadTheWayLoad = GameObjects.LoadOutsideFreyaLeadWay
  freyaLeadTheWayMid = GameObjects.Cal120_MidFreyaLead
  freyaActivationLoad = GameObjects.ActivatedOutsideFreya
  spreadDoorRealmHelper = GameObjects.SpreadDoor_RealmHelper
  midMidgardLoad = GameObjects.Cal120_MidRevealMidgard
  cineActive = false
  largeShop = GameObjects.LargeShop
  brokSpawnObject = largeShop.Child:FindSingleGOByName("VendorSpawner").Child
  sindriSpawnObject = largeShop.Child:FindSingleGOByName("VendorSpawner1").Child
  ArtifactVisibility()
  SetBridgeGatewayMarkers()
  AirlockMidgardGrunge = level:FindGameObjects("underwater*")
  table.insert(AirlockMidgardGrunge, GameObjects.Cal120_Entry_MidguardGrunge)
end
function OnFirstStart(level)
  alfheimLoad:HideEntityVolume()
  jotunheimLoad:HideEntityVolume()
  helheimLoad:HideEntityVolume()
  niflheimLoad:HideEntityVolume()
  muspelheimLoad:HideEntityVolume()
  dragonLoad:HideEntityVolume()
  brokCatLoad:HideEntityVolume()
  brokShopLoad:HideEntityVolume()
  brokCaresLoad:HideEntityVolume()
  huldraReunionLoad:HideEntityVolume()
  eyesOnThePrizeLoad:HideEntityVolume()
  freyaLeadTheWayLoad:HideEntityVolume()
  freyaLeadTheWayMid:HideEntityVolume()
  freyaActivationLoad:HideEntityVolume()
  surveyZoneAlfheim:HideEntityVolume()
  surveyZonePeaksPass:HideEntityVolume()
  surveyZoneJotunheim:HideEntityVolume()
  GameObjects.LoadFinaleFastTravel:HideEntityVolume()
  hengeDisruption:JumpAnimationToFrame(0)
  hengeDisruption:PauseAnimation()
  HideHengeDisruptionLights()
  GameObjects.Zone_PlaytestCompleteJotunheim:Hide()
  GameObjects.AreaAnnounce120:Show()
end
function OnStart(level)
  SetBridgeAlignmentImmediate()
  LD.RegisterForVariableUpdate(level, "SAVED_BOOKMARK_15_Caldera_010_ChiselReturn", {
    immediateFn = function()
      GameObjects.BOOKMARK_15_Caldera_010_ChiselReturn:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end,
    fn = function()
      GameObjects.BOOKMARK_15_Caldera_010_ChiselReturn:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end
  })
  LD.RegisterForVariableUpdate(level, "SAVED_BOOKMARK_35_Caldera_010_JotunheimReady", {
    immediateFn = function()
      GameObjects.BOOKMARK_35_Caldera_010_JotunheimReady:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end,
    fn = function()
      GameObjects.BOOKMARK_35_Caldera_010_JotunheimReady:FindSingleGOByName("BookmarkZone").LuaObjectScript.Disable()
    end
  })
  LD.RegisterForVariableUpdate(level, "RealmTravel_JotunheimFailed", {
    immediateFn = UpdateLoadZones,
    fn = UpdateLoadZones
  })
  LD.RegisterForVariableUpdate(level, "DragonArrivalTriggered", {
    immediateFn = SetDragonArrival,
    fn = SetDragonArrival
  })
  LD.RegisterForVariableUpdate(level, "CurrentRealm", {
    immediateFn = SetCurrentRealm,
    fn = SetCurrentRealm
  })
  LD.RegisterForVariableUpdate(level, "BridgePosition", {
    immediateFn = function()
      SetBridgeAlignmentImmediate()
      SetBridgeGatewayMarkers()
    end,
    fn = function()
      SetBridgeAlignment()
      SetBridgeGatewayMarkers()
    end
  })
  LD.RegisterForVariableUpdate(level, "JotTowerRevealed", {
    immediateFn = function()
      GameObjects.BtrComp_ThisIsIt.LuaObjectScript.Enable()
      GameObjects.BtrComp_PreSayGoodbye.LuaObjectScript.Enable()
    end,
    fn = function()
      GameObjects.BtrComp_ThisIsIt.LuaObjectScript.Enable()
      GameObjects.BtrComp_PreSayGoodbye.LuaObjectScript.Enable()
    end
  })
  LD.RegisterForCineUpdate(level, {
    {
      at = 165,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 201,
      immediateFn = CreateBridgeOverride,
      fn = CreateBridgeOverride
    },
    {
      at = 250,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 310,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 330,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 360,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 380,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 387,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 400,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 470,
      immediateFn = function()
        SetDragonArrival()
      end,
      fn = function()
        SetDragonArrival()
      end
    },
    {
      at = 490,
      immediateFn = function()
        DragonComplete()
      end,
      fn = function()
        DragonComplete()
      end
    },
    {
      at = 500,
      immediateFn = function()
        GameObjects.AreaAnnounce120:Show()
      end,
      fn = function()
        GameObjects.AreaAnnounce120:Show()
      end
    },
    {
      at = 520,
      immediateFn = function()
        UpdateLoadZones()
      end,
      fn = function()
        UpdateLoadZones()
      end
    },
    {
      at = 610,
      immediateFn = function()
        surveyZoneJotunheim:ShowEntityVolume()
      end,
      fn = function()
        surveyZoneJotunheim:ShowEntityVolume()
      end
    }
  })
  local cal130 = game.FindLevel("Cal130_TempleInt")
  if cal130 ~= nil then
    FakeDoorsOff()
  else
    FakeDoorsOn()
  end
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 183 then
    ShopIntroStart()
  end
  cal100 = game.FindLevel("Cal100_Hub")
  UnlockDoors()
  MuspelheimDiscVisability()
  NiflheimDiscVisability()
  GameObjects.FastTravelPoint.LuaObjectScript.Enable()
  if 380 <= cineNumber and cineNumber <= 390 then
    local currentRealm = LD.GetCurrentRealm()
    if currentRealm == "Midgard" then
      LockDoors()
    elseif currentRealm == "Helheim" then
      GameObjects.FastTravelPoint.LuaObjectScript.Disable()
    end
  end
  UpdateLoadZones()
end
function UpdateLoadZones()
  local currentRealm = LD.GetCurrentRealm()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  TurnAllLoadZonesOff()
  if currentRealm == "Midgard" then
    if 165 <= cineNumber and cineNumber < 183 then
      print("turning off all load zones until shop intro has finished")
    elseif cineNumber == 190 then
      LockDoors()
    elseif 190 <= cineNumber and cineNumber < 210 then
      freyaActivationLoad:ShowEntityVolume()
      freyaLeadTheWayLoad:ShowEntityVolume()
      freyaLeadTheWayMid:ShowEntityVolume()
      print("turning on freya lead the way wad load in 120")
      local LTWStage = game.Level.GetVariable("FreyaLTWStage")
      if 60 <= LTWStage and LTWStage < 80 then
        LockDoors()
      end
    elseif 250 <= cineNumber and cineNumber < 263 then
      brokShopLoad:ShowEntityVolume()
      surveyZoneAlfheim:ShowEntityVolume()
    elseif cineNumber == 310 then
      brokCaresLoad:ShowEntityVolume()
    elseif cineNumber == 380 then
      brokCatLoad:ShowEntityVolume()
      LockDoors()
    elseif 380 <= cineNumber and cineNumber < 390 then
      LockDoors()
    elseif cineNumber == 470 then
      dragonLoad:ShowEntityVolume()
      ForceAirlockToVanaheim()
    elseif cineNumber == 500 then
      huldraReunionLoad:ShowEntityVolume()
      midgardActivationLoad:ShowEntityVolume()
      midMidgardLoad:ShowEntityVolume()
    elseif cineNumber == 515 and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") == true then
      eyesOnThePrizeLoad:ShowEntityVolume()
      midgardActivationLoad:ShowEntityVolume()
      midMidgardLoad:ShowEntityVolume()
    elseif 610 <= cineNumber then
      midgardLoad:ShowEntityVolume()
      midgardActivationLoad:ShowEntityVolume()
      midMidgardLoad:ShowEntityVolume()
    else
      midgardLoad:ShowEntityVolume()
      midgardActivationLoad:ShowEntityVolume()
      midMidgardLoad:ShowEntityVolume()
    end
  elseif currentRealm == "Helheim" then
    helheimLoad:ShowEntityVolume()
    HideFiresForHelheim()
    if 380 <= cineNumber and cineNumber < 390 then
      GameObjects.FastTravelPoint.LuaObjectScript.Disable()
    end
  elseif currentRealm == "Alfheim" then
    alfheimLoad:ShowEntityVolume()
  elseif currentRealm == "Jotunheim" then
    jotunheimLoad:ShowEntityVolume()
  elseif 610 <= cineNumber and currentRealm == "Jotunheim" then
    surveyZoneJotunheim:ShowEntityVolume()
  elseif currentRealm == "Niflheim" then
    niflheimLoad:ShowEntityVolume()
  elseif currentRealm == "Muspelheim" then
    muspelheimLoad:ShowEntityVolume()
  end
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Cal130_TempleInt" then
    FakeDoorsOff()
  end
  if cal100 == nil and newLevel.Name == "WAD_Cal100_Hub" then
    cal100 = newLevel
  end
  if newLevel.Name == "WAD_Hel100_CalderaHelDressing" then
    hel100 = newLevel
  end
end
function OnWadUnloaded(level, newLevel)
  if newLevel.Name == "WAD_Cal130_TempleInt" then
    FakeDoorsOn()
  end
  if cal100 ~= nil and newLevel.Name == "WAD_Cal100_Hub" then
    cal100 = nil
  end
end
function SetBridgeGatewayMarkers()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper1", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper3", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper4", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper7", false)
  local selBridgePosition = LD.GetBridgePosition()
  if selBridgePosition == "Jotunheim" then
    JotunheimCompassPaths()
  elseif selBridgePosition == "Alfheim" then
    AlfheimCompassPaths()
  elseif selBridgePosition == "Vanaheim" or selBridgePosition == "Midgard" then
    VanaheimCompassPaths()
  elseif selBridgePosition == "Helheim" then
    HelheimCompassPaths()
  elseif selBridgePosition == "Asgard" then
    AsgardCompassPaths()
  elseif selBridgePosition == "Muspelheim" then
    MuspelheimCompassPaths()
  elseif selBridgePosition == "Niflheim" then
    NiflheimCompassPaths()
  end
end
function JotunheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper", true)
end
function AlfheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper7", true)
end
function VanaheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper1", true)
end
function HelheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", true)
end
function AsgardCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper4", true)
end
function MuspelheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper2", true)
end
function NiflheimCompassPaths()
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper3", true)
end
function ShowPlaytetZoneJotunheim()
  GameObjects.Zone_PlaytestCompleteJotunheim:Show()
end
function HideAllCal120()
  local vis = GameObjects.Cal120_Vis
  vis:Hide()
end
function ShowAllCal120()
  local vis = GameObjects.Cal120_Vis
  vis:Show()
end
function BrokShopDone()
  brokShopLoad:HideEntityVolume()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  SetCineActive(false)
end
function BrokCatDone()
  brokCatLoad:HideEntityVolume()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  SetCineActive(false)
end
function HuldraReunionStart()
  SetCineActive(true)
end
function HuldraReunionDone()
  huldraReunionLoad:HideEntityVolume()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  SetCineActive(false)
  if cal100 then
    cal100:CallScript("OpenFlipTempleDoor")
  end
end
function BrokCaresDone()
  brokCaresLoad:HideEntityVolume()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  surveyZonePeaksPass:ShowEntityVolume()
end
function BrokCaresPostBanterDone()
  SetCineActive(false)
end
function ShopIntroStart()
  CheckAndForceLoadBrokVendor(true)
  SetCineActive(true)
end
function ShopIntroDone()
  SetCineActive(false)
  LockDoors()
  GameObjects.Btr_Cal120.LuaObjectScript.ShopIntroDone()
  GameObjects.FastTravelPoint.LuaObjectScript.Disable()
end
function FastTravelIntroDone()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  UnlockDoors()
end
function AreaAnnounce120()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("Brok Shop")
  GameObjects.AreaAnnounce120:Hide()
end
function SetDragonArrival()
  midgardLoad:HideEntityVolume()
  midgardActivationLoad:HideEntityVolume()
  midMidgardLoad:HideEntityVolume()
  dragonLoad:Show()
end
function DragonComplete()
  midgardLoad:ShowEntityVolume()
  midgardActivationLoad:ShowEntityVolume()
  midMidgardLoad:ShowEntityVolume()
  dragonLoad:Hide()
end
function FakeDoorsOn()
  fake130doors:Show()
  fake130doors:ShowCollision()
  print("turning fake 130 doors on")
end
function FakeDoorsOff()
  fake130doors:Hide()
  fake130doors:HideCollision()
  print("turning fake 130 doors off")
end
function RealDoorsOn()
  GameObjects.SpreadDoor_Caldera_Small:Show()
end
function RealDoorsOff()
  GameObjects.SpreadDoor_Caldera_Small:Hide()
end
function LockDoors()
  GameObjects.SpreadDoor_Caldera_AirLock.Child.LuaObjectScript.Lock()
end
function UnlockDoors()
  GameObjects.SpreadDoor_Caldera_AirLock.Child.LuaObjectScript.Unlock()
end
function Cal130LoadCheck()
  game.UI.LoadCheck("Cal130_TempleInt")
end
function MidgardLoadCheck()
  game.UI.LoadCheck("Cal100_Hub", "Cal110_BridgeTop", "Cal200_Shore")
end
function EyesOnThePrizeLoadCheck()
  game.UI.LoadCheck("Cal120_c_EyesOnThePrize")
end
function ArtifactVisibility()
  BroochVisibility()
  ToyVisibility()
  CupVisibility()
  AlfheimVisibility()
  HornVisibility()
  MaskVisibility()
  ShipVisibility()
  QueenVisibility()
end
function HideFiresForHelheim()
  GameObjects.Cal120Fire_Spot_Door_Brazier_01:Hide()
  GameObjects.Cal120Fire_Spot_Door_Brazier_02:Hide()
  GameObjects.brazierfire_noOffset:Hide()
  GameObjects.brazierfire_noOffset1:Hide()
end
function ShowFiresForDefault()
  GameObjects.Cal120Fire_Spot_Door_Brazier_01:Show()
  GameObjects.Cal120Fire_Spot_Door_Brazier_02:Show()
  GameObjects.brazierfire_noOffset:Show()
  GameObjects.brazierfire_noOffset1:Show()
end
function BroochVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayBrooch")
  if game.Wallets.HasResource("HERO", "DisplayBroochAnimal") then
    GameObjects.ShopArtifactBrooch01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "BroochAnimal") then
    game.Wallets.AddResource("HERO", "DisplayBroochAnimal", 1)
    game.Wallets.RemoveResource("HERO", "DisplayBrooch", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactBrooch01:Show()
  else
    GameObjects.ShopArtifactBrooch01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayBroochRay") then
    GameObjects.ShopArtifactBrooch02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "BroochRay") then
    game.Wallets.AddResource("HERO", "DisplayBroochRay", 1)
    game.Wallets.RemoveResource("HERO", "DisplayBrooch", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactBrooch02:Show()
  else
    GameObjects.ShopArtifactBrooch02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayBroochFancy") then
    GameObjects.ShopArtifactBrooch05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "BroochFancy") then
    game.Wallets.AddResource("HERO", "DisplayBroochFancy", 1)
    game.Wallets.RemoveResource("HERO", "DisplayBrooch", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactBrooch05:Show()
  else
    GameObjects.ShopArtifactBrooch05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayBroochRuby") then
    GameObjects.ShopArtifactBrooch03:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "BroochRuby") then
    game.Wallets.AddResource("HERO", "DisplayBroochRuby", 1)
    game.Wallets.RemoveResource("HERO", "DisplayBrooch", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactBrooch03:Show()
  else
    GameObjects.ShopArtifactBrooch03:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayBroochNeedle") then
    GameObjects.ShopArtifactBrooch04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "BroochNeedle") then
    game.Wallets.AddResource("HERO", "DisplayBroochNeedle", 1)
    game.Wallets.RemoveResource("HERO", "DisplayBrooch", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactBrooch04:Show()
  else
    GameObjects.ShopArtifactBrooch04:Hide()
  end
end
function CupVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayOrnateCup")
  if game.Wallets.HasResource("HERO", "DisplayCupDragon") then
    GameObjects.ShopArtifactCup01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupDragon") then
    game.Wallets.AddResource("HERO", "DisplayCupDragon", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup01:Show()
  else
    GameObjects.ShopArtifactCup01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayCupHandle") then
    GameObjects.ShopArtifactCup02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupHandle") then
    game.Wallets.AddResource("HERO", "DisplayCupHandle", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup02:Show()
  else
    GameObjects.ShopArtifactCup02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayCupFeet") then
    GameObjects.ShopArtifactCup03:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupFeet") then
    game.Wallets.AddResource("HERO", "DisplayCupFeet", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup03:Show()
  else
    GameObjects.ShopArtifactCup03:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayCupGoblet") then
    GameObjects.ShopArtifactCup04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupGoblet") then
    game.Wallets.AddResource("HERO", "DisplayCupGoblet", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup04:Show()
  else
    GameObjects.ShopArtifactCup04:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayCupPintGlass") then
    GameObjects.ShopArtifactCup05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupPintGlass") then
    game.Wallets.AddResource("HERO", "DisplayCupPintGlass", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup05:Show()
  else
    GameObjects.ShopArtifactCup05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayCupHolyGrail") then
    GameObjects.ShopArtifactCup06:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "CupHolyGrail") then
    game.Wallets.AddResource("HERO", "DisplayCupHolyGrail", 1)
    game.Wallets.RemoveResource("HERO", "DisplayOrnateCup", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactCup06:Show()
  else
    GameObjects.ShopArtifactCup06:Hide()
  end
end
function HornVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayVikingHorn")
  if game.Wallets.HasResource("HERO", "DisplayHornUShape") then
    GameObjects.ShopArtifactHorn01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornUShape") then
    game.Wallets.AddResource("HERO", "DisplayHornUShape", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn01:Show()
  else
    GameObjects.ShopArtifactHorn01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayHornWorldTree") then
    GameObjects.ShopArtifactHorn02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornWorldTree") then
    game.Wallets.AddResource("HERO", "DisplayHornWorldTree", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn02:Show()
  else
    GameObjects.ShopArtifactHorn02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayHornExtension") then
    GameObjects.ShopArtifactHorn03:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornExtension") then
    game.Wallets.AddResource("HERO", "DisplayHornExtension", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn03:Show()
  else
    GameObjects.ShopArtifactHorn03:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayHornHorse") then
    GameObjects.ShopArtifactHorn04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornHorse") then
    game.Wallets.AddResource("HERO", "DisplayHornHorse", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn04:Show()
  else
    GameObjects.ShopArtifactHorn04:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayHornHandle") then
    GameObjects.ShopArtifactHorn05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornHandle") then
    game.Wallets.AddResource("HERO", "DisplayHornHandle", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn05:Show()
  else
    GameObjects.ShopArtifactHorn05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayHornBigMouth") then
    GameObjects.ShopArtifactHorn06:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "HornBigMouth") then
    game.Wallets.AddResource("HERO", "DisplayHornBigMouth", 1)
    game.Wallets.RemoveResource("HERO", "DisplayVikingHorn", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactHorn06:Show()
  else
    GameObjects.ShopArtifactHorn06:Hide()
  end
end
function MaskVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayNorseMask")
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskStoneFace") then
    GameObjects.ShopArtifactMask12:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskStoneFace") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskStoneFace", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask12:Show()
  else
    GameObjects.ShopArtifactMask12:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskCurlyBeard") then
    GameObjects.ShopArtifactMask06:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskCurlyBeard") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskCurlyBeard", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask06:Show()
  else
    GameObjects.ShopArtifactMask06:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskFlatBeard") then
    GameObjects.ShopArtifactMask05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskFlatBeard") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskFlatBeard", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask05:Show()
  else
    GameObjects.ShopArtifactMask05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskStraightBeard") then
    GameObjects.ShopArtifactMask11:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskStraightBeard") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskStraightBeard", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask11:Show()
  else
    GameObjects.ShopArtifactMask11:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskReptile") then
    GameObjects.ShopArtifactMask04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskReptile") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskReptile", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask04:Show()
  else
    GameObjects.ShopArtifactMask04:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskMustache") then
    GameObjects.ShopArtifactMask09:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskMustache") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskMustache", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask09:Show()
  else
    GameObjects.ShopArtifactMask09:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskTiki") then
    GameObjects.ShopArtifactMask08:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskTiki") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskTiki", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask08:Show()
  else
    GameObjects.ShopArtifactMask08:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskGhoul") then
    GameObjects.ShopArtifactMask01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskGhoul") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskGhoul", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask01:Show()
  else
    GameObjects.ShopArtifactMask01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayNorseMaskGoat") then
    GameObjects.ShopArtifactMask07:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "NorseMaskGoat") then
    game.Wallets.AddResource("HERO", "DisplayNorseMaskGoat", 1)
    game.Wallets.RemoveResource("HERO", "DisplayNorseMask", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactMask07:Show()
  else
    GameObjects.ShopArtifactMask07:Hide()
  end
end
function ToyVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayLostToy")
  if game.Wallets.HasResource("HERO", "DisplayLostToyTroll") then
    GameObjects.ShopArtifactToy02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "LostToyTroll") then
    game.Wallets.AddResource("HERO", "DisplayLostToyTroll", 1)
    game.Wallets.RemoveResource("HERO", "DisplayLostToy", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactToy02:Show()
  else
    GameObjects.ShopArtifactToy02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayLostToySpearGuy") then
    GameObjects.ShopArtifactToy05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "LostToySpearGuy") then
    game.Wallets.AddResource("HERO", "DisplayLostToySpearGuy", 1)
    game.Wallets.RemoveResource("HERO", "DisplayLostToy", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactToy05:Show()
  else
    GameObjects.ShopArtifactToy05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayLostToyBoat") then
    GameObjects.ShopArtifactToy04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "LostToyBoat") then
    game.Wallets.AddResource("HERO", "DisplayLostToyBoat", 1)
    game.Wallets.RemoveResource("HERO", "DisplayLostToy", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactToy04:Show()
  else
    GameObjects.ShopArtifactToy04:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayLostToyHorse") then
    GameObjects.ShopArtifactToy01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "LostToyHorse") then
    game.Wallets.AddResource("HERO", "DisplayLostToyHorse", 1)
    game.Wallets.RemoveResource("HERO", "DisplayLostToy", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactToy01:Show()
  else
    GameObjects.ShopArtifactToy01:Hide()
  end
end
function AlfheimVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayAlfheimArtifact")
  if game.Wallets.HasResource("HERO", "DisplayAlfheimPendant") then
    GameObjects.alfheimMesh01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimPendant") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimPendant", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh01:Show()
  else
    GameObjects.alfheimMesh01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayAlfheimMedallion") then
    GameObjects.alfheimMesh02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimMedallion") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimMedallion", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh02:Show()
  else
    GameObjects.alfheimMesh02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayAlfheimCurvy") then
    GameObjects.alfheimMesh03:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimCurvy") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimCurvy", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh03:Show()
  else
    GameObjects.alfheimMesh03:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayAlfheimSHook") then
    GameObjects.alfheimMesh06:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimSHook") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimSHook", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh06:Show()
  else
    GameObjects.alfheimMesh06:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayAlfheimHook") then
    GameObjects.alfheimMesh05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimHook") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimHook", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh05:Show()
  else
    GameObjects.alfheimMesh05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayAlfheimInsect") then
    GameObjects.alfheimMesh04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "AlfheimInsect") then
    game.Wallets.AddResource("HERO", "DisplayAlfheimInsect", 1)
    game.Wallets.RemoveResource("HERO", "DisplayAlfheimArtifact", 1)
    numRevealed = numRevealed - 1
    GameObjects.alfheimMesh04:Show()
  else
    GameObjects.alfheimMesh04:Hide()
  end
end
function ShipVisibility()
  local numRevealed = game.Wallets.GetResourceValue("HERO", "DisplayShipHead")
  if game.Wallets.HasResource("HERO", "DisplayShipDragon") then
    GameObjects.ShopArtifactShipHead01:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipDragon") then
    game.Wallets.AddResource("HERO", "DisplayShipDragon", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead01:Show()
  else
    GameObjects.ShopArtifactShipHead01:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipSeaHorse") then
    GameObjects.ShopArtifactShipHead02:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipSeaHorse") then
    game.Wallets.AddResource("HERO", "DisplayShipSeaHorse", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead02:Show()
  else
    GameObjects.ShopArtifactShipHead02:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipHook") then
    GameObjects.ShopArtifactShipHead03:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipHook") then
    game.Wallets.AddResource("HERO", "DisplayShipHook", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead03:Show()
  else
    GameObjects.ShopArtifactShipHead03:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipTongue") then
    GameObjects.ShopArtifactShipHead04:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipTongue") then
    game.Wallets.AddResource("HERO", "DisplayShipTongue", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead04:Show()
  else
    GameObjects.ShopArtifactShipHead04:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipHook2") then
    GameObjects.ShopArtifactShipHead05:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipHook2") then
    game.Wallets.AddResource("HERO", "DisplayShipHook2", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead05:Show()
  else
    GameObjects.ShopArtifactShipHead05:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipGoldHook") then
    GameObjects.ShopArtifactShipHead09:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipGoldHook") then
    game.Wallets.AddResource("HERO", "DisplayShipGoldHook", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead09:Show()
  else
    GameObjects.ShopArtifactShipHead09:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipHook3") then
    GameObjects.ShopArtifactShipHead07:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipHook3") then
    game.Wallets.AddResource("HERO", "DisplayShipHook3", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead07:Show()
  else
    GameObjects.ShopArtifactShipHead07:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipHook4") then
    GameObjects.ShopArtifactShipHead08:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipHook4") then
    game.Wallets.AddResource("HERO", "DisplayShipHook4", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead08:Show()
  else
    GameObjects.ShopArtifactShipHead08:Hide()
  end
  if game.Wallets.HasResource("HERO", "DisplayShipGoldHook2") then
    GameObjects.ShopArtifactShipHead08:Show()
  elseif 0 < numRevealed and game.Wallets.HasResource("HERO", "ShipGoldHook2") then
    game.Wallets.AddResource("HERO", "DisplayShipGoldHook2", 1)
    game.Wallets.RemoveResource("HERO", "DisplayShipHead", 1)
    numRevealed = numRevealed - 1
    GameObjects.ShopArtifactShipHead06:Show()
  else
    GameObjects.ShopArtifactShipHead06:Hide()
  end
end
function QueenVisibility()
  if game.Wallets.HasResource("HERO", "DisplayQueenHelm") then
    GameObjects.ValkyrieDropShop:Show()
  else
    GameObjects.ValkyrieDropShop:Hide()
  end
end
function MuspelheimDiscVisability()
  local musDisk = GameObjects.Muspelheim_Disc
  if game.QuestManager.GetQuestState("Quest_SonLanguage_Muspelheim") == "Complete" then
    musDisk:Show()
    print("Show Mus Disk")
  else
    musDisk:Hide()
    print("Hide Mus Disk")
  end
end
function NiflheimDiscVisability()
  local nifDisk = GameObjects.Niflheim_Disk
  if game.QuestManager.GetQuestState("Quest_SonLanguage_Niflheim") == "Complete" then
    nifDisk:Show()
    print("Show Nif Disk")
  else
    nifDisk:Hide()
    print("Hide Nif Disk")
  end
end
function CreateBridgeSound()
  GameObjects.AirlockBifrostCrystal.Child.LuaObjectScript.PlaySoundActivateCrystal()
end
function CreateBridgeOverride()
  GameObjects.AirlockBifrostCrystal.Child.LuaObjectScript.SetCrystalObjectStates(2)
  GameObjects.PitEdgeCollision:Hide()
end
function OpenAirlockDoor()
  GameObjects.SpreadDoor_Caldera_Small.LuaObjectScript.PlayCurrentAnim(1)
end
function SetBridgeAlignment()
  local selBridgePosition = LD.GetBridgePosition()
  local frame = LD.GetRealmFrame(selBridgePosition)
  local rate = LD.GetCorrectedBridgeAnimRate(room, selBridgePosition)
  if rate == 0 then
    SetBridgeAlignmentImmediate()
  else
    room:PlayAnimToFrame(frame, rate)
  end
end
function SetBridgeAlignmentImmediate()
  hengeDisruption:JumpAnimationToFrame(0)
  hengeDisruption:PauseAnimation()
  local selBridgePosition = LD.GetBridgePosition()
  local frame = LD.GetRealmFrame(selBridgePosition)
  room:JumpAnimToFrame(frame)
  room:PauseAnim()
end
function StartHengeBridgeAnim(level)
  hengeDisruption:PlayAnimationToEnd()
  local cineLights = GameObjects.Cine_Start_490a
  cineLights:Show()
  cineLights:JumpAnimToFrame(0)
  cineLights:PlayAnimToEnd()
end
function HideHengeDisruptionLights()
  GameObjects.Cine_Start_490a:Hide()
end
function SetCurrentRealm()
  local currentRealm = LD.GetCurrentRealm()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  GameObjects.FastTravelPoint.LuaObjectScript.Enable()
  if currentRealm == "Midgard" then
    LD.Map(AirlockMidgardGrunge, function(obj)
      obj:Show()
    end)
    GameObjects.dressing_temple_center:Show()
    GameObjects.dressing_noshadow_temple_center:Show()
    GameObjects.underwater:Show()
    GameObjects.underwater_NOSHADOW:Show()
  else
    LD.Map(AirlockMidgardGrunge, function(obj)
      obj:Hide()
    end)
    GameObjects.dressing_temple_center:Hide()
    GameObjects.dressing_noshadow_temple_center:Hide()
    GameObjects.underwater:Hide()
    GameObjects.underwater_NOSHADOW:Hide()
  end
  UpdateLoadZones()
end
function TurnAllLoadZonesOff()
  midgardLoad:HideEntityVolume()
  helheimLoad:HideEntityVolume()
  jotunheimLoad:HideEntityVolume()
  alfheimLoad:HideEntityVolume()
  dragonLoad:HideEntityVolume()
  niflheimLoad:HideEntityVolume()
  muspelheimLoad:HideEntityVolume()
  eyesOnThePrizeLoad:HideEntityVolume()
  brokCatLoad:HideEntityVolume()
  brokShopLoad:HideEntityVolume()
  brokCaresLoad:HideEntityVolume()
  huldraReunionLoad:HideEntityVolume()
  midgardActivationLoad:HideEntityVolume()
  freyaLeadTheWayLoad:HideEntityVolume()
  freyaLeadTheWayMid:HideEntityVolume()
  freyaActivationLoad:HideEntityVolume()
  midMidgardLoad:HideEntityVolume()
  UnlockDoors()
end
function ForceAirlockToVanaheim()
  LD.SetBridgePosition("Midgard")
end
function SetCineActive(value)
  if value == true then
    cineActive = true
  elseif value == false then
    largeShop.LuaObjectScript.DisableCinematicTrigger()
    cineActive = false
    if cineDespawn then
      UnloadBrokVendor()
    end
  end
end
function CheckAndForceLoadBrokVendor(enableCinematicTrigger)
  if brokSpawnObject.LuaObjectScript.GetLastEnemy() == nil then
    brokIsSpawned = false
    LoadBrokVendor(enableCinematicTrigger)
  end
end
function BrokIsAllowedToSpawn()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 190 <= cineNum and cineNum <= 195 or 190 < cineNum and cineNum < 263 and LD.GetCurrentRealm() == "Alfheim" then
    return false
  elseif cineNum == 470 then
    return false
  end
  return true
end
function LoadBrokVendor(enableCinematicTrigger)
  if BrokIsAllowedToSpawn() == true and not brokIsSpawned then
    if enableCinematicTrigger == true then
      largeShop.LuaObjectScript.EnableCinematicTrigger()
    end
    brokSpawnObject.LuaObjectScript.SpawnEnemy()
    brokIsSpawned = true
    print("Spawning Brok in 120..............!")
    if game.Level.GetVariable("CompletedCineNumber") >= 510 then
      LoadSindriVendor(enableCinematicTrigger)
    end
  end
  cineDespawn = false
  return brokSpawnObject.LuaObjectScript.GetLastEnemy()
end
function LoadSindriVendor(enableCinematicTrigger)
  if not sindriIsSpawned then
    if enableCinematicTrigger == true then
      largeShop.LuaObjectScript.EnableCinematicTrigger()
    end
    sindriSpawnObject.LuaObjectScript.SpawnEnemy()
    sindriIsSpawned = true
    print("Spawning Sindri in 120..............!")
  end
  return sindriSpawnObject.LuaObjectScript.GetLastEnemy()
end
function UnloadBrokVendor()
  if not cineActive then
    if brokIsSpawned then
      print("De-Spawning Brok in 120..............!")
      local brokRef = brokSpawnObject.LuaObjectScript.GetLastEnemy()
      if brokRef ~= nil then
        print("Brok Ref is...", brokRef)
        brokRef:Destroy()
        largeShop.LuaObjectScript.DespawnTriggered()
        print("Trying to destroy..", brokRef)
        brokIsSpawned = false
      end
    end
    if sindriIsSpawned then
      print("De-Spawning Sindri in 120...........!")
      local sindriRef = sindriSpawnObject.LuaObjectScript.GetLastEnemy()
      if sindriRef ~= nil then
        print("Sindri Ref is...", sindriRef)
        sindriRef:Destroy()
        print("Trying to destroy..", sindriRef)
        sindriIsSpawned = false
      end
    end
  else
    print("Cine stopping despawn brok")
    cineDespawn = true
  end
end
function OnDoorInteractionStart()
  local realm = LD.GetCurrentRealm()
  spreadDoorRealmHelper.LuaObjectScript.UpdateRealm(realm)
end
function OnDoorStartSync_SideA()
  if hel100 then
    hel100:CallScript("Cal120_DoorStartSync_SideA")
  end
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 then
    cal050:CallScript("HideCalLakeZones")
  end
end
function OnDoorStartSync_SideB()
  if hel100 then
    hel100:CallScript("Cal120_DoorStartSync_SideB")
  end
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 510 and cal100 then
    cal100:GetGameObject("Btr_Caldera_Bridge"):CallScript("Play010_EnteringMidgard11")
  end
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 and cal100 then
    cal050:CallScript("ShowCalLakeZones")
  end
end
function StartDoorForm()
  GameObjects.FastTravelPoint.LuaObjectScript.SetVisualState(1)
end
function StartDoorForm_Sound()
  GameObjects.FastTravelPoint.LuaObjectScript.LuaHook_Sound_PlaySoundFTBuildGate()
end
function StartDoorCollapse()
  GameObjects.FastTravelPoint.LuaObjectScript.SetVisualState(3)
end
function EnableLargeShopVendorInteract()
  print("GOT ENABLE FROM SHOP INTRO for VENDOR INTERACT ")
  timer.StartLevelTimer(18, ForceVendor)
end
function ForceVendor()
  largeShop:FindSingleGOByName("vendorInteract").LuaObjectScript.EnableCinematicTrigger()
  largeShop.LuaObjectScript.VendorInteractEnable()
  largeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.DisableCinematicTrigger()
  largeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.AttemptToTriggerGreeting()
end
function FastTravelPointConfirmed()
  print("POINT SELECTED!")
end
function PlayerArrivedFromFastTravel()
  print("I just arrived from fast traveling!")
  EvaluateQuestObjectives_FastTravel()
  EvaluateBanter_OnFastTravelArrival()
  EvaluateSound_OnFastTravelArrival()
end
function Complete_Quest_StoneMason_Objective700()
  LD.CompleteQuest("Quest_StoneMason_Objective700")
  LD.CompleteQuest("Quest_StoneMason_Objective800")
  local questState = game.QuestManager.GetQuestState("Quest_StoneMason_Objective800")
  if questState == "Complete" then
    game.SubObject.SoftSave()
  end
end
local ObjectiveActions = {
  {
    ActiveQuest = "Quest_StoneMason_Objective800",
    StateRequirement = "Active",
    Action = "Complete"
  },
  {
    ActiveQuest = "Quest_Helheim_Objective000",
    StateRequirement = "Active",
    Action = "Complete"
  }
}
function EvaluateQuestObjectives_FastTravel()
  for _, v in ipairs(ObjectiveActions) do
    if v ~= nil and v.ActiveQuest ~= nil then
      local questState = game.QuestManager.GetQuestState(v.ActiveQuest)
      if questState == v.StateRequirement then
        game.QuestManager.ProposeQuestState(v.ActiveQuest, v.Action)
      end
    end
  end
end
function QuestStoneFixup()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_02")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneForestDungeon")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneForestDungeon", 1)
  end
  local questState2 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_01")
  local entryStone2 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVolundr")
  if (entryStone2 == 0 or entryStone2 == -1) and questState2 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVolundr", 1)
  end
  local questState3 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_02_Objective_01")
  local entryStone3 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra3")
  if (entryStone3 == 0 or entryStone3 == -1) and questState3 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra3", 1)
  end
  local questState4 = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  local entryStone4 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra2")
  if (entryStone4 == 0 or entryStone4 == -1) and questState4 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra2", 1)
  end
end
local BanterOnArrival = {
  {
    BanterName = "010_LandSnakes!",
    MinCine = 330,
    MaxCine = 340
  }
}
function EvaluateBanter_OnFastTravelArrival()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  for _, v in ipairs(BanterOnArrival) do
    if v ~= nil and cineNum >= v.MinCine and cineNum < v.MaxCine then
      game.Audio.PlayBanter(v.BanterName, nil, nil, false)
    end
  end
  if cineNum == 330 then
    LD.SetEntityVariable("NAR_RoadLoreAllowed", true)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  local appVersion, masterVersion = level:GetAppMasterVersion()
  if appVersion == 256 then
    local player = game.Player.FindPlayer()
    local son = game.AI.FindSon()
    local savedAvailState = son:GetAvailabilityStateRequestByName("LevelDesignScript")
    if savedAvailState ~= nil and savedAvailState.Unoccupied == false then
      local vendorCheckpointPos = engine.Vector.New(-97.141, 5.966, 85.891)
      if player:GetWorldPosition():Distance(vendorCheckpointPos) < 2 then
        son:RemoveAvailabilityRequest("LevelDesignScript")
        if savedAvailState.AvailableForSync == false or savedAvailState.AvailableForBanter == false or savedAvailState.AvailableInLevel == false or savedAvailState.AvailableForCombat == false then
          savedAvailState.Unoccupied = true
          son:SetNewAvailabilityRequest("LevelDesignScript", savedAvailState)
        end
      end
    end
    QuestStoneFixup()
  end
end
function Cal120_Bookmark_BifrostBridgeOn()
  GameObjects.BifrostBridgeZone:HideEntityVolume()
  GameObjects.AirlockBifrostCrystal.Child.LuaObjectScript.SetCrystalObjectStates(2)
  fake130doors:Hide()
end
local airlockMus = false
function airlockOpenMusic()
  OnDoorStartSync_SideA()
  if game.FindLevel("Hel100_CalderaHelDressing") then
    if game.Level.GetVariable("CompletedCineNumber") >= 390 then
      local hel050 = game.FindLevel("Hel050_Sound")
      if hel050 ~= nil then
        hel050:CallScript("musicRevisitOut")
      end
    elseif airlockMus == false then
      game.Audio.StartMusic("SND_MX_HEL_hel1_exit")
      airlockMus = true
    end
  end
end
function EvaluateSound_OnFastTravelArrival()
  if game.FindLevel("Msp100_Base") then
    game.FindLevel("Msp100_Base"):CallScript("CalderaAirLock_FTArrival")
  end
end
function OnEvaluateLoadGroup_LoadGroup_Cine()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber == 515 and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") == true then
    return "EyesOnThePrize"
  end
end
