local LD = require("design.LevelDesignLibrary")
local talkInteract
local tinkerStarted = false
local tinkerEnded = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.BtrComp_ThisIsIt.LuaObjectScript.Disable()
  GameObjects.BtrComp_PreSayGoodbye.LuaObjectScript.Disable()
  GameObjects.workBladeProp.Child:Hide()
  GameObjects.brokHammerProp.Child:Hide()
end
function OnStart(level, obj)
  GameObjects.BtrComp_RealmTravelIntro1.LuaObjectScript.DisableConsoleError("020_TempleFlipOffCritical")
end
function CanRoom3Play()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return LD.GetCurrentRealm() == "Alfheim" and 250 <= cineNum and cineNum < 263
end
function CanHelheimTravelPlay()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 383
end
function CanHelAirLockBanterPlay()
  return LD.GetCurrentRealm() == "Helheim" and game.Level.GetVariable("CompletedCineNumber") == 383
end
function CanFimbalscroteBanterPlay()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 610
end
function OnFimbalscroteBanterPlay()
  if CanFimbalscroteBanterPlay() then
    DisableTalkInteract()
    _G.SetCineActive(true)
    GameObjects.FastTravelPoint.LuaObjectScript.Disable()
    _G.LockDoors()
    local cal130 = game.FindLevel("Cal130_TempleInt")
    if cal130 ~= nil then
      cal130:CallScript("LockMidgardDoor")
    end
  end
end
function OnFimbalscroteBanterEnd()
  if CanFimbalscroteBanterPlay() then
    EnableTalkInteract()
    _G.SetCineActive(false)
    GameObjects.FastTravelPoint.LuaObjectScript.Enable()
    _G.UnlockDoors()
    local cal130 = game.FindLevel("Cal130_TempleInt")
    if cal130 ~= nil then
      cal130:CallScript("UnlockMidgardDoor")
    end
  end
end
function CanStraightBackToMidgardPlay()
  return LD.GetCurrentRealm() == "Helheim" and game.Level.GetVariable("CompletedCineNumber") == 387
end
function CanFastTravelTinkerPlay()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 387
end
function Can020_TempleFlipOffCriticalPlay()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 510 and game.QuestManager.GetQuestState("Quest_Caldera_Objective700") ~= "Complete"
end
function SetFastTravelStage2()
  game.Audio.SetBanterFact("040_fastTravel_Increment", 0)
  if game.Level.GetVariable("CompletedCineNumber") == 387 then
    LD.GiveFastTravelStageTwo()
  end
end
function CanFastTravelTinker_02_Play()
  return LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 387
end
function SetupFastTravelTinker()
  if tinkerStarted == false then
    tinkerStarted = true
    DisableTalkInteract()
    GameObjects.FastTravelPoint.LuaObjectScript.Disable()
  end
end
function OnEndFastTravelTinker()
  if tinkerEnded == false then
    tinkerEnded = true
    EnableTalkInteract()
    GameObjects.FastTravelPoint.LuaObjectScript.Enable()
    game.Audio.SetBanterFact("canPlayTinker04", true, "Infinite")
  end
end
function GetTalkInteract()
  if talkInteract == nil then
    talkInteract = GameObjects.LargeShop:FindSingleGOByName("TalkInteract_LS")
  end
end
function DisableTalkInteract()
  GetTalkInteract()
  talkInteract.LuaObjectScript.EnableCinematicTrigger()
end
function EnableTalkInteract(playGreeting)
  GetTalkInteract()
  talkInteract.LuaObjectScript.DisableCinematicTrigger()
  if playGreeting then
    talkInteract.LuaObjectScript.AttemptToTriggerGreeting()
  end
end
function ShopIntroDone()
  DisableTalkInteract()
  GameObjects.POI_FastTravelIntro.LuaObjectScript.SetupHintSeq()
  GameObjects.Btr_FastTravelIntro_LockedIn.Child.LuaObjectScript.ResetLookAtMonitor()
  GameObjects.Btr_FastTravelIntro_LockedIn.Child.LuaObjectScript.Enable()
end
function OnBanterRealmTravelRoom3Fired()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 263 <= cineNum and cineNum < 515 then
    GameObjects.BtrComp_RealmTravelRoom3.LuaObjectScript.Disable()
  elseif CanPlaySnakeBellyOffCrit1() then
    GameObjects.BtrComp_PreSayGoodbye.LuaObjectScript.Enable()
  end
end
function OnBanterRealmTravelRoom3Finished()
  if (game.Wallets.GetResourceValue("HERO", "MuspelheimCipherPiece") == 4 or LD.GetEntityVariable("CAL_RealmUnlocked_Muspelheim")) and CanRoom3Play() then
    game.Audio.PlayBanter("RealmTravelRoom3_Mus")
  end
end
function CanPlaySnakeBellyOffCrit1()
  return LD.GetEntityVariable("CompletedCineNumber") == 520 and LD.GetEntityVariable("CAL_MimirEyeAcquired") == false
end
function CanPlayCoverOurTracks()
  return LD.GetEntityVariable("CompletedCineNumber") == 515 and LD.GetEntityVariable("_GBL_JotTowerRevealed") == true
end
function HasMimirsEye()
  return LD.GetEntityVariable("CompletedCineNumber") == 570 and LD.GetEntityVariable("CAL_MimirEyeAcquired") == true
end
function EnablePreSayingGoodbye()
  if HasMimirsEye() then
    GameObjects.BtrComp_PreSayGoodbye.LuaObjectScript.Enable()
  end
end
