local LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function CineDoorBowstringGift()
  if game.Level.GetVariable("FreyaLTWStage") == 50 then
    local doorObj = GameObjects.SpreadDoor_Caldera_AirLock.Child
    local player = game.Player.FindPlayer()
    local branchName = "BRA_DoorSpreadFreyaOpen"
    doorObj.LuaObjectScript.EnableCinematicTrigger(true)
    player:RequestInteract(doorObj)
    LD.PlayApproach_GroupSync(doorObj, {
      {player, branchName},
      {
        game.AI.FindSon(),
        branchName
      },
      {
        LD:FindFreya(),
        branchName,
        {keepEvaluatingPath = true}
      }
    }, "DoorSpreadFreyaOpen", true, "synchJointFront", {completion_percentage = 0.7})
    local freyaChar = LD.FindFreya()
    if freyaChar ~= nil then
      freyaChar:CallScript("ForceForwardSplineNavState")
    end
    local freyaLTW = game.FindLevel("FreyaLTW")
    if freyaLTW ~= nil then
      _G.LockDoors()
      freyaLTW:CallScript("LTW_Airlock_Start")
    end
    local cal100 = game.FindLevel("Cal100_Hub")
    if cal100 ~= nil then
      cal100:CallScript("FreyaLTWBridgeDone")
    end
  end
end
function CineDoorInteraction()
  local alf150 = game.FindLevel("Alf150_BridgeDark")
  local cineObj
  local doorObjchild = GameObjects.SpreadDoor_Caldera_AirLock.Child
  local freyaRef = LD:FindFreya()
  if freyaRef ~= nil then
    freyaRef:ModifyCreatureMotion()
  end
  if alf150 ~= nil and game.Level.GetVariable("CompletedCineNumber") >= 187 and game.Level.GetVariable("CompletedCineNumber") < 210 then
    doorObjchild.LuaObjectScript.EnableCinematicTrigger()
    cineObj = alf150:FindSingleGameObject("Cine_AlfheimHenge")
    cineObj:CallScript("SetupCineSequence", doorObjchild)
    alf150:CallScript("Animate150Trees")
  end
  local ltwStage = game.Level.GetVariable("FreyaLTWStage")
  if 0 < ltwStage and ltwStage < 500 then
    local freyaLTW = game.FindLevel("FreyaLTW")
    if freyaLTW ~= nil then
      freyaLTW:CallScript("TurnOffSonLTW")
      freyaLTW:CallScript("LTW_DONE")
    else
      game.Level.SetVariable("FreyaLTWStage", 500)
    end
  end
end
