local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kraActor, sonActor, brokActor, meatProp, meatProp2, hammerProp, bladeProp, bladePropLoc
local synchJoint = "BrokCares_SynchJoint"
local cineLights, cineEnterCamera_BrokCares
local firedSeq = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SetupProps()
  TryFireSeq()
end
function OnUpdate()
  if cineEnterCamera_BrokCares ~= nil then
    cineEnterCamera_BrokCares:Update()
  end
end
function SpawnBrok()
  local brokRef
  brokRef = _G.LoadBrokVendor(true)
  _G.SetCineActive(true)
  return brokRef
end
function SetupActors()
  kraActor = actor.Actor.New("KRATOS ACTOR: BROK CARES", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON ACTOR: BROK CARES", game.AI.FindSon)
  brokActor = actor.Actor.New("BROK ACTOR: BROK CARES")
  brokActor:SetSpawnFunction(SpawnBrok)
end
function SetupProps()
  if meatProp == nil then
    meatProp = GameObjects.meatProp.Child
    meatProp2 = GameObjects.meatProp2.Child
    hammerProp = GameObjects.brokHammerProp.Child
    bladeProp = GameObjects.workBlade.Child
    cineLights = GameObjects.Cine_Start_320
    cineLights:Hide()
    meatProp:Hide()
    meatProp2:Hide()
  end
end
function RestoreProps()
  meatProp:Hide()
  meatProp2:Hide()
  bladeProp:SetWorldPosition(bladePropLoc)
end
function HideHammer()
  hammerProp:Hide()
end
function ShowAndAlignProps()
  meatProp:Show()
  meatProp2:Show()
  local jointIndex = thisObj:GetJointIndex(synchJoint)
  local jointFace = thisObj:GetWorldJointForward(jointIndex)
  local jointPos = thisObj:GetWorldJointPosition(jointIndex)
  hammerProp:SetWorldPosition(jointPos)
  hammerProp:SetWorldFacing(jointFace)
  hammerProp:Show()
  hammerProp:JumpAnimationToFrame(0, {
    Animation = "narCalBrokCares000Cine"
  })
  hammerProp:PauseAnimation()
  meatProp2:JumpAnimationToFrame(0, {
    Animation = "narCalBrokCares000Cine1"
  })
  meatProp2:PauseAnimation()
  bladePropLoc = bladeProp:GetWorldPosition()
  bladeProp:SetWorldPosition(engine.Vector.New(0, 0, 0))
end
function TryFireSeq()
  if CanSeqFire() then
    SetupProps()
    SetupActors()
    SetupSeq()
  end
end
function OnInteractStart(level, obj, creature)
  print("Interact started BrokCares............ ", creature)
  if creature == brokActor:GetCreature() then
    SetupBrokIdleSeq()
  end
end
function SetupBrokIdleSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "BrokCaresIdle")
  local idleTab = {
    {Obj = meatProp}
  }
  seq:ActorSync(brokActor, {
    Slaves = idleTab,
    Branch = "BRA_BrokCaresIdle",
    ReferenceJoint = "BrokCares_SynchJoint"
  })
  seq:StartSequence()
end
function SetupSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "BrokCares")
  local slaveTab = {
    {Actor = brokActor},
    {Actor = sonActor},
    {
      Obj = meatProp,
      Anim = "narCalBrokCares000Cine",
      TweenTime = 0.2
    },
    {
      Obj = meatProp2,
      Anim = "narCalBrokCares000Cine1"
    },
    {
      Obj = hammerProp,
      Anim = "narCalBrokCares000Cine"
    }
  }
  firedSeq = true
  seq:SetPostSkipMusic("SND_MX_FOOT_start_master")
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Cal120_AI_BrokCares") ~= nil
  end)
  seq:SpawnActorAndWait(brokActor)
  seq:Do(ShowAndAlignProps)
  seq:Do(function()
    brokActor:GetCreature():EndInteract()
    brokActor:GetCreature():RequestInteract(thisObj)
  end)
  seq:Do(AddArrivalMarker)
  seq:WaitForFunctionTrue(PlayerInCal120)
  local requestSeq = LD.CreateCineSequence(thisLevel, thisObj, "BrokCares InteractRequest")
  requestSeq:WaitForFunctionTrue(function()
    return not player:IsInteracting()
  end)
  requestSeq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(StartCineEnter_BrokCares)
  seq:BranchSequence(requestSeq)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_BrokCares",
    ReferenceJoint = synchJoint,
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius
  })
  seq:Do(PlayCineLights)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_BrokCares",
    ReferenceJoint = synchJoint
  })
  seq:Do(function()
    seq:MarkAbleToSkip()
  end)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(brokActor)
  seq:Do(function()
    seq:EndSkipIfActive()
  end)
  seq:Do(BranchBrokToTableIdle)
  seq:Do(HideHammer)
  seq:Do(function()
    cineLights:Hide()
  end)
  seq:SetCompletedCineNumber(320)
  seq:Do(function()
    GameObjects.Btr_Cal120.LuaObjectScript.DisableTalkInteract()
  end)
  seq:WaitSeconds(1)
  seq:Do(CompassOn)
  seq:Do(_G.BrokCaresDone)
  seq:Do(RemoveArrivalMarker)
  seq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "11_Caldera_010_ReturnFromPeaks"]
    tableEntry.OverrideObject = GameObjects.CheckpointOverride
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  seq:Do(function()
    game.Audio.PlayBanter("SipOrSup", PostBanterDone, false, false)
  end)
  seq:WaitForFunctionTrue(function()
    return ND.FindBrok() == nil
  end)
  seq:Do(RestoreProps)
  seq:Do(ClearShopHammerRestriction)
  seq:StartSequence()
end
function CanSeqFire()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return 310 <= cineNum and cineNum < 320 and not firedSeq
end
function PlayerInCal120()
  return player.GroundLevel == thisLevel
end
function AddArrivalMarker()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveArrivalMarker()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function PlayCineLights()
  cineLights:JumpAnimToFrame(0)
  cineLights:Show()
  cineLights:PlayAnimToEnd()
end
function CompassOn()
  game.Compass.SetDesignerForcedHide(false)
end
function StartCineEnter_BrokCares()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BrokCares = CCEC.CineEnterCamera.New("ENV_CineEnter_BrokCares", 12.3)
  cineEnterCamera_BrokCares:SetCallback(DestroyCineEnter_BrokCares)
  cineEnterCamera_BrokCares:Start()
end
function DestroyCineEnter_BrokCares()
  cineEnterCamera_BrokCares = nil
  game.SubObject.Sleep(thisObj)
end
function BranchBrokToTableIdle()
  GameObjects.LargeShop.LuaObjectScript.StartCounterRequest(brokActor:GetCreature())
  GameObjects.LargeShop.LuaObjectScript.SetPreventHammering(true)
end
function ClearShopHammerRestriction()
  GameObjects.LargeShop.LuaObjectScript.SetPreventHammering(false)
end
function PostBanterDone()
  _G.BrokCaresPostBanterDone()
  LD.CallFunctionAfterDelay(EnableTalkInteract, 1.5)
end
function EnableTalkInteract()
  GameObjects.LargeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.DisableCinematicTrigger()
  GameObjects.LargeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.AttemptToTriggerGreeting()
end
