local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local monitors = require("level.MonitorLibrary")
local actor = require("narrative.actor")
local TUT = require("game.GlobalTutorials")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kraActor, brokActor, cine_lights_383, cineEnterCamera_BrokSavesCat
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  InitializeVariables()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  cine_lights_383 = GameObjects.Cine_Start_383
  HideCineLights()
  TryFireSeq()
end
function OnUpdate()
  if cineEnterCamera_BrokSavesCat ~= nil then
    cineEnterCamera_BrokSavesCat:Update()
  end
end
function InitializeVariables()
end
function SetupActors()
  kraActor = actor.Actor.New("KRATOS ACTOR: BROK SAVES CAT", game.Player.FindPlayer)
  brokActor = actor.Actor.New("BROK ACTOR: BROK SAVES CAT")
  brokActor:SetSpawnFunction(SpawnBrok)
end
function SpawnBrok()
  local brokRef
  brokRef = _G.LoadBrokVendor()
  _G.SetCineActive(true)
  return brokRef
end
function TryFireSeq()
  if CanSeqFire() then
    SetupActors()
    SetupCineSequence()
  end
end
function SetupCineSequence()
  local cineMainSeq = LD.CreateCineSequence(thisLevel, thisObj, "brokSavesCatMain")
  local slaveTab = {
    {Actor = brokActor}
  }
  cineMainSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  cineMainSeq:Do(AddArrivalMarker)
  cineMainSeq:SpawnActorAndWait(brokActor)
  cineMainSeq:WaitForFunctionTrue(PlayerInCal120)
  cineMainSeq:Do(StartCineEnter_BrokSavesCat)
  cineMainSeq:Do(game.Cinematics.EnableCinematicMode)
  cineMainSeq:Do(function()
    cineMainSeq:MarkAbleToSkip()
  end)
  cineMainSeq:WaitForLoadCheck("Cal120_AI_BrokSavesCat")
  cineMainSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_BrokSavesCat",
    ReferenceJoint = "BrokSavesCat_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.ArrivalRadius,
    weapon_state = "bare",
    strafe_distance = 0.5
  })
  cineMainSeq:Do(function()
    brokActor:GetCreature():EndInteract()
  end)
  cineMainSeq:Do(PlayCineLights)
  cineMainSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_BrokSavesCat",
    ReferenceJoint = "BrokSavesCat_SyncJoint"
  })
  cineMainSeq:Do(RemoveArrivalMarker)
  cineMainSeq:WaitForActorFinishMove(kraActor, "MOV_BrokSavesCat")
  cineMainSeq:Do(function()
    cineMainSeq:EndSkipIfActive()
  end)
  cineMainSeq:Do(game.Cinematics.DisableCinematicMode)
  cineMainSeq:StopPuppetingActor(kraActor)
  cineMainSeq:WaitUntilActorAnimPastPercentage(brokActor, 0.99)
  cineMainSeq:Do(BranchBrokToTableIdle)
  cineMainSeq:StopPuppetingActor(brokActor)
  cineMainSeq:SetCompletedCineNumber(383)
  cineMainSeq:Do(HideCineLights)
  cineMainSeq:Do(BOOKMARK_18_Caldera_010_RealmTravelToHelheim)
  cineMainSeq:Do(function()
    _G.BrokCatDone()
  end)
  cineMainSeq:Do(function()
    game.Audio.PlayBanter("010_EyeOnYou", ShowHint)
  end)
  cineMainSeq:StartSequence()
end
function PlayerInCal120()
  return player.GroundLevel == thisLevel
end
function AddArrivalMarker()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveArrivalMarker()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function BranchBrokToTableIdle()
  GameObjects.LargeShop.LuaObjectScript.StartCounterRequest(brokActor:GetCreature())
end
function ShowHint()
  TUT.Cal120_BrokImproveBlades_Tutorial()
end
function PlayCineLights()
  cine_lights_383:Show()
  cine_lights_383:JumpAnimToFrame(0)
  cine_lights_383:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_383:Hide()
end
function CanSeqFire()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  return completedCineNum < 383 and 380 <= completedCineNum
end
function BOOKMARK_18_Caldera_010_RealmTravelToHelheim()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "18_Caldera_010_RealmTravelToHelheim"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function StartCineEnter_BrokSavesCat()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BrokSavesCat = CCEC.CineEnterCamera.New("ENV_CineEnter_BrokSavesCat", 7)
  cineEnterCamera_BrokSavesCat:SetCallback(DestroyCineEnter_BrokSavesCat)
  cineEnterCamera_BrokSavesCat:Start()
end
function DestroyCineEnter_BrokSavesCat()
  cineEnterCamera_BrokSavesCat = nil
  game.SubObject.Sleep(thisObj)
end
