local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kraActor, sonActor, brokActor, hammerProp, bladeProp, cineEnterCamera_BrokShop, cine_lights_263
local synchJoint = "BrokShop_SynchJoint"
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
end
function OnStart(level, obj)
  thisObj:FindSingleGOByName("NoGoZone"):Hide()
  cine_lights_263 = GameObjects.Cine_Start_263
  HideCineLights()
  SetupProps()
  if InCineRange() then
    SetupActors()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function SpawnBrok()
  local brokRef
  brokRef = _G.LoadBrokVendor(true)
  _G.SetCineActive(true)
  return brokRef
end
function OnUpdate(level, obj)
  if cineEnterCamera_BrokShop ~= nil then
    cineEnterCamera_BrokShop:Update()
  end
end
function SetupProps()
  hammerProp = GameObjects.brokHammer.Child
  bladeProp = GameObjects.workBlade.Child
end
function SetupActors()
  kraActor = actor.Actor.New("BROK SHOP: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("BROK SHOP: Son Actor", game.AI.FindSon)
  brokActor = actor.Actor.New("BROK SHOP: Brok Actor")
  brokActor:SetSpawnFunction(SpawnBrok)
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Brok Shop Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = brokActor},
    {
      Obj = bladeProp,
      Anim = "narCalBrokShop010"
    },
    {
      Obj = hammerProp,
      Anim = "narCalBrokShop010"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:Do(function()
    thisObj:FindSingleGOByName("NoGoZone"):Show()
  end)
  cineSeq:Do(DisablePrepZone)
  cineSeq:SpawnActorAndWait(brokActor)
  cineSeq:Do(function()
    game.Player.FindPlayer():SetAccelerationOverride(1.2)
  end)
  cineSeq:Do(function()
    game.Player.FindPlayer():SetDecelerationOverride(1.2)
  end)
  local requestSeq = LD.CreateCineSequence(thisLevel, thisObj, "BrokShop InteractRequest")
  requestSeq:WaitForFunctionTrue(function()
    return not player:IsInteracting()
  end)
  requestSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:BranchSequence(requestSeq)
  cineSeq:Do(function()
    brokActor:GetCreature():EndInteract()
  end)
  cineSeq:Do(StartCineEnter_BrokShop)
  cineSeq:WaitForLoadCheck("Cal120_AI_BrokShop")
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_BrokShop",
    ReferenceJoint = synchJoint,
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.ArrivalRadius,
    foot = game.Creature.Foot.kRight,
    weapon_state = "bare_on_back"
  })
  cineSeq:Do(AlignProps)
  cineSeq:Do(function()
    thisObj:FindSingleGOByName("NoGoZone"):Hide()
  end)
  cineSeq:Do(PlayCineLights)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_BrokShop",
    ReferenceJoint = synchJoint
  })
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.847)
  cineSeq:Do(RealignProps)
  cineSeq:WaitUntilActorAnimPastPercentage(brokActor, 0.94)
  cineSeq:Do(BranchBrokToTableIdle)
  cineSeq:StopPuppetingActor(brokActor)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(function()
    game.Player.FindPlayer():ClearAccelerationOverride()
  end)
  cineSeq:Do(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end)
  cineSeq:Do(function()
    GameObjects.LargeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.DisableCinematicTrigger()
  end)
  cineSeq:Do(function()
    GameObjects.LargeShop:FindSingleGOByName("TalkInteract_LS").LuaObjectScript.AttemptToTriggerGreeting()
  end)
  cineSeq:Do(NewGamePlusRecipe)
  cineSeq:WaitSeconds(1)
  cineSeq:SetCompletedCineNumber(263)
  cineSeq:Do(function()
    _G.BrokShopDone()
  end)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(RemoveApproachMarker)
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:StartSequence()
end
function NewGamePlusRecipe()
  if game.GetNewGamePlus() == true then
    if game.Wallets.HasRecipe("HERO", "Recipe_PurchaseEpicRune_Tier7") then
      game.UI.ClearNotification("Recipe", "Recipe_PurchaseEpicRune_Tier7")
      game.Wallets.RemoveRecipe("HERO", "Recipe_PurchaseEpicRune_Tier7")
    end
    LD.AddRecipe_Safe("HERO", "Recipe_PurchaseEpicRune_Tier8")
  end
end
function AddApproachMarker()
  if not player:HasMarker("ReadyForBrokShop") then
    player:AddMarker("ReadyForBrokShop")
  end
end
function RemoveApproachMarker()
  if player:HasMarker("ReadyForBrokShop") then
    player:RemoveMarker("ReadyForBrokShop")
  end
end
function DisablePrepZone()
  GameObjects.EntityZoneEvent_BrokShopPrep.Child.LuaObjectScript.Disable()
end
function RealignProps()
  GameObjects.LargeShop.LuaObjectScript.InitializeProps(hammerProp.Parent)
  GameObjects.LargeShop.LuaObjectScript.InitializeProps(bladeProp.Parent)
end
function BranchBrokToTableIdle()
  GameObjects.LargeShop.LuaObjectScript.StartCounterRequest(brokActor:GetCreature())
end
function InCineRange()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return cineNum < 263 and 250 <= cineNum
end
function CanSeqFire()
  return InCineRange() and LD.GetCurrentRealm() == "Midgard"
end
function AlignProps()
  local jointIndex = thisObj:GetJointIndex(synchJoint)
  local jointFace = thisObj:GetWorldJointForward(jointIndex)
  local jointPos = thisObj:GetWorldJointPosition(jointIndex)
  hammerProp:SetWorldPosition(jointPos)
  hammerProp:SetWorldFacing(jointFace)
  bladeProp:SetWorldPosition(jointPos)
  bladeProp:SetWorldFacing(jointFace)
end
function PlayCineLights()
  cine_lights_263:Show()
  cine_lights_263:JumpAnimToFrame(0)
  cine_lights_263:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_263:Hide()
end
function StartCineEnter_BrokShop()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BrokShop = CCEC.CineEnterCamera.New("ENV_CineEnter_narCalBrokShop010", 10)
  cineEnterCamera_BrokShop:SetCallback(DestroyCineEnter_BroShop)
  cineEnterCamera_BrokShop:Start()
end
function DestroyCineEnter_BroShop()
  cineEnterCamera_BrokShop = nil
  game.SubObject.Sleep(thisObj)
end
