local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, player
local bowstringGiftCompleted = false
local freyaAIObject, arrowProp
local bSubmitArrowReleasedCamera = false
local bFreyaStillHasArrowInHerHands = false
local freyaObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
end
function OnFirstStart(level, obj)
  DisableSlowZones()
end
function OnUpdate()
  SubmitFreyaGiftCamera()
end
function OnStart(level, obj)
  SetupProps()
  if not bowstringGiftCompleted and game.Level.GetVariable("CompletedCineNumber") == 195 then
    BuildBowstringGiftSeq()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {bowstringGiftCompleted = bowstringGiftCompleted}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bowstringGiftCompleted = savedInfo.bowstringGiftCompleted
end
function SetupProps()
  arrowProp = GameObjects.arrowProp.Child
  HideProps()
end
function HideProps()
  arrowProp:Hide()
end
function ShowProps()
  arrowProp:Show()
end
function BuildBowstringGiftSeq()
  local freyaActor = actor.Actor.New("Freya", LD.FindFreya)
  local sonActor = actor.Actor.New("Son", game.AI.FindSon)
  local kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "BowstringGift")
  local approachActorTable = {
    {Obj = arrowProp}
  }
  local sceneActorTable = {
    {Actor = sonActor},
    {Obj = arrowProp}
  }
  seq:WaitForFunctionTrue(function()
    return LD.FindFreya() ~= nil
  end)
  seq:WaitForActorInZone(freyaActor, thisObj)
  seq:Do(DisableFreLTW)
  seq:Do(EnableSlowZones)
  seq:Do(InitializeDesignerCamera)
  seq:ActorForceApproachAndWait(freyaActor, {
    Branch = "BRA_BowstringGiftEnter",
    ReferenceJoint = "BowstringGift_SynchJoint",
    speed = ND.FreyaWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.ArrivalRadius
  })
  seq:Do(ShowProps)
  seq:ActorSync(freyaActor, {
    Slaves = approachActorTable,
    Branch = "BRA_BowstringGiftEnter",
    ReferenceJoint = "BowstringGift_SynchJoint"
  })
  seq:Do(EnableSonCA)
  seq:Do(DisableSonLTW)
  seq:WaitForActorInZone(kratosActor, thisObj)
  seq:StartPOIMoment()
  seq:Do(DisableFastTravel)
  seq:Do(DisableSonCA)
  seq:ActorSync(freyaActor, {
    Slaves = sceneActorTable,
    Branch = "BRA_BowstringGiftScene",
    ReferenceJoint = "BowstringGift_SynchJoint"
  })
  seq:WaitSeconds(1)
  seq:Do(function()
    game.Audio.PlayBanter("BowstringGift_Fire")
    LD.CallFunctionAfterDelay(function()
      GameObjects.AirlockBifrostCrystal.Child.LuaObjectScript.PlaySoundActivateCrystal()
    end, 0.4)
  end)
  seq:WaitSeconds(1)
  seq:Do(function()
    GameObjects.AirlockBifrostCrystal.Child.LuaObjectScript.SetCrystalObjectStates(2)
  end)
  seq:WaitSeconds(1)
  seq:Do(function()
    GameObjects.PitEdgeCollision:Hide()
    game.Compass.SetDesignerForcedHide(true)
    game.Audio.PlayBanter("BowstringGift")
  end)
  seq:WaitUntilActorAnimPastPercentage(freyaActor, 0.95)
  seq:Do(EnableLTW)
  seq:WaitForActorPuppeteerComplete(freyaActor)
  seq:Do(HideProps)
  seq:EndPOIMoment()
  seq:Do(EnableFastTravel)
  seq:StopPuppetingActor(freyaActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(SleepTheScriptAgain)
  seq:Do(DelayedSlowZoneDisable)
  seq:Do(function()
    bowstringGiftCompleted = true
    game.Audio.PlayBanter("BowstringGift2")
  end)
  seq:StartSequence()
end
function SpawnFreya()
  local freObj = LD.FindFreya()
  if freObj ~= nil then
    return
  else
    local objName = "POI_BowstringGift"
    local jointName = "BowstringGift_SynchJoint"
    local spawnPosVector = LD.GetWorldJointPosition(objName, jointName)
    local spawnDirVector = LD.GetWorldJointForward(objName, jointName)
    LD.SpawnFreyaAtVector(spawnPosVector, spawnDirVector)
  end
end
function EnableLTW()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("LTW_Airlock_Resume")
  end
end
function DisableFreLTW()
  print("freya in zone")
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("TurnOffFreyaLTW")
  end
end
function DisableSonLTW()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil then
    calFre100:CallScript("TurnOffSonLTW")
  end
end
function EnableSonCA()
  GameObjects.CA_IdleBehavior_BowstringGift.LuaObjectScript.Enable()
end
function DisableSonCA()
  GameObjects.CA_IdleBehavior_BowstringGift.LuaObjectScript.Disable()
end
function DisableFastTravel()
  GameObjects.FastTravelPoint.Child.LuaObjectScript.Disable()
end
function EnableFastTravel()
  GameObjects.FastTravelPoint.Child.LuaObjectScript.Enable()
end
function DisableSlowZones()
  GameObjects.SlowerZone:Hide()
  GameObjects.SlowestZone:Hide()
  GameObjects.SlowerZone_Sides:Hide()
end
function DelayedSlowZoneDisable()
  timers.StartLevelTimer(3.5, DisableSlowZones)
end
function SleepTheScriptAgain()
  game.SubObject.Sleep(thisObj)
end
function EnableSlowZones()
  GameObjects.SlowerZone:Show()
  GameObjects.SlowestZone:Show()
  GameObjects.SlowerZone_Sides:Show()
end
function InitializeDesignerCamera()
  game.SubObject.Wake(thisObj)
  bSubmitArrowReleasedCamera = false
  bFreyaStillHasArrowInHerHands = true
  player = game.Player.FindPlayer()
end
function LookAtTheFloatingArrow()
  local behavior = "FSE_SWAY_POI_BOWSTRINGGIFT_ONEOFF"
  game.FX.SubmitEffect({
    EffectName = behavior,
    Duration = 5,
    TweenInTime = 1.2,
    TweenInEaseIn = 1,
    TweenInEaseOut = 1,
    TweenOutTime = 2.2,
    TweenOutEaseIn = 1,
    TweenOutEaseOut = 1
  })
end
function SubmitFreyaGiftCamera()
  if bSubmitArrowReleasedCamera == true and freyaObj ~= nil then
    local fActiveMovePercent = freyaObj:GetActiveMovePercent()
    if 0.14 < fActiveMovePercent and fActiveMovePercent < 0.22 then
      game.Camera.SubmitCameraByName("PLYR_NAR_FreyaTravelRoom_022FK_Set")
    elseif 0.22 < fActiveMovePercent then
      game.Camera.SubmitCameraByName("PLYR_NAR_FreyaTravelRoom_030_Set")
    end
  end
  if bFreyaStillHasArrowInHerHands == true then
    if freyaObj == nil then
      freyaObj = ND.FindFreya()
    end
    if player:IsInsideEntityZone("SlowestZone") and freyaObj ~= nil then
      local fActiveMovePercent = freyaObj:GetActiveMovePercent()
      game.Camera.SubmitCameraByName("PLYR_NAR_FreyaTravelRoom_010_Set")
      if freyaObj:IsPlayingMove("MOV_BowstringGiftScene") then
        game.Camera.SubmitCameraByName("PLYR_NAR_FreyaTravelRoom_020_Set")
        if 0.05 < fActiveMovePercent then
          bSubmitArrowReleasedCamera = true
        end
        if 0.8 < fActiveMovePercent then
          bSubmitArrowReleasedCamera = false
          bFreyaStillHasArrowInHerHands = false
        end
      end
    end
  end
end
