local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local thisObj, thisLevel, son, shopInteract, brkActor, sinActor, workBladeProp
local synchJoint = "EyesOnThePrize_SynchJoint"
local camOneShot_QuestStarted, sinCreature, nearbySinRef, nearbyBrkRef
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  shopInteract = GameObjects.LargeShop:FindSingleGOByName("vendorInteract")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  InitializeVariables()
  if CanSeqFire() then
    GameObjects.Btr_Cal120.LuaObjectScript.DisableTalkInteract()
  end
end
function InitializeVariables()
  local currentCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if game.Level.GetVariable("CompletedCineNumber") == 515 then
    SetupActors()
  end
  SetupProps()
end
function GetNearbyBrok()
  if nearbyBrkRef ~= nil then
    return nearbyBrkRef
  end
  local objArray = game.World.FindGameObjectsByMarker("brok00", game.Player.FindPlayer().WorldPosition, 10)
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil then
      nearbyBrkRef = obj:GetCreature():GetAI()
      if nearbyBrkRef ~= nil then
        return nearbyBrkRef
      end
    end
  end
  return nil
end
function GetNearbySindri()
  if nearbySinRef ~= nil then
    return nearbySinRef
  end
  local objArray = game.World.FindGameObjectsByMarker("sindri00", game.Player.FindPlayer().WorldPosition, 10)
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil then
      nearbySinRef = obj:GetCreature():GetAI()
      if nearbySinRef ~= nil then
        return nearbySinRef
      end
    end
  end
  return nil
end
function SetupActors()
  brkActor = actor.Actor.New("BROK ACTOR: EYES PRIZE", GetNearbyBrok)
  sinActor = actor.Actor.New("SINDRI ACTOR: EYES PRIZE", GetNearbySindri)
end
function SetupProps()
  workBladeProp = GameObjects.workBladeGrindStone.Child
end
function AlignProps()
  local jointIndex = thisObj:GetJointIndex(synchJoint)
  local jointFace = thisObj:GetWorldJointForward(jointIndex)
  local jointPos = thisObj:GetWorldJointPosition(jointIndex)
  workBladeProp:SetWorldPosition(jointPos)
  workBladeProp:SetWorldFacing(jointFace)
end
function CanSeqFire()
  local currentCineNumber = game.Level.GetVariable("CompletedCineNumber")
  return currentCineNumber == 515 and game.Level.GetVariable("CAL_NAR_EyesOnThePrize") == false and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed")
end
function TrySetup()
  if CanSeqFire() then
    shopInteract.LuaObjectScript.EnableCinematicTrigger()
    SetupCineSequence()
  end
end
function SetupCineSequence()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "POI_EyesOnThePrize")
  local slaveTab = {
    {Actor = brkActor},
    {Obj = workBladeProp}
  }
  seq:Do(_G.LockDoors)
  seq:Do(AlignProps)
  seq:Do(function()
    GameObjects.EyesOnThePrize_Collision:Show()
  end)
  seq:ActorSync(sinActor, {
    Slaves = slaveTab,
    Branch = "BRA_EyesOnThePrize",
    ReferenceJoint = synchJoint
  })
  seq:Do(SonApproach)
  seq:Do(game.Cinematics.EnableCinematicMode)
  seq:StartPOIMoment(0.25)
  seq:Do(CameraLookAt_QuestionStarted)
  seq:WaitUntilActorAnimPastPercentage(brkActor, 0.87)
  seq:Do(function()
    GameObjects.EyesOnThePrize_Collision:Hide()
  end)
  seq:WaitUntilActorAnimPastPercentage(brkActor, 0.97)
  seq:Do(SonExit)
  seq:WaitForActorFinishMove(brkActor, "MOV_EyesOnThePrize")
  seq:Do(EyesOnPrizeComplete)
  seq:EndPOIMoment()
  seq:Do(game.Cinematics.DisableCinematicMode)
  seq:StopPuppetingActor(brkActor)
  seq:Do(EnableShop)
  seq:WaitSeconds(2)
  seq:Do(PlayPointOfNoReturn)
  seq:WaitSeconds(8)
  seq:Do(function()
    if GetSindriCreature() ~= nil then
      GetSindriCreature():TriggerMoveEvent("LE_EyesOnThePrizeExit")
    end
  end)
  seq:WaitForFunctionTrue(function()
    return GetSindriCreature() == nil or GetSindriCreature():IsPlayingMove("MOV_EyesOnThePrizeLoopExit")
  end)
  seq:StopPuppetingActor(sinActor)
  seq:Do(DestroyOneShot_QuestStarted)
  seq:StartSequence()
end
function PlayPointOfNoReturn()
  game.Audio.PlayBanter("065_PointOfNoReturn", EnableTalkInteract)
end
function SonApproach()
  GameObjects.vendorInteract.LuaObjectScript.SyncSon()
end
function SonExit()
  GameObjects.vendorInteract.LuaObjectScript.ClearSonPuppeteer()
  son:TriggerMoveEvent("ExitCrafting")
  GameObjects.vendorInteract.LuaObjectScript.RemoveSonOccupied()
  if son:HasMarker("InVendor") then
    son:RemoveMarker("InVendor")
  end
end
function EnableShop()
  GameObjects.LargeShop.LuaObjectScript.VendorInteractEnable()
  BranchBrokToTableIdle()
end
function BranchBrokToTableIdle()
  GameObjects.LargeShop.LuaObjectScript.StartCounterRequest(brkActor:GetCreature())
end
function EyesOnPrizeComplete()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective820", "Complete")
  game.Level.SetVariable("CAL_NAR_EyesOnThePrize", true)
  shopInteract.LuaObjectScript.DisableCinematicTrigger()
  GameObjects.BtrComp_RealmTravelRoom3.LuaObjectScript.Enable()
  _G.UnlockDoors()
end
function EnableTalkInteract()
  GameObjects.Btr_Cal120.LuaObjectScript.EnableTalkInteract(true)
end
function GetSindriCreature()
  if sinCreature == nil and sinActor ~= nil then
    sinCreature = sinActor:GetCreature()
  end
  return sinCreature
end
function OnUpdate(level)
  if camOneShot_QuestStarted ~= nil then
    camOneShot_QuestStarted:Update()
  end
end
function DestroyOneShot_QuestStarted()
  camOneShot_QuestStarted = nil
  game.SubObject.Sleep(thisObj)
end
function CameraLookAt_QuestionStarted()
  game.SubObject.Wake(thisObj)
  camOneShot_QuestStarted = CCOS.OneShotCamera.New("PLYR_NAR_HuldraBrosInteract_LargeTable_FrameBoth", 69)
  camOneShot_QuestStarted:SetCallback(DestroyOneShot_QuestStarted)
  camOneShot_QuestStarted:ActivateCineLock()
  camOneShot_QuestStarted:Start()
end
